# OrangePi Homelab Documentation

Welcome to the comprehensive documentation for my OrangePi homelab setup. This documentation covers all services, configurations, and workflows.

## 📖 Table of Contents

- [🏠 Overview](#overview)
- [🔧 Infrastructure](#infrastructure)
- [📦 Services](#services)
- [🔐 Security](#security)
- [📋 Maintenance](#maintenance)
- [🚀 Deployment](#deployment)

## 🏠 Overview

This homelab runs on an OrangePi single-board computer with a combination of Docker containers and systemd services. The setup emphasizes:

- **Self-hosting**: All services run locally with external access via VPN
- **Automation**: Ansible-based deployment and configuration management
- **Security**: VPN-first access with Zitadel identity management
- **Backup**: Multi-layered backup strategy with Duplicati and Syncthing
- **Monitoring**: Service health monitoring and status dashboards

## 🔧 Infrastructure

### Hardware
- **Device**: OrangePi (ARM-based SBC)
- **Storage**: NFS mounts to Synology NAS (192.168.2.132)
- **Network**: Local network with NetBird VPN mesh

### Network Architecture
- **Local Network**: 192.168.2.0/24
- **OrangePi IP**: 192.168.2.106
- **Synology NAS**: 192.168.2.132
- **VPN**: NetBird mesh network
- **DNS**: Pi-hole for ad blocking
- **Reverse Proxy**: Caddy (via NetBird)

## 📦 Services

### Media Services
- **[Jellyfin](services/jellyfin.md)** - Media streaming server
- **[Sonarr](services/sonarr.md)** - TV series management
- **[Radarr](services/radarr.md)** - Movie management  
- **[Bazarr](services/bazarr.md)** - Subtitle management
- **[JDownloader](services/jdownloader.md)** - Download manager

### Storage & Sync
- **[Syncthing](services/syncthing.md)** - File synchronization
- **[MinIO](services/minio.md)** - S3-compatible object storage
- **[Duplicati](services/duplicati.md)** - Encrypted backup solution

### Network & VPN
- **[Pi-hole](services/pihole.md)** - DNS sinkhole and ad blocker
- **[NetBird](services/netbird.md)** - VPN mesh network
- **[Zitadel](services/zitadel.md)** - Identity and access management

### Applications
- **[Immich](services/immich.md)** - Photo and video management
- **[Paperless](services/paperless.md)** - Document management system
- **[Vaultwarden](services/vaultwarden.md)** - Password manager
- **[Home Assistant](services/home-assistant.md)** - Home automation hub

### Management
- **[Portainer](services/portainer.md)** - Docker container management
- **[Homer](services/homer.md)** - Service dashboard
- **[Homepage](services/homepage.md)** - Alternative dashboard

### Utilities
- **[DDClient](services/ddclient.md)** - Dynamic DNS client

## 🔐 Security

- **[VPN Setup](security/vpn-setup.md)** - NetBird configuration
- **[Authentication](security/authentication.md)** - Zitadel SSO setup
- **[SSL Certificates](security/ssl-certificates.md)** - TLS configuration
- **[Firewall Rules](security/firewall.md)** - Network security
- **[Backup Encryption](security/backup-encryption.md)** - Data protection

## 📋 Maintenance

- **[Backup Strategy](maintenance/backup-strategy.md)** - Comprehensive backup plan
- **[Update Process](maintenance/updates.md)** - Service update procedures
- **[Monitoring](maintenance/monitoring.md)** - Health checks and alerts
- **[Troubleshooting](maintenance/troubleshooting.md)** - Common issues and solutions

## 🚀 Deployment

- **[Ansible Setup](deployment/ansible.md)** - Automated deployment
- **[Manual Installation](deployment/manual.md)** - Step-by-step setup
- **[Environment Variables](deployment/environment.md)** - Configuration reference
- **[Network Configuration](deployment/network.md)** - Networking setup

---

## Quick Links

- **Service Status**: [Homepage](http://192.168.2.106:3000) | [Homer](http://192.168.2.106:8090)
- **Container Management**: [Portainer](http://192.168.2.106:9000)
- **Network Admin**: [Pi-hole](http://192.168.2.106:8080)
- **VPN Management**: [NetBird Dashboard](https://elbird.mywire.org)
- **Identity Management**: [Zitadel](https://elbird.mywire.org/auth)

## Need Help?

- 📧 Check the [Troubleshooting Guide](maintenance/troubleshooting.md)
- 🔧 Review [Service-Specific Documentation](services/)
- 🚀 Follow [Deployment Instructions](deployment/)

---

*Last updated: $(date '+%Y-%m-%d %H:%M:%S')*