# Services Documentation

This directory contains detailed documentation for each service running on the OrangePi homelab.

## Service Categories

### 📺 Media Services
- **jellyfin.md** - Media streaming server configuration
- **sonarr.md** - TV series automation setup  
- **radarr.md** - Movie automation configuration
- **bazarr.md** - Subtitle management setup
- **jdownloader.md** - Download manager configuration

### 💾 Storage & Sync
- **syncthing.md** - File synchronization setup
- **minio.md** - S3-compatible storage configuration
- **duplicati.md** - Backup solution setup

### 🌐 Network & VPN  
- **pihole.md** - DNS ad blocker configuration
- **netbird.md** - VPN mesh network setup
- **zitadel.md** - Identity provider configuration

### 📱 Applications
- **immich.md** - Photo management setup
- **paperless.md** - Document management configuration
- **vaultwarden.md** - Password manager setup
- **home-assistant.md** - Home automation configuration

### ⚙️ Management
- **portainer.md** - Docker management interface
- **homer.md** - Service dashboard configuration
- **homepage.md** - Alternative dashboard setup

### 🔧 Utilities
- **ddclient.md** - Dynamic DNS client setup

## Documentation Template

Each service documentation follows this structure:

```markdown
# Service Name

## Overview
Brief description of the service and its purpose.

## Configuration
Docker compose configuration and environment variables.

## Setup Instructions
Step-by-step setup process.

## Usage
How to use the service effectively.

## Troubleshooting
Common issues and solutions.

## Maintenance
Update procedures and backup considerations.
```

## Getting Started

1. Choose a service from the list above
2. Follow the setup instructions
3. Refer to troubleshooting if issues arise
4. Check the main [README](../README.md) for infrastructure details