# Jellyfin Media Server

## Overview

Jellyfin is the volunteer-built media solution that puts you in control of your media. Stream to any device from your own server, with no strings attached.

## Configuration

**Container**: `jellyfin`  
**Port**: `8097` (mapped from 8096)  
**Data Source**: NFS mount to Synology `/volume1/homes`

### Docker Compose

```yaml
jellyfin:
  image: lscr.io/linuxserver/jellyfin:latest
  container_name: jellyfin
  volumes:
    - jellyfin_config:/config
    - type: volume
      source: synology_homes
      target: /data
      volume:
        nocopy: true
  ports:
    - 8097:8096
  restart: always
  environment:
    - PUID=1000
    - PGID=1000
    - TZ=Europe/Berlin
    - JELLYFIN_PublishedServerUrl=http://192.168.2.106:8097
```

## Setup Instructions

1. **Access the web interface**: http://192.168.2.106:8097
2. **Initial setup wizard**:
   - Set preferred language
   - Create admin user account
   - Configure media libraries pointing to `/data`
3. **Library setup**:
   - Movies: `/data/Media/Movies`
   - TV Shows: `/data/Media/TV`
   - Music: `/data/Media/Music`

## Media Organization

Jellyfin works best with properly organized media:

```
/data/Media/
├── Movies/
│   ├── Movie Name (Year)/
│   │   └── Movie Name (Year).mkv
│   └── Another Movie (Year)/
│       └── Another Movie (Year).mp4
├── TV/
│   ├── Show Name/
│   │   ├── Season 01/
│   │   │   ├── S01E01 - Episode Name.mkv
│   │   │   └── S01E02 - Episode Name.mkv
│   │   └── Season 02/
│   │       └── S02E01 - Episode Name.mkv
└── Music/
    ├── Artist/
    │   └── Album/
    │       └── 01 - Track Name.mp3
```

## Integration with *arr Services

Jellyfin integrates seamlessly with:
- **Sonarr**: Automatic TV show downloads
- **Radarr**: Automatic movie downloads  
- **Bazarr**: Subtitle management

## Usage

### Web Interface
- Access at http://192.168.2.106:8097
- Admin dashboard for library management
- User management and permissions

### Mobile Apps
- **Android**: Jellyfin for Android
- **iOS**: Jellyfin Mobile
- **TV**: Jellyfin for Android TV, Apple TV

### Desktop Clients
- **Windows/Mac/Linux**: Jellyfin Media Player
- **Web browser**: Direct access via web interface

## Configuration Tips

### Hardware Acceleration
- OrangePi has limited transcoding capabilities
- Direct play is preferred over transcoding
- Configure clients for supported formats

### Library Scanning
- Enable real-time monitoring for instant updates
- Schedule full library scans during off-peak hours
- Use proper file naming for automatic metadata

## Troubleshooting

### Common Issues

**Library not updating**:
```bash
# Restart Jellyfin service
sudo systemctl restart jellyfin-docker.service
```

**Permission issues**:
```bash
# Check NFS mount permissions
ls -la /var/lib/docker/volumes/media_synology_homes/_data
```

**Playback issues**:
- Check client codec support
- Disable transcoding if hardware acceleration unavailable
- Verify network bandwidth

### Log Analysis
```bash
# View Jellyfin logs
docker logs jellyfin

# Follow logs in real-time
docker logs -f jellyfin
```

## Maintenance

### Updates
Jellyfin updates automatically via the LinuxServer image:
```bash
# Pull latest image and restart
cd /home/orangepi/media
sudo docker compose pull jellyfin
sudo docker compose up -d jellyfin
```

### Backup Strategy
- **Configuration**: Included in volume backup
- **Media files**: Stored on Synology NAS with RAID protection
- **Database**: Regular Jellyfin metadata backups

### Performance Monitoring
- Monitor CPU usage during peak hours
- Check available storage space
- Monitor network utilization

## Related Services

- **[Sonarr](sonarr.md)** - TV series management
- **[Radarr](radarr.md)** - Movie management
- **[Bazarr](bazarr.md)** - Subtitle downloads
- **[Syncthing](syncthing.md)** - Media file synchronization

---

**Access URL**: http://192.168.2.106:8097  
**Admin Panel**: Login with configured admin credentials  
**Mobile Apps**: Available on all major app stores