# OrangePi Service Configurations

This directory contains Docker compose and environment files for all services running on the OrangePi.

## Services Synced

- _ansible
- ansible
- authelia
- caddy
- ddclient
- duplicati
- grocy
- homeassistant
- homepage
- homer
- .immich-app
- immich-app
- media
- nextcloud
- no-ip
- opencloud
- paperless
- pihole
- portainer
- storage
- supernote-sync
- traefik
- uptime-kuma
- vaultwarden
- wg-easy

## Scripts

Important scripts are stored in the `scripts/` directory.

## Sync Information

- Last synced: Fri Jul 11 04:54:16 AM CST 2025
- Total services found: 20
- Successfully synced: 20
- Total files copied: 29
- Sync log: /tmp/sync-configs-20250711-045415.log

## Usage

To deploy a service:
```bash
cd /path/to/service
docker compose up -d
```

## Important Notes

- .env files may contain sensitive information
- Remember to update passwords and secrets when deploying to a new system
- Some services may require additional setup (databases, volumes, etc.)

## Restoring to a New System

1. Clone this dotfiles repository
2. Copy service directories to desired locations
3. Update .env files with new passwords/secrets
4. Create necessary Docker networks and volumes
5. Run `docker compose up -d` in each service directory
