#!/bin/bash

# Sync live configurations back to dotfiles
# This preserves the current running state before making changes

set -e

echo "🔄 Syncing live configurations back to dotfiles..."

# Services to sync
services=(
    "homeassistant"
    "duplicati" 
    "homepage"
    "media"
    "storage"
    "immich-app"
    "vaultwarden"
    "pihole"
    "paperless"
)

for service in "${services[@]}"; do
    if [ -d "/home/orangepi/$service" ]; then
        echo "📁 Syncing $service..."
        
        # Create dotfiles directory if it doesn't exist
        mkdir -p "/home/orangepi/dotfiles/orangepi/$service"
        
        # Sync docker-compose.yml
        if [ -f "/home/orangepi/$service/docker-compose.yml" ]; then
            cp -v "/home/orangepi/$service/docker-compose.yml" "/home/orangepi/dotfiles/orangepi/$service/"
        fi
        
        # Sync config directories (if they exist and aren't data)
        if [ -d "/home/orangepi/$service/config" ]; then
            rsync -av --exclude='*.db' --exclude='*.log' --exclude='cache/' \
                "/home/orangepi/$service/config/" "/home/orangepi/dotfiles/orangepi/$service/config/"
        fi
        
        # Skip .env files (they may contain secrets)
        echo "  ⚠️  Skipping .env files for security"
    else
        echo "❌ $service directory not found, skipping..."
    fi
done

echo ""
echo "✅ Sync complete! Check git status to see what changed:"
echo "cd /home/orangepi/dotfiles && git status"