/*
 * Decompiled with CFR 0.152.
 */
package org.jdownloader.container.sft;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.jdownloader.container.sft.DelphiFormEntry;
import org.jdownloader.container.sft.DelphiFormEntryBinary;
import org.jdownloader.container.sft.DelphiFormEntryBoolean;
import org.jdownloader.container.sft.DelphiFormEntryCollection;
import org.jdownloader.container.sft.DelphiFormEntryCollectionItem;
import org.jdownloader.container.sft.DelphiFormEntryEnumValue;
import org.jdownloader.container.sft.DelphiFormEntryExtended;
import org.jdownloader.container.sft.DelphiFormEntryList;
import org.jdownloader.container.sft.DelphiFormEntryNumber;
import org.jdownloader.container.sft.DelphiFormEntryObject;
import org.jdownloader.container.sft.DelphiFormEntrySet;
import org.jdownloader.container.sft.DelphiFormEntryString;

public class DelphiFormBinLoader {
    public static final String DFM_MAGIC_HEADER = "TPF0";
    protected DelphiFormEntry root;
    protected DataInputStream inputStream;

    public DelphiFormBinLoader(DataInputStream inputStream) throws Exception {
        this.setInput(inputStream);
        this.run();
    }

    public void setInput(DataInputStream inputStream) {
        this.inputStream = inputStream;
    }

    public void releaseInput() {
        this.inputStream = null;
    }

    public void run() throws Exception {
        if (this.inputStream == null) {
            throw new NullPointerException("invalid dfm stream");
        }
        byte[] sftMagic = new byte[4];
        this.inputStream.read(sftMagic, 0, 4);
        if (!new String(sftMagic, "UTF-8").equals(DFM_MAGIC_HEADER)) {
            throw new UnsupportedOperationException("unsupported dfm format");
        }
        this.readObject(null);
    }

    protected String readString() throws IOException {
        if (this.inputStream.available() == 0) {
            return null;
        }
        int len = this.inputStream.readByte() & 0xFF;
        if (len == 0 || this.inputStream.available() < len) {
            return null;
        }
        byte[] rawstring = new byte[len];
        this.inputStream.read(rawstring);
        return new String(rawstring);
    }

    protected String readUTFString() throws IOException {
        if (this.inputStream.available() == 0) {
            return null;
        }
        byte[] rawlen = new byte[4];
        this.inputStream.read(rawlen);
        int len = (rawlen[3] & 0xFF) << 24 | (rawlen[2] & 0xFF) << 16 | (rawlen[1] & 0xFF) << 8 | rawlen[0] & 0xFF;
        if (len == 0 || this.inputStream.available() < len) {
            return null;
        }
        byte[] rawstring = new byte[len];
        this.inputStream.read(rawstring);
        byte[] encstring = new String(rawstring, "UTF-8").getBytes();
        return new String(encstring, "UTF-8");
    }

    protected long readNumber(int size) throws IOException {
        long propertyValue;
        switch (size) {
            case 1: {
                propertyValue = this.inputStream.readByte() & 0xFF;
                break;
            }
            case 2: {
                propertyValue = this.inputStream.readShort() & 0xFFFF;
                break;
            }
            case 4: {
                propertyValue = this.inputStream.readInt() & 0xFFFFFFFF;
                break;
            }
            case 8: {
                propertyValue = DelphiFormBinLoader.bigToLittleEndian(this.inputStream.readLong()) & Long.MAX_VALUE;
                break;
            }
            default: {
                throw new UnsupportedOperationException("unsupported integer size");
            }
        }
        return propertyValue;
    }

    protected double readExtended() throws IOException {
        byte[] extended = new byte[10];
        byte[] normalize = new byte[8];
        this.inputStream.read(extended);
        long exponent = (((long)extended[9] & 0x7FL) << 8 | (long)extended[8]) - 16383L + 1023L;
        long double_builder = 0L;
        double_builder |= ((long)extended[9] & 0x80L) << 56;
        double_builder |= (exponent << 4 & 0xFFFFL) << 48;
        double_builder |= ((long)extended[7] & 0x7FL) << 45;
        double_builder |= ((long)extended[6] & 0xFFL) << 37;
        double_builder |= ((long)extended[5] & 0xFFL) << 29;
        double_builder |= ((long)extended[4] & 0xFFL) << 21;
        double_builder |= ((long)extended[3] & 0xFFL) << 13;
        double_builder |= ((long)extended[2] & 0xFFL) << 5;
        ByteBuffer.wrap(normalize).putLong(double_builder |= ((long)extended[1] & 0xFFL) >> 3);
        return ByteBuffer.wrap(normalize).getDouble();
    }

    protected byte[] readBinary() throws IOException {
        if (this.inputStream.available() == 0) {
            return null;
        }
        byte[] rawlen = new byte[4];
        this.inputStream.read(rawlen);
        int len = (rawlen[3] & 0xFF) << 24 | (rawlen[2] & 0xFF) << 16 | (rawlen[1] & 0xFF) << 8 | rawlen[0] & 0xFF;
        if (len == 0 || this.inputStream.available() < len) {
            return null;
        }
        byte[] raw = new byte[len];
        this.inputStream.read(raw);
        return raw;
    }

    protected ArrayList<String> readSet() throws IOException {
        String entry;
        ArrayList<String> list = new ArrayList<String>();
        while ((entry = this.readString()) != null) {
            list.add(entry);
        }
        return list;
    }

    protected boolean readObject(DelphiFormEntry parent) throws Exception {
        String objectType = this.readString();
        if (objectType == null) {
            return false;
        }
        String objectName = this.readString();
        DelphiFormEntryObject node = new DelphiFormEntryObject(parent, objectName, objectType);
        if (node.isRoot()) {
            this.root = node;
        }
        this.readPropertys(node, false);
        while (this.readObject(node)) {
        }
        return true;
    }

    protected void readCollection(DelphiFormEntry parent) throws Exception {
        while ((this.inputStream.readByte() & 0xFF) == 1) {
            this.readPropertys(new DelphiFormEntryCollectionItem(parent), false);
        }
    }

    protected void readPropertys(DelphiFormEntry parent, boolean isList) throws Exception {
        int propertyType;
        block17: while (true) {
            String propertyName = null;
            if (!isList && (propertyName = this.readString()) == null) {
                return;
            }
            propertyType = this.inputStream.readByte() & 0xFF;
            switch (propertyType) {
                case 0: {
                    if (!isList) continue block17;
                    return;
                }
                case 1: {
                    this.readPropertys(new DelphiFormEntryList(parent, propertyName), true);
                    continue block17;
                }
                case 2: {
                    new DelphiFormEntryNumber(parent, propertyName, this.readNumber(1), propertyType);
                    continue block17;
                }
                case 3: {
                    new DelphiFormEntryNumber(parent, propertyName, this.readNumber(2), propertyType);
                    continue block17;
                }
                case 4: {
                    new DelphiFormEntryNumber(parent, propertyName, this.readNumber(4), propertyType);
                    continue block17;
                }
                case 5: {
                    new DelphiFormEntryExtended(parent, propertyName, this.readExtended());
                    continue block17;
                }
                case 6: {
                    new DelphiFormEntryString(parent, propertyName, this.readString());
                    continue block17;
                }
                case 7: {
                    new DelphiFormEntryEnumValue(parent, propertyName, this.readString());
                    continue block17;
                }
                case 8: {
                    new DelphiFormEntryBoolean(parent, propertyName, false);
                    continue block17;
                }
                case 9: {
                    new DelphiFormEntryBoolean(parent, propertyName, true);
                    continue block17;
                }
                case 11: {
                    new DelphiFormEntrySet(parent, propertyName, this.readSet());
                    continue block17;
                }
                case 12: {
                    new DelphiFormEntryBinary(parent, propertyName, this.readBinary());
                    continue block17;
                }
                case 14: {
                    this.readCollection(new DelphiFormEntryCollection(parent, propertyName));
                    continue block17;
                }
                case 19: {
                    new DelphiFormEntryNumber(parent, propertyName, this.readNumber(8), propertyType);
                    continue block17;
                }
                case 20: {
                    new DelphiFormEntryString(parent, propertyName, this.readUTFString());
                    continue block17;
                }
            }
            break;
        }
        throw new UnsupportedOperationException("unsupported entry type " + propertyType);
    }

    public DelphiFormEntry getRoot() {
        return this.root;
    }

    public static long bigToLittleEndian(long bigendian) {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.order(ByteOrder.BIG_ENDIAN);
        buf.putLong(bigendian);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        return buf.getLong(0);
    }
}

