/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import jd.config.ConfigGroup;
import jd.config.GuiConfigListener;
import jd.config.Property;
import jd.controlling.ListController;
import org.appwork.utils.StringUtils;

public class ConfigEntry
implements Serializable {
    private static final long serialVersionUID = 7422046260361380162L;
    private final int type;
    private ConfigGroup group;
    private String label;
    private Object defaultValue;
    private boolean enabled = true;
    private Property propertyInstance = null;
    private String propertyName = null;
    private PropertyType propertyType = PropertyType.NORMAL;
    private GuiConfigListener guiListener;
    private ConfigEntry conditionEntry;
    private Boolean compareValue;
    private final List<ConfigEntry> listener = new ArrayList<ConfigEntry>();
    private String description;
    private ActionListener actionListener;
    private ImageIcon imageIcon;
    private transient ListController controller;
    private Object[] list;
    private int start;
    private int end;
    private int step = 1;
    private JComponent component;
    private String constraints;
    private boolean notifyChanges = false;

    public boolean isNotifyChanges() {
        return this.notifyChanges;
    }

    public void setNotifyChanges(boolean notifyChanges) {
        this.notifyChanges = notifyChanges;
    }

    public ConfigEntry(int type) {
        this.type = type;
    }

    public ConfigEntry(int type, JComponent component, String constraints) {
        this.type = type;
        this.component = component;
        this.constraints = constraints;
    }

    public ConfigEntry(int type, ActionListener actionListener, String description, String label, ImageIcon icon) {
        this.type = type;
        this.actionListener = actionListener;
        this.description = description;
        this.label = label;
        this.imageIcon = icon;
    }

    public ConfigEntry(int type, ListController controller, String label) {
        this.type = type;
        this.controller = controller;
        this.label = label;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, Object[] list, String label) {
        this.type = type;
        this.propertyInstance = propertyInstance;
        this.propertyName = propertyName;
        this.list = list;
        this.label = label;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, String label) {
        this.type = type;
        this.propertyInstance = propertyInstance;
        this.propertyName = propertyName;
        this.label = label;
    }

    public ConfigEntry(int type, Property propertyInstance, String propertyName, String label, int start, int end, int step) {
        this.type = type;
        this.propertyInstance = propertyInstance;
        this.propertyName = propertyName;
        this.label = label;
        this.start = start;
        this.end = end;
        this.step = step;
    }

    @Deprecated
    public ConfigEntry(int type, Property propertyInstance, String propertyName, String label, int start, int end) {
        this(type, propertyInstance, propertyName, label, start, end, 1);
    }

    @Deprecated
    public ConfigEntry setStep(int step) {
        this.step = step;
        return this;
    }

    public ConfigEntry(int type, String label) {
        this.type = type;
        this.label = label;
    }

    public ActionListener getActionListener() {
        return this.actionListener;
    }

    public JComponent getComponent() {
        return this.component;
    }

    public String getConstraints() {
        return this.constraints;
    }

    public Object getDefaultValue() {
        switch (this.getType()) {
            case 3: {
                if (this.defaultValue == null) {
                    return false;
                }
                if (this.defaultValue instanceof String) {
                    return StringUtils.equalsIgnoreCase((String)"true", (String)((String)this.defaultValue));
                }
                if (this.defaultValue instanceof Boolean) {
                    return this.defaultValue;
                }
                return false;
            }
        }
        return this.defaultValue;
    }

    public String getDescription() {
        return this.description;
    }

    public int getEnd() {
        return this.end;
    }

    public ConfigGroup getGroup() {
        return this.group;
    }

    public GuiConfigListener getGuiListener() {
        return this.guiListener;
    }

    public ImageIcon getImageIcon() {
        return this.imageIcon;
    }

    public String getLabel() {
        return this.label;
    }

    public Object[] getList() {
        return this.list;
    }

    public ListController getListController() {
        if (this.controller == null) {
            this.controller = new ListController(){

                @Override
                public String getList() {
                    return "";
                }

                @Override
                public void setList(String list) {
                }
            };
        }
        return this.controller;
    }

    public Property getPropertyInstance() {
        return this.propertyInstance;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public int getStart() {
        return this.start;
    }

    public int getStep() {
        return this.step;
    }

    public int getType() {
        return this.type;
    }

    public boolean isConditionalEnabled(ConfigEntry source, Object newData) {
        if (this.conditionEntry == null) {
            return true;
        }
        if (source == null) {
            source = this.conditionEntry;
            newData = this.conditionEntry.getPropertyInstance().hasProperty(this.conditionEntry.getPropertyName()) ? this.conditionEntry.getPropertyInstance().getProperty(this.conditionEntry.getPropertyName()) : this.conditionEntry.getDefaultValue();
        }
        return source == this.conditionEntry ? this.compareValue.equals(newData) : true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ConfigEntry setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ConfigEntry setEnabled(boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ConfigEntry setEnabledCondidtion(ConfigEntry conditionEntry, boolean compareValue) {
        if (conditionEntry == null) {
            return this;
        }
        this.conditionEntry = conditionEntry;
        this.compareValue = compareValue;
        conditionEntry.addListener(this);
        return this;
    }

    public void addListener(ConfigEntry listener) {
        if (listener != null) {
            this.listener.add(listener);
        }
    }

    public void setGroup(ConfigGroup group) {
        this.group = group;
    }

    public void setGuiListener(GuiConfigListener guiListener) {
        if (this.guiListener == null) {
            this.guiListener = guiListener;
        }
    }

    public ConfigEntry setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
        return this;
    }

    public void valueChanged(Object newValue) {
        if (!this.notifyChanges) {
            return;
        }
        for (ConfigEntry next : this.listener) {
            GuiConfigListener nextGuiListener = next.getGuiListener();
            if (nextGuiListener == null) continue;
            nextGuiListener.dataChanged(this, newValue);
        }
    }

    public static enum PropertyType {
        NONE,
        NORMAL,
        NEEDS_RESTART;


        public static PropertyType getMax(PropertyType ... changes) {
            ArrayList<PropertyType> sorter = new ArrayList<PropertyType>();
            for (PropertyType type : changes) {
                sorter.add(type);
            }
            Collections.sort(sorter);
            PropertyType ret = (PropertyType)((Object)sorter.get(sorter.size() - 1));
            return ret;
        }

        public PropertyType getMax(PropertyType propertyType) {
            return PropertyType.getMax(propertyType, this);
        }
    }
}

