/*
 * Decompiled with CFR 0.152.
 */
package jd.config;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.appwork.utils.StringUtils;

public class WeakStringCache {
    private ReferenceQueue<String> queue = new ReferenceQueue();
    private List<WeakStringCacheEntries> entries = new ArrayList<WeakStringCacheEntries>();
    private long cacheSize = 0L;

    protected long entryHash(String string) {
        int hash = string.hashCode();
        int length = string.length();
        long ret = (long)hash << 32 | (long)length & 0xFFFFFFFFL;
        return ret;
    }

    protected int getStringHash(long entryHash) {
        return (int)(entryHash >> 32);
    }

    protected int getStringLength(long entryHash) {
        return (int)entryHash;
    }

    protected int compare(long x, long y) {
        return x < y ? -1 : (x == y ? 0 : 1);
    }

    private WeakStringCacheEntries getWeakStringCacheEntries(int stringLength) {
        int min = 0;
        int max = this.entries.size() - 1;
        int mid = 0;
        while (min <= max) {
            mid = (max + min) / 2;
            WeakStringCacheEntries midEntry = this.entries.get(mid);
            int comp = this.compare(stringLength, midEntry.stringLength);
            if (min == max) {
                if (stringLength != midEntry.stringLength) break;
                return midEntry;
            }
            if (comp < 0) {
                max = mid;
                continue;
            }
            if (comp > 0) {
                min = mid + 1;
                continue;
            }
            return midEntry;
        }
        WeakStringCacheEntries ret = new WeakStringCacheEntries(stringLength);
        this.entries.add(ret);
        Collections.sort(this.entries, new Comparator<WeakStringCacheEntries>(){

            @Override
            public int compare(WeakStringCacheEntries o1, WeakStringCacheEntries o2) {
                return WeakStringCache.this.compare(o1.stringLength, o2.stringLength);
            }
        });
        return ret;
    }

    public String cache(String string) {
        this.clean();
        long searchFor = this.entryHash(string);
        int searchForLength = string.length();
        WeakStringCacheEntries entries = this.getWeakStringCacheEntries(searchForLength);
        int min = 0;
        int max = entries.size() - 1;
        int mid = 0;
        int next = 0;
        while (min <= max) {
            mid = (max + min) / 2;
            WeakStringCacheEntry midEntry = (WeakStringCacheEntry)entries.get(mid);
            int comp = this.compare(searchFor, midEntry.entryHash);
            if (min == max) {
                String midValue = (String)midEntry.get();
                if (!StringUtils.equals((String)string, (String)midValue)) break;
                return midValue;
            }
            if (comp < 0) {
                max = mid;
                continue;
            }
            if (comp > 0) {
                min = mid + 1;
                continue;
            }
            while (mid <= max && midEntry.entryHash == searchFor) {
                String midValue;
                if (StringUtils.equals((String)string, (String)(midValue = (String)(midEntry = (WeakStringCacheEntry)entries.get(mid++)).get()))) {
                    return midValue;
                }
                next = next++;
            }
            break block0;
        }
        ++this.cacheSize;
        entries.add(min, new WeakStringCacheEntry(string, searchFor));
        Collections.sort(entries, new Comparator<WeakStringCacheEntry>(){

            @Override
            public int compare(WeakStringCacheEntry o1, WeakStringCacheEntry o2) {
                return WeakStringCache.this.compare(o1.entryHash, o2.entryHash);
            }
        });
        return string;
    }

    private void clean() {
        Reference<String> purge;
        block0: while ((purge = this.queue.poll()) != null) {
            WeakStringCacheEntry entry = (WeakStringCacheEntry)purge;
            Iterator it = this.getWeakStringCacheEntries(entry.getStringLength()).iterator();
            while (it.hasNext()) {
                WeakStringCacheEntry next = (WeakStringCacheEntry)it.next();
                if (purge != next) continue;
                --this.cacheSize;
                it.remove();
                continue block0;
            }
        }
    }

    protected class WeakStringCacheEntries
    extends ArrayList<WeakStringCacheEntry> {
        protected final int stringLength;

        protected WeakStringCacheEntries(int stringLength) {
            this.stringLength = stringLength;
        }
    }

    protected class WeakStringCacheEntry
    extends WeakReference<String> {
        protected final long entryHash;

        protected WeakStringCacheEntry(String referent) {
            super(referent, WeakStringCache.this.queue);
            this.entryHash = WeakStringCache.this.entryHash(referent);
        }

        protected WeakStringCacheEntry(String referent, long entryHash) {
            super(referent, WeakStringCache.this.queue);
            this.entryHash = entryHash;
        }

        public String toString() {
            return String.valueOf(this.entryHash);
        }

        protected int getStringLength() {
            return WeakStringCache.this.getStringLength(this.entryHash);
        }
    }
}

