/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.AccountFilter;
import jd.controlling.AccountPropertyChangedEvent;
import jd.controlling.AccountUpOrDowngradeEvent;
import jd.controlling.accountchecker.AccountChecker;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.http.Browser;
import jd.http.BrowserSettingsThread;
import jd.nutils.encoding.Encoding;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountProperty;
import jd.plugins.AccountUnavailableException;
import jd.plugins.MultiHostHost;
import jd.plugins.Plugin;
import jd.plugins.PluginForHost;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownEvent;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.ConfirmDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.Eventsender;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.URLHelper;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.dialog.ConfirmDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.LazyPlugin;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.UpdateRequiredClassNotFoundException;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.plugins.controller.host.PluginFinder;
import org.jdownloader.settings.AccountData;
import org.jdownloader.settings.AccountSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class AccountController
implements AccountControllerListener,
Account.AccountPropertyChangeHandler {
    private static final long serialVersionUID = -7560087582989096645L;
    private final HashMap<String, List<Account>> ACCOUNTS;
    @Deprecated
    private final HashMap<String, Map<Account, Object>> MULTIHOSTER_ACCOUNTS;
    private static AccountController INSTANCE = new AccountController();
    private final Eventsender<AccountControllerListener, AccountControllerEvent> broadcaster = new Eventsender<AccountControllerListener, AccountControllerEvent>(){

        protected void fireEvent(AccountControllerListener listener, AccountControllerEvent event) {
            listener.onAccountControllerEvent(event);
        }
    };
    private AccountSettings config = (AccountSettings)JsonConfig.create(AccountSettings.class);
    private DelayedRunnable delayedSaver;
    private final String lastKnownAccountTypeProperty = "lastKnownAccountType";
    private final String lastKnownValidUntilTimeStampProperty = "lastKnownValidUntilTimeStamp";
    private final long minimumExtendTime = 86400000L;
    private final String SLV = "slv";
    private final String SLID = "slid";
    private final String IMPORTED_TIMESTAMP = "im";

    public Eventsender<AccountControllerListener, AccountControllerEvent> getEventSender() {
        return this.broadcaster;
    }

    private AccountController() {
        if (this.config.getListID() <= 0L) {
            this.config.setListID(System.currentTimeMillis());
        }
        ShutdownController.getInstance().addShutdownEvent(new ShutdownEvent(){

            public void onShutdown(ShutdownRequest shutdownRequest) {
                AccountController.this.save();
            }

            public long getMaxDuration() {
                return 0L;
            }

            public String toString() {
                return "ShutdownEvent: Save AccountController";
            }
        });
        this.ACCOUNTS = this.loadAccounts(this.config);
        this.MULTIHOSTER_ACCOUNTS = new HashMap();
        this.delayedSaver = new DelayedRunnable(5000L, 30000L){

            public String getID() {
                return "AccountController";
            }

            public void delayedrun() {
                AccountController.this.save();
            }
        };
        Collection<List<Account>> accsc = this.ACCOUNTS.values();
        for (List<Account> accs : accsc) {
            for (Account acc : accs) {
                acc.setAccountController(this);
                if (acc.getPlugin() == null) continue;
                this.updateInternalMultiHosterMap(acc, acc.getAccountInfo());
            }
        }
        this.broadcaster.addListener((EventListener)this);
        this.delayedSaver.getService().scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                if (((AccountSettings)JsonConfig.create(AccountSettings.class)).isAutoAccountRefreshEnabled()) {
                    try {
                        AccountController.this.refreshAccountStats();
                    }
                    catch (Throwable e) {
                        LogController.CL().log(e);
                    }
                }
            }
        }, 1L, 5L, TimeUnit.MINUTES);
        CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                if (JDGui.bugme((WarnLevel)WarnLevel.SEVERE)) {
                    if (!newValue.booleanValue()) {
                        ConfirmDialog d = new ConfirmDialog(544, _GUI.T.lit_are_you_sure(), _GUI.T.are_you_sure_disabled_premium(), (Icon)new AbstractIcon("question", 32), _GUI.T.lit_continue(), null);
                        try {
                            ((ConfirmDialogInterface)UIOManager.I().show(ConfirmDialogInterface.class, (UserIODefinition)d)).throwCloseExceptions();
                            return;
                        }
                        catch (DialogClosedException dialogClosedException) {
                        }
                        catch (DialogCanceledException dialogCanceledException) {
                            // empty catch block
                        }
                        new Thread(""){

                            @Override
                            public void run() {
                                CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.setValue((Object)true);
                            }
                        }.start();
                    }
                } else {
                    return;
                }
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void save() {
        HashMap<String, ArrayList<AccountData>> ret = new HashMap<String, ArrayList<AccountData>>();
        AccountController accountController = this;
        synchronized (accountController) {
            for (Map.Entry<String, List<Account>> next : this.ACCOUNTS.entrySet()) {
                if (next.getValue().size() == 0) continue;
                ArrayList<AccountData> list = new ArrayList<AccountData>(next.getValue().size());
                ret.put(next.getKey(), list);
                for (Account a : next.getValue()) {
                    list.add(AccountData.create(a));
                }
            }
        }
        this.config.setListVersion(System.currentTimeMillis());
        this.config.setAccounts(ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateInternalMultiHosterMap(Account account, AccountInfo ai) {
        AccountController accountController = this;
        synchronized (accountController) {
            List<MultiHostHost> multiHostSupport;
            Iterator<Map.Entry<String, Map<Account, Object>>> it = this.MULTIHOSTER_ACCOUNTS.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Map<Account, Object>> next = it.next();
                Map<Account, Object> accs = next.getValue();
                if (accs.remove(account) == null || accs.size() != 0) continue;
                it.remove();
            }
            boolean isMulti = false;
            if (ai != null && (multiHostSupport = ai.getMultiHostSupportV2()) != null) {
                block7: for (MultiHostHost support : multiHostSupport) {
                    isMulti = true;
                    MultiHostHost.MultihosterHostStatus status = support.getStatus();
                    switch (status) {
                        case WORKING: 
                        case WORKING_UNSTABLE: {
                            break;
                        }
                        default: {
                            continue block7;
                        }
                    }
                    String host = support.getDomain();
                    Map<Account, Object> accs = this.MULTIHOSTER_ACCOUNTS.get(host);
                    if (accs == null) {
                        accs = new WeakHashMap<Account, Object>();
                        this.MULTIHOSTER_ACCOUNTS.put(host, accs);
                    }
                    accs.put(account, this);
                }
            }
            account.setProperty("IS_MULTI_HOSTER_ACCOUNT", isMulti);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public AccountInfo updateAccountInfo(Account account, boolean forceupdate) {
        AccountInfo ai = account.getAccountInfo();
        if (account.getPlugin() == null) {
            return ai;
        }
        Account.AccountError errorBefore = account.getError();
        double balanceBefore = -1.0;
        if (ai != null) {
            balanceBefore = ai.getAccountBalance();
        }
        PluginForHost plugin = null;
        final HashMap propertyChanges = new HashMap();
        try {
            LogInterface oldLogger;
            BrowserSettingsThread bThread;
            LogSource logger;
            block109: {
                long tempDisabledCounterBefore2222;
                block108: {
                    String whoAmI;
                    block107: {
                        Account.AccountPropertyChangeHandler handler = new Account.AccountPropertyChangeHandler(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public boolean fireAccountPropertyChange(AccountProperty property) {
                                if (property != null) {
                                    HashMap hashMap = propertyChanges;
                                    synchronized (hashMap) {
                                        propertyChanges.put(property.getProperty(), property);
                                    }
                                }
                                return false;
                            }
                        };
                        account.setNotifyHandler(handler);
                        account.setChecking(true);
                        if (!forceupdate) {
                            if (account.lastUpdateTime() != 0L) {
                                if (ai != null && ai.isExpired()) {
                                    account.setError(Account.AccountError.EXPIRED, -1L, null);
                                    AccountInfo accountInfo = ai;
                                    return accountInfo;
                                }
                                if (!account.isValid()) {
                                    account.setError(Account.AccountError.INVALID, -1L, null);
                                    AccountInfo accountInfo = ai;
                                    return accountInfo;
                                }
                            }
                            if (System.currentTimeMillis() - account.lastUpdateTime() < account.getRefreshTimeout()) {
                                AccountInfo accountInfo = ai;
                                return accountInfo;
                            }
                        }
                        PluginClassLoader.PluginClassLoaderChild cl = PluginClassLoader.getSharedChild(account.getPlugin());
                        PluginClassLoader.setThreadPluginClassLoaderChild(cl, null);
                        try {
                            plugin = account.getPlugin().getLazyP().newInstance(cl);
                            if (plugin == null) {
                                LogController.CL().severe("AccountCheck: Failed because plugin " + account.getHoster() + " is missing!");
                                account.setError(Account.AccountError.PLUGIN_ERROR, -1L, null);
                                AccountInfo errorNow = null;
                                return errorNow;
                            }
                        }
                        catch (Throwable e) {
                            LogController.CL().log(e);
                            account.setError(Account.AccountError.PLUGIN_ERROR, -1L, e.getMessage());
                            AccountInfo errorNow = null;
                            return errorNow;
                        }
                        whoAmI = account.getUser() + "->" + account.getHoster();
                        logger = LogController.getFastPluginLogger("accountCheck:" + plugin.getHost() + "_" + plugin.getLazyP().getClassName());
                        logger.info("Account Update: " + whoAmI + "(" + plugin.getLazyP().getClassName() + "|" + plugin.getVersion() + ")");
                        plugin.setLogger((LogInterface)logger);
                        Thread currentThread = Thread.currentThread();
                        bThread = null;
                        oldLogger = null;
                        if (currentThread instanceof BrowserSettingsThread) {
                            bThread = (BrowserSettingsThread)currentThread;
                        }
                        if (bThread != null) {
                            oldLogger = bThread.getLogger();
                            bThread.setLogger((LogInterface)logger);
                        }
                        Browser br = plugin.createNewBrowserInstance();
                        br.setLogger((LogInterface)logger);
                        plugin.setBrowser(br);
                        plugin.setDownloadLink(plugin.buildAccountCheckDownloadLink(account));
                        plugin.init();
                        account.setError(null, -1L, null);
                        ai = account.getAccountInfo();
                        if (ai != null) {
                            ai.setLastValidUntil(ai.getValidUntil());
                            ai.setExpired(false);
                        }
                        tempDisabledCounterBefore2222 = account.getTmpDisabledTimeout();
                        try {
                            plugin.validateLogins(account);
                            ai = plugin.fetchAccountInfo(account);
                            plugin.validateLastChallengeResponse();
                            account.setAccountInfo(ai);
                        }
                        finally {
                            account.setUpdateTime(System.currentTimeMillis());
                        }
                        if (account.isValid()) break block107;
                        logger.info("Account:" + whoAmI + "|Invalid!");
                        account.setError(Account.AccountError.INVALID, -1L, null);
                        AccountInfo accountInfo = ai;
                        try {
                            if (plugin != null) {
                                plugin.invalidateLastChallengeResponse();
                            }
                        }
                        catch (Throwable e) {
                            logger.log(e);
                        }
                        if (plugin != null) {
                            try {
                                plugin.clean();
                            }
                            catch (Throwable e) {
                                logger.log(e);
                            }
                        }
                        logger.close();
                        if (bThread != null) {
                            bThread.setLogger(oldLogger);
                        }
                        return accountInfo;
                    }
                    if (plugin.hasFeature(LazyPlugin.FEATURE.CAPTCHA_SOLVER)) {
                        ai.setStatus("Balance: " + ai.getAccountBalanceFormatted());
                        if (ai.getAccountBalance() <= 0.0) {
                            account.setError(Account.AccountError.INVALID, -1L, "Zero balance");
                        }
                        double lowBalanceThreshold = 1.0;
                        if (!(balanceBefore >= 1.0) || ai.getAccountBalance() < 1.0) {
                            // empty if block
                        }
                    }
                    account.setLastValidTimestamp(System.currentTimeMillis());
                    if (ai == null || !ai.isExpired()) break block108;
                    logger.clear();
                    logger.info("Account:" + whoAmI + "|Expired!");
                    account.setError(Account.AccountError.EXPIRED, -1L, null);
                    AccountInfo lowBalanceThreshold = ai;
                    try {
                        if (plugin != null) {
                            plugin.invalidateLastChallengeResponse();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                    if (plugin != null) {
                        try {
                            plugin.clean();
                        }
                        catch (Throwable e) {
                            logger.log(e);
                        }
                    }
                    logger.close();
                    if (bThread != null) {
                        bThread.setLogger(oldLogger);
                    }
                    return lowBalanceThreshold;
                }
                if (ai != null && !ai.isUnlimitedTraffic() && !ai.isSpecialTraffic() && ai.getTrafficLeft() == 0L) {
                    throw new AccountUnavailableException(_GUI.T.account_error_no_traffic_left(), 300000L);
                }
                if (tempDisabledCounterBefore2222 > 0L && account.getTmpDisabledTimeout() == tempDisabledCounterBefore2222) {
                    logger.info("no longer temp disabled!");
                    if (Account.AccountError.TEMP_DISABLED.equals((Object)account.getError())) {
                        account.setError(null, -1L, null);
                    }
                }
                logger.clear();
                try {
                    if (plugin != null) {
                        plugin.invalidateLastChallengeResponse();
                    }
                }
                catch (Throwable e) {
                    logger.log(e);
                }
                if (plugin != null) {
                    try {
                        plugin.clean();
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                }
                logger.close();
                if (bThread != null) {
                    bThread.setLogger(oldLogger);
                }
                break block109;
                catch (Throwable e) {
                    AccountInfo tempDisabledCounterBefore2222 = plugin.handleAccountException(account, (LogInterface)logger, e);
                    PluginClassLoader.setThreadPluginClassLoaderChild(null, null);
                    account.setNotifyHandler(null);
                    account.setChecking(false);
                    this.getEventSender().fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.ACCOUNT_CHECKED, account, new Object[0]));
                    this.checkAccountUpOrDowngrade(account);
                    Account.AccountError errorNow = account.getError();
                    if (errorBefore != errorNow) {
                        AccountProperty latestChangeEvent = null;
                        HashMap hashMap = propertyChanges;
                        synchronized (hashMap) {
                            latestChangeEvent = (AccountProperty)propertyChanges.get((Object)AccountProperty.Property.ERROR);
                        }
                        if (latestChangeEvent != null) {
                            this.getEventSender().fireEvent((DefaultEvent)new AccountPropertyChangedEvent(latestChangeEvent.getAccount(), latestChangeEvent));
                        }
                    }
                    return tempDisabledCounterBefore2222;
                }
            }
            AccountInfo accountInfo = ai;
            return accountInfo;
            {
                finally {
                    try {
                        if (plugin != null) {
                            plugin.invalidateLastChallengeResponse();
                        }
                    }
                    catch (Throwable e) {
                        logger.log(e);
                    }
                    if (plugin != null) {
                        try {
                            plugin.clean();
                        }
                        catch (Throwable e) {
                            logger.log(e);
                        }
                    }
                    logger.close();
                    if (bThread != null) {
                        bThread.setLogger(oldLogger);
                    }
                }
            }
        }
        finally {
            PluginClassLoader.setThreadPluginClassLoaderChild(null, null);
            account.setNotifyHandler(null);
            account.setChecking(false);
            this.getEventSender().fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.ACCOUNT_CHECKED, account, new Object[0]));
            this.checkAccountUpOrDowngrade(account);
            Account.AccountError errorNow = account.getError();
            if (errorBefore != errorNow) {
                AccountProperty latestChangeEvent = null;
                HashMap hashMap = propertyChanges;
                synchronized (hashMap) {
                    latestChangeEvent = (AccountProperty)propertyChanges.get((Object)AccountProperty.Property.ERROR);
                }
                if (latestChangeEvent != null) {
                    this.getEventSender().fireEvent((DefaultEvent)new AccountPropertyChangedEvent(latestChangeEvent.getAccount(), latestChangeEvent));
                }
            }
        }
    }

    private void checkAccountUpOrDowngrade(Account account) {
        boolean isPremiumUnlimitedRenewal;
        String lastKnownAccountType;
        AccountInfo ai = account.getAccountInfo();
        if (ai == null) {
            return;
        }
        if (account.getError() != null) {
            return;
        }
        if (account.getLastValidTimestamp() <= 0L) {
            return;
        }
        if (account.getPlugin() == null) {
            return;
        }
        Account.AccountType currentAccountType = account.getType();
        if (currentAccountType != null) {
            lastKnownAccountType = account.getStringProperty("lastKnownAccountType", currentAccountType.name());
            account.setProperty("lastKnownAccountType", currentAccountType.name());
        } else {
            lastKnownAccountType = account.getStringProperty("lastKnownAccountType", Account.AccountType.UNKNOWN.name());
            account.setProperty("lastKnownAccountType", Account.AccountType.UNKNOWN.name());
        }
        final long currentValidUntilTimeStamp = account.getValidPremiumUntil();
        boolean hasLastKnownPremiumValidUntilTimeStamp = account.hasProperty("lastKnownValidUntilTimeStamp");
        long lastKnownPremiumValidUntilTimeStamp = account.getLongProperty("lastKnownValidUntilTimeStamp", currentValidUntilTimeStamp);
        final boolean isPremiumAccount = Account.AccountType.PREMIUM.equals((Object)currentAccountType) || Account.AccountType.LIFETIME.equals((Object)currentAccountType);
        boolean wasPremiumAccount = Account.AccountType.PREMIUM.name().equals(lastKnownAccountType) || Account.AccountType.LIFETIME.name().equals(lastKnownAccountType);
        final boolean isPremiumUpgraded = isPremiumAccount && !wasPremiumAccount;
        final boolean isPremiumDowngraded = !isPremiumAccount && wasPremiumAccount;
        boolean isLimitedRenewal = currentValidUntilTimeStamp > lastKnownPremiumValidUntilTimeStamp && currentValidUntilTimeStamp - lastKnownPremiumValidUntilTimeStamp > 86400000L;
        final boolean isPremiumLimitedRenewal = isPremiumAccount && isLimitedRenewal;
        boolean isUnlimitedRenewal = currentValidUntilTimeStamp != lastKnownPremiumValidUntilTimeStamp && currentValidUntilTimeStamp == -1L;
        boolean bl = isPremiumUnlimitedRenewal = isPremiumAccount && isUnlimitedRenewal;
        if (isPremiumLimitedRenewal || isPremiumUnlimitedRenewal) {
            account.setProperty("lastKnownValidUntilTimeStamp", currentValidUntilTimeStamp);
        } else if (isPremiumAccount && !hasLastKnownPremiumValidUntilTimeStamp) {
            account.setProperty("lastKnownValidUntilTimeStamp", currentValidUntilTimeStamp);
        }
        final long renewalDuration = currentValidUntilTimeStamp > 0L ? (lastKnownPremiumValidUntilTimeStamp > 0L && lastKnownPremiumValidUntilTimeStamp - System.currentTimeMillis() > 0L ? currentValidUntilTimeStamp - lastKnownPremiumValidUntilTimeStamp : currentValidUntilTimeStamp - System.currentTimeMillis()) : 0L;
        if (isPremiumDowngraded || isPremiumUpgraded || isPremiumLimitedRenewal || isPremiumUnlimitedRenewal) {
            this.getEventSender().fireEvent((DefaultEvent)new AccountUpOrDowngradeEvent(this, account){

                @Override
                public boolean isPremiumAccount() {
                    return isPremiumAccount;
                }

                @Override
                public boolean isPremiumUpgraded() {
                    return isPremiumUpgraded;
                }

                @Override
                public boolean isPremiumDowngraded() {
                    return isPremiumDowngraded;
                }

                @Override
                public boolean isPremiumLimitedRenewal() {
                    return isPremiumLimitedRenewal;
                }

                @Override
                public boolean isPremiumUnlimitedRenewal() {
                    return isPremiumUnlimitedRenewal;
                }

                @Override
                public long getPremiumRenewalDuration() {
                    return renewalDuration;
                }

                @Override
                public long getExpireTimeStamp() {
                    return currentValidUntilTimeStamp;
                }
            });
        }
    }

    public void checkPluginUpdates() {
        PluginFinder pluginFinder = new PluginFinder();
        for (Account account : this.list(null)) {
            AccountInfo accountInfo = account.getAccountInfo();
            if (account.getPlugin() == null || !account.isMultiHost() || accountInfo == null) continue;
            try {
                accountInfo.setMultiHostSupportV2(account.getPlugin(), accountInfo.getMultiHostSupportV2(), pluginFinder);
                this.getEventSender().fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.ACCOUNT_CHECKED, account, new Object[0]));
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
    }

    public static AccountController getInstance() {
        return INSTANCE;
    }

    private synchronized HashMap<String, List<Account>> loadAccounts(AccountSettings config) {
        HashMap<String, ArrayList<AccountData>> dat = config.getAccounts();
        if (dat == null) {
            dat = new HashMap();
        }
        PluginFinder pluginFinder = new PluginFinder();
        HashMap<String, List<Account>> ret = new HashMap<String, List<Account>>();
        for (Map.Entry<String, ArrayList<AccountData>> next : dat.entrySet()) {
            if (next.getValue().size() <= 0) continue;
            String nextHost = next.getKey().toLowerCase(Locale.ENGLISH);
            for (AccountData ad : next.getValue()) {
                List<Account> accs;
                String accountHost;
                Account acc = ad.toAccount();
                acc.setHoster(nextHost);
                PluginForHost plugin = pluginFinder.assignPlugin(acc, true);
                if (plugin != null) {
                    accountHost = plugin.getHost();
                    acc.setPlugin(plugin);
                } else {
                    accountHost = nextHost;
                    acc.setPlugin(null);
                }
                AccountInfo ai = acc.getAccountInfo();
                if (ai != null) {
                    if (plugin != null) {
                        try {
                            ai.setMultiHostSupportV2(plugin, ai.getMultiHostSupportV2(), pluginFinder);
                        }
                        catch (Throwable e) {
                            LogController.CL().log(e);
                        }
                    } else {
                        ai.setMultiHostSupportV2(null, null, null);
                    }
                }
                if ((accs = ret.get(accountHost)) == null) {
                    accs = new ArrayList<Account>();
                    ret.put(accountHost, accs);
                }
                accs.add(acc);
            }
        }
        return ret;
    }

    @Deprecated
    public void addAccount(PluginForHost pluginForHost, Account account) {
        account.setHoster(pluginForHost.getHost());
        this.addAccount(account);
    }

    public ArrayList<Account> list(String host) {
        if (host == null) {
            return this.listAccounts(null);
        }
        return this.listAccounts(new AccountFilter(host));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<Account> listAccounts(AccountFilter filter) {
        ArrayList<Account> ret = new ArrayList<Account>();
        AccountController accountController = this;
        synchronized (accountController) {
            Integer maxResults = filter != null ? filter.getMaxResultsNum() : null;
            HashSet<String> hostPreFilter = null;
            if (filter != null) {
                hostPreFilter = new HashSet<String>();
                List<String> hosts = filter.getHosts();
                if (hosts != null) {
                    for (String host : hosts) {
                        hostPreFilter.add(StringUtils.toLowerCaseOrNull((String)host));
                    }
                }
                if (hostPreFilter.size() == 0) {
                    hostPreFilter = null;
                }
            }
            block4: for (Map.Entry<String, List<Account>> accounts : this.ACCOUNTS.entrySet()) {
                if (accounts.getValue() == null || hostPreFilter != null && !hostPreFilter.contains(accounts.getKey())) continue;
                for (Account account : accounts.getValue()) {
                    if (account.getPlugin() == null || filter != null && !filter.matches(account)) continue;
                    ret.add(account);
                    if (maxResults == null || ret.size() < maxResults) continue;
                    break block4;
                }
            }
        }
        return ret;
    }

    public List<Account> list() {
        return this.listAccounts(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAccountsSize(String host) {
        if (host == null) {
            return 0;
        }
        AccountController accountController = this;
        synchronized (accountController) {
            List<Account> ret = this.ACCOUNTS.get(host.toLowerCase(Locale.ENGLISH));
            if (ret != null && ret.size() > 0) {
                return ret.size();
            }
            return 0;
        }
    }

    public void addAccount(Account account) {
        this.addAccount(account, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account addAccount(Account account, boolean forceAccountCheckOnPropertyChange) {
        if (account == null) {
            return null;
        }
        if (account.getPlugin() == null) {
            new PluginFinder().assignPlugin(account, true);
        } else if (account.getHoster() == null) {
            return null;
        }
        Account existingAccount = null;
        AccountController accountController = this;
        synchronized (accountController) {
            String host = account.getHoster().toLowerCase(Locale.ENGLISH);
            List<Account> accs = this.ACCOUNTS.get(host);
            if (accs == null) {
                accs = new ArrayList<Account>();
                this.ACCOUNTS.put(host, accs);
            }
            String username = StringUtils.isNotEmpty((String)account.getUser()) ? account.getUser() : null;
            for (Account acc : accs) {
                if (acc == account) {
                    existingAccount = acc;
                    break;
                }
                if (username == null || !StringUtils.equals((String)acc.getUser(), (String)username) || !StringUtils.equals((String)acc.getPass(), (String)account.getPass())) continue;
                existingAccount = acc;
                break;
            }
            if (existingAccount == null && username != null) {
                for (Account acc : accs) {
                    if (!StringUtils.equals((String)acc.getUser(), (String)username)) continue;
                    existingAccount = acc;
                    break;
                }
            }
            if (existingAccount == null) {
                account.setAccountController(this);
                accs.add(account);
            }
        }
        if (existingAccount != null) {
            Account.AccountError newError = account.getError();
            AccountInfo newAccountInfo = account.getAccountInfo();
            if (!StringUtils.equals((String)existingAccount.getPass(), (String)account.getPass())) {
                existingAccount.setPass(account.getPass(), false);
            }
            if (newError == null) {
                existingAccount.setError(null, -1L, null, false);
                existingAccount.setAccountInfo(newAccountInfo);
                existingAccount.setProperties(account.getProperties());
            } else {
                existingAccount.setError(newError, -1L, account.getErrorString(), false);
                existingAccount.setTmpDisabledTimeout(account.getTmpDisabledTimeout());
                if (newAccountInfo != null) {
                    AccountInfo oldAccountInfo = existingAccount.getAccountInfo();
                    if (oldAccountInfo != null) {
                        for (Map.Entry entry : oldAccountInfo.getProperties().entrySet()) {
                            newAccountInfo.setProperty((String)entry.getKey(), entry.getValue());
                        }
                    }
                    existingAccount.setAccountInfo(newAccountInfo);
                }
                for (Map.Entry<String, Object> entry : account.getProperties().entrySet()) {
                    existingAccount.setProperty(entry.getKey(), entry.getValue());
                }
            }
            existingAccount.setEnabled(true, forceAccountCheckOnPropertyChange);
            this.getEventSender().fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.ACCOUNT_CHECKED, existingAccount, new Object[0]));
            return existingAccount;
        }
        this.getEventSender().fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.ADDED, account, new Object[0]));
        return account;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeAccount(Account account) {
        if (account == null) {
            return false;
        }
        account.setAccountController(null);
        AccountController accountController = this;
        synchronized (accountController) {
            String host = account.getHoster().toLowerCase(Locale.ENGLISH);
            List<Account> accs = this.ACCOUNTS.get(host);
            if (accs == null || !accs.remove(account)) {
                return false;
            }
            if (accs.size() == 0) {
                this.ACCOUNTS.remove(host);
            }
        }
        this.broadcaster.fireEvent((DefaultEvent)new AccountControllerEvent(this, AccountControllerEvent.Types.REMOVED, account, new Object[0]));
        return true;
    }

    @Override
    public void onAccountControllerEvent(AccountControllerEvent event) {
        Account acc = event.getAccount();
        this.delayedSaver.resetAndStart();
        Plugin.PluginEnvironment pluginEnvironment = Plugin.PluginEnvironment.getPluginEnvironment();
        boolean forceRecheck = false;
        switch ((AccountControllerEvent.Types)((Object)event.getType())) {
            case ADDED: {
                CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.setValue((Object)true);
                this.updateInternalMultiHosterMap(acc, acc.getAccountInfo());
                break;
            }
            case ACCOUNT_PROPERTY_UPDATE: {
                AccountProperty propertyChange = ((AccountPropertyChangedEvent)event).getProperty();
                switch (propertyChange.getProperty()) {
                    case ENABLED: {
                        if (Boolean.FALSE.equals(propertyChange.getValue())) {
                            return;
                        }
                        AccountInfo ai = acc.getAccountInfo();
                        if (!acc.isValid() || ai != null && ai.isExpired()) {
                            acc.setUpdateTime(0L);
                        }
                        forceRecheck = true;
                        break;
                    }
                    case ERROR: {
                        if (propertyChange.getValue() != null) {
                            return;
                        }
                        forceRecheck = true;
                        break;
                    }
                    case PASSWORD: 
                    case USERNAME: {
                        if (!Plugin.PluginEnvironment.UNKNOWN.equals((Object)pluginEnvironment)) break;
                        acc.setAccountInfo(null);
                        acc.setProperties(null);
                        acc.setUpdateTime(0L);
                        forceRecheck = true;
                    }
                }
                break;
            }
            case ACCOUNT_CHECKED: {
                this.updateInternalMultiHosterMap(acc, acc.getAccountInfo());
                return;
            }
            case REMOVED: {
                this.updateInternalMultiHosterMap(acc, null);
                return;
            }
        }
        if (acc == null || !acc.isEnabled()) {
            return;
        }
        if (Plugin.PluginEnvironment.ACCOUNT_CHECK.equals((Object)pluginEnvironment)) {
            return;
        }
        AccountChecker.getInstance().check(acc, forceRecheck);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAccountStats() {
        AccountController accountController = this;
        synchronized (accountController) {
            for (List<Account> accounts : this.ACCOUNTS.values()) {
                if (accounts == null) {
                    return;
                }
                for (Account acc : accounts) {
                    if (acc.getPlugin() == null || !acc.isEnabled() || !acc.isValid() || !acc.refreshTimeoutReached()) continue;
                    AccountChecker.getInstance().check(acc, false);
                }
            }
        }
    }

    public Account getValidAccount(PluginForHost pluginForHost) {
        return this.getValidAccount(pluginForHost.getHost());
    }

    public Account getValidAccount(String host) {
        ArrayList<Account> ret = this.getValidAccounts(host);
        if (ret != null && ret.size() > 0) {
            return (Account)ret.get(0);
        }
        return null;
    }

    public ArrayList<Account> getValidAccounts(String host) {
        ArrayList<Account> ret;
        if (StringUtils.isEmpty((String)host)) {
            return null;
        }
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof SingleDownloadController) {
            SingleDownloadController controller = (SingleDownloadController)((Object)currentThread);
            Account acc = controller.getAccount();
            if (acc == null) {
                return null;
            }
            if (StringUtils.equals((String)acc.getHosterByPlugin(), (String)host)) {
                ArrayList<Account> ret2 = new ArrayList<Account>();
                ret2.add(acc);
                return ret2;
            }
        }
        if ((ret = this.listAccounts(new AccountFilter(host).setEnabled(true).setValid(true).setTemporarilyDisabled(false))) == null || ret.size() == 0) {
            return null;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public List<Account> getMultiHostAccounts(String host) {
        if (host == null) {
            return null;
        }
        AccountController accountController = this;
        synchronized (accountController) {
            Map<Account, Object> list = this.MULTIHOSTER_ACCOUNTS.get(host.toLowerCase(Locale.ENGLISH));
            if (list != null && list.size() > 0) {
                return new ArrayList<Account>(list.keySet());
            }
        }
        return null;
    }

    public static String createFullBuyPremiumUrl(String buyPremiumUrl, String id) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyyyy'_'HHmm");
        id = id + "/" + simpleDateFormat.format(new Date());
        return "https://update3.jdownloader.org/jdserv/BuyPremiumInterface/redirect?" + Encoding.urlEncode((String)buyPremiumUrl) + "&" + Encoding.urlEncode((String)id);
    }

    public static String buildAfflink(LazyHostPlugin lazyHostPlugin, PluginForHost plugin, String source) {
        String ret = null;
        if (plugin != null) {
            ret = plugin.getBuyPremiumUrl();
        } else if (lazyHostPlugin != null) {
            try {
                plugin = lazyHostPlugin.getPrototype(null);
                ret = plugin.getBuyPremiumUrl();
            }
            catch (UpdateRequiredClassNotFoundException updateRequiredClassNotFoundException) {
                // empty catch block
            }
        }
        try {
            URLHelper.verifyURL((URL)new URL(ret));
        }
        catch (MalformedURLException e) {
            ret = null;
        }
        if (StringUtils.isEmpty((String)ret) && lazyHostPlugin != null && lazyHostPlugin.getHost().contains(".")) {
            ret = "https://" + lazyHostPlugin.getHost();
        }
        if (StringUtils.isEmpty((String)ret)) {
            return null;
        }
        return AccountController.createFullBuyPremiumUrl(ret, source);
    }

    public static void openAfflink(LazyHostPlugin lazyHostPlugin, PluginForHost plugin, String source) {
        String refURL = AccountController.buildAfflink(lazyHostPlugin, plugin, source);
        if (refURL == null) {
            return;
        }
        CrossSystem.openURL((String)refURL);
    }

    @Override
    public boolean fireAccountPropertyChange(AccountProperty propertyChange) {
        if (propertyChange.getAccount().isChecking()) {
            return false;
        }
        this.getEventSender().fireEvent((DefaultEvent)new AccountPropertyChangedEvent(propertyChange.getAccount(), propertyChange));
        return true;
    }

    public List<Account> importAccounts(File f) {
        AccountSettings cfg = (AccountSettings)JsonConfig.create((File)new File(f.getParent(), "org.jdownloader.settings.AccountSettings"), AccountSettings.class);
        long timeStamp = System.currentTimeMillis();
        HashMap<String, List<Account>> accounts = this.loadAccounts(cfg);
        ArrayList<Account> added = new ArrayList<Account>();
        for (Map.Entry<String, List<Account>> es : accounts.entrySet()) {
            for (Account ad : es.getValue()) {
                Account acc = new Account(ad.getUser(), ad.getPass());
                acc.setHoster(ad.getHoster());
                acc.setProperty("im", timeStamp);
                acc.setProperty("slid", cfg.getListID());
                acc.setProperty("slv", cfg.getListVersion());
                this.addAccount(acc);
                added.add(ad);
            }
        }
        return added;
    }
}

