/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.PluginForHost;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.controller.LazyPlugin;

public class AccountFilter {
    private List<String> hosts = null;
    private Boolean enabled = null;
    private Boolean valid = null;
    private List<Account.AccountType> accountTypes = null;
    private Boolean expired = null;
    private Boolean temporarilyDisabled = null;
    private Boolean multiHostAccount = null;
    private Long minimumTrafficLeft = null;
    private Double minimumBalance = null;
    private List<LazyPlugin.FEATURE> features = null;
    private Integer maxResultsNum = null;
    private String username = null;
    private String multiHostSupport = null;

    public AccountFilter() {
    }

    public AccountFilter(List<String> hosts) {
        this(hosts != null ? hosts.toArray(new String[0]) : null);
    }

    public AccountFilter(String ... hosts) {
        this.setHosts(hosts);
    }

    public AccountFilter setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public AccountFilter setValid(Boolean valid) {
        this.valid = valid;
        return this;
    }

    public AccountFilter setAccountTypes(Account.AccountType ... accountTypes) {
        this.accountTypes = accountTypes != null && accountTypes.length > 0 ? Arrays.asList(accountTypes) : null;
        return this;
    }

    public List<Account.AccountType> getAccountTypes() {
        return this.accountTypes;
    }

    public AccountFilter setExpired(Boolean expired) {
        this.expired = expired;
        return this;
    }

    public AccountFilter setTemporarilyDisabled(Boolean temporarilyDisabled) {
        this.temporarilyDisabled = temporarilyDisabled;
        return this;
    }

    public AccountFilter setMultiHostAccount(Boolean multiHostAccount) {
        this.multiHostAccount = multiHostAccount;
        return this;
    }

    public AccountFilter setMultiHostSupported(String multiHostSupport) {
        this.multiHostSupport = StringUtils.toLowerCaseOrNull((String)multiHostSupport);
        return this;
    }

    public AccountFilter setMinimumTrafficLeft(Long minimumTrafficLeft) {
        this.minimumTrafficLeft = minimumTrafficLeft;
        return this;
    }

    public AccountFilter setMinimumBalance(Double minimumBalance) {
        this.minimumBalance = minimumBalance;
        return this;
    }

    public AccountFilter setFeature(LazyPlugin.FEATURE ... features) {
        this.features = features != null && features.length > 0 ? Arrays.asList(features) : null;
        return this;
    }

    public AccountFilter setHosts(String ... hosts) {
        this.hosts = hosts != null && hosts.length > 0 ? Arrays.asList(hosts) : null;
        return this;
    }

    public AccountFilter setMaxResultsNum(Integer maxResultsNum) {
        this.maxResultsNum = maxResultsNum;
        return this;
    }

    public Integer getMaxResultsNum() {
        return this.maxResultsNum;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public AccountFilter setUsername(String username) {
        this.username = username;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    protected boolean matchesAccountType(Account account) {
        List<Account.AccountType> accountTypes = this.accountTypes;
        if (accountTypes != null && !accountTypes.isEmpty()) {
            Account.AccountType accountType = account.getType();
            if (accountType == null) {
                return false;
            }
            for (Account.AccountType type : accountTypes) {
                if (type == null || !type.equals((Object)accountType)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean matchesFeatures(Account account) {
        List<LazyPlugin.FEATURE> features = this.features;
        if (features != null && !features.isEmpty()) {
            PluginForHost plugin = account.getPlugin();
            if (plugin == null) {
                return false;
            }
            for (LazyPlugin.FEATURE feature : features) {
                if (plugin.hasFeature(feature)) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean matchesHost(Account account) {
        List<String> hosts = this.getHosts();
        if (hosts != null && !hosts.isEmpty()) {
            String accountHost = account.getHosterByPlugin();
            if (accountHost == null) {
                return false;
            }
            for (String host : hosts) {
                if (host == null || !host.equalsIgnoreCase(accountHost)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    protected boolean matchesUsername(Account account) {
        String username = this.username;
        if (username != null) {
            String accountUsername = account.getUser();
            if (accountUsername == null) {
                return false;
            }
            return accountUsername.equalsIgnoreCase(username);
        }
        return true;
    }

    protected boolean matchesMultiHostSupport(Account account) {
        String multiHostSupport = this.multiHostSupport;
        if (multiHostSupport != null) {
            if (!account.isMultiHost()) {
                return false;
            }
            AccountInfo ai = account.getAccountInfo();
            if (ai == null || ai.getMultihostSupportedHost(multiHostSupport) == null) {
                return false;
            }
        }
        return true;
    }

    protected boolean matchesMultiHostAccount(Account account) {
        Boolean multiHostAccount = this.multiHostAccount;
        return multiHostAccount == null || multiHostAccount.booleanValue() == account.isMultiHost();
    }

    public boolean matches(Account account) {
        AccountInfo ai;
        AccountInfo ai2;
        AccountInfo ai3;
        if (account == null || account.getPlugin() == null) {
            return false;
        }
        Boolean enabled = this.enabled;
        if (enabled != null && enabled.booleanValue() != account.isEnabled()) {
            return false;
        }
        Boolean valid = this.valid;
        if (valid != null && valid.booleanValue() != account.isValid()) {
            return false;
        }
        if (!this.matchesAccountType(account)) {
            return false;
        }
        if (!this.matchesMultiHostAccount(account)) {
            return false;
        }
        if (!this.matchesMultiHostSupport(account)) {
            return false;
        }
        if (!this.matchesHost(account)) {
            return false;
        }
        if (!this.matchesUsername(account)) {
            return false;
        }
        Boolean expired = this.expired;
        if (expired != null && (ai3 = account.getAccountInfo()) != null && expired.booleanValue() != ai3.isExpired()) {
            return false;
        }
        Boolean temporarilyDisabled = this.temporarilyDisabled;
        if (temporarilyDisabled != null && temporarilyDisabled.booleanValue() != account.isTempDisabled()) {
            return false;
        }
        Long minimumTrafficLeft = this.minimumTrafficLeft;
        if (minimumTrafficLeft != null && (ai2 = account.getAccountInfo()) != null && !ai2.isUnlimitedTraffic() && ai2.getTrafficLeft() < minimumTrafficLeft) {
            return false;
        }
        Double minimumBalance = this.minimumBalance;
        if (minimumBalance != null && (ai = account.getAccountInfo()) != null && ai.getAccountBalance() < minimumBalance) {
            return false;
        }
        return this.matchesFeatures(account);
    }

    public List<Account> filter(List<Account> accounts) {
        ArrayList<Account> result = new ArrayList<Account>();
        if (accounts == null) {
            return result;
        }
        Integer maxResultsNum = this.getMaxResultsNum();
        for (Account account : accounts) {
            if (!this.matches(account)) continue;
            result.add(account);
            if (maxResultsNum == null || result.size() < maxResultsNum) continue;
            break;
        }
        return result;
    }
}

