/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jd.controlling.WindowsClipboardChangeDetector;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkModifier;
import jd.parser.html.HTMLParser;
import org.appwork.utils.IO;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.os.CrossSystem;
import org.jdownloader.controlling.PasswordUtils;
import org.jdownloader.gui.views.components.packagetable.dragdrop.PackageControllerTableTransferable;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GraphicalUserInterfaceSettings;

public class ClipboardMonitoring {
    private static final ClipboardMonitoring INSTANCE = new ClipboardMonitoring();
    private static final DataFlavor URLFLAVOR;
    private static final DataFlavor URILISTFLAVOR;
    private final AtomicReference<Object> monitoringThread;
    private final Clipboard clipboard;
    private static final AtomicReference<GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE> CLIPBOARD_SKIP_MODE;
    private final AtomicReference<AtomicBoolean> skipChangeDetection;
    private static final AtomicBoolean HTML_FLAVOR_ALLOWED;
    private final ClipboardChangeDetector clipboardChangeDetector;
    private final LogSource logger;
    private static final byte[] REPLACEMENT_CHARACTER;

    public static boolean isHtmlFlavorAllowed() {
        return HTML_FLAVOR_ALLOWED.get();
    }

    public static void setHtmlFlavorAllowed(boolean htmlFlavor) {
        HTML_FLAVOR_ALLOWED.set(htmlFlavor);
    }

    public static void setClipboardSkipMode(GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE mode) {
        if (mode == null) {
            CLIPBOARD_SKIP_MODE.set(GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE.ON_STARTUP);
        } else {
            CLIPBOARD_SKIP_MODE.set(mode);
        }
    }

    private IGNORE ignoreTransferable(Transferable transferable, DataFlavor[] dataFlavors) {
        if (transferable == null && (dataFlavors == null || dataFlavors.length == 0)) {
            return IGNORE.EMPTY;
        }
        if (ClipboardMonitoring.isDataFlavorSupported(transferable, dataFlavors, PackageControllerTableTransferable.FLAVOR)) {
            return IGNORE.PACKAGECONTROLLER;
        }
        try {
            if (transferable != null && transferable.getClass().getName().contains("TransferableProxy")) {
                Field isLocal = transferable.getClass().getDeclaredField("isLocal");
                if (isLocal != null) {
                    isLocal.setAccessible(true);
                    if (Boolean.TRUE.equals(isLocal.getBoolean(transferable))) {
                        return IGNORE.LOCAL;
                    }
                }
            } else if (dataFlavors != null) {
                for (DataFlavor dataFlavor : dataFlavors) {
                    if (!StringUtils.equals((String)dataFlavor.getHumanPresentableName(), (String)"application/x-java-jvm-local-objectref")) continue;
                    return IGNORE.JVM;
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return IGNORE.NO;
    }

    public static Transferable getTransferable() {
        return ClipboardMonitoring.getINSTANCE().clipboard.getContents(null);
    }

    public synchronized void startMonitoring() {
        if (this.clipboard != null && !this.isMonitoring()) {
            final boolean skipFirstRound = GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE.ON_STARTUP.equals((Object)CLIPBOARD_SKIP_MODE.get()) && this.monitoringThread.get() == null || GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE.ON_ENABLE.equals((Object)CLIPBOARD_SKIP_MODE.get());
            Thread newMonitoringThread = new Thread(){
                private final AtomicLong roundIndex = new AtomicLong(0L);
                private ClipboardHash oldStringContent = new ClipboardHash(0, -1);
                private ClipboardHash oldListContent = new ClipboardHash(0, -1);
                private ClipboardHash oldHTMLFragment = new ClipboardHash(0, -1);

                private String handleThisRound(String existing, String add) {
                    if (existing == null) {
                        if (StringUtils.isNotEmpty((String)add)) {
                            return add;
                        }
                        return null;
                    }
                    if (StringUtils.isNotEmpty((String)add)) {
                        if (existing.equals(add)) {
                            return existing;
                        }
                        return existing + "\r\n" + add;
                    }
                    return existing;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        ClipboardMonitoring.this.clipboardChangeDetector.reset();
                        block24: while (Thread.currentThread() == ClipboardMonitoring.this.monitoringThread.get()) {
                            final ClipboardChangeDetector.CHANGE_FLAG changeFlag = ClipboardMonitoring.this.clipboardChangeDetector.waitForClipboardChanges();
                            if (Thread.currentThread() != ClipboardMonitoring.this.monitoringThread.get()) {
                                ClipboardMonitoring.this.logger.finer("Changed ClipBoard Monitoring Thread");
                                return;
                            }
                            if (ClipboardChangeDetector.CHANGE_FLAG.INTERRUPTED.equals((Object)changeFlag)) {
                                ClipboardMonitoring.this.logger.finer("Interrupted ClipBoard Monitoring Thread");
                                return;
                            }
                            try {
                                Object htmlFragment;
                                String debugHtmlFragment;
                                String debugStringContent;
                                String browserURL;
                                String debugListContent;
                                boolean macOSWorkaroundNeeded;
                                String handleThisRound;
                                Transferable currentContent;
                                DataFlavor[] dataFlavors;
                                block43: {
                                    block42: {
                                        dataFlavors = ClipboardMonitoring.this.clipboard.getAvailableDataFlavors();
                                        currentContent = null;
                                        IGNORE ignoreFlag = ClipboardMonitoring.this.ignoreTransferable(currentContent, dataFlavors);
                                        switch (ignoreFlag) {
                                            case EMPTY: 
                                            case JVM: 
                                            case LOCAL: 
                                            case PACKAGECONTROLLER: {
                                                if (!ClipboardChangeDetector.CHANGE_FLAG.DETECTED.equals((Object)changeFlag)) continue block24;
                                                this.roundIndex.getAndIncrement();
                                                continue block24;
                                            }
                                        }
                                        handleThisRound = null;
                                        macOSWorkaroundNeeded = false;
                                        debugListContent = null;
                                        try {
                                            String newListContent = ClipboardMonitoring.getListTransferData(currentContent, dataFlavors);
                                            try {
                                                if (!this.oldListContent.equals(newListContent)) {
                                                    debugListContent = newListContent;
                                                    handleThisRound = this.handleThisRound(handleThisRound, newListContent);
                                                }
                                            }
                                            finally {
                                                this.oldListContent = new ClipboardHash(newListContent);
                                            }
                                        }
                                        catch (Throwable e) {
                                            if (!CrossSystem.isMac() || !(e instanceof IOException)) break block42;
                                            macOSWorkaroundNeeded = true;
                                        }
                                    }
                                    browserURL = null;
                                    boolean htmlFlavorAllowed = ClipboardMonitoring.isHtmlFlavorAllowed();
                                    debugStringContent = null;
                                    debugHtmlFragment = null;
                                    if (StringUtils.isEmpty(handleThisRound) || CrossSystem.isMac()) {
                                        String newStringContent = ClipboardMonitoring.getStringTransferData(currentContent, dataFlavors);
                                        try {
                                            if (!this.oldStringContent.equals(newStringContent)) {
                                                debugStringContent = newStringContent;
                                                handleThisRound = this.handleThisRound(handleThisRound, newStringContent);
                                                try {
                                                    htmlFragment = ClipboardMonitoring.getHTMLFragment(currentContent, dataFlavors);
                                                    if (htmlFragment != null) {
                                                        if (!this.oldHTMLFragment.equals(((HTMLFragment)htmlFragment).getFragment())) {
                                                            this.oldHTMLFragment = new ClipboardHash(((HTMLFragment)htmlFragment).getFragment());
                                                            debugHtmlFragment = ((HTMLFragment)htmlFragment).getFragment();
                                                            if (htmlFlavorAllowed) {
                                                                handleThisRound = this.handleThisRound(handleThisRound, ((HTMLFragment)htmlFragment).getFragment());
                                                            }
                                                            browserURL = ((HTMLFragment)htmlFragment).getSourceURL();
                                                        }
                                                        break block43;
                                                    }
                                                    this.oldHTMLFragment = new ClipboardHash(null);
                                                }
                                                catch (Throwable htmlFragment2) {}
                                                break block43;
                                            }
                                            try {
                                                htmlFragment = ClipboardMonitoring.getHTMLFragment(currentContent, dataFlavors);
                                                if (htmlFragment != null) {
                                                    if (!this.oldHTMLFragment.equals(((HTMLFragment)htmlFragment).getFragment())) {
                                                        this.oldHTMLFragment = new ClipboardHash(((HTMLFragment)htmlFragment).getFragment());
                                                        debugHtmlFragment = ((HTMLFragment)htmlFragment).getFragment();
                                                        if (htmlFlavorAllowed) {
                                                            handleThisRound = this.handleThisRound(newStringContent, ((HTMLFragment)htmlFragment).getFragment());
                                                        }
                                                        browserURL = ((HTMLFragment)htmlFragment).getSourceURL();
                                                    }
                                                    break block43;
                                                }
                                                this.oldHTMLFragment = new ClipboardHash(null);
                                            }
                                            catch (Throwable htmlFragment3) {
                                                // empty catch block
                                            }
                                        }
                                        finally {
                                            this.oldStringContent = new ClipboardHash(newStringContent);
                                        }
                                    }
                                }
                                if (handleThisRound != null || ClipboardChangeDetector.CHANGE_FLAG.DETECTED.equals((Object)changeFlag)) {
                                    final ClipboardHash stringContent = this.oldStringContent;
                                    htmlFragment = this.oldHTMLFragment;
                                    ClipboardHash listContent = this.oldListContent;
                                    final String stringDebugContent = debugStringContent;
                                    String listDebugContent = debugListContent;
                                    String htmlFragmentDebugContent = debugHtmlFragment;
                                    final long round = this.roundIndex.getAndIncrement();
                                    if (StringUtils.isNotEmpty((String)handleThisRound) && (round > 0L || !skipFirstRound)) {
                                        ClipboardMonitoring.this.clipboardChangeDetector.restart();
                                        if (stringContent.getClipboardLength() > 7 || ((ClipboardHash)htmlFragment).getClipboardLength() > 14 || listContent.getClipboardLength() > 7) {
                                            LinkCollectingJob job = new LinkCollectingJob(LinkOrigin.CLIPBOARD.getLinkOriginDetails(), handleThisRound, (ClipboardHash)htmlFragment, htmlFragmentDebugContent, listContent, listDebugContent){
                                                final /* synthetic */ ClipboardHash val$htmlFragment;
                                                final /* synthetic */ String val$htmlFragmentDebugContent;
                                                final /* synthetic */ ClipboardHash val$listContent;
                                                final /* synthetic */ String val$listDebugContent;
                                                {
                                                    this.val$htmlFragment = clipboardHash2;
                                                    this.val$htmlFragmentDebugContent = string2;
                                                    this.val$listContent = clipboardHash3;
                                                    this.val$listDebugContent = string3;
                                                    super(origin, jobContent);
                                                }

                                                @Override
                                                public String toString() {
                                                    return super.toString() + "|ChangeFlag:" + (Object)((Object)changeFlag) + "|Round:" + round + "|StringContent:(" + (stringDebugContent != null) + "|" + stringContent + ")|HTMLFragment:(" + (this.val$htmlFragmentDebugContent != null) + "|" + this.val$htmlFragment + ")|ListContent:(" + (this.val$listDebugContent != null) + "|" + this.val$listContent + ")";
                                                }
                                            };
                                            final HashSet<String> pws = PasswordUtils.getPasswords(handleThisRound);
                                            if (pws != null && pws.size() > 0) {
                                                job.addPrePackagizerModifier(new CrawledLinkModifier(){

                                                    @Override
                                                    public boolean modifyCrawledLink(CrawledLink link) {
                                                        link.getArchiveInfo().getExtractionPasswords().addAll(pws);
                                                        return true;
                                                    }
                                                });
                                            }
                                            if (browserURL == null) {
                                                try {
                                                    browserURL = ClipboardMonitoring.getCurrentBrowserURL(currentContent, dataFlavors, null);
                                                }
                                                catch (Throwable e) {
                                                    e.printStackTrace();
                                                }
                                            }
                                            job.setCustomSourceUrl(browserURL);
                                            LinkCollector.getInstance().addCrawlerJob(job);
                                        }
                                    }
                                }
                                if (!macOSWorkaroundNeeded) continue;
                                ClipboardMonitoring.this.setCurrentContent(handleThisRound);
                            }
                            catch (Throwable e) {
                                ClipboardMonitoring.this.clipboardChangeDetector.slowDown(e);
                                String message = e.getMessage();
                                if (StringUtils.containsIgnoreCase((String)message, (String)"Font transform has") || StringUtils.containsIgnoreCase((String)message, (String)"Failed to retrieve atom name") || StringUtils.containsIgnoreCase((String)message, (String)"cannot open system clipboard") || StringUtils.containsIgnoreCase((String)message, (String)"Owner failed to convert data") || StringUtils.containsIgnoreCase((String)message, (String)"Owner timed out") || StringUtils.containsIgnoreCase((String)message, (String)"system clipboard data unavailable")) continue;
                                if (message != null) {
                                    ClipboardMonitoring.this.logger.severe(message);
                                }
                                ClipboardMonitoring.this.logger.log(e);
                            }
                        }
                    }
                    finally {
                        this.oldStringContent = null;
                        this.oldHTMLFragment = null;
                        this.oldListContent = null;
                        ClipboardMonitoring.this.monitoringThread.compareAndSet(Thread.currentThread(), ClipboardMonitoring.this);
                    }
                }
            };
            newMonitoringThread.setName("ClipboardMonitor");
            newMonitoringThread.setDaemon(true);
            Object oldMonitoringThread = this.monitoringThread.getAndSet(newMonitoringThread);
            newMonitoringThread.start();
            if (oldMonitoringThread != null && oldMonitoringThread instanceof Thread) {
                ((Thread)oldMonitoringThread).interrupt();
            }
        }
    }

    public synchronized ClipboardContent getCurrentContent() {
        if (this.clipboard != null) {
            try {
                Transferable currentContent = this.clipboard.getContents(null);
                return this.getCurrentContent(currentContent);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized ClipboardContent getCurrentContent(Transferable currentContent) {
        if (currentContent != null) {
            ClipboardContent ret = this.getCurrentContent(currentContent, true, true, ClipboardMonitoring.isHtmlFlavorAllowed());
            if (ret == null) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)ret.getContentText())) {
                sb.append("<");
                sb.append(ret.getContentText());
                sb.append(">");
            }
            if (StringUtils.isNotEmpty((String)ret.getContentHtml())) {
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append("<");
                sb.append(ret.getContentHtml());
                sb.append(">");
            }
            if (sb.length() > 0) {
                return new ClipboardContent(ret.getBrowserURL(), ret.getContentText(), ret.getContentHtml(), sb.toString());
            }
        }
        return null;
    }

    public synchronized ClipboardContent getCurrentContent(boolean browserURL, boolean contentText, boolean contentHtml) {
        if (this.clipboard != null) {
            try {
                Transferable currentContent = this.clipboard.getContents(null);
                return this.getCurrentContent(currentContent, browserURL, contentText, contentHtml);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    public synchronized ClipboardContent getCurrentContent(Transferable currentContent, boolean browserURL, boolean contentText, boolean contentHtml) {
        if (currentContent == null) {
            return null;
        }
        String stringContent = null;
        if (contentText) {
            try {
                stringContent = ClipboardMonitoring.getStringTransferData(currentContent, null);
            }
            catch (Throwable e) {
                contentText = false;
            }
        }
        HTMLFragment htmlFragment = null;
        String sourceURL = null;
        if (browserURL || contentHtml) {
            try {
                htmlFragment = ClipboardMonitoring.getHTMLFragment(currentContent, null);
                sourceURL = htmlFragment.getSourceURL();
            }
            catch (Throwable e) {
                contentHtml = false;
            }
        }
        if (browserURL && StringUtils.isEmpty(sourceURL)) {
            try {
                sourceURL = ClipboardMonitoring.getCurrentBrowserURL(currentContent);
            }
            catch (Throwable e) {
                browserURL = false;
            }
        }
        if (browserURL && StringUtils.isNotEmpty(sourceURL) || contentHtml && htmlFragment != null && StringUtils.isNotEmpty((String)htmlFragment.getFragment()) || contentText && StringUtils.isNotEmpty((String)stringContent)) {
            return new ClipboardContent(sourceURL, stringContent, htmlFragment == null ? null : htmlFragment.getFragment());
        }
        return null;
    }

    public synchronized void setCurrentContent(String string) {
        block3: {
            if (this.clipboard != null) {
                try {
                    final AtomicBoolean skipFlag = new AtomicBoolean(true);
                    this.skipChangeDetection.set(skipFlag);
                    this.clipboard.setContents(new StringSelection(string), new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            skipFlag.set(false);
                        }
                    });
                }
                catch (Throwable e) {
                    AtomicBoolean old = this.skipChangeDetection.getAndSet(null);
                    if (old == null) break block3;
                    old.set(false);
                }
            }
        }
    }

    public synchronized void setCurrentContent(Transferable object) {
        block3: {
            if (this.clipboard != null) {
                try {
                    final AtomicBoolean skipFlag = new AtomicBoolean(true);
                    this.skipChangeDetection.set(skipFlag);
                    this.clipboard.setContents(object, new ClipboardOwner(){

                        @Override
                        public void lostOwnership(Clipboard clipboard, Transferable contents) {
                            skipFlag.set(false);
                        }
                    });
                }
                catch (Throwable e) {
                    AtomicBoolean old = this.skipChangeDetection.getAndSet(null);
                    if (old == null) break block3;
                    old.set(false);
                }
            }
        }
    }

    public synchronized void stopMonitoring() {
        Object thread = this.monitoringThread.getAndSet(this);
        if (thread != null && thread instanceof Thread) {
            ((Thread)thread).interrupt();
        }
    }

    public boolean isMonitoring() {
        Object thread = this.monitoringThread.get();
        return thread != null && thread instanceof Thread && ((Thread)thread).isAlive();
    }

    public ClipboardMonitoring() {
        WindowsClipboardChangeDetector clipboardChangeDetector;
        Clipboard lclipboard;
        block5: {
            this.monitoringThread = new AtomicReference<Object>(null);
            this.skipChangeDetection = new AtomicReference<Object>(null);
            this.logger = LogController.CL(ClipboardMonitoring.class);
            lclipboard = null;
            clipboardChangeDetector = null;
            try {
                if (GraphicsEnvironment.isHeadless() || (lclipboard = Toolkit.getDefaultToolkit().getSystemClipboard()) == null || !CrossSystem.isWindows()) break block5;
                try {
                    if (CrossSystem.getOS().isMinimum(CrossSystem.OperatingSystem.WINDOWS_XP)) {
                        clipboardChangeDetector = new WindowsClipboardChangeDetector(this.skipChangeDetection, this.logger);
                    }
                }
                catch (Throwable th) {
                    this.logger.log(th);
                }
            }
            catch (Throwable th) {
                this.logger.log(th);
            }
        }
        this.clipboard = lclipboard;
        this.clipboardChangeDetector = this.clipboard != null ? (clipboardChangeDetector == null ? new ClipboardChangeDetector(this.skipChangeDetection) : clipboardChangeDetector) : null;
    }

    @Deprecated
    public static String getHTMLTransferData(Transferable transferable) throws UnsupportedFlavorException, IOException {
        HTMLFragment ret = ClipboardMonitoring.getHTMLFragment(transferable, null);
        if (ret != null) {
            return ret.getFragment();
        }
        return null;
    }

    public static HTMLFragment getHTMLFragment(Transferable transferable, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException {
        String result = ClipboardMonitoring.getMimeTypeFragment(transferable, ".*?text/html.*", dataFlavors);
        if (CrossSystem.isWindows()) {
            String sourceURL = new Regex(result, "EndFragment:\\d+[\r\n]*SourceURL:(.*?)(\r|\n)").getMatch(0);
            String fragment = new Regex(result, "<!--StartFragment-->(.*?)<!--EndFragment-->").getMatch(0);
            if (fragment != null) {
                if (!StringUtils.isEmpty((String)sourceURL) && HTMLParser.getProtocol(sourceURL) != null) {
                    return new HTMLFragment(sourceURL, fragment);
                }
                String browserURL = ClipboardMonitoring.getCurrentBrowserURL(transferable, dataFlavors, result);
                return new HTMLFragment(browserURL, fragment);
            }
        }
        String browserURL = ClipboardMonitoring.getCurrentBrowserURL(transferable, dataFlavors, result);
        return new HTMLFragment(browserURL, result);
    }

    public static String getTextFragment(Transferable transferable, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException {
        return ClipboardMonitoring.getMimeTypeFragment(transferable, ".*?text/plain.*", dataFlavors);
    }

    public static String getMimeTypeFragment(Transferable transferable, String pattern, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException {
        byte[] htmlDataBytes;
        DataFlavor[] flavors;
        DataFlavor mimeTypeFlavor = null;
        Class<byte[]> preferClass = byte[].class;
        if (transferable != null) {
            flavors = transferable.getTransferDataFlavors();
        } else if (dataFlavors != null) {
            flavors = dataFlavors;
        } else {
            return null;
        }
        for (DataFlavor flav : flavors) {
            String charSet;
            if (!flav.getMimeType().matches(pattern) || !flav.getRepresentationClass().isAssignableFrom(preferClass)) continue;
            if (mimeTypeFlavor == null) {
                mimeTypeFlavor = flav;
            }
            if (!"UTF-8".equalsIgnoreCase(charSet = new Regex(flav.toString(), "charset=(.*?)]").getMatch(0))) continue;
            mimeTypeFlavor = flav;
            break;
        }
        if ((htmlDataBytes = ClipboardMonitoring.getBytes(transferable, flavors, null, mimeTypeFlavor)) != null && htmlDataBytes.length != 0) {
            String charSet = new Regex(mimeTypeFlavor.toString(), "charset=(.*?)]").getMatch(0);
            String result = ClipboardMonitoring.convertBytes(htmlDataBytes, Charset.forName(charSet), true);
            return result;
        }
        return null;
    }

    private static final boolean startsWith(byte[] array, int startIndex, byte[] check) {
        if (array != null && check != null && array.length >= startIndex + check.length) {
            for (int index = 0; index < check.length; ++index) {
                if (array[startIndex + index] == check[index]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static String convertBytes(byte[] bytes, Charset charSet, boolean linuxWorkaround) throws UnsupportedEncodingException {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        if (charSet == null) {
            charSet = IO.BOM.UTF8.getCharSet();
        }
        if (CrossSystem.isUnix()) {
            int indexOriginal = 0;
            int i = 0;
            block0: while (true) {
                if (ClipboardMonitoring.startsWith(bytes, i, REPLACEMENT_CHARACTER)) {
                    i += REPLACEMENT_CHARACTER.length;
                    continue;
                }
                for (IO.BOM bom : IO.BOM.values()) {
                    if (!ClipboardMonitoring.startsWith(bytes, i, bom.getBOM())) continue;
                    i += bom.length();
                    charSet = bom.getCharSet();
                    continue block0;
                }
                break;
            }
            while (i < bytes.length) {
                if (bytes[i] != 0) {
                    bytes[indexOriginal++] = bytes[i];
                }
                ++i;
            }
            return new String(bytes, 0, indexOriginal, charSet);
        }
        return new String(bytes, charSet);
    }

    public static boolean hasSupportedTransferData(Transferable transferable) {
        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            return true;
        }
        if (URLFLAVOR != null && transferable.isDataFlavorSupported(URLFLAVOR)) {
            return true;
        }
        if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            return true;
        }
        return URILISTFLAVOR != null && transferable.isDataFlavorSupported(URILISTFLAVOR);
    }

    public static void processSupportedTransferData(Transferable transferable, LinkOrigin origin) {
        try {
            String content;
            DataFlavor[] dataFlavors = null;
            String listContent = ClipboardMonitoring.getListTransferData(transferable, dataFlavors);
            String stringContent = ClipboardMonitoring.getStringTransferData(transferable, dataFlavors);
            HTMLFragment htmlFragment = StringUtils.isNotEmpty((String)stringContent) ? ClipboardMonitoring.getHTMLFragment(transferable, null) : null;
            String sourceURL = htmlFragment != null && StringUtils.isNotEmpty((String)htmlFragment.getSourceURL()) ? htmlFragment.getSourceURL() : (htmlFragment == null ? ClipboardMonitoring.getCurrentBrowserURL(transferable, dataFlavors, null) : ClipboardMonitoring.getCurrentBrowserURL(transferable, dataFlavors, htmlFragment.getFragment()));
            StringBuilder sb = new StringBuilder();
            if (StringUtils.isNotEmpty((String)listContent)) {
                sb.append("<");
                sb.append(listContent);
                sb.append(">\r\n\r\n");
            }
            if (StringUtils.isEmpty((String)listContent) && StringUtils.isNotEmpty((String)stringContent)) {
                sb.append("<");
                sb.append(stringContent);
                sb.append(">\r\n\r\n");
            }
            if (htmlFragment != null && ClipboardMonitoring.isHtmlFlavorAllowed() && StringUtils.isNotEmpty((String)htmlFragment.getFragment())) {
                sb.append("<");
                sb.append(htmlFragment.getFragment());
                sb.append(">");
            }
            if (!StringUtils.isEmpty((String)(content = sb.toString()))) {
                LinkCollectingJob job = new LinkCollectingJob(origin.getLinkOriginDetails(), content);
                job.setCustomSourceUrl(sourceURL);
                final HashSet<String> pws = PasswordUtils.getPasswords(content);
                if (pws != null && pws.size() > 0) {
                    job.setArchivPasswords(new ArrayList<String>(pws));
                    job.addPrePackagizerModifier(new CrawledLinkModifier(){

                        @Override
                        public boolean modifyCrawledLink(CrawledLink link) {
                            link.getArchiveInfo().getExtractionPasswords().addAll(pws);
                            return true;
                        }
                    });
                }
                LinkCollector.getInstance().addCrawlerJob(job);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getStringTransferData(Transferable transferable, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException {
        if (ClipboardMonitoring.isDataFlavorSupported(transferable, dataFlavors, DataFlavor.stringFlavor)) {
            Object ret = null;
            try {
                ret = ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, DataFlavor.stringFlavor);
            }
            catch (UnsupportedFlavorException e) {
                if (StringUtils.containsIgnoreCase((String)e.getMessage(), (String)"Unicode String")) {
                    return null;
                }
                throw e;
            }
            if (ret == null) {
                return null;
            }
            return StringUtils.removeBOM((String)ret.toString());
        }
        return null;
    }

    public static String getURLTransferData(Transferable transferable, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException {
        if (URLFLAVOR != null && ClipboardMonitoring.isDataFlavorSupported(transferable, dataFlavors, URLFLAVOR)) {
            Object ret = ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, URLFLAVOR);
            if (ret == null) {
                return null;
            }
            URL url = (URL)ret;
            if (StringUtils.isEmpty((String)url.getFile())) {
                return null;
            }
            return url.toExternalForm();
        }
        return null;
    }

    public static boolean isDataFlavorSupported(Transferable transferable, DataFlavor[] dataFlavors, DataFlavor dataFlavor) {
        if (transferable != null && transferable.isDataFlavorSupported(dataFlavor)) {
            return true;
        }
        if (dataFlavors != null) {
            for (int index = 0; index < dataFlavors.length; ++index) {
                if (!dataFlavors[index].equals(dataFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    public static Object getTransferData(Transferable transferable, Clipboard clipboard, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (transferable != null) {
            return transferable.getTransferData(dataFlavor);
        }
        if (clipboard != null) {
            return clipboard.getData(dataFlavor);
        }
        return null;
    }

    public static String getListTransferData(Transferable transferable, DataFlavor[] dataFlavors) throws UnsupportedFlavorException, IOException, URISyntaxException {
        Object ret;
        StringBuilder sb = new StringBuilder("");
        if (URILISTFLAVOR != null && ClipboardMonitoring.isDataFlavorSupported(transferable, dataFlavors, URILISTFLAVOR) && (ret = ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, URILISTFLAVOR)) != null) {
            StringTokenizer izer = new StringTokenizer((String)ret, "\r\n");
            while (izer.hasMoreTokens()) {
                File probe;
                String next;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                if (!StringUtils.isNotEmpty((String)(next = izer.nextToken()))) continue;
                if (next.matches("(?i)^(https?|ftp):/.+")) {
                    sb.append(next);
                    continue;
                }
                if (next.matches("(?i)^file:/.+")) {
                    sb.append(next.replaceFirst("file:///", "file:/"));
                    continue;
                }
                if (!next.startsWith("/") || !(probe = new File(next)).isAbsolute()) continue;
                sb.append(probe.toURI().toString());
            }
        }
        if (sb.length() == 0 && ClipboardMonitoring.isDataFlavorSupported(transferable, dataFlavors, DataFlavor.javaFileListFlavor) && (ret = ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, DataFlavor.javaFileListFlavor)) != null) {
            List list = (List)ret;
            for (File f : list) {
                if (!f.isAbsolute()) continue;
                if (sb.length() > 0) {
                    sb.append("\r\n");
                }
                sb.append(f.toURI().toString());
            }
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static ClipboardMonitoring getINSTANCE() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] getBytes(Transferable transferable, DataFlavor[] dataFlavors, String mimeType, DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        DataFlavor found;
        DataFlavor flavor;
        if (mimeType == null && dataFlavor == null) {
            return null;
        }
        Class<byte[]> preferClass = byte[].class;
        if (dataFlavor != null) {
            flavor = dataFlavor;
        } else if (transferable != null) {
            found = null;
            for (DataFlavor test : transferable.getTransferDataFlavors()) {
                if (!test.getMimeType().contains(mimeType) || !test.getRepresentationClass().isAssignableFrom(preferClass)) continue;
                found = test;
                break;
            }
            flavor = found;
        } else if (dataFlavors != null) {
            found = null;
            for (DataFlavor test : dataFlavors) {
                if (!test.getMimeType().contains(mimeType) || !test.getRepresentationClass().isAssignableFrom(preferClass)) continue;
                found = test;
                break;
            }
            flavor = found;
        } else {
            flavor = null;
        }
        if (flavor != null) {
            byte[] htmlBytes = null;
            if (flavor.getRepresentationClass().isAssignableFrom(byte[].class)) {
                htmlBytes = (byte[])ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, flavor);
            } else if (flavor.getRepresentationClass().isAssignableFrom(InputStream.class)) {
                InputStream is = null;
                try {
                    is = (InputStream)ClipboardMonitoring.getTransferData(transferable, ClipboardMonitoring.getINSTANCE().clipboard, flavor);
                    htmlBytes = IO.readStream((int)-1, (InputStream)is);
                }
                finally {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
            return htmlBytes;
        }
        return null;
    }

    public static String getCurrentBrowserURL(Transferable transferable) throws UnsupportedFlavorException, IOException {
        return ClipboardMonitoring.getCurrentBrowserURL(transferable, null, null);
    }

    public static String getCurrentBrowserURL(Transferable transferable, DataFlavor[] dataFlavors, String htmlFlavor) throws UnsupportedFlavorException, IOException {
        String viewSource;
        String ret = ClipboardMonitoring.getBrowserMime(transferable, dataFlavors, "x-moz-url");
        if (!StringUtils.isEmpty((String)ret)) {
            String[] lines = Regex.getLines((String)ret);
            if (lines != null && lines.length > 0) {
                ret = lines[0];
            }
        } else {
            ret = ClipboardMonitoring.getBrowserMime(transferable, dataFlavors, "x-moz-url-priv");
        }
        if (!StringUtils.isEmpty((String)ret)) {
            if (HTMLParser.getProtocol(ret) != null) {
                return ret;
            }
            viewSource = new Regex(ret, "^view-source:\\s*(https?://.+)").getMatch(0);
            if (!StringUtils.isEmpty((String)viewSource) && HTMLParser.getProtocol(viewSource) != null) {
                return viewSource;
            }
        }
        if (htmlFlavor != null) {
            viewSource = new Regex(htmlFlavor, "<a href=\"view-source:(https?://.*?)\"").getMatch(0);
            if (!StringUtils.isEmpty((String)viewSource) && HTMLParser.getProtocol(viewSource) != null) {
                return viewSource;
            }
            viewSource = new Regex(htmlFlavor, "EndFragment:\\s*\\d+[\r\n]*SourceURL:\\s*(.*?)(\r|\n)").getMatch(0);
            if (!StringUtils.isEmpty((String)viewSource) && HTMLParser.getProtocol(viewSource) != null) {
                return viewSource;
            }
        }
        return null;
    }

    public static String getBrowserMime(Transferable transferable, DataFlavor[] dataFlavors, String mime) throws UnsupportedFlavorException, IOException {
        byte[] xmozurlprivBytes = ClipboardMonitoring.getBytes(transferable, dataFlavors, mime, null);
        return ClipboardMonitoring.convertBytes(xmozurlprivBytes, IO.BOM.UTF8.getCharSet(), false);
    }

    static {
        DataFlavor ret = null;
        try {
            ret = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (Throwable e) {
            LogController.CL().info("urlFlavor not supported");
        }
        finally {
            URLFLAVOR = ret;
        }
        try {
            ret = null;
            ret = new DataFlavor("text/uri-list; class=java.lang.String");
        }
        catch (Throwable e) {
            LogController.CL().info("uriListFlavor not supported");
        }
        finally {
            URILISTFLAVOR = ret;
        }
        CLIPBOARD_SKIP_MODE = new AtomicReference<GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE>(GraphicalUserInterfaceSettings.CLIPBOARD_SKIP_MODE.ON_STARTUP);
        HTML_FLAVOR_ALLOWED = new AtomicBoolean(true);
        REPLACEMENT_CHARACTER = new byte[]{-17, -65, -67};
    }

    public static enum IGNORE {
        PACKAGECONTROLLER,
        LOCAL,
        JVM,
        EMPTY,
        NO;

    }

    public static class ClipboardContent {
        private final String content;
        private final String contentText;
        private final String contentHtml;
        private final String browserURL;

        public String getContent() {
            return this.content;
        }

        public String getContentText() {
            return this.contentText;
        }

        public String getContentHtml() {
            return this.contentHtml;
        }

        public String getBrowserURL() {
            return this.browserURL;
        }

        protected ClipboardContent(String browserURL, String contentText, String contentHtml) {
            this(browserURL, contentText, contentHtml, null);
        }

        protected ClipboardContent(String browserURL, String contentText, String contentHtml, String content) {
            this.contentText = contentText;
            this.contentHtml = contentHtml;
            this.browserURL = browserURL;
            this.content = content;
        }
    }

    protected static class ClipboardChangeDetector {
        protected volatile int waitTimeout;
        private final AtomicReference<AtomicBoolean> skipChangeFlag;

        protected ClipboardChangeDetector(AtomicReference<AtomicBoolean> skipChangeFlag) {
            this.skipChangeFlag = skipChangeFlag;
            this.waitTimeout = this.getMinWaitTimeout();
        }

        protected boolean isSkipFlagSet() {
            AtomicBoolean flag = this.skipChangeFlag.get();
            return flag != null && flag.get();
        }

        protected CHANGE_FLAG waitForClipboardChanges() {
            while (true) {
                CHANGE_FLAG ret = this.hasChanges();
                switch (ret) {
                    case DETECTED: 
                    case TIMEOUT: 
                    case INTERRUPTED: {
                        return ret;
                    }
                }
            }
        }

        protected int getCurrentWaitTimeout() {
            return this.waitTimeout;
        }

        protected int getMinWaitTimeout() {
            return 200;
        }

        protected int getMaxWaitTimeout() {
            return 1000;
        }

        protected int getWaitTimeoutInc() {
            return 200;
        }

        protected void reset() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CHANGE_FLAG hasChanges() {
            CHANGE_FLAG ret;
            if (this.isSkipFlagSet()) {
                this.waitTimeout = this.getMinWaitTimeout();
                ret = CHANGE_FLAG.SKIP;
            } else {
                this.waitTimeout = Math.min(this.waitTimeout + this.getWaitTimeoutInc(), this.getMaxWaitTimeout());
                ret = CHANGE_FLAG.TIMEOUT;
            }
            try {
                ClipboardChangeDetector clipboardChangeDetector = this;
                synchronized (clipboardChangeDetector) {
                    this.wait(this.getCurrentWaitTimeout());
                }
                return ret;
            }
            catch (InterruptedException e) {
                return CHANGE_FLAG.INTERRUPTED;
            }
        }

        protected void slowDown(Throwable e) {
            this.waitTimeout = 5000;
        }

        protected void restart() {
            this.waitTimeout = this.getMinWaitTimeout();
        }

        protected static enum CHANGE_FLAG {
            DETECTED,
            INTERRUPTED,
            TIMEOUT,
            SKIP,
            BLACKLISTED,
            FALSE;

        }
    }

    private static class ClipboardHash {
        private final int hash;
        private final int length;

        private ClipboardHash(int hash, int length) {
            this.hash = hash;
            this.length = length;
        }

        private int getClipboardHash() {
            return this.hash;
        }

        private int getClipboardLength() {
            return this.length;
        }

        private ClipboardHash(String string) {
            if (string == null) {
                this.hash = 0;
                this.length = -1;
            } else {
                this.hash = string.hashCode();
                this.length = string.length();
            }
        }

        public String toString() {
            return "ClipboardHash:" + this.getClipboardHash() + "|ClipboardLength:" + this.getClipboardLength();
        }

        private boolean equals(HTMLFragment fragment) {
            if (fragment != null) {
                return this.equals(fragment.getFragment());
            }
            return this.equals((String)null);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj instanceof String) {
                return this.equals((String)obj);
            }
            if (obj instanceof HTMLFragment) {
                return this.equals((HTMLFragment)obj);
            }
            if (obj instanceof ClipboardHash) {
                ClipboardHash o = (ClipboardHash)obj;
                return this.length == o.length && this.hash == o.hash;
            }
            return false;
        }

        private boolean equals(String string) {
            if (string == null) {
                return this.length == -1 && this.hash == 0;
            }
            return this.length == string.length() && this.hash == string.hashCode();
        }
    }

    public static class HTMLFragment {
        private final String sourceURL;
        private final String fragment;

        public final String getSourceURL() {
            return this.sourceURL;
        }

        public final String getFragment() {
            return this.fragment;
        }

        private HTMLFragment(String sourceURL, String fragment) {
            this.sourceURL = sourceURL;
            this.fragment = fragment;
        }
    }
}

