/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import java.util.EventListener;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.packagecontroller.AbstractNode;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.handler.StorageHandler;
import org.appwork.utils.Application;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.settings.DelayWriteMode;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DelayWriteController {
    private static final DelayWriteController INSTANCE = new DelayWriteController();
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final DelayedRunnable flushWrites = new DelayedRunnable(10000L, 120000L){

        public String getID() {
            return "DelayWriteController";
        }

        public void delayedrun() {
            StorageHandler.flushWrites();
        }
    };
    private final DownloadWatchdogListener downloadWatchDogListener = new DownloadWatchdogListener(){

        @Override
        public void onDownloadWatchdogStateIsStopping() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchdogStateIsStopped() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchdogStateIsRunning() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchdogStateIsPause() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchdogStateIsIdle() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchdogDataUpdate() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadWatchDogPropertyChange(DownloadWatchDogProperty propertyChange) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerStopped(SingleDownloadController downloadController, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerStart(SingleDownloadController downloadController, DownloadLinkCandidate candidate) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }
    };
    private final LinkCollectorListener linkCollectorListener = new LinkCollectorListener(){

        @Override
        public void onLinkCrawlerStopped(LinkCollectorCrawler crawler) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCrawlerStarted(LinkCollectorCrawler crawler) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCrawlerNewJob(LinkCollectingJob job) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCrawlerAdded(LinkCollectorCrawler crawler) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink link) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink link) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCollectorAbort(LinkCollectorEvent event) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onLinkCrawlerFinished() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }
    };
    private final DownloadControllerListener downloadControllerListener = new DownloadControllerListener(){

        @Override
        public void onDownloadControllerUpdatedData(FilePackage pkg) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerStructureRefresh() {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerStructureRefresh(FilePackage pkg) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerRemovedPackage(FilePackage pkg) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerRemovedLinklist(List<DownloadLink> list) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }

        @Override
        public void onDownloadControllerAddedPackage(FilePackage pkg) {
            DelayWriteController.this.flushWrites.resetAndStart();
        }
    };

    private DelayWriteController() {
    }

    public static final DelayWriteController getInstance() {
        return INSTANCE;
    }

    public void init() {
        if (this.initialized.compareAndSet(false, true)) {
            LogInterface logger = LoggerFactory.getDefaultLogger();
            DelayWriteMode mode = CFG_GENERAL.CFG.getDelayWriteMode();
            logger.info("DelayWriteMode: " + (Object)((Object)mode));
            if (DelayWriteMode.AUTO.equals((Object)mode) && Application.isHeadless()) {
                logger.info("DelayedWrites auto enabled because JDownloader is running in headless mode!");
                this.setEnabled(true);
            } else if (DelayWriteMode.ON.equals((Object)mode)) {
                logger.info("DelayedWrites enabled!");
                this.setEnabled(true);
            } else {
                logger.info("DelayedWrites disabled!");
            }
        }
    }

    private void setEnabled(boolean enabled) {
        if (enabled) {
            DownloadController.getInstance().getEventSender().addListener((EventListener)this.downloadControllerListener);
            DownloadWatchDog.getInstance().getEventSender().addListener(this.downloadWatchDogListener);
            LinkCollector.getInstance().getEventsender().addListener(this.linkCollectorListener);
        } else {
            DownloadController.getInstance().getEventSender().removeListener((EventListener)this.downloadControllerListener);
            DownloadWatchDog.getInstance().getEventSender().removeListener(this.downloadWatchDogListener);
            LinkCollector.getInstance().getEventsender().removeListener(this.linkCollectorListener);
        }
        StorageHandler.setDelayedWritesEnabled((boolean)enabled);
    }
}

