/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling;

import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.platform.unix.X11;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.NativeLongByReference;
import com.sun.jna.ptr.PointerByReference;

public class X11ClipboardSupport {
    public static X11Extended x11 = X11Extended.INSTANCE;
    private static final int MAX_PROPERTY_VALUE_LEN = 4096;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        X11.Display disp = x11.XOpenDisplay(null);
        if (disp == null) {
            return;
        }
        try {
            Thread.sleep(5000L);
            X11.Atom atom_selection = x11.XInternAtom(disp, "CLIPBOARD", false);
            X11.Atom atom_net_wm_name = x11.XInternAtom(disp, "_NET_WM_NAME", false);
            X11.Atom atom_wm_name = x11.XInternAtom(disp, "WM_NAME", false);
            System.out.println(atom_selection);
            System.out.println(atom_net_wm_name);
            System.out.println(atom_wm_name);
            X11.Window window = x11.XGetSelectionOwner(disp, atom_selection);
            System.out.println(window.longValue());
            X11.Window[] sub = X11ClipboardSupport.getSubwindows(disp, window);
            if (sub != null) {
                for (X11.Window w : sub) {
                    System.out.println(w.longValue());
                }
            }
            X11.Window parent = X11ClipboardSupport.getParent(disp, window);
            System.out.println("parent " + (parent != null ? parent.longValue() : -1L));
            X11.Window root = X11ClipboardSupport.getRoot(disp, window);
            System.out.println("root " + (root != null ? root.longValue() : -1L));
            X11.XTextProperty name = new X11.XTextProperty();
            x11.XGetWMName(disp, window, name);
            System.out.println(name.value);
            PointerByReference nameRef = new PointerByReference();
            try {
                int status = X11Extended.INSTANCE.XFetchName(disp, window, nameRef);
                if (nameRef.getValue() != null) {
                    System.out.println(nameRef.getValue().getString(0L));
                }
            }
            finally {
                if (nameRef.getValue() != null) {
                    X11Extended.INSTANCE.XFree(nameRef.getValue());
                }
            }
            X11.Window active = X11ClipboardSupport.get_active_window(disp);
            System.out.println("pid(clipboard):" + X11ClipboardSupport.get_window_pid(disp, window));
            System.out.println("pid(active):" + X11ClipboardSupport.get_window_pid(disp, active));
            X11.XTextProperty name2 = new X11.XTextProperty();
            x11.XGetWMName(disp, active, name2);
            System.out.println("active:" + name2.value);
            System.out.println(X11ClipboardSupport.get_property_as_utf8_string(disp, window, x11.XInternAtom(disp, "UTF8_STRING", false), "_NET_WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_utf8_string(disp, window, X11.Atom.None, "_NET_WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, window, X11.XA_STRING, "WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, window, X11.Atom.None, "WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, window, X11.XA_STRING, "WM_CLIENT_MACHINE"));
            System.out.println(X11ClipboardSupport.get_property_as_utf8_string(disp, active, x11.XInternAtom(disp, "UTF8_STRING", false), "_NET_WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_utf8_string(disp, active, X11.Atom.None, "_NET_WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, active, X11.XA_STRING, "WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, active, X11.Atom.None, "WM_NAME"));
            System.out.println(X11ClipboardSupport.get_property_as_string(disp, active, X11.XA_STRING, "WM_CLIENT_MACHINE"));
        }
        finally {
            x11.XCloseDisplay(disp);
        }
    }

    private static X11.Window get_property_as_window(X11.Display disp, X11.Window win, X11.Atom xa_prop_type, String prop_name) {
        X11.Window ret = null;
        Pointer prop = X11ClipboardSupport.get_property(disp, win, xa_prop_type, prop_name, null);
        if (prop != null) {
            ret = new X11.Window(prop.getLong(0L));
            X11ClipboardSupport.g_free(prop);
        }
        return ret;
    }

    public static X11.Window get_active_window(X11.Display disp) {
        return X11ClipboardSupport.get_property_as_window(disp, x11.XDefaultRootWindow(disp), X11.XA_WINDOW, "_NET_ACTIVE_WINDOW");
    }

    public static X11.Window getParent(X11.Display disp, X11.Window win) throws Exception {
        X11.WindowByReference root = new X11.WindowByReference();
        X11.WindowByReference parent = new X11.WindowByReference();
        PointerByReference children = new PointerByReference();
        IntByReference childCount = new IntByReference();
        if (x11.XQueryTree(disp, win, root, parent, children, childCount) == 0) {
            throw new Exception("Can't query subwindows");
        }
        return parent.getValue();
    }

    public static X11.Window getRoot(X11.Display disp, X11.Window win) throws Exception {
        X11.WindowByReference root = new X11.WindowByReference();
        X11.WindowByReference parent = new X11.WindowByReference();
        PointerByReference children = new PointerByReference();
        IntByReference childCount = new IntByReference();
        if (x11.XQueryTree(disp, win, root, parent, children, childCount) == 0) {
            throw new Exception("Can't query subwindows");
        }
        return root.getValue();
    }

    public static X11.Window[] getSubwindows(X11.Display disp, X11.Window win) throws Exception {
        X11.WindowByReference root = new X11.WindowByReference();
        X11.WindowByReference parent = new X11.WindowByReference();
        PointerByReference children = new PointerByReference();
        IntByReference childCount = new IntByReference();
        if (x11.XQueryTree(disp, win, root, parent, children, childCount) == 0) {
            throw new Exception("Can't query subwindows");
        }
        if (childCount.getValue() == 0) {
            return null;
        }
        X11.Window[] retVal = new X11.Window[childCount.getValue()];
        if (X11.XID.SIZE == 4) {
            int[] windows = children.getValue().getIntArray(0L, childCount.getValue());
            for (int x = 0; x < retVal.length; ++x) {
                X11.Window ret;
                retVal[x] = ret = new X11.Window((long)windows[x]);
            }
        } else {
            long[] windows = children.getValue().getLongArray(0L, childCount.getValue());
            for (int x = 0; x < retVal.length; ++x) {
                X11.Window ret;
                retVal[x] = ret = new X11.Window(windows[x]);
            }
        }
        x11.XFree(children.getValue());
        return retVal;
    }

    private static Integer get_property_as_int(X11.Display disp, X11.Window win, X11.Atom xa_prop_type, String prop_name) {
        Integer intProp = null;
        Pointer prop = X11ClipboardSupport.get_property(disp, win, xa_prop_type, prop_name, null);
        if (prop != null) {
            intProp = prop.getInt(0L);
            X11ClipboardSupport.g_free(prop);
        }
        return intProp;
    }

    public static int get_window_pid(X11.Display disp, X11.Window win) {
        Integer pid = X11ClipboardSupport.get_property_as_int(disp, win, X11.XA_CARDINAL, "_NET_WM_PID");
        return pid == null ? -1 : pid;
    }

    private static String get_property_as_string(X11.Display disp, X11.Window win, X11.Atom xa_prop_type, String prop_name) {
        String strProp = null;
        Pointer prop = X11ClipboardSupport.get_property(disp, win, xa_prop_type, prop_name, null);
        if (prop != null) {
            strProp = X11ClipboardSupport.g_strdup(prop);
            X11ClipboardSupport.g_free(prop);
        }
        return strProp;
    }

    private static void g_free(Pointer pointer) {
        if (pointer != null) {
            x11.XFree(pointer);
        }
    }

    private static String get_property_as_utf8_string(X11.Display disp, X11.Window win, X11.Atom xa_prop_type, String prop_name) {
        String strProp = null;
        Pointer prop = X11ClipboardSupport.get_property(disp, win, xa_prop_type, prop_name, null);
        if (prop != null) {
            strProp = X11ClipboardSupport.g_locale_to_utf8(prop);
            X11ClipboardSupport.g_free(prop);
        }
        return strProp;
    }

    private static String g_strdup(Pointer pointer) {
        String value = pointer.getString(0L);
        return value;
    }

    private static String g_locale_to_utf8(Pointer pointer) {
        return X11ClipboardSupport.g_strdup(pointer);
    }

    public static Pointer get_property(X11.Display disp, X11.Window win, X11.Atom xa_prop_type, String prop_name, NativeLongByReference size) {
        X11.AtomByReference xa_ret_type = new X11.AtomByReference();
        IntByReference ret_format = new IntByReference();
        NativeLongByReference ret_nitems = new NativeLongByReference();
        NativeLongByReference ret_bytes_after = new NativeLongByReference();
        PointerByReference ret_prop = new PointerByReference();
        X11.Atom xa_prop_name = x11.XInternAtom(disp, prop_name, false);
        if (x11.XGetWindowProperty(disp, win, xa_prop_name, new NativeLong(0L), new NativeLong(1024L), false, xa_prop_type, xa_ret_type, ret_format, ret_nitems, ret_bytes_after, ret_prop) != 0) {
            return null;
        }
        if (xa_ret_type.getValue() == null || xa_prop_type != null && xa_ret_type.getValue().longValue() != xa_prop_type.longValue()) {
            X11ClipboardSupport.g_free(ret_prop.getPointer());
            return null;
        }
        if (size != null) {
            long tmp_size = (long)(ret_format.getValue() / 8) * ret_nitems.getValue().longValue();
            if (ret_format.getValue() == 32) {
                tmp_size *= (long)(NativeLong.SIZE / 4);
            }
            size.setValue(new NativeLong(tmp_size));
        }
        return ret_prop.getValue();
    }

    public static interface X11Extended
    extends X11 {
        public static final X11Extended INSTANCE = (X11Extended)Native.load((String)"X11", X11Extended.class);

        public X11.Window XGetSelectionOwner(X11.Display var1, X11.Atom var2);
    }
}

