/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.captcha;

import java.util.ArrayList;
import java.util.HashMap;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.LookUpKeys;
import org.appwork.storage.config.annotations.SpinnerValidator;
import org.jdownloader.captcha.v2.CaptchaQualityEnsuranceRule;

public interface CaptchaSettings
extends ConfigInterface {
    public static final CaptchaSettings CFG = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="Enable the CES & Remote Captcha Bubbles")
    public boolean isRemoteCaptchaBubbleEnabled();

    public void setRemoteCaptchaBubbleEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Activates CES CAPTCHA services for login captchas. This is not recommended, as users generally expect a near-instant login process. Using a solver can extend login times to several minutes.")
    public boolean isCaptchaExchangeForAccountLoginEnabled();

    public void setCaptchaExchangeForAccountLoginEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="True to enable a countdown in captcha dialogs. Dialog will close automated after the coundown")
    public boolean isDialogCountdownForDownloadsEnabled();

    public void setDialogCountdownForDownloadsEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="True to enable a countdown in crawler captcha dialogs. Dialog will close automated after the coundown")
    public boolean isDialogCountdownForCrawlerEnabled();

    public void setDialogCountdownForCrawlerEnabled(boolean var1);

    @AboutConfig
    @DefaultEnumValue(value="SKIP")
    @LookUpKeys(value={"captchatimeoutaction", "hostercaptchatimeoutaction"})
    @DescriptionForConfigEntry(value="Defines what should happen if a captcha prompt runs into a timeout meaning that neither the user nor any captcha solver did answer the captcha prompt. This setting affects all HOSTER download/account-check processes.")
    public CAPTCHA_TIMEOUT_ACTION getOnHosterCaptchaTimeoutAction();

    public void setOnHosterCaptchaTimeoutAction(CAPTCHA_TIMEOUT_ACTION var1);

    @AboutConfig
    @DefaultEnumValue(value="SKIP")
    @LookUpKeys(value={"crawlercaptchatimeoutaction"})
    @DescriptionForConfigEntry(value="Defines what should happen if a captcha prompt runs into a timeout meaning that neither the user nor any captcha solver did answer the captcha prompt. This setting affects all CRAWLER processes.")
    public CAPTCHA_TIMEOUT_ACTION getOnCrawlerCaptchaTimeoutAction();

    public void setOnCrawlerCaptchaTimeoutAction(CAPTCHA_TIMEOUT_ACTION var1);

    @AboutConfig
    @DefaultIntValue(value=300000)
    @SpinnerValidator(min=10000L, max=900000L)
    @DescriptionForConfigEntry(value="MS to wait until captcha dialog gets answered. Close dialog after this timeout unanswered")
    public int getCaptchaDialogDefaultCountdown2();

    public void setCaptchaDialogDefaultCountdown2(int var1);

    @AboutConfig
    @DefaultIntValue(value=95)
    @DescriptionForConfigEntry(value="Do not Change me unless you know 100000% what this value is used for!")
    public int getAutoCaptchaPriorityThreshold();

    public void setAutoCaptchaPriorityThreshold(int var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="Captcha Mode")
    @DefaultEnumValue(value="NORMAL")
    public MODE getCaptchaMode();

    public void setCaptchaMode(MODE var1);

    @AboutConfig
    @DefaultIntValue(value=600000)
    @DescriptionForConfigEntry(value="Timeout in milliseconds after which a challenge (captcha) invalidates (e.g sessions run out...) this timeout should be set by the plugins")
    public int getDefaultChallengeTimeout();

    public void setDefaultChallengeTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=10000)
    @DescriptionForConfigEntry(value="If the CES Bubble Support is enable, the bubble gives the user a chance to cancel the CES usage. This is the timeout for this skip option")
    public int getCaptchaExchangeChanceToSkipBubbleTimeout();

    public void setCaptchaExchangeChanceToSkipBubbleTimeout(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCancelDialogCountdownOnHateCaptchaClick();

    public void setCancelDialogCountdownOnHateCaptchaClick(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isCancelDialogCountdownOnMouseMove();

    public void setCancelDialogCountdownOnMouseMove(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isCancelDialogCountdownOnMouseClick();

    public void setCancelDialogCountdownOnMouseClick(boolean var1);

    @AboutConfig
    @DescriptionForConfigEntry(value="If you change these rules, Captchas might become very hard or even impossible to solve over time. Do NEVER ever change these rules without knowing what you are doing")
    public HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> getQualityEnsuranceRules();

    public void setQualityEnsuranceRules(HashMap<String, ArrayList<CaptchaQualityEnsuranceRule>> var1);

    public static enum CAPTCHA_TIMEOUT_ACTION {
        SKIP,
        SKIP_HOSTER,
        RETRY,
        ASK;

    }

    public static enum MODE {
        NORMAL,
        SKIP_ALL;

    }
}

