/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.captcha;

import java.awt.Image;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.SwingUtilities;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.captcha.HideAllCaptchasException;
import jd.controlling.captcha.HideCaptchasByHostException;
import jd.controlling.captcha.HideCaptchasByPackageException;
import jd.controlling.captcha.RefreshException;
import jd.controlling.captcha.SkipException;
import jd.controlling.captcha.SkipRequest;
import jd.controlling.captcha.StopCurrentActionException;
import jd.gui.swing.dialog.CaptchaDialog;
import jd.gui.swing.dialog.DialogType;
import jd.gui.swing.jdgui.JDGui;
import jd.plugins.Plugin;
import jd.plugins.PluginForDecrypt;
import jd.plugins.PluginForHost;
import org.appwork.exceptions.ThrowUncheckedException;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.uio.CloseReason;
import org.appwork.utils.Exceptions;
import org.appwork.utils.images.IconIO;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.EDTHelper;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogHandler;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.appwork.utils.swing.dialog.InternDialog;
import org.appwork.utils.swing.windowmanager.WindowManager;
import org.jdownloader.DomainInfo;
import org.jdownloader.captcha.v2.AbstractCaptchaDialog;
import org.jdownloader.captcha.v2.Challenge;
import org.jdownloader.captcha.v2.challenge.stringcaptcha.ImageCaptchaChallenge;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.settings.SilentModeSettings;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.settings.staticreferences.CFG_SILENTMODE;

public abstract class ChallengeDialogHandler<D extends AbstractCaptchaDialog<ResultType>, T extends Challenge<ResultType>, ResultType> {
    private DomainInfo host;
    protected T captchaChallenge;
    private CaptchaSettings config;
    private final UniqueAlltimeID id = new UniqueAlltimeID();
    protected DialogHandler dialogHandler;
    private LogSource logger;
    protected volatile ResultType result;
    protected D dialog;
    protected Exception resultException = null;
    protected volatile ResultType suggest;

    public ChallengeDialogHandler(DomainInfo instance, T captchaChallenge2) {
        this.host = instance;
        this.captchaChallenge = captchaChallenge2;
        this.config = (CaptchaSettings)JsonConfig.create(CaptchaSettings.class);
        this.logger = JDGui.getInstance().getLogger();
        this.dialogHandler = new DialogHandler(){

            public <T> T showDialog(final AbstractDialog<T> dialog) throws DialogClosedException, DialogCanceledException {
                try {
                    dialog.forceDummyInit();
                    boolean silentModeActive = JDGui.getInstance().isSilentModeActive();
                    if (silentModeActive && !SwingUtilities.isEventDispatchThread()) {
                        long countdown = -1L;
                        if (dialog.isCountdownFlagEnabled()) {
                            long countdownDif = dialog.getCountdown();
                            countdown = System.currentTimeMillis() + countdownDif;
                        }
                        if (countdown < 0L && CFG_SILENTMODE.CFG.getOnCaptchaDuringSilentModeAction() == SilentModeSettings.CaptchaDuringSilentModeAction.WAIT_IN_BACKGROUND_UNTIL_WINDOW_GETS_FOCUS_OR_TIMEOUT) {
                            countdown = System.currentTimeMillis() + (Long)CFG_SILENTMODE.ON_DIALOG_DURING_SILENT_MODE_ACTION_TIMEOUT.getValue();
                        }
                        JDGui.getInstance().flashTaskbar();
                        while (JDGui.getInstance().isSilentModeActive()) {
                            if (countdown > 0L) {
                                Thread.sleep(Math.min(Math.max(1L, countdown - System.currentTimeMillis()), 250L));
                                if (System.currentTimeMillis() <= countdown) continue;
                                dialog.onTimeout();
                                Thread.interrupted();
                                throw new DialogCanceledException(dialog.getReturnmask());
                            }
                            Thread.sleep(250L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    if (dialog.getReturnmask() == 0) {
                        dialog.setCloseReason(CloseReason.INTERRUPT);
                    }
                    throw new DialogClosedException(256, (Throwable)e);
                }
                catch (DialogCanceledException e) {
                    throw e;
                }
                catch (Exception e) {
                    ChallengeDialogHandler.this.logger.log((Throwable)e);
                }
                dialog.resetDummyInit();
                new EDTRunner(){

                    protected void runInEDT() {
                        dialog.displayDialog();
                    }
                }.waitForEDT();
                return null;
            }
        };
    }

    public ResultType getResult() {
        if (this.resultException != null) {
            ThrowUncheckedException.throwUncheckedException((Throwable)this.resultException);
        }
        return this.result;
    }

    protected abstract D createDialog(DialogType var1, int var2);

    protected void setResultFrom(D dialog) {
        this.resultException = null;
        try {
            this.result = dialog.getReturnValue();
        }
        catch (Exception e) {
            this.resultException = e;
        }
    }

    protected Image[] getImages(T challenge) {
        if (challenge instanceof ImageCaptchaChallenge) {
            Image[] images = null;
            try {
                Image img;
                images = CaptchaDialog.getGifImages((URL)((ImageCaptchaChallenge)this.captchaChallenge).getImageFile().toURI().toURL());
                if ((images == null || images.length == 0) && (img = IconIO.getImage((URL)((ImageCaptchaChallenge)this.captchaChallenge).getImageFile().toURI().toURL(), (boolean)false)) != null) {
                    images = new Image[]{img};
                }
            }
            catch (MalformedURLException e) {
                throw new WTFException((Throwable)e);
            }
            if (images == null || images.length == 0 || images[0] == null) {
                this.getLogger().severe("Could not load CaptchaImage! " + ((ImageCaptchaChallenge)this.captchaChallenge).getImageFile().getAbsolutePath());
                return null;
            }
            return images;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void waitForDialog(final D dialog) throws DialogClosedException, DialogCanceledException, HideCaptchasByHostException, HideCaptchasByPackageException, StopCurrentActionException, HideAllCaptchasException, RefreshException {
        new EDTHelper<Object>(){

            public Object edtRun() {
                dialog.getDialog().addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosing(WindowEvent e) {
                        ChallengeDialogHandler challengeDialogHandler = ChallengeDialogHandler.this;
                        synchronized (challengeDialogHandler) {
                            ChallengeDialogHandler.this.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void windowClosed(WindowEvent e) {
                        ChallengeDialogHandler challengeDialogHandler = ChallengeDialogHandler.this;
                        synchronized (challengeDialogHandler) {
                            ChallengeDialogHandler.this.notifyAll();
                        }
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }
                });
                return null;
            }
        }.waitForEDT();
        try {
            while (Boolean.TRUE.equals(new EDTHelper<Boolean>(){

                public Boolean edtRun() {
                    return dialog.getDialog().isDisplayable();
                }
            }.getReturnValue())) {
                ChallengeDialogHandler challengeDialogHandler = this;
                synchronized (challengeDialogHandler) {
                    this.wait(1000L);
                }
            }
        }
        catch (InterruptedException e) {
            if (dialog.getReturnmask() != 0) throw new DialogClosedException(256, (Throwable)e);
            dialog.setCloseReason(CloseReason.INTERRUPT);
            throw new DialogClosedException(256, (Throwable)e);
        }
        finally {
            try {
                ((AbstractCaptchaDialog)((Object)dialog)).dispose();
            }
            catch (Exception exception) {}
        }
        this.setResultFrom(dialog);
        try {
            if (dialog.getCloseReason() == CloseReason.OK) return;
            if (((AbstractCaptchaDialog)((Object)dialog)).isHideCaptchasForHost()) {
                throw new HideCaptchasByHostException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isHideCaptchasForPackage()) {
                throw new HideCaptchasByPackageException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isStopDownloads()) {
                throw new StopCurrentActionException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isHideAllCaptchas()) {
                throw new HideAllCaptchasException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isStopCrawling()) {
                throw new StopCurrentActionException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isStopShowingCrawlerCaptchas()) {
                throw new HideAllCaptchasException();
            }
            if (((AbstractCaptchaDialog)((Object)dialog)).isRefresh()) {
                throw new RefreshException();
            }
            dialog.throwCloseExceptions();
            throw new DialogClosedException(64);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    protected void showDialog(D dialog) throws DialogClosedException, DialogCanceledException {
        this.dialog = dialog;
        this.dialogHandler.showDialog(dialog);
    }

    public DomainInfo getHost() {
        return this.host;
    }

    public void run() throws InterruptedException, SkipException {
        this.viaGUI();
    }

    public void setSuggest(ResultType value) {
        this.suggest = value;
    }

    public ResultType getSuggest() {
        return this.suggest;
    }

    public void requestFocus() {
        new EDTRunner(){

            protected void runInEDT() {
                InternDialog win;
                Object d = ChallengeDialogHandler.this.dialog;
                if (d != null && (win = d.getDialog()) != null) {
                    WindowManager.getInstance().setZState((Window)win, WindowManager.FrameState.TO_FRONT_FOCUSED);
                }
            }
        };
    }

    protected LogInterface getLogger() {
        LogInterface logger = null;
        Plugin plg = ((Challenge)this.captchaChallenge).getPlugin();
        if (plg != null) {
            if (plg instanceof PluginForHost) {
                logger = plg.getLogger();
            } else if (plg instanceof PluginForDecrypt) {
                logger = plg.getLogger();
            }
        }
        if (logger == null) {
            logger = LoggerFactory.getDefaultLogger();
        }
        return logger;
    }

    private void viaGUI() throws InterruptedException, SkipException {
        DialogType dialogType = DialogType.OTHER;
        try {
            int f = 0;
            int countdown = this.getTimeoutInMS();
            if (((Challenge)this.captchaChallenge).isAccountLogin()) {
                dialogType = DialogType.HOSTER;
            } else if (((Challenge)this.captchaChallenge).getPlugin() instanceof PluginForHost) {
                dialogType = DialogType.HOSTER;
            } else if (((Challenge)this.captchaChallenge).getPlugin() instanceof PluginForDecrypt) {
                dialogType = DialogType.CRAWLER;
            }
            if (countdown > 0) {
                f |= 4;
            }
            this.showDialog(dialogType, f);
            return;
        }
        catch (DialogNoAnswerException e) {
            if (e.isCausedByInterrupt()) {
                throw (InterruptedException)Exceptions.addSuppressed((Throwable)new InterruptedException("Dialog Interrupted"), (Throwable)e);
            }
            if (e.isCausedByTimeout()) {
                throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.TIMEOUT, e);
            }
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.SINGLE, e);
        }
        catch (HideCaptchasByHostException e) {
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.BLOCK_HOSTER, e);
        }
        catch (HideCaptchasByPackageException e) {
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.BLOCK_PACKAGE, e);
        }
        catch (StopCurrentActionException e) {
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.STOP_CURRENT_ACTION, e);
        }
        catch (HideAllCaptchasException e) {
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.BLOCK_ALL_CAPTCHAS, e);
        }
        catch (RuntimeException e) {
            LogSource.exception((LogInterface)this.getLogger(), (Throwable)e);
        }
        catch (RefreshException e) {
            throw new SkipException((Challenge<?>)this.captchaChallenge, SkipRequest.REFRESH, e);
        }
    }

    protected int getTimeoutInMS() {
        int countdown = -1;
        Plugin plugin = ((Challenge)this.captchaChallenge).getPlugin();
        if (plugin instanceof PluginForHost && this.config.isDialogCountdownForDownloadsEnabled()) {
            countdown = (Integer)CFG_CAPTCHA.CAPTCHA_DIALOG_DEFAULT_COUNTDOWN.getValue();
        } else if (plugin instanceof PluginForDecrypt && this.config.isDialogCountdownForCrawlerEnabled()) {
            countdown = (Integer)CFG_CAPTCHA.CAPTCHA_DIALOG_DEFAULT_COUNTDOWN.getValue();
        }
        int remainingTimeout = ((Challenge)this.captchaChallenge).getRemainingTimeout();
        if (remainingTimeout > 0 && (countdown <= 0 || remainingTimeout < countdown)) {
            countdown = remainingTimeout;
        }
        return countdown;
    }

    protected void showDialog(DialogType dialogType, int flag) throws DialogClosedException, DialogCanceledException, HideCaptchasByHostException, HideCaptchasByPackageException, StopCurrentActionException, HideAllCaptchasException, RefreshException {
        D dialog = this.createDialog(dialogType, flag);
        if (dialog == null) {
            return;
        }
        this.showDialog(dialog);
        this.waitForDialog(dialog);
    }

    public UniqueAlltimeID getID() {
        return this.id;
    }
}

