/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import jd.plugins.PluginForHost;
import org.appwork.utils.StringUtils;
import org.jdownloader.DomainInfo;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.CachedAccountGroup;

public class AccountCache
implements Iterable<CachedAccount> {
    protected static final AccountCache NA = new AccountCache(null){

        @Override
        public Iterator<CachedAccount> iterator() {
            return new Iterator<CachedAccount>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public CachedAccount next() {
                    return null;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    };
    protected final List<CachedAccountGroup> cache;

    public boolean isCustomizedCache() {
        return false;
    }

    public AccountCache(List<CachedAccountGroup> cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Iterator<CachedAccount> getRuleAwareIterator() {
        if (this.cache == null || this.cache.size() == 0) {
            return new ArrayList(0).iterator();
        }
        if (this.cache.size() == 1 && AccountGroup.Rules.ORDER.equals((Object)this.cache.get(0).getRule())) {
            return this.cache.get(0).iterator();
        }
        ArrayList<CachedAccount> ret = new ArrayList<CachedAccount>();
        block8: for (CachedAccountGroup cachedAccountGroup : this.cache) {
            switch (cachedAccountGroup.getRule()) {
                case DISABLED: {
                    continue block8;
                }
                case BALANCED: {
                    ret.addAll(cachedAccountGroup);
                    break;
                }
                case RANDOM: {
                    CachedAccountGroup cachedAccountGroup2 = cachedAccountGroup;
                    synchronized (cachedAccountGroup2) {
                        if (cachedAccountGroup.size() > 1) {
                            Collections.shuffle(cachedAccountGroup);
                        }
                        ret.addAll(cachedAccountGroup);
                        break;
                    }
                }
                default: {
                    ret.addAll(cachedAccountGroup);
                }
            }
        }
        return ret.iterator();
    }

    @Override
    public Iterator<CachedAccount> iterator() {
        return new Iterator<CachedAccount>(){
            final Iterator<CachedAccount> it;
            final AtomicReference<CachedAccount> next;
            {
                this.it = AccountCache.this.getRuleAwareIterator();
                this.next = new AtomicReference<Object>(null);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public CachedAccount next() {
                CachedAccount ret = this.next.getAndSet(null);
                if (ret != null) {
                    return ret;
                }
                if (this.hasNext()) {
                    return this.next.getAndSet(null);
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                if (this.next.get() != null) {
                    return true;
                }
                while (this.it.hasNext()) {
                    CachedAccount iNext = this.it.next();
                    if (iNext.getAccount() != null && (iNext.getAccount().getAccountController() == null || !iNext.getAccount().isEnabled() || !iNext.getAccount().isValid())) continue;
                    this.next.set(iNext);
                    break;
                }
                return this.next.get() != null;
            }
        };
    }

    public static class CachedAccount {
        private final Account account;
        private final ACCOUNTTYPE type;
        private final PluginForHost plugin;
        private final String host;
        private final DomainInfo pluginDomainInfo;

        public String getHost() {
            return this.host;
        }

        public DomainInfo getPluginDomainInfo() {
            return this.pluginDomainInfo;
        }

        public CachedAccount(String host, Account account, PluginForHost plugin) {
            this.account = account;
            this.type = account == null ? ACCOUNTTYPE.NONE : (StringUtils.equalsIgnoreCase((String)host, (String)account.getHoster()) ? ACCOUNTTYPE.ORIGINAL : ACCOUNTTYPE.MULTI);
            this.plugin = plugin;
            this.host = host;
            this.pluginDomainInfo = plugin != null ? DomainInfo.getInstance(plugin.getHost()) : null;
        }

        public final Account getAccount() {
            return this.account;
        }

        public final ACCOUNTTYPE getType() {
            return this.type;
        }

        public final PluginForHost getPlugin() {
            return this.plugin;
        }

        public boolean hasCaptcha(DownloadLink link) {
            return this.plugin != null && Boolean.TRUE.equals(this.plugin.expectCaptcha(link, this.account));
        }

        public boolean canHandle(DownloadLink link) throws Exception {
            if (this.plugin == null) {
                return false;
            }
            if (link.getDefaultPlugin() != null && !link.getDefaultPlugin().allowHandle(link, this.plugin)) {
                return false;
            }
            if (!this.plugin.canHandle(link, this.account)) {
                return false;
            }
            return this.plugin.enoughTrafficFor(link, this.account);
        }

        public String toString() {
            if (this.plugin == null) {
                return "Plugin:none|Type:" + (Object)((Object)this.type) + "|Account:" + this.account;
            }
            return "Plugin:" + this.plugin.getHost() + "|Version:" + this.plugin.getVersion() + "|Type:" + (Object)((Object)this.type) + "|Account:" + this.account;
        }

        public static boolean sameAccount(CachedAccount x, CachedAccount y) {
            if (x != null && y != null) {
                Account xx = x.getAccount();
                Account yy = y.getAccount();
                return xx != null && yy != null && xx.equals(yy);
            }
            return false;
        }

        public static boolean samePlugin(CachedAccount x, CachedAccount y) {
            if (x != null && y != null) {
                PluginForHost xx = x.getPlugin();
                PluginForHost yy = y.getPlugin();
                return xx != null && yy != null && xx.equals(yy);
            }
            return false;
        }

        public boolean equals(CachedAccount cachedAccount) {
            if (cachedAccount == null) {
                return false;
            }
            if (cachedAccount == this) {
                return true;
            }
            if (this.getType() != cachedAccount.getType()) {
                return false;
            }
            return CachedAccount.sameAccount(this, cachedAccount) && CachedAccount.samePlugin(this, cachedAccount);
        }
    }

    public static enum ACCOUNTTYPE {
        ORIGINAL,
        MULTI,
        NONE;

    }
}

