/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import jd.controlling.downloadcontroller.DiskSpaceChecker;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.plugins.PluginForHost;
import jd.plugins.download.DownloadLinkDownloadable;
import org.appwork.utils.Exceptions;
import org.appwork.utils.Files17;
import org.appwork.utils.StringUtils;

public class DiskSpaceChecker17
extends DiskSpaceChecker {
    protected static boolean MOUNT_POINT_NOT_FOUND_IN_FSTAB = false;
    private boolean invalidPathExceptionThrown = false;

    public DiskSpaceChecker17(DiskSpaceReservation diskSpaceReservation, Object requestor) {
        super(diskSpaceReservation, requestor);
    }

    protected Path toPath(File file) {
        try {
            return file.toPath();
        }
        catch (InvalidPathException e) {
            Path alternativeFile = null;
            try {
                if (file.equals(this.getDestination())) {
                    Object owner = this.diskSpaceReservation.getOwner();
                    if (owner instanceof DownloadLinkDownloadable) {
                        DownloadLinkDownloadable downloadLink = (DownloadLinkDownloadable)owner;
                        alternativeFile = new File(downloadLink.getDownloadLink().getDownloadLinkController().getSessionDownloadDirectory()).toPath();
                    } else if (owner instanceof PluginForHost) {
                        PluginForHost plugin = (PluginForHost)owner;
                        alternativeFile = new File(plugin.getDownloadLink().getDownloadLinkController().getSessionDownloadDirectory()).toPath();
                    } else if (owner instanceof SingleDownloadController) {
                        SingleDownloadController controller = (SingleDownloadController)owner;
                        alternativeFile = new File(controller.getSessionDownloadDirectory()).toPath();
                    }
                }
            }
            catch (InvalidPathException e2) {
                throw (InvalidPathException)Exceptions.addSuppressed((Throwable)e2, (Throwable)e);
            }
            if (alternativeFile == null) {
                throw e;
            }
            this.getLogger().exception("fallback to download folder:" + alternativeFile, (Throwable)e);
            return alternativeFile;
        }
    }

    @Override
    protected void log(Throwable e) {
        if (Exceptions.containsInstanceOf((Throwable)e, (Class[])new Class[]{InvalidPathException.class})) {
            if (this.invalidPathExceptionThrown) {
                return;
            }
            this.invalidPathExceptionThrown = true;
        }
        super.log(e);
    }

    @Override
    protected void findRoots() {
        if (!MOUNT_POINT_NOT_FOUND_IN_FSTAB) {
            try {
                File dest = this.getDestination();
                Path normalRoot = Files17.guessRoot((Path)this.toPath(dest));
                if (normalRoot != null) {
                    Path realRoot;
                    this.roots.addIfAbsent(normalRoot.toString());
                    Path realPath = null;
                    for (Path currentPath = this.toPath(dest); currentPath != null; currentPath = currentPath.getParent()) {
                        if (Files.exists(currentPath, new LinkOption[0])) {
                            realPath = currentPath.toRealPath(new LinkOption[0]);
                            break;
                        }
                        if (currentPath.equals(normalRoot)) break;
                    }
                    if (realPath != null && (realRoot = Files17.guessRoot(realPath)) != null) {
                        this.roots.addIfAbsent(realRoot.toString());
                    }
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException && StringUtils.contains((String)e.getMessage(), (String)"Mount point not found in fstab")) {
                    MOUNT_POINT_NOT_FOUND_IN_FSTAB = true;
                }
                this.log(e);
            }
        }
        if (this.roots.size() == 0) {
            super.findRoots();
        }
    }

    @Override
    public long getUsableSpace() {
        if (!MOUNT_POINT_NOT_FOUND_IN_FSTAB) {
            File dest = this.getDestination();
            try {
                Long ret = Files17.getUsableSpace((Path)this.toPath(dest));
                if (ret != null) {
                    return ret;
                }
            }
            catch (Throwable e) {
                this.log(e);
            }
        }
        return super.getUsableSpace();
    }
}

