/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.lang.ref.WeakReference;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.plugins.DownloadLink;
import org.jdownloader.controlling.domainrules.DomainRuleController;
import org.jdownloader.controlling.domainrules.DomainRuleSet;

public class DownloadLinkCandidate {
    private final boolean forced;
    private final WeakReference<DownloadLink> link;
    private final AccountCache.CachedAccount cachedAccount;
    private final AbstractProxySelectorImpl proxySelector;
    private final boolean customizedAccount;
    private DomainRuleSet domainRuleSet = null;

    public AbstractProxySelectorImpl getProxySelector() {
        return this.proxySelector;
    }

    public AccountCache.CachedAccount getCachedAccount() {
        return this.cachedAccount;
    }

    public DownloadLink getLink() {
        return this.link == null ? null : (DownloadLink)this.link.get();
    }

    public boolean isForced() {
        return this.forced;
    }

    public String toString() {
        DownloadLink link = this.getLink();
        return "DownloadCandidate:" + link + "|Host " + (link == null ? null : link.getHost()) + "|Account:" + this.cachedAccount + "|Proxy:" + this.proxySelector;
    }

    public DownloadLinkCandidate(DownloadLink link, boolean forced) {
        this(link, forced, null, null, false);
    }

    public DownloadLinkCandidate(DownloadLinkCandidate candidate, AccountCache.CachedAccount cachedAccount, boolean customizedAccount) {
        this(candidate.getLink(), candidate.isForced(), cachedAccount, null, customizedAccount);
    }

    public DownloadLinkCandidate(DownloadLink link, boolean forced, AccountCache.CachedAccount cachedAccount, AbstractProxySelectorImpl proxy, boolean customizedAccount) {
        this.link = new WeakReference<DownloadLink>(link);
        this.forced = forced;
        this.cachedAccount = cachedAccount;
        this.proxySelector = proxy;
        this.customizedAccount = customizedAccount;
    }

    public DownloadLinkCandidate(DownloadLinkCandidate candidate, AbstractProxySelectorImpl proxy) {
        this(candidate.getLink(), candidate.isForced(), candidate.getCachedAccount(), proxy, candidate.isCustomizedAccount());
    }

    public boolean isCustomizedAccount() {
        return this.customizedAccount;
    }

    public DomainRuleSet getDomainRuleSet() {
        if (this.domainRuleSet != null) {
            return this.domainRuleSet;
        }
        DownloadLink link = this.getLink();
        String downloadDomain = link.getDomainInfo().getTld();
        AccountCache.CachedAccount cachedAccount = this.getCachedAccount();
        String pluginDomain = cachedAccount.getHost();
        String fileName = link.getName();
        this.domainRuleSet = DomainRuleController.getInstance().createRuleSet(cachedAccount.getAccount(), downloadDomain, pluginDomain, fileName);
        return this.domainRuleSet;
    }
}

