/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.List;
import jd.http.Browser;
import jd.plugins.LinkStatus;
import jd.plugins.PluginException;
import org.appwork.utils.Exceptions;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.SkipReason;

public class DownloadLinkCandidateResult {
    private final RESULT result;
    private final SkipReason skipReason;
    private long startTime = -1L;
    private long waitTime = -1L;
    private String message = null;
    private final String lastPluginHost;
    private final boolean reachedDownloadInterface;
    private final long timeStamp = System.currentTimeMillis();
    private long finishTime = -1L;
    private final ConditionalSkipReason conditionalSkip;
    private final Throwable throwable;

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isReachedDownloadInterface() {
        return this.reachedDownloadInterface;
    }

    public String getLastPluginHost() {
        return this.lastPluginHost;
    }

    public String getMessage() {
        String ret = this.message;
        if (ret != null) {
            return ret;
        }
        if (this.throwable instanceof PluginException) {
            return ((PluginException)this.throwable).getLocalizedMessage();
        }
        return null;
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    protected void setWaitTime(long waitTime) {
        this.waitTime = Math.max(-1L, waitTime);
    }

    public long getRemainingTime() {
        long finishTime = this.getFinishTime();
        long waitTime = this.getWaitTime();
        if (finishTime > 0L && waitTime > 0L) {
            long current = System.currentTimeMillis();
            long ret = Math.max(0L, finishTime + waitTime - current);
            return ret;
        }
        return -1L;
    }

    public long getStartTime() {
        return this.startTime;
    }

    protected void setStartTime(long startTime) {
        this.startTime = Math.max(-1L, startTime);
    }

    public long getFinishTime() {
        if (this.finishTime == -1L) {
            return this.getTimeStamp();
        }
        return this.finishTime;
    }

    protected void setFinishTime(long finishTime) {
        this.finishTime = Math.max(-1L, finishTime);
    }

    public ConditionalSkipReason getConditionalSkip() {
        return this.conditionalSkip;
    }

    public SkipReason getSkipReason() {
        return this.skipReason;
    }

    public String getErrorID() {
        Throwable throwable = this.getThrowable();
        RESULT result = this.getResult();
        if (throwable != null) {
            StackTraceElement[] st = throwable.getStackTrace();
            if (st != null && st.length > 0) {
                StringBuilder sb = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                if (throwable instanceof PluginException) {
                    sb.append("PluginException: ").append(throwable.getMessage()).append("(" + LinkStatus.toString(((PluginException)throwable).getLinkStatus()) + ")");
                } else {
                    sb.append(throwable.getClass().getName() + " : " + throwable.getMessage());
                }
                sb2.append(sb.toString());
                boolean found = false;
                boolean found2 = false;
                for (int i = 0; i < st.length; ++i) {
                    String line = st[i].toString();
                    if (sb.length() > 0) {
                        sb.append("\r\n");
                    }
                    sb.append(line);
                    if (!found2) {
                        if (sb2.length() > 0) {
                            sb2.append("\r\n");
                        }
                        sb2.append(line);
                    }
                    if (st[i].getLineNumber() >= 0) {
                        found2 = true;
                    }
                    if (!line.startsWith("jd.plugins.hoster.")) continue;
                    found = true;
                    break;
                }
                if (found) {
                    return sb.toString();
                }
                if (found2) {
                    return sb2.toString();
                }
                return st[0].toString();
            }
            return throwable.toString();
        }
        if (result != null) {
            switch (result) {
                case FAILED: 
                case FAILED_INCOMPLETE: 
                case FATAL_ERROR: 
                case FILE_UNAVAILABLE: 
                case HOSTER_UNAVAILABLE: 
                case PLUGIN_DEFECT: {
                    return result.name();
                }
            }
            return null;
        }
        return null;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public DownloadLinkCandidateResult(ConditionalSkipReason conditionalSkip, Throwable throwable, String lastPluginHost) {
        this(conditionalSkip, throwable, lastPluginHost, false);
    }

    public DownloadLinkCandidateResult(ConditionalSkipReason conditionalSkip, Throwable throwable, String lastPluginHost, boolean reachedDownloadInterface) {
        this(RESULT.CONDITIONAL_SKIPPED, conditionalSkip, null, throwable, lastPluginHost, reachedDownloadInterface);
    }

    private DownloadLinkCandidateResult(RESULT result, ConditionalSkipReason conditionalSkip, SkipReason skipReason, Throwable throwable, String lastPluginHost, boolean reachedDownloadInterface) {
        this.result = result;
        this.skipReason = skipReason;
        this.lastPluginHost = lastPluginHost;
        this.conditionalSkip = conditionalSkip;
        this.throwable = throwable;
        List brEx = Exceptions.getInstancesof((Throwable)throwable, Browser.BrowserException.class);
        if (brEx != null) {
            for (Browser.BrowserException brE : brEx) {
                brE.removeRequest();
            }
        }
        this.reachedDownloadInterface = reachedDownloadInterface;
    }

    public DownloadLinkCandidateResult(RESULT result, Throwable throwable, String lastPluginHost) {
        this(result, throwable, lastPluginHost, false);
    }

    public DownloadLinkCandidateResult(RESULT result, Throwable throwable, String lastPluginHost, boolean reachedDownloadInterface) {
        this(result, null, null, throwable, lastPluginHost, reachedDownloadInterface);
    }

    public DownloadLinkCandidateResult(SkipReason skipReason, Throwable throwable, String lastPluginHost, boolean reachedDownloadInterface) {
        this(RESULT.SKIPPED, null, skipReason, throwable, lastPluginHost, reachedDownloadInterface);
    }

    public DownloadLinkCandidateResult(SkipReason skipReason, Throwable throwable, String lastPluginHost) {
        this(skipReason, throwable, lastPluginHost, false);
    }

    public String toString() {
        return "RESULT:" + (Object)((Object)this.getResult()) + "|SkipReason:" + (Object)((Object)this.getSkipReason()) + "|Message:" + this.getMessage() + "|Wait:" + this.getWaitTime() + "|ReachedDownloadInterface:" + this.isReachedDownloadInterface();
    }

    public RESULT getResult() {
        return this.result;
    }

    public static enum RESULT {
        CONNECTION_TEMP_UNAVAILABLE,
        CONNECTION_ISSUES,
        FATAL_ERROR,
        RETRY,
        ACCOUNT_INVALID,
        ACCOUNT_ERROR,
        ACCOUNT_REQUIRED,
        ACCOUNT_UNAVAILABLE,
        HOSTER_UNAVAILABLE,
        FILE_UNAVAILABLE,
        PROXY_UNAVAILABLE,
        IP_BLOCKED,
        CAPTCHA,
        PLUGIN_DEFECT,
        CONDITIONAL_SKIPPED,
        SKIPPED,
        FINISHED,
        FINISHED_EXISTS,
        FAILED,
        FAILED_INCOMPLETE,
        FAILED_EXISTS,
        OFFLINE_TRUSTED,
        STOPPED,
        COUNTRY_BLOCKED;

    }
}

