/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateHistory;
import jd.controlling.downloadcontroller.DownloadLinkCandidateLoadBalancer;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.ProxyInfoHistory;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.plugins.Account;
import jd.plugins.DownloadLink;
import org.appwork.exceptions.WTFException;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.domainrules.CompiledDomainRule;
import org.jdownloader.controlling.domainrules.DomainRuleSet;
import org.jdownloader.logging.LogController;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class DownloadLinkCandidateSelector {
    private final Comparator<CandidateResultHolder> RESULT_SORTER = new Comparator<CandidateResultHolder>(){
        private final DownloadLinkCandidateResult.RESULT[] FINAL_RESULT_SORT_ORDER = new DownloadLinkCandidateResult.RESULT[]{DownloadLinkCandidateResult.RESULT.SKIPPED, DownloadLinkCandidateResult.RESULT.ACCOUNT_REQUIRED, DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, DownloadLinkCandidateResult.RESULT.FATAL_ERROR};

        private int indexOf(DownloadLinkCandidateResult.RESULT o1) {
            for (int index = 0; index < this.FINAL_RESULT_SORT_ORDER.length; ++index) {
                if (this.FINAL_RESULT_SORT_ORDER[index] != o1) continue;
                return index;
            }
            return -1;
        }

        @Override
        private int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        @Override
        public int compare(CandidateResultHolder o1, CandidateResultHolder o2) {
            long i1 = this.indexOf(o1.getResult().getResult());
            long i2 = this.indexOf(o2.getResult().getResult());
            if (i1 >= 0L && i2 < 0L) {
                return -1;
            }
            if (i2 >= 0L && i1 < 0L) {
                return 1;
            }
            if (i1 >= 0L && i2 >= 0L) {
                return this.compare(i1, i2);
            }
            i1 = o1.getResult().getRemainingTime();
            i2 = o2.getResult().getRemainingTime();
            return -this.compare(i1, i2);
        }
    };
    private final DownloadSession session;
    private LinkedHashMap<DownloadLink, LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult>> roundResults = new LinkedHashMap();
    private final ProxyBalanceMode freeProxyBalanceMode;
    private static final AtomicInteger CYCLE = new AtomicInteger(0);
    public boolean isStopMarkReached = false;
    private boolean forcedOnly = false;

    public DownloadSession getSession() {
        return this.session;
    }

    public DownloadLinkCandidateSelector(DownloadSession session) {
        this.session = session;
        this.freeProxyBalanceMode = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getFreeProxyBalanceMode();
    }

    public DownloadLinkCandidateResult getBlockingDownloadLinkCandidateResult(DownloadLinkCandidate candidate, List<DownloadLinkCandidateResult> candidateResults, DownloadLinkCandidateHistory history) {
        if (candidateResults.size() > 1) {
            HashMap<DownloadLinkCandidateResult.RESULT, AtomicInteger> resultCounterMap = new HashMap<DownloadLinkCandidateResult.RESULT, AtomicInteger>();
            for (DownloadLinkCandidateResult downloadLinkCandidateResult : candidateResults) {
                DownloadLinkCandidateResult.RESULT result = downloadLinkCandidateResult.getResult();
                switch (result) {
                    case FILE_UNAVAILABLE: 
                    case CONNECTION_ISSUES: 
                    case HOSTER_UNAVAILABLE: {
                        resultCounterMap.clear();
                        break;
                    }
                    case FAILED_INCOMPLETE: 
                    case RETRY: {
                        AtomicInteger resultCounter = (AtomicInteger)resultCounterMap.get((Object)result);
                        if (resultCounter == null) {
                            resultCounter = new AtomicInteger(1);
                            resultCounterMap.put(result, resultCounter);
                            break;
                        }
                        resultCounter.incrementAndGet();
                        break;
                    }
                }
            }
            for (Map.Entry entry : resultCounterMap.entrySet()) {
                if (entry.getValue() == null || ((AtomicInteger)entry.getValue()).get() <= 5) continue;
                DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FILE_UNAVAILABLE, null, candidate.getCachedAccount().getHost(), false);
                ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDownloadTempUnavailableRetryWaittime());
                history.attach(candidate);
                history.dettach(candidate, ret);
                return ret;
            }
        }
        int maxNumberOfDownloadLinkCandidates = -1;
        return null;
    }

    public final List<AbstractProxySelectorImpl> getProxies(DownloadLinkCandidate candidate, boolean ignoreConnectBans, boolean ignoreAllBans) {
        List<AbstractProxySelectorImpl> ret = ProxyController.getInstance().getProxySelectors(candidate, ignoreConnectBans, ignoreAllBans);
        if (candidate.getCachedAccount().getAccount() == null) {
            try {
                switch (this.freeProxyBalanceMode) {
                    case BALANCE: {
                        Collections.sort(ret, new DownloadLinkCandidateLoadBalancer(candidate));
                        break;
                    }
                    case RANDOM: {
                        Collections.shuffle(ret);
                        break;
                    }
                    case CYCLE: {
                        int cyleIndex = CYCLE.getAndIncrement();
                        if (cyleIndex >= ret.size()) {
                            CYCLE.set(0);
                            cyleIndex = 0;
                        }
                        ArrayList<AbstractProxySelectorImpl> cycle = new ArrayList<AbstractProxySelectorImpl>();
                        while (cyleIndex < ret.size()) {
                            cycle.add(ret.get(cyleIndex));
                            ++cyleIndex;
                        }
                        if (cyleIndex > 0) {
                            cycle.addAll(ret.subList(0, cyleIndex));
                        }
                        ret = cycle;
                        break;
                    }
                }
            }
            catch (Throwable e) {
                LogController.CL(true).log(e);
            }
        }
        return ret;
    }

    public final CachedAccountPermission getCachedAccountPermission(AccountCache.CachedAccount cachedAccount) {
        if (cachedAccount != null) {
            if (!this.session.isUseAccountsEnabled() && !AccountCache.ACCOUNTTYPE.NONE.equals((Object)cachedAccount.getType())) {
                return CachedAccountPermission.DISABLED;
            }
            Account canidateAccount = cachedAccount.getAccount();
            if (canidateAccount != null) {
                if (!canidateAccount.isEnabled()) {
                    return CachedAccountPermission.DISABLED;
                }
                if (canidateAccount.isTempDisabled()) {
                    return CachedAccountPermission.TEMP_DISABLED;
                }
            }
            return CachedAccountPermission.OK;
        }
        return CachedAccountPermission.IMPOSSIBLE;
    }

    public final DownloadLinkCandidatePermission getDownloadLinkCandidatePermission(DownloadLinkCandidate candidate) {
        int maxDownloads = Math.max(1, CFG_GENERAL.CFG.getMaxSimultaneDownloads());
        DomainRuleSet domainRuleSet = null;
        if (!candidate.isForced() && this.session.getControllers().size() >= maxDownloads && (domainRuleSet = candidate.getDomainRuleSet()).size() == 0 && !DownloadWatchDog.getInstance().checkForAdditionalDownloadSlots(this.session)) {
            return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
        }
        DownloadLink candidateLink = candidate.getLink();
        AccountCache.CachedAccount cachedAccount = candidate.getCachedAccount();
        Account candidateAccount = cachedAccount.getAccount();
        int maxPluginConcurrentAccount = cachedAccount.getPlugin().getMaxSimultanDownload(null, candidateAccount, candidate.getProxySelector());
        if (maxPluginConcurrentAccount == 0) {
            String plugin = cachedAccount.getPlugin().getLazyP().getClassName();
            if (candidateAccount == null) {
                throw new WTFException(plugin + ".getMaxSimultanDownload(null,null) returned 0!");
            }
            throw new WTFException(plugin + ".getMaxSimultanDownload(null," + candidateAccount.getUser() + ") returned 0!");
        }
        int maxPluginConcurrentHost = cachedAccount.getPlugin().getMaxSimultanDownload(candidateLink, candidateAccount, candidate.getProxySelector());
        if (maxPluginConcurrentHost <= 0) {
            return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
        }
        int maxConcurrentHost = this.session.getMaxConcurrentDownloadsPerHost();
        String candidatePlugin = cachedAccount.getPlugin().getHost();
        int forcedDownloads = 0;
        for (SingleDownloadController singleDownloadController : this.session.getControllers()) {
            boolean sameAccountHost;
            Account downloadAccount = singleDownloadController.getAccount();
            DownloadLinkCandidate downloadCandidate = singleDownloadController.getDownloadLinkCandidate();
            DownloadLink downloadLink = singleDownloadController.getDownloadLink();
            if (downloadAccount != null ? (candidateAccount != null ? (sameAccountHost = StringUtils.equals((String)downloadAccount.getHoster(), (String)candidateAccount.getHoster())) && downloadAccount != candidateAccount && !candidateAccount.isConcurrentUsePossible() : (sameAccountHost = StringUtils.equals((String)downloadAccount.getHoster(), (String)candidatePlugin)) && !downloadAccount.isConcurrentUsePossible()) : candidateAccount != null && (sameAccountHost = StringUtils.equals((String)candidateAccount.getHoster(), (String)downloadLink.getHost())) && !candidateAccount.isConcurrentUsePossible()) {
                return DownloadLinkCandidatePermission.CONCURRENCY_FORBIDDEN;
            }
            if (downloadCandidate.isForced()) {
                ++forcedDownloads;
            }
            if (downloadLink.getDomainInfo().compareTo(candidateLink.getDomainInfo()) == 0) {
                --maxConcurrentHost;
            }
            if (candidatePlugin.equals(downloadCandidate.getCachedAccount().getPlugin().getHost()) && cachedAccount.getPlugin().isSameAccount(downloadAccount, singleDownloadController.getProxySelector(), candidateAccount, candidate.getProxySelector())) {
                if (--maxPluginConcurrentAccount <= 0) {
                    return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
                }
                if (candidateLink.getHost().equals(downloadLink.getHost()) && --maxPluginConcurrentHost <= 0) {
                    return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
                }
            }
            String downloadDomain = downloadLink.getDomainInfo().getTld();
            String pluginDomain = downloadCandidate.getCachedAccount().getHost();
            String fileName = downloadLink.getName();
            domainRuleSet = candidate.getDomainRuleSet();
            for (Map.Entry<CompiledDomainRule, AtomicInteger> s : domainRuleSet.getMap().entrySet()) {
                if (!s.getKey().matches(downloadCandidate.getCachedAccount().getAccount(), downloadDomain, pluginDomain, fileName)) continue;
                s.getValue().incrementAndGet();
            }
        }
        if (candidate.isForced() && forcedDownloads < Math.max(0, (Integer)CFG_GENERAL.MAX_FORCED_DOWNLOADS.getValue())) {
            return DownloadLinkCandidatePermission.OK_FORCED;
        }
        if (maxConcurrentHost <= 0 || this.session.getControllers().size() >= maxDownloads) {
            domainRuleSet = candidate.getDomainRuleSet();
            for (Map.Entry entry : domainRuleSet.getMap().entrySet()) {
                if (!((CompiledDomainRule)entry.getKey()).isAllowToExceedTheGlobalLimit() || ((AtomicInteger)entry.getValue()).get() >= ((CompiledDomainRule)entry.getKey()).getMaxSimultanDownloads()) continue;
                return DownloadLinkCandidatePermission.OK;
            }
            if (DownloadWatchDog.getInstance().checkForAdditionalDownloadSlots(this.session)) {
                return DownloadLinkCandidatePermission.OK_SPEED_EXTENSION;
            }
            return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
        }
        domainRuleSet = candidate.getDomainRuleSet();
        for (Map.Entry entry : domainRuleSet.getMap().entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() < ((CompiledDomainRule)entry.getKey()).getMaxSimultanDownloads()) continue;
            return DownloadLinkCandidatePermission.CONCURRENCY_LIMIT;
        }
        return DownloadLinkCandidatePermission.OK;
    }

    public boolean isMirrorManagement() {
        return this.session.isMirrorManagementEnabled();
    }

    public boolean isForcedOnly() {
        return this.forcedOnly;
    }

    public void setForcedOnly(boolean forcedOnly) {
        this.forcedOnly = forcedOnly;
    }

    public boolean isExcluded(DownloadLink link) {
        return this.roundResults.containsKey(link);
    }

    public void addExcluded(DownloadLink link) {
        if (this.roundResults.containsKey(link)) {
            return;
        }
        this.roundResults.put(link, null);
    }

    public boolean validateDownloadLinkCandidate(DownloadLinkCandidate possibleCandidate) {
        DownloadLinkCandidateResult linkResult = null;
        DownloadLinkCandidateResult proxyResult = null;
        DownloadLinkCandidateHistory linkHistory = this.getSession().getHistory(possibleCandidate.getLink());
        if (linkHistory != null) {
            linkResult = linkHistory.getBlockingHistory(this, possibleCandidate);
        }
        ProxyInfoHistory proxyHistory = this.getSession().getProxyInfoHistory();
        proxyResult = proxyHistory.getBlockingHistory(possibleCandidate);
        if (linkResult != null && proxyResult == null) {
            this.addExcluded(possibleCandidate, linkResult);
            return false;
        }
        if (proxyResult != null && linkResult == null) {
            this.addExcluded(possibleCandidate, proxyResult);
            return false;
        }
        if (proxyResult != null && linkResult != null) {
            switch (linkResult.getResult()) {
                case PLUGIN_DEFECT: 
                case ACCOUNT_REQUIRED: 
                case FATAL_ERROR: 
                case SKIPPED: {
                    this.addExcluded(possibleCandidate, linkResult);
                    break;
                }
                case FILE_UNAVAILABLE: 
                case CONNECTION_ISSUES: {
                    if (proxyResult.getRemainingTime() >= linkResult.getRemainingTime()) {
                        this.addExcluded(possibleCandidate, proxyResult);
                        break;
                    }
                    this.addExcluded(possibleCandidate, linkResult);
                    break;
                }
                default: {
                    System.out.println("FIXME " + (Object)((Object)linkResult.getResult()));
                }
            }
            return false;
        }
        return true;
    }

    public void setExcluded(DownloadLink link) {
        this.roundResults.put(link, null);
    }

    public boolean isStopMarkReached() {
        return this.isStopMarkReached;
    }

    public void addExcluded(DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult> map;
        if (result == null) {
            throw new IllegalArgumentException("result == null");
        }
        DownloadLink link = candidate.getLink();
        if (result.getSkipReason() != null) {
            DownloadLinkCandidateHistory history = this.getSession().buildHistory(link);
            history.attach(candidate);
            history.dettach(candidate, result);
        }
        if ((map = this.roundResults.get(link)) == null) {
            map = new LinkedHashMap();
            this.roundResults.put(link, map);
        }
        map.put(candidate, result);
        if (link == this.getSession().getStopMark() && this.getSession().isStopMarkReached(link, false)) {
            this.isStopMarkReached = true;
        }
    }

    public LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult> finalizeDownloadLinkCandidatesResults() {
        LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult> ret = new LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult>();
        block6: for (Map.Entry<DownloadLink, LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult>> next : this.roundResults.entrySet()) {
            Map map = next.getValue();
            if (map == null || map.size() == 0) continue;
            ArrayList<CandidateResultHolder> results = new ArrayList<CandidateResultHolder>();
            for (Map.Entry next2 : map.entrySet()) {
                DownloadLinkCandidateResult candidateResult = (DownloadLinkCandidateResult)next2.getValue();
                switch (candidateResult.getResult()) {
                    case CONNECTION_TEMP_UNAVAILABLE: {
                        continue block6;
                    }
                    case FILE_UNAVAILABLE: 
                    case CONNECTION_ISSUES: 
                    case PLUGIN_DEFECT: 
                    case ACCOUNT_REQUIRED: 
                    case FATAL_ERROR: 
                    case SKIPPED: 
                    case PROXY_UNAVAILABLE: 
                    case CONDITIONAL_SKIPPED: {
                        results.add(new CandidateResultHolder((DownloadLinkCandidate)next2.getKey(), candidateResult));
                        break;
                    }
                    default: {
                        throw new WTFException("This should not happen " + (Object)((Object)candidateResult.getResult()));
                    }
                }
                try {
                    Collections.sort(results, this.RESULT_SORTER);
                }
                catch (Throwable e) {
                    LogController.CL(true).log(e);
                }
                CandidateResultHolder mostImportantResult = (CandidateResultHolder)results.get(0);
                ret.put(mostImportantResult.getCandidate(), mostImportantResult.getResult());
            }
        }
        return ret;
    }

    public static enum ProxyBalanceMode {
        DISABLED,
        RANDOM,
        CYCLE,
        BALANCE;

    }

    public static enum CachedAccountPermission {
        OK,
        DISABLED,
        TEMP_DISABLED,
        IMPOSSIBLE;

    }

    public static enum DownloadLinkCandidatePermission {
        OK,
        OK_FORCED,
        CONCURRENCY_LIMIT,
        CONCURRENCY_FORBIDDEN,
        OK_SPEED_EXTENSION;

    }

    private static class CandidateResultHolder {
        private final DownloadLinkCandidateResult result;
        private final DownloadLinkCandidate candidate;

        public DownloadLinkCandidateResult getResult() {
            return this.result;
        }

        public DownloadLinkCandidate getCandidate() {
            return this.candidate;
        }

        private CandidateResultHolder(DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
            this.result = result;
            this.candidate = candidate;
        }
    }
}

