/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.config.Property;
import jd.controlling.AccountController;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidateHistory;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.FileAccessManager;
import jd.controlling.downloadcontroller.ProxyInfoHistory;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.event.DownloadWatchdogEvent;
import jd.controlling.packagecontroller.PackageControllerQueue;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.AccountTrafficView;
import jd.plugins.DownloadLink;
import jd.plugins.FilePackage;
import jd.plugins.PluginForHost;
import jd.plugins.download.raf.FileBytesCache;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.Queue;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.hosterrule.AccountGroup;
import org.jdownloader.controlling.hosterrule.CachedAccountGroup;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.controller.PluginClassLoader;
import org.jdownloader.plugins.controller.host.HostPluginController;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.IfFilenameTooLongAction;

public class DownloadSession
extends Property {
    private static final FileAccessManager FILE_ACCESS_MANAGER = new FileAccessManager();
    private static final DiskSpaceManager DISK_SPACE_MANAGER = new DiskSpaceManager();
    private final NullsafeAtomicReference<SessionState> sessionState = new NullsafeAtomicReference((Object)SessionState.NORMAL);
    private final HashMap<String, AccountCache> accountCache = new HashMap();
    private final WeakHashMap<DownloadLink, DownloadLinkCandidateHistory> candidateHistory = new WeakHashMap();
    private final WeakHashMap<UniqueAlltimeID, IfFileExistsAction> fileExistsActions = new WeakHashMap();
    private final WeakHashMap<UniqueAlltimeID, IfFilenameTooLongAction> fileFilenameTooLongActions = new WeakHashMap();
    private final AtomicInteger downloadsStarted = new AtomicInteger(0);
    private final AtomicInteger skipCounter = new AtomicInteger(0);
    private final NullsafeAtomicReference<Integer> speedLimitBeforePause = new NullsafeAtomicReference(null);
    private final NullsafeAtomicReference<Boolean> speedLimitedBeforePause = new NullsafeAtomicReference(null);
    private volatile List<DownloadLink> forcedLinks = new CopyOnWriteArrayList<DownloadLink>();
    private volatile List<DownloadLink> activationRequests = new CopyOnWriteArrayList<DownloadLink>();
    private final WeakHashMap<PluginForHost, PluginClassLoader.PluginClassLoaderChild> activationPluginCache = new WeakHashMap();
    private final AtomicBoolean refreshCandidates = new AtomicBoolean(false);
    private final AtomicBoolean activateForcedOnly = new AtomicBoolean(false);
    private AtomicLong activatorRebuildRequest = new AtomicLong(1L);
    private NullsafeAtomicReference<CaptchaSettings.MODE> captchaMode = new NullsafeAtomicReference((Object)CaptchaSettings.MODE.NORMAL);
    private static final Comparator<AccountCache.CachedAccount> EXPIRE_DATE_SORTER = new Comparator<AccountCache.CachedAccount>(){

        @Override
        public final int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        public final long getExpireDate(Account account) {
            if (account == null) {
                return Long.MAX_VALUE;
            }
            long validUntil = account.getValidPremiumUntil();
            if (validUntil <= 0L) {
                return Long.MAX_VALUE;
            }
            return validUntil;
        }

        @Override
        public int compare(AccountCache.CachedAccount account1, AccountCache.CachedAccount account2) {
            long expireDate1 = this.getExpireDate(account1.getAccount());
            long expireDate2 = this.getExpireDate(account2.getAccount());
            return this.compare(expireDate1, expireDate2);
        }
    };
    private static final Comparator<AccountCache.CachedAccount> TRAFFIC_LEFT_SORTER = new Comparator<AccountCache.CachedAccount>(){

        @Override
        public final int compare(long x, long y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }

        public final long getTrafficLeft(Account account) {
            if (account == null) {
                return Long.MAX_VALUE;
            }
            AccountTrafficView accountTrafficView = account.getAccountTrafficView();
            if (accountTrafficView == null || accountTrafficView.isUnlimitedTraffic()) {
                return Long.MAX_VALUE;
            }
            return accountTrafficView.getTrafficLeft();
        }

        @Override
        public int compare(AccountCache.CachedAccount account1, AccountCache.CachedAccount account2) {
            long trafficLeft1 = this.getTrafficLeft(account1.getAccount());
            long trafficLeft2 = this.getTrafficLeft(account2.getAccount());
            return this.compare(trafficLeft1, trafficLeft2);
        }
    };
    private static final Comparator<AccountCache.CachedAccount> ACCOUNT_SORTER = new Comparator<AccountCache.CachedAccount>(){

        @Override
        public int compare(AccountCache.CachedAccount o1, AccountCache.CachedAccount o2) {
            int ret = EXPIRE_DATE_SORTER.compare(o1, o2);
            if (ret == 0) {
                return TRAFFIC_LEFT_SORTER.compare(o1, o2);
            }
            return ret;
        }
    };
    private final ProxyInfoHistory proxyInfoHistory;
    private final AtomicInteger maxConcurrentDownloadsPerHost = new AtomicInteger(Integer.MAX_VALUE);
    private final NullsafeAtomicReference<Object> stopMark = new NullsafeAtomicReference((Object)STOPMARK.NONE);
    private final AtomicBoolean useAccounts = new AtomicBoolean(true);
    private final AtomicBoolean mirrorManagement = new AtomicBoolean(true);
    private final CopyOnWriteArraySet<SingleDownloadController> controllers = new CopyOnWriteArraySet<SingleDownloadController>(){
        private static final long serialVersionUID = -3897088297641777499L;

        @Override
        public boolean add(SingleDownloadController e) {
            DownloadSession.this.downloadsStarted.incrementAndGet();
            e.getDownloadLinkCandidate().getLink().setDownloadLinkController(e);
            return super.add(e);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object e) {
            boolean ret = super.remove(e);
            if (ret) {
                try {
                    DownloadSession.this.getDiskSpaceManager().freeAllReservationsBy(e);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    DownloadSession.this.getFileAccessManager().unlockAllHeldby(e);
                }
                finally {
                    if (e instanceof SingleDownloadController) {
                        ((SingleDownloadController)e).getDownloadLinkCandidate().getLink().setDownloadLinkController(null);
                    }
                }
            }
            return ret;
        }
    };
    private final long createTime = System.currentTimeMillis();
    private static volatile WeakReference<FileBytesCache> downloadWriteCache = null;

    public DiskSpaceManager getDiskSpaceManager() {
        return DISK_SPACE_MANAGER;
    }

    public CaptchaSettings.MODE getCaptchaMode() {
        return (CaptchaSettings.MODE)((Object)this.captchaMode.get());
    }

    protected void setCaptchaMode(CaptchaSettings.MODE captchaMode) {
        if (captchaMode == null) {
            captchaMode = CaptchaSettings.MODE.NORMAL;
        }
        this.captchaMode.set((Object)captchaMode);
    }

    public long getActivatorRebuildRequest() {
        return this.activatorRebuildRequest.get();
    }

    protected void incrementActivatorRebuildRequest() {
        this.activatorRebuildRequest.incrementAndGet();
    }

    public boolean isCandidatesRefreshRequired() {
        return this.refreshCandidates.get();
    }

    public boolean isUseAccountsEnabled() {
        return this.useAccounts.get();
    }

    protected void setUseAccountsEnabled(boolean b) {
        this.useAccounts.set(b);
    }

    public boolean isMirrorManagementEnabled() {
        return this.mirrorManagement.get();
    }

    protected void setMirrorManagementEnabled(boolean b) {
        this.mirrorManagement.set(b);
    }

    public int getMaxConcurrentDownloadsPerHost() {
        return this.maxConcurrentDownloadsPerHost.get();
    }

    protected void setMaxConcurrentDownloadsPerHost(int max) {
        if (max <= 0) {
            this.maxConcurrentDownloadsPerHost.set(Integer.MAX_VALUE);
        } else {
            this.maxConcurrentDownloadsPerHost.set(max);
        }
    }

    public boolean isForcedOnlyModeEnabled() {
        return this.activateForcedOnly.get();
    }

    public int getSkipCounter() {
        return this.skipCounter.get();
    }

    public int getSpeedLimitBeforePause() {
        Integer ret = (Integer)this.speedLimitBeforePause.get();
        if (ret == null) {
            return -1;
        }
        return Math.max(-1, ret);
    }

    public Boolean isSpeedWasLimitedBeforePauseEnabled() {
        return (Boolean)this.speedLimitedBeforePause.get();
    }

    protected void setActivationRequests(List<DownloadLink> activationRequests) {
        if (!this.isCandidatesRefreshRequired() && !activationRequests.equals(this.activationRequests)) {
            this.refreshCandidates();
        }
        this.activationRequests = activationRequests;
    }

    public void refreshCandidates() {
        this.refreshCandidates.set(true);
    }

    protected void setForcedLinks(CopyOnWriteArrayList<DownloadLink> forcedLinks) {
        if (!this.isCandidatesRefreshRequired() && !forcedLinks.equals(this.forcedLinks)) {
            this.refreshCandidates();
        }
        this.forcedLinks = forcedLinks;
    }

    protected boolean removeActivationRequest(DownloadLink link) {
        if (link == null) {
            return false;
        }
        boolean removed = this.activationRequests.remove(link);
        boolean bl = removed = this.forcedLinks.remove(link) || removed;
        if (removed) {
            this.refreshCandidates();
        }
        return removed;
    }

    protected boolean removeActivationRequests(List<DownloadLink> links) {
        if (links == null) {
            return false;
        }
        boolean removed = this.activationRequests.remove(links);
        boolean bl = removed = this.forcedLinks.remove(links) || removed;
        if (removed) {
            this.refreshCandidates();
        }
        return removed;
    }

    private Map<PluginForHost, PluginClassLoader.PluginClassLoaderChild> getActivationPluginCache() {
        return this.activationPluginCache;
    }

    public static synchronized FileBytesCache getDownloadWriteCache() {
        FileBytesCache ret = null;
        if (downloadWriteCache != null && (ret = (FileBytesCache)downloadWriteCache.get()) != null) {
            return ret;
        }
        ret = new FileBytesCache(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getMaxBufferSize() * 1024, ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getFlushBufferTimeout());
        downloadWriteCache = new WeakReference<FileBytesCache>(ret);
        return ret;
    }

    public ProxyInfoHistory getProxyInfoHistory() {
        return this.proxyInfoHistory;
    }

    public synchronized PluginForHost getPlugin(String host) {
        LazyHostPlugin fallBackPlugin;
        if (StringUtils.isEmpty((String)host)) {
            return null;
        }
        for (Map.Entry<PluginForHost, PluginClassLoader.PluginClassLoaderChild> next : this.getActivationPluginCache().entrySet()) {
            PluginForHost plugin = next.getKey();
            if (plugin == null || !StringUtils.equalsIgnoreCase((String)host, (String)plugin.getHost())) continue;
            return plugin;
        }
        PluginForHost plugin = JDUtilities.getPluginForHost(host);
        if (plugin == null && (fallBackPlugin = HostPluginController.getInstance().getFallBackPlugin()) != null) {
            try {
                plugin = fallBackPlugin.getPrototype(PluginClassLoader.getThreadPluginClassLoaderChild());
            }
            catch (Throwable e) {
                LogController.CL().log(e);
            }
        }
        this.getActivationPluginCache().put(plugin, PluginClassLoader.getSharedChild(plugin));
        return plugin;
    }

    public synchronized PluginClassLoader.PluginClassLoaderChild getPluginClassLoaderChild(PluginForHost plugin) {
        if (plugin == null) {
            return null;
        }
        for (Map.Entry<PluginForHost, PluginClassLoader.PluginClassLoaderChild> next : this.getActivationPluginCache().entrySet()) {
            PluginForHost entry = next.getKey();
            if (entry != plugin) continue;
            return next.getValue();
        }
        return null;
    }

    public List<DownloadLink> getForcedLinks() {
        return this.forcedLinks;
    }

    public void toggleStopMark(Object entry) {
        Object stopMark = this.getStopMark();
        if (entry == STOPMARK.RANDOM && stopMark != STOPMARK.NONE) {
            entry = null;
        }
        if (entry == null || stopMark == entry || entry == STOPMARK.NONE) {
            this.setStopMark((Object)STOPMARK.NONE);
        } else {
            this.setStopMark(entry);
        }
    }

    public boolean isForcedLinksWaiting() {
        return this.forcedLinks.size() > 0;
    }

    public boolean isActivationRequestsWaiting() {
        if (this.activateForcedOnly.get()) {
            return this.forcedLinks.size() > 0;
        }
        return this.forcedLinks.size() > 0 || this.activationRequests.size() > 0;
    }

    public DownloadSession() {
        this(null);
    }

    protected DownloadSession(DownloadSession previousSession) {
        if (previousSession == null) {
            this.proxyInfoHistory = new ProxyInfoHistory();
        } else {
            if (previousSession.getControllers().size() > 0) {
                throw new IllegalArgumentException("previousSession contains active controllers!");
            }
            this.proxyInfoHistory = previousSession.getProxyInfoHistory();
            if (previousSession.isStopMarkSet() && !previousSession.isStopMarkReached()) {
                this.setStopMark(previousSession.getStopMark());
            }
            this.setCaptchaMode(previousSession.getCaptchaMode());
            this.setMaxConcurrentDownloadsPerHost(previousSession.getMaxConcurrentDownloadsPerHost());
            this.setUseAccountsEnabled(previousSession.isUseAccountsEnabled());
            this.setMirrorManagementEnabled(previousSession.isMirrorManagementEnabled());
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    protected DownloadLinkCandidateHistory getHistory(DownloadLink downloadLink) {
        return this.candidateHistory.get(downloadLink);
    }

    protected Collection<DownloadLinkCandidateHistory> getHistories() {
        return this.candidateHistory.values();
    }

    public DownloadLinkCandidateHistory buildHistory(DownloadLink downloadLink) {
        DownloadLinkCandidateHistory ret = this.candidateHistory.get(downloadLink);
        if (ret == null) {
            ret = new DownloadLinkCandidateHistory();
            this.candidateHistory.put(downloadLink, ret);
        }
        return ret;
    }

    protected DownloadLinkCandidateHistory removeHistory(DownloadLink downloadLink) {
        if (downloadLink == null) {
            this.candidateHistory.clear();
            return null;
        }
        return this.candidateHistory.remove(downloadLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAccountCache(String host) {
        this.refreshCandidates.set(true);
        HashMap<String, AccountCache> hashMap = this.accountCache;
        synchronized (hashMap) {
            if (StringUtils.isEmpty((String)host)) {
                this.accountCache.clear();
            } else {
                this.accountCache.remove(host.toLowerCase(Locale.ENGLISH));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccountCache getAccountCache(DownloadLink link) {
        String host = link.getHost();
        if (StringUtils.isEmpty((String)host)) {
            return AccountCache.NA;
        }
        AccountCache ret = null;
        HashMap<String, AccountCache> hashMap = this.accountCache;
        synchronized (hashMap) {
            if (this.accountCache.containsKey(host)) {
                ret = this.accountCache.get(host);
                if (ret == null) {
                    return AccountCache.NA;
                }
                return ret;
            }
        }
        PluginForHost defaulPlugin = this.getPlugin(host);
        final ArrayList<CachedAccountGroup> cachedGroups = new ArrayList<CachedAccountGroup>();
        if (!this.isUseAccountsEnabled()) {
            CachedAccountGroup freeGroup = new CachedAccountGroup(AccountGroup.Rules.ORDER);
            freeGroup.add(new AccountCache.CachedAccount(host, null, defaulPlugin));
            cachedGroups.add(freeGroup);
            ret = new AccountCache(cachedGroups);
        } else {
            ret = HosterRuleController.getInstance().getAccountCache(host, this);
            if (ret == null) {
                List<Account> multiHosts;
                boolean removeNoAccountWithCaptcha = false;
                int numberofPremiumAccounts = 0;
                CachedAccountGroup hosterPremiumGroup = new CachedAccountGroup(AccountGroup.Rules.ORDER);
                CachedAccountGroup hosterFreeGroup = new CachedAccountGroup(AccountGroup.Rules.RANDOM);
                block13: for (Account acc : AccountController.getInstance().list(host)) {
                    if (!acc.isEnabled() || !acc.isValid()) continue;
                    AccountInfo ai = acc.getAccountInfo();
                    if (ai == null || ai.isSpecialTraffic() || ai.isUnlimitedTraffic() || ai.isTrafficRefill()) {
                        removeNoAccountWithCaptcha = true;
                    }
                    AccountCache.CachedAccount cachedAccount = new AccountCache.CachedAccount(host, acc, defaulPlugin);
                    switch (acc.getType()) {
                        case LIFETIME: 
                        case PREMIUM: {
                            hosterPremiumGroup.add(cachedAccount);
                            continue block13;
                        }
                    }
                    hosterFreeGroup.add(cachedAccount);
                }
                if (hosterPremiumGroup.size() > 0) {
                    numberofPremiumAccounts += hosterPremiumGroup.size();
                    try {
                        Collections.sort(hosterPremiumGroup, ACCOUNT_SORTER);
                    }
                    catch (Throwable e) {
                        LogController.CL().log(e);
                    }
                    cachedGroups.add(hosterPremiumGroup);
                }
                if ((multiHosts = AccountController.getInstance().getMultiHostAccounts(host)) != null) {
                    CachedAccountGroup multiHosterGroup = new CachedAccountGroup(AccountGroup.Rules.ORDER);
                    for (Account acc : multiHosts) {
                        if (!acc.isEnabled() || !acc.isValid()) continue;
                        multiHosterGroup.add(new AccountCache.CachedAccount(host, acc, this.getPlugin(acc.getHoster())));
                    }
                    if (multiHosterGroup.size() > 0) {
                        numberofPremiumAccounts += multiHosterGroup.size();
                        try {
                            Collections.sort(multiHosterGroup, ACCOUNT_SORTER);
                        }
                        catch (Throwable e) {
                            LogController.CL().log(e);
                        }
                        cachedGroups.add(multiHosterGroup);
                    }
                }
                if (hosterFreeGroup.size() > 0) {
                    cachedGroups.add(hosterFreeGroup);
                }
                AccountCache.CachedAccount noAccount = new AccountCache.CachedAccount(host, null, defaulPlugin);
                boolean addNoAccountGroup = numberofPremiumAccounts > 0 ? false : !removeNoAccountWithCaptcha || !noAccount.hasCaptcha(link);
                if (!addNoAccountGroup) {
                    noAccount = new AccountCache.CachedAccount(host, null, defaulPlugin){
                        final List<CachedAccountGroup> finalCachedGroups;
                        {
                            super(host, account, plugin);
                            this.finalCachedGroups = new ArrayList<CachedAccountGroup>(cachedGroups);
                        }

                        @Override
                        public boolean canHandle(DownloadLink link) throws Exception {
                            try {
                                for (CachedAccountGroup cachedGroup : this.finalCachedGroups) {
                                    for (AccountCache.CachedAccount cachedAccount : cachedGroup) {
                                        if (!cachedAccount.canHandle(link)) continue;
                                        return false;
                                    }
                                }
                            }
                            catch (Exception ignore) {
                                return false;
                            }
                            return super.canHandle(link);
                        }
                    };
                }
                CachedAccountGroup freeGroup = new CachedAccountGroup(AccountGroup.Rules.ORDER);
                freeGroup.add(noAccount);
                cachedGroups.add(freeGroup);
                ret = new AccountCache(cachedGroups);
            }
        }
        HashMap<String, AccountCache> hashMap2 = this.accountCache;
        synchronized (hashMap2) {
            if (!this.accountCache.containsKey(host)) {
                this.accountCache.put(host, ret);
                return ret;
            }
            ret = this.accountCache.get(host);
            if (ret == null) {
                return AccountCache.NA;
            }
            return ret;
        }
    }

    public boolean isStopMark(Object item) {
        Object stopMark = this.stopMark.get();
        if (stopMark instanceof STOPMARK) {
            return false;
        }
        if (stopMark == item) {
            return true;
        }
        if (stopMark instanceof DownloadLink) {
            return item == ((DownloadLink)stopMark).getFilePackage();
        }
        return false;
    }

    public boolean isStopMarkSet() {
        return this.stopMark.get() != STOPMARK.NONE;
    }

    public boolean isStopMarkReached(final DownloadLink link, boolean checkRemoved) {
        if (!link.isEnabled() || link.isSkipped() || link.getFinalLinkState() != null) {
            return true;
        }
        DownloadLinkCandidateHistory history = this.getHistory(link);
        if (history != null) {
            DownloadLinkCandidateResult last;
            List<DownloadLinkCandidateResult> results = DownloadLinkCandidateHistory.selectResults(history, null);
            return results.size() <= 0 || !DownloadLinkCandidateResult.RESULT.IP_BLOCKED.equals((Object)(last = results.get(results.size() - 1)).getResult()) || System.currentTimeMillis() - last.getTimeStamp() >= 60000L;
        }
        if (checkRemoved) {
            return Boolean.TRUE.equals(DownloadController.getInstance().getQueue().addWait(new PackageControllerQueue.ReadOnlyQueueAction<Boolean, RuntimeException>(Queue.QueuePriority.HIGH){

                protected Boolean run() throws RuntimeException {
                    FilePackage fp = link.getParentNode();
                    return FilePackage.isDefaultFilePackage(fp) || fp == null || DownloadController.getInstance() != fp.getControlledBy();
                }
            }));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isStopMarkReached() {
        Object stop = this.stopMark.get();
        if (stop == STOPMARK.NONE) {
            return false;
        }
        if (stop == STOPMARK.HIDDEN) {
            return true;
        }
        if (stop instanceof DownloadLink) {
            DownloadLink link = (DownloadLink)stop;
            return this.isStopMarkReached(link, true);
        }
        if (stop instanceof FilePackage) {
            final FilePackage fp = (FilePackage)stop;
            Boolean fpResult = DownloadController.getInstance().getQueue().addWait(new PackageControllerQueue.ReadOnlyQueueAction<Boolean, RuntimeException>(Queue.QueuePriority.HIGH){

                protected Boolean run() throws RuntimeException {
                    return FilePackage.isDefaultFilePackage(fp) || fp == null || DownloadController.getInstance() != fp.getControlledBy();
                }
            });
            if (Boolean.FALSE.equals(fpResult)) {
                boolean readL = fp.getModifyLock().readLock();
                try {
                    for (DownloadLink link : fp.getChildren()) {
                        if (this.isStopMarkReached(link, false)) continue;
                        boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    fp.getModifyLock().readUnlock(readL);
                }
            }
            return true;
        }
        return false;
    }

    protected void setStopMark(Object stopEntry) {
        Object entry = stopEntry;
        if (entry == null || entry == STOPMARK.NONE) {
            entry = STOPMARK.NONE;
        }
        if (entry == STOPMARK.RANDOM) {
            while (true) {
                try {
                    Iterator<SingleDownloadController> it = this.controllers.iterator();
                    if (it.hasNext()) {
                        entry = it.next().getDownloadLink();
                        break;
                    }
                    entry = STOPMARK.HIDDEN;
                }
                catch (Throwable throwable) {
                    continue;
                }
                break;
            }
        }
        this.stopMark.set(entry);
        DownloadWatchDog.getInstance().getEventSender().fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.PROPERTY_CHANGE, new DownloadWatchDogProperty(DownloadWatchDogProperty.Property.STOPSIGN, entry)));
    }

    public IfFileExistsAction getOnFileExistsAction(FilePackage filePackage) {
        return this.fileExistsActions.get((Object)filePackage.getUniqueID());
    }

    public void setOnFileExistsAction(FilePackage filePackage, IfFileExistsAction action) {
        if (filePackage == null) {
            this.fileExistsActions.clear();
            return;
        }
        if (action == null) {
            this.fileExistsActions.remove((Object)filePackage.getUniqueID());
        } else {
            this.fileExistsActions.put(filePackage.getUniqueID(), action);
        }
    }

    public IfFilenameTooLongAction getOnFilenameTooLongAction(FilePackage filePackage) {
        return this.fileFilenameTooLongActions.get((Object)filePackage.getUniqueID());
    }

    public void setOnFileFilenameTooLongAction(FilePackage filePackage, IfFilenameTooLongAction action) {
        if (filePackage == null) {
            this.fileFilenameTooLongActions.clear();
            return;
        }
        if (action == null) {
            this.fileFilenameTooLongActions.remove((Object)filePackage.getUniqueID());
        } else {
            this.fileFilenameTooLongActions.put(filePackage.getUniqueID(), action);
        }
    }

    public FileAccessManager getFileAccessManager() {
        return FILE_ACCESS_MANAGER;
    }

    public Object getStopMark() {
        return this.stopMark.get();
    }

    public int getDownloadsStarted() {
        return this.downloadsStarted.get();
    }

    protected Set<SingleDownloadController> getControllers() {
        return this.controllers;
    }

    protected List<DownloadLink> getActivationRequests() {
        return this.activationRequests;
    }

    public SessionState getSessionState() {
        return (SessionState)((Object)this.sessionState.get());
    }

    public void setForcedOnlyModeEnabled(boolean b) {
        this.activateForcedOnly.set(b);
    }

    public boolean setCandidatesRefreshRequired(boolean b) {
        return this.refreshCandidates.getAndSet(b);
    }

    public void setSpeedLimitBeforePause(int downloadSpeedLimit) {
        this.speedLimitBeforePause.set((Object)downloadSpeedLimit);
    }

    public void setSpeedWasLimitedBeforePauseEnabled(boolean b) {
        this.speedLimitedBeforePause.set((Object)b);
    }

    public boolean compareAndSetSessionState(SessionState expect, SessionState update) {
        return this.sessionState.compareAndSet((Object)expect, (Object)update);
    }

    protected void setSessionState(SessionState state) {
        this.sessionState.set((Object)state);
    }

    protected void setSkipCounter(int i) {
        this.skipCounter.set(i);
    }

    public synchronized void clearPluginCache() {
        this.getActivationPluginCache().clear();
    }

    public static enum SessionState {
        NORMAL,
        RECONNECT_REQUESTED,
        RECONNECT_RUNNING;

    }

    public static enum STOPMARK {
        NONE,
        HIDDEN,
        RANDOM;

    }
}

