/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.LogRecord;
import javax.swing.Icon;
import jd.controlling.AccountController;
import jd.controlling.AccountControllerEvent;
import jd.controlling.AccountControllerListener;
import jd.controlling.TaskQueue;
import jd.controlling.captcha.CaptchaSettings;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.BadDestinationException;
import jd.controlling.downloadcontroller.DeferredRunnableException;
import jd.controlling.downloadcontroller.DiskSpaceManager;
import jd.controlling.downloadcontroller.DiskSpaceReservation;
import jd.controlling.downloadcontroller.DownloadController;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateHistory;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadLinkCandidateSelector;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.controlling.downloadcontroller.DownloadWatchDogJob;
import jd.controlling.downloadcontroller.DownloadWatchDogProperty;
import jd.controlling.downloadcontroller.ExceptionRunnable;
import jd.controlling.downloadcontroller.FileIsLockedException;
import jd.controlling.downloadcontroller.IfFileExistsDialog;
import jd.controlling.downloadcontroller.IfFileExistsDialogInterface;
import jd.controlling.downloadcontroller.NoInternetConnection;
import jd.controlling.downloadcontroller.PathTooLongException;
import jd.controlling.downloadcontroller.PrePluginCheckDummyChallenge;
import jd.controlling.downloadcontroller.ProxyInfoHistory;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.downloadcontroller.SingleDownloadReturnState;
import jd.controlling.downloadcontroller.event.DownloadWatchdogEvent;
import jd.controlling.downloadcontroller.event.DownloadWatchdogEventSender;
import jd.controlling.downloadcontroller.event.DownloadWatchdogListener;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkOrigin;
import jd.controlling.linkcollector.LinkOriginDetails;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractPackageChildrenNodeFilter;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.ProxyEvent;
import jd.controlling.reconnect.Reconnecter;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.ReconnecterListener;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.gui.UserIO;
import jd.gui.swing.jdgui.JDGui;
import jd.gui.swing.jdgui.WarnLevel;
import jd.http.Browser;
import jd.http.NoGateWayException;
import jd.parser.Regex;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.CandidateResultProvider;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkProperty;
import jd.plugins.FilePackage;
import jd.plugins.FilePackageProperty;
import jd.plugins.PluginException;
import jd.plugins.PluginForHost;
import jd.plugins.PluginsC;
import jd.plugins.download.DownloadInterface;
import jd.plugins.download.Downloadable;
import jd.plugins.download.HashInfo;
import jd.plugins.download.HashResult;
import jd.plugins.download.raf.FileBytesCache;
import org.appwork.controlling.State;
import org.appwork.controlling.StateEvent;
import org.appwork.controlling.StateEventListener;
import org.appwork.controlling.StateMachine;
import org.appwork.controlling.StateMachineInterface;
import org.appwork.exceptions.WTFException;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.shutdown.ShutdownController;
import org.appwork.shutdown.ShutdownRequest;
import org.appwork.shutdown.ShutdownVetoException;
import org.appwork.shutdown.ShutdownVetoListener;
import org.appwork.storage.config.JsonConfig;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.uio.CloseReason;
import org.appwork.uio.ExceptionDialogInterface;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.ConcatIterator;
import org.appwork.utils.IO;
import org.appwork.utils.NullsafeAtomicReference;
import org.appwork.utils.StringUtils;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.DefaultEventListener;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.net.httpconnection.ProxyAuthException;
import org.appwork.utils.net.httpconnection.ProxyConnectException;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.speedmeter.SpeedMeterInterface;
import org.appwork.utils.swing.dialog.ExceptionDialog;
import org.jdownloader.captcha.blacklist.CaptchaBlackList;
import org.jdownloader.controlling.DownloadLinkWalker;
import org.jdownloader.controlling.FileCreationEvent;
import org.jdownloader.controlling.FileCreationListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.domainrules.DomainRuleController;
import org.jdownloader.controlling.domainrules.event.DomainRuleControllerListener;
import org.jdownloader.controlling.download.DownloadControllerListener;
import org.jdownloader.controlling.hosterrule.AccountUsageRule;
import org.jdownloader.controlling.hosterrule.HosterRuleController;
import org.jdownloader.controlling.hosterrule.HosterRuleControllerListener;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.ConditionalSkipReasonException;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.IgnorableConditionalSkipReason;
import org.jdownloader.plugins.MirrorLoading;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.SkipReasonException;
import org.jdownloader.plugins.TimeOutCondition;
import org.jdownloader.plugins.ValidatableConditionalSkipReason;
import org.jdownloader.plugins.WaitForAccountSkipReason;
import org.jdownloader.plugins.WaitWhileWaitingSkipReasonIsSet;
import org.jdownloader.plugins.WaitingSkipReason;
import org.jdownloader.plugins.controller.container.ContainerPluginController;
import org.jdownloader.settings.CleanAfterDownloadAction;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.MirrorDetectionDecision;
import org.jdownloader.settings.staticreferences.CFG_CAPTCHA;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;
import org.jdownloader.settings.staticreferences.CFG_RECONNECT;
import org.jdownloader.translate._JDT;
import org.jdownloader.utils.JDFileUtils;

public class DownloadWatchDog
implements DownloadControllerListener,
StateMachineInterface,
ShutdownVetoListener,
FileCreationListener {
    public static final State IDLE_STATE = new State("IDLE");
    public static final State RUNNING_STATE = new State("RUNNING");
    public static final State PAUSE_STATE = new State("PAUSE");
    public static final State STOPPING_STATE = new State("STOPPING");
    public static final State STOPPED_STATE = new State("STOPPED_STATE");
    protected final NullsafeAtomicReference<Thread> currentWatchDogThread = new NullsafeAtomicReference(null);
    protected final NullsafeAtomicReference<Thread> reconnectThread = new NullsafeAtomicReference(null);
    protected final NullsafeAtomicReference<Thread> tempWatchDogJobThread = new NullsafeAtomicReference(null);
    protected NullsafeAtomicReference<DownloadWatchDogJob> currentWatchDogJob = new NullsafeAtomicReference(null);
    private final LinkedList<DownloadWatchDogJob> watchDogJobs = new LinkedList();
    private final StateMachine stateMachine;
    private final DownloadSpeedManager dsm;
    private final GeneralSettings config;
    private static final DownloadWatchDog INSTANCE;
    private final LogSource logger;
    private final Object WATCHDOGLOCK = new Object();
    private final AtomicBoolean autoReconnectEnabled = new AtomicBoolean(false);
    private final DownloadWatchdogEventSender eventSender;
    private final boolean isForceMirrorDetectionCaseInsensitive;
    private Object shutdownLock = new Object();
    protected NullsafeAtomicReference<DownloadSession> session = new NullsafeAtomicReference(null);
    private static final HashSet<String> accessChecks;

    public boolean isForceMirrorDetectionCaseInsensitive() {
        return this.isForceMirrorDetectionCaseInsensitive;
    }

    public DownloadWatchdogEventSender getEventSender() {
        return this.eventSender;
    }

    public static DownloadWatchDog getInstance() {
        return INSTANCE;
    }

    private DownloadWatchDog() {
        this.logger = LogController.CL();
        this.config = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
        this.isForceMirrorDetectionCaseInsensitive = this.config.isForceMirrorDetectionCaseInsensitive();
        this.eventSender = new DownloadWatchdogEventSender();
        DownloadSession initSession = new DownloadSession();
        this.session.set((Object)initSession);
        this.dsm = new DownloadSpeedManager();
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT.getEventSender().addListener((EventListener)new GenericConfigEventListener<Integer>(){

            public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
                DownloadWatchDog.this.dsm.setLimit(DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled() ? DownloadWatchDog.this.config.getDownloadSpeedLimit() : 0);
            }

            public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
            }
        }, false);
        this.dsm.setLimit(this.config.isDownloadSpeedLimitEnabled() ? this.config.getDownloadSpeedLimit() : 0);
        CFG_GENERAL.DOWNLOAD_SPEED_LIMIT_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                DownloadWatchDog.this.dsm.setLimit(DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled() ? DownloadWatchDog.this.config.getDownloadSpeedLimit() : 0);
            }
        }, false);
        CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS.getEventSender().addListener((EventListener)new GenericConfigEventListener<Integer>(){

            public void onConfigValueModified(KeyHandler<Integer> keyHandler, Integer newValue) {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        currentSession.refreshCandidates();
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return false;
                    }
                });
            }

            public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
            }
        }, false);
        CFG_CAPTCHA.CAPTCHA_MODE.getEventSender().addListener((EventListener)new GenericConfigEventListener<Enum>(){

            public void onConfigValueModified(KeyHandler<Enum> keyHandler, final Enum newValue) {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        currentSession.setCaptchaMode((CaptchaSettings.MODE)newValue);
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return true;
                    }
                });
            }

            public void onConfigValidatorError(KeyHandler<Enum> keyHandler, Enum invalidValue, ValidationException validateException) {
            }
        });
        initSession.setCaptchaMode(CFG_CAPTCHA.CFG.getCaptchaMode());
        CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST.getEventSender().addListener((EventListener)new GenericConfigEventListener<Integer>(){

            public void onConfigValueModified(KeyHandler<Integer> keyHandler, final Integer newValue) {
                if (CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.isEnabled()) {
                    DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                        @Override
                        public void execute(DownloadSession currentSession) {
                            if (newValue != null && CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.isEnabled()) {
                                currentSession.setMaxConcurrentDownloadsPerHost(newValue);
                            } else {
                                currentSession.setMaxConcurrentDownloadsPerHost(-1);
                            }
                            currentSession.refreshCandidates();
                        }

                        @Override
                        public void interrupt() {
                        }

                        @Override
                        public boolean isHighPriority() {
                            return false;
                        }
                    });
                }
            }

            public void onConfigValidatorError(KeyHandler<Integer> keyHandler, Integer invalidValue, ValidationException validateException) {
            }
        }, false);
        DomainRuleController.getInstance().getEventSender().addListener(new DomainRuleControllerListener(){

            @Override
            public void onDomainRulesUpdated() {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        currentSession.refreshCandidates();
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return false;
                    }
                });
            }
        });
        CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, final Boolean newValue) {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        if (newValue != null && Boolean.TRUE.equals(newValue)) {
                            currentSession.setMaxConcurrentDownloadsPerHost((Integer)CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST.getValue());
                        } else {
                            currentSession.setMaxConcurrentDownloadsPerHost(-1);
                        }
                        currentSession.refreshCandidates();
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return false;
                    }
                });
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        }, false);
        if (CFG_GENERAL.MAX_DOWNLOADS_PER_HOST_ENABLED.isEnabled()) {
            initSession.setMaxConcurrentDownloadsPerHost((Integer)CFG_GENERAL.MAX_SIMULTANE_DOWNLOADS_PER_HOST.getValue());
        }
        CFG_RECONNECT.AUTO_RECONNECT_ENABLED.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
                DownloadWatchDog.this.autoReconnectEnabled.set(Boolean.TRUE.equals(newValue));
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        }, false);
        this.autoReconnectEnabled.set(CFG_RECONNECT.AUTO_RECONNECT_ENABLED.isEnabled());
        CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.getEventSender().addListener((EventListener)new GenericConfigEventListener<Boolean>(){

            public void onConfigValueModified(KeyHandler<Boolean> keyHandler, final Boolean newValue) {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        boolean useAccounts = Boolean.TRUE.equals(newValue);
                        DownloadWatchDog.this.logger.info("USE_AVAILABLE_ACCOUNTS: " + useAccounts);
                        currentSession.setUseAccountsEnabled(useAccounts);
                        currentSession.removeAccountCache(null);
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return true;
                    }
                });
            }

            public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
            }
        }, false);
        boolean useAccounts = CFG_GENERAL.USE_AVAILABLE_ACCOUNTS.isEnabled();
        this.logger.info("USE_AVAILABLE_ACCOUNTS: " + useAccounts);
        initSession.setUseAccountsEnabled(useAccounts);
        Reconnecter.getInstance().getEventSender().addListener(new ReconnecterListener(){

            @Override
            public void onBeforeReconnect(ReconnecterEvent event) {
            }

            @Override
            public void onAfterReconnect(final ReconnecterEvent event) {
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                    @Override
                    public void execute(DownloadSession currentSession) {
                        if (event.getResult() == Reconnecter.ReconnectResult.SUCCESSFUL) {
                            ProxyInfoHistory proxyInfoHistory = currentSession.getProxyInfoHistory();
                            proxyInfoHistory.validate();
                            List<ProxyInfoHistory.WaitingSkipReasonContainer> reconnects = proxyInfoHistory.list(WaitingSkipReason.CAUSE.IP_BLOCKED, null);
                            if (reconnects != null) {
                                for (ProxyInfoHistory.WaitingSkipReasonContainer reconnect : reconnects) {
                                    if (!reconnect.getProxySelector().isReconnectSupported()) continue;
                                    reconnect.invalidate();
                                }
                            }
                        }
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public boolean isHighPriority() {
                        return true;
                    }
                });
                if (DownloadWatchDog.this.isAutoReconnectEnabled() && Reconnecter.getFailedCounter() > 5) {
                    switch (event.getResult()) {
                        case FAILED: {
                            CFG_RECONNECT.AUTO_RECONNECT_ENABLED.setValue((Object)false);
                            UserIO.getInstance().requestMessageDialog(544, _JDT.T.jd_controlling_reconnect_Reconnector_progress_failed2());
                        }
                    }
                }
            }
        }, false);
        this.stateMachine = new StateMachine((StateMachineInterface)this, IDLE_STATE, STOPPED_STATE);
        this.startDownloadJobExecuter();
        this.stateMachine.addListener(new StateEventListener(){

            public void onStateUpdate(StateEvent event) {
            }

            public void onStateChange(StateEvent event) {
                if (event.getNewState() == RUNNING_STATE) {
                    DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.STATE_RUNNING, new Object[0]));
                } else if (event.getNewState() == STOPPED_STATE) {
                    DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.STATE_STOPPED, new Object[0]));
                } else if (event.getNewState() == IDLE_STATE) {
                    DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.STATE_IDLE, new Object[0]));
                } else if (event.getNewState() == PAUSE_STATE) {
                    DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.STATE_PAUSE, new Object[0]));
                } else if (event.getNewState() == STOPPING_STATE) {
                    DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.STATE_STOPPING, new Object[0]));
                }
            }
        });
        DownloadController.getInstance().addListener(this);
        ShutdownController.getInstance().addShutdownVetoListener((ShutdownVetoListener)this);
        FileCreationManager.getInstance().getEventSender().addListener(this);
    }

    public final boolean isWatchDogThread() {
        Thread current = Thread.currentThread();
        return current == this.getWatchDogThread();
    }

    private final Thread getWatchDogThread() {
        Thread current = (Thread)this.tempWatchDogJobThread.get();
        if (current != null) {
            return current;
        }
        return (Thread)this.currentWatchDogThread.get();
    }

    private void clearDownloadListStatus() {
        DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                DownloadController.getInstance().set(new DownloadLinkWalker(){

                    @Override
                    public void handle(DownloadLink link) {
                        link.setConditionalSkipReason(null);
                    }

                    @Override
                    public boolean accept(FilePackage fp) {
                        return true;
                    }

                    @Override
                    public boolean accept(DownloadLink link) {
                        return true;
                    }
                });
                return null;
            }
        });
    }

    public void forceDownload(final List<DownloadLink> linksForce) {
        if (linksForce == null || linksForce.size() == 0) {
            return;
        }
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.stateMachine.isState(new State[]{STOPPING_STATE})) {
                    // empty if block
                }
                DownloadWatchDog.this.unSkip(linksForce);
                if (DownloadWatchDog.this.stateMachine.isStartState() || DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.startDownloads(new Runnable(){

                        @Override
                        public void run() {
                            DownloadWatchDog.this.getSession().setForcedOnlyModeEnabled(true);
                            DownloadWatchDog.this.enqueueForcedDownloads(linksForce);
                        }
                    });
                } else {
                    DownloadWatchDog.this.enqueueForcedDownloads(linksForce);
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    private void enqueueForcedDownloads(final List<DownloadLink> linksForce) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                LinkedHashSet<DownloadLink> oldList = new LinkedHashSet<DownloadLink>(currentSession.getForcedLinks());
                oldList.addAll(linksForce);
                currentSession.setForcedLinks(new CopyOnWriteArrayList<DownloadLink>(DownloadWatchDog.this.sortActivationRequests(oldList)));
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    private List<DownloadLink> sortActivationRequests(Iterable<DownloadLink> links) {
        HashMap<Priority, ArrayList<DownloadLink>> optimizedList = new HashMap<Priority, ArrayList<DownloadLink>>();
        int count = 0;
        for (DownloadLink link : links) {
            ArrayList<DownloadLink> list;
            ++count;
            Priority prio = link.getPriorityEnum();
            if (Priority.DEFAULT.equals((Object)prio)) {
                prio = link.getFilePackage().getPriorityEnum();
            }
            if ((list = (ArrayList<DownloadLink>)optimizedList.get((Object)prio)) == null) {
                list = new ArrayList<DownloadLink>();
                optimizedList.put(prio, list);
            }
            list.add(link);
        }
        ArrayList<DownloadLink> newList = new ArrayList<DownloadLink>(count);
        for (Priority prio : Priority.values()) {
            List ret = (List)optimizedList.remove((Object)prio);
            if (ret == null) continue;
            newList.addAll(ret);
        }
        return newList;
    }

    public int getActiveDownloads() {
        return this.getSession().getControllers().size();
    }

    public DownloadSpeedManager getDownloadSpeedManager() {
        return this.dsm;
    }

    public void validateDestination(File file) throws BadDestinationException {
        if (file.exists()) {
            return;
        }
        File checking = null;
        try {
            switch (CrossSystem.getOSFamily()) {
                case LINUX: {
                    String[] folders = CrossSystem.getPathComponents((File)file);
                    if (folders.length < 3) break;
                    String userName = System.getProperty("user.name");
                    if (folders.length >= 4 && "run".equals(folders[1]) && "media".equals(folders[2]) && folders[3].equals(userName)) {
                        checking = new File("/run/media/" + userName + "/" + folders[4]);
                        break;
                    }
                    if ("media".equals(folders[1])) {
                        checking = new File("/media/" + folders[2]);
                        break;
                    }
                    if (!"mnt".equals(folders[1])) break;
                    checking = new File("/mnt/" + folders[2]);
                    break;
                }
                case MAC: {
                    String[] folders = CrossSystem.getPathComponents((File)file);
                    if (folders.length < 3) break;
                    if ("media".equals(folders[1])) {
                        checking = new File("/media/" + folders[2]);
                        break;
                    }
                    if ("mnt".equals(folders[1])) {
                        checking = new File("/mnt/" + folders[2]);
                        break;
                    }
                    if (!"Volumes".equals(folders[1])) break;
                    checking = new File("/Volumes/" + folders[2]);
                    break;
                }
                default: {
                    if (CrossSystem.getOS().isMaximum(CrossSystem.OperatingSystem.WINDOWS_NT) && file.getAbsolutePath().length() > 259) {
                        checking = file;
                        throw new PathTooLongException(file);
                    }
                    String[] folders = CrossSystem.getPathComponents((File)file);
                    if (folders.length <= 0) break;
                    String root = folders[0];
                    if (root.matches("^[a-zA-Z]{1}:\\\\$") || root.matches("^[a-zA-Z]{1}://$")) {
                        checking = new File(folders[0]);
                        break;
                    }
                    if (!root.equals("\\\\") || folders.length < 3) break;
                    checking = new File(folders[0] + folders[1] + "\\" + folders[2]);
                }
            }
            if (checking != null && checking.exists() && checking.isDirectory()) {
                checking = null;
            }
        }
        catch (BadDestinationException e) {
            throw e;
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        if (checking != null) {
            this.logger.info("DownloadFolderRoot: " + checking + " for " + file + " is invalid! Missing or not a directory!");
            throw new BadDestinationException(checking);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DownloadLinkCandidate next(DownloadLinkCandidateSelector selector) {
        List<DownloadLinkCandidate> nextCandidates;
        DownloadSession currentSession = selector.getSession();
        HashMap<String, Boolean> destinationValidationCache = new HashMap<String, Boolean>();
        while (this.newDLStartAllowed(currentSession) && (nextCandidates = this.nextDownloadLinkCandidates(selector)) != null && nextCandidates.size() > 0) {
            DownloadLinkCandidate nextCandidate = this.findFinalCandidate(selector, nextCandidates);
            if (nextCandidate == null) continue;
            String destination = nextCandidate.getLink().getFilePackage().getDownloadDirectory();
            boolean validationOk = false;
            try {
                Boolean cachedValidationResult = (Boolean)destinationValidationCache.get(destination);
                if (cachedValidationResult == null) {
                    this.validateDestination(new File(destination));
                    validationOk = true;
                } else if (cachedValidationResult.booleanValue()) {
                    validationOk = true;
                } else {
                    for (DownloadLinkCandidate candidate : nextCandidates) {
                        selector.addExcluded(candidate, new DownloadLinkCandidateResult(SkipReason.INVALID_DESTINATION, null, null));
                    }
                }
            }
            catch (PathTooLongException e) {
                for (DownloadLinkCandidate candidate : nextCandidates) {
                    selector.addExcluded(candidate, new DownloadLinkCandidateResult(SkipReason.INVALID_DESTINATION, null, null));
                }
            }
            catch (BadDestinationException e) {
                for (DownloadLinkCandidate candidate : nextCandidates) {
                    selector.addExcluded(candidate, new DownloadLinkCandidateResult(SkipReason.INVALID_DESTINATION, null, null));
                }
            }
            finally {
                destinationValidationCache.put(destination, validationOk);
            }
            if (!validationOk) continue;
            if (DiskSpaceManager.DISKSPACERESERVATIONRESULT.FAILED.equals((Object)this.validateDiskFree(nextCandidates))) {
                for (DownloadLinkCandidate downloadLinkCandidate : nextCandidates) {
                    selector.addExcluded(downloadLinkCandidate, new DownloadLinkCandidateResult(SkipReason.DISK_FULL, null, null));
                }
                continue;
            }
            try {
                if (PluginForHost.implementsSortDownloadLink(nextCandidate.getCachedAccount().getPlugin())) {
                    ArrayList<DownloadLink> mirrors = new ArrayList<DownloadLink>();
                    mirrors.add(0, nextCandidate.getLink());
                    for (DownloadLink mirror : this.findDownloadLinkMirrors(nextCandidate.getLink(), MirrorDetectionDecision.SAFE, false)) {
                        if (!nextCandidate.getCachedAccount().canHandle(mirror) || mirror.getFinalLinkState() != null && FinalLinkState.OFFLINE.equals((Object)mirror.getFinalLinkState())) continue;
                        DownloadLinkCandidate candidate = new DownloadLinkCandidate(nextCandidate.getLink(), nextCandidate.isForced(), nextCandidate.getCachedAccount(), nextCandidate.getProxySelector(), nextCandidate.isCustomizedAccount());
                        DownloadLinkCandidateSelector.DownloadLinkCandidatePermission permission = selector.getDownloadLinkCandidatePermission(candidate);
                        switch (permission) {
                            case OK: 
                            case OK_FORCED: 
                            case OK_SPEED_EXTENSION: {
                                if (!selector.validateDownloadLinkCandidate(candidate)) break;
                                mirrors.add(mirror);
                                break;
                            }
                        }
                    }
                    List<DownloadLink> list = nextCandidate.getCachedAccount().getPlugin().sortDownloadLinks(nextCandidate.getCachedAccount().getAccount(), mirrors);
                    if (list != null && list.size() > 0 && list.get(0) != nextCandidate.getLink()) {
                        nextCandidate = new DownloadLinkCandidate(list.get(0), nextCandidate.isForced(), nextCandidate.getCachedAccount(), nextCandidate.getProxySelector(), nextCandidate.isCustomizedAccount());
                    }
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
            selector.setExcluded(nextCandidate.getLink());
            MirrorLoading condition = new MirrorLoading(nextCandidate.getLink());
            for (DownloadLink mirror : this.findDownloadLinkMirrors(nextCandidate.getLink(), this.config.getMirrorDetectionDecision(), true)) {
                selector.setExcluded(mirror);
                if (mirror.getFinalLinkState() != null && !FinalLinkState.CheckFailed(mirror.getFinalLinkState())) continue;
                mirror.setConditionalSkipReason(condition);
            }
            return nextCandidate;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadLinkCandidate findFinalCandidate(DownloadLinkCandidateSelector selector, List<DownloadLinkCandidate> candidates) {
        Object downloadLink;
        LinkedHashMap<DownloadLink, DownloadLinkCandidate> bestCandidates;
        LinkedHashMap map;
        if (candidates == null) return null;
        if (candidates.size() == 0) {
            return null;
        }
        LinkedHashMap<DownloadLink, LinkedHashMap> preferredFiltered = new LinkedHashMap<DownloadLink, LinkedHashMap>();
        for (DownloadLinkCandidate nextCandidate : candidates) {
            String host;
            ArrayList<DownloadLinkCandidate> list;
            DownloadLink candidateLink = nextCandidate.getLink();
            map = (LinkedHashMap)preferredFiltered.get(candidateLink);
            if (map == null) {
                map = new LinkedHashMap();
                preferredFiltered.put(candidateLink, map);
            }
            if ((list = (ArrayList<DownloadLinkCandidate>)map.get(host = nextCandidate.getCachedAccount().getPlugin().getHost())) == null) {
                list = new ArrayList<DownloadLinkCandidate>();
                map.put(host, list);
            }
            if (!list.isEmpty() && ((DownloadLinkCandidate)list.get(0)).isCustomizedAccount()) continue;
            list.add(nextCandidate);
        }
        candidates = new ArrayList<DownloadLinkCandidate>();
        Iterator it = preferredFiltered.entrySet().iterator();
        block21: while (true) {
            if (!it.hasNext()) {
                bestCandidates = new LinkedHashMap<DownloadLink, DownloadLinkCandidate>();
                downloadLink = candidates.iterator();
                break;
            }
            Map.Entry next = it.next();
            downloadLink = (DownloadLink)next.getKey();
            map = (LinkedHashMap)next.getValue();
            Iterator it2 = map.entrySet().iterator();
            while (true) {
                if (!it2.hasNext()) continue block21;
                Map.Entry next2 = it2.next();
                ArrayList list = (ArrayList)next2.getValue();
                if (list.size() > 1) {
                    ArrayList<DownloadLinkCandidate> newList = new ArrayList<DownloadLinkCandidate>();
                    try {
                        ArrayList<Account> accList = new ArrayList<Account>();
                        LinkedHashMap<Account, DownloadLinkCandidate> accMap = new LinkedHashMap<Account, DownloadLinkCandidate>();
                        for (DownloadLinkCandidate candidate : list) {
                            accMap.put(candidate.getCachedAccount().getAccount(), candidate);
                            accList.add(candidate.getCachedAccount().getAccount());
                        }
                        for (Account account : ((DownloadLinkCandidate)list.get(0)).getCachedAccount().getPlugin().sortAccounts((DownloadLink)downloadLink, accList)) {
                            DownloadLinkCandidate candidate = (DownloadLinkCandidate)accMap.remove(account);
                            if (candidate == null) continue;
                            newList.add(candidate);
                        }
                    }
                    catch (Throwable e) {
                        this.logger.log(e);
                    }
                    if (newList.size() == list.size()) {
                        candidates.addAll(newList);
                        continue;
                    }
                }
                candidates.addAll(list);
            }
            break;
        }
        block25: while (downloadLink.hasNext()) {
            DownloadLinkCandidate nextCandidate = (DownloadLinkCandidate)downloadLink.next();
            DownloadLink candidateLink = nextCandidate.getLink();
            DownloadLinkCandidate bestCandidate = (DownloadLinkCandidate)bestCandidates.get(candidateLink);
            if (bestCandidate == null) {
                bestCandidates.put(candidateLink, nextCandidate);
                continue;
            }
            if (bestCandidate.isCustomizedAccount()) continue;
            boolean bestHasCaptcha = bestCandidate.getCachedAccount().hasCaptcha(candidateLink);
            boolean nextHasCaptcha = nextCandidate.getCachedAccount().hasCaptcha(candidateLink);
            switch (bestCandidate.getCachedAccount().getType()) {
                case MULTI: {
                    switch (nextCandidate.getCachedAccount().getType()) {
                        case ORIGINAL: {
                            if (nextHasCaptcha) continue block25;
                            bestCandidates.put(candidateLink, nextCandidate);
                            break;
                        }
                        case MULTI: {
                            if (!bestHasCaptcha || nextHasCaptcha) continue block25;
                            bestCandidates.put(candidateLink, nextCandidate);
                            break;
                        }
                    }
                    break;
                }
                case ORIGINAL: {
                    switch (nextCandidate.getCachedAccount().getType()) {
                        case ORIGINAL: 
                        case MULTI: {
                            if (!bestHasCaptcha || nextHasCaptcha) continue block25;
                            bestCandidates.put(candidateLink, nextCandidate);
                            break;
                        }
                    }
                    break;
                }
                case NONE: {
                    switch (nextCandidate.getCachedAccount().getType()) {
                        case NONE: {
                            if (!bestHasCaptcha || nextHasCaptcha) break;
                            bestCandidates.put(candidateLink, nextCandidate);
                            break;
                        }
                        case ORIGINAL: 
                        case MULTI: {
                            if (!nextHasCaptcha) {
                                bestCandidates.put(candidateLink, nextCandidate);
                                break;
                            }
                            bestCandidates.put(candidateLink, nextCandidate);
                        }
                    }
                    continue block25;
                }
            }
        }
        ArrayList finalCandidates = new ArrayList(bestCandidates.values());
        try {
            Collections.sort(finalCandidates, new Comparator<DownloadLinkCandidate>(){

                public int compareDown(boolean x, boolean y) {
                    return x == y ? 0 : (x ? 1 : -1);
                }

                @Override
                public int compare(DownloadLinkCandidate x, DownloadLinkCandidate y) {
                    int ret = x.getCachedAccount().getType().compareTo(y.getCachedAccount().getType());
                    if (ret != 0) {
                        return ret;
                    }
                    boolean xCaptcha = x.getCachedAccount().hasCaptcha(x.getLink());
                    boolean yCaptcha = y.getCachedAccount().hasCaptcha(y.getLink());
                    return this.compareDown(xCaptcha, yCaptcha);
                }
            });
            return (DownloadLinkCandidate)finalCandidates.get(0);
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        return (DownloadLinkCandidate)finalCandidates.get(0);
    }

    private boolean isMirrorCandidate(DownloadLink linkCandidate, String cachedLinkCandidateName, DownloadLink mirrorCandidate, MirrorDetectionDecision mirrorDetectionDecision) {
        if (MirrorDetectionDecision.DISABLED.equals((Object)mirrorDetectionDecision)) {
            return false;
        }
        String cachedLinkMirrorID = linkCandidate.getDefaultPlugin().getMirrorID(linkCandidate);
        String mirrorCandidateMirrorID = mirrorCandidate.getDefaultPlugin().getMirrorID(mirrorCandidate);
        if (cachedLinkMirrorID != null && mirrorCandidateMirrorID != null) {
            return StringUtils.equals((String)cachedLinkMirrorID, (String)mirrorCandidateMirrorID);
        }
        if (cachedLinkCandidateName == null) {
            cachedLinkCandidateName = linkCandidate.getView().getDisplayName();
        }
        String mirrorCandidateName = mirrorCandidate.getView().getDisplayName();
        boolean sameName = CrossSystem.isWindows() || this.isForceMirrorDetectionCaseInsensitive() ? cachedLinkCandidateName.equalsIgnoreCase(mirrorCandidateName) : cachedLinkCandidateName.equals(mirrorCandidateName);
        switch (mirrorDetectionDecision) {
            case DISABLED: {
                return false;
            }
            case SAFE: {
                Boolean sameSizeResult = this.hasSameSize(linkCandidate, mirrorCandidate, mirrorDetectionDecision);
                if (sameSizeResult != null && Boolean.FALSE.equals(sameSizeResult)) {
                    return false;
                }
                Boolean sameHashResult = this.hasSameHash(linkCandidate, mirrorCandidate);
                if (sameHashResult != null && Boolean.FALSE.equals(sameHashResult)) {
                    return sameHashResult;
                }
                return sameName;
            }
            case AUTO: {
                Boolean sameSizeResult = this.hasSameSize(linkCandidate, mirrorCandidate, mirrorDetectionDecision);
                if (sameSizeResult != null && Boolean.FALSE.equals(sameSizeResult)) {
                    return false;
                }
                Boolean sameHashResult = this.hasSameHash(linkCandidate, mirrorCandidate);
                if (sameHashResult != null) {
                    return sameHashResult;
                }
                return sameName;
            }
            case FILENAME: {
                return sameName;
            }
            case FILENAME_FILESIZE: {
                Boolean sameSizeResult = this.hasSameSize(linkCandidate, mirrorCandidate, mirrorDetectionDecision);
                return sameName && sameSizeResult != null && Boolean.TRUE.equals(sameSizeResult);
            }
        }
        return false;
    }

    private Boolean hasSameSize(DownloadLink linkCandidate, DownloadLink mirrorCandidate, MirrorDetectionDecision mirrorDetectionDecision) {
        if (MirrorDetectionDecision.DISABLED.equals((Object)mirrorDetectionDecision)) {
            return false;
        }
        int fileSizeEquality = this.config.getMirrorDetectionFileSizeEquality();
        long verifiedFileSizeA = linkCandidate.getView().getBytesTotalVerified();
        long verifiedFileSizeB = mirrorCandidate.getView().getBytesTotalVerified();
        if (fileSizeEquality == 10000 || MirrorDetectionDecision.SAFE.equals((Object)mirrorDetectionDecision)) {
            if (verifiedFileSizeA >= 0L && verifiedFileSizeB >= 0L) {
                return verifiedFileSizeA == verifiedFileSizeB;
            }
        } else {
            long sizeA = linkCandidate.getView().getBytesTotal();
            long sizeB = mirrorCandidate.getView().getBytesTotal();
            if (sizeA >= 0L && sizeB >= 0L) {
                int maxDiffPercent;
                long maxDiff;
                long diff = Math.abs(sizeA - sizeB);
                return diff <= (maxDiff = sizeA * (long)(maxDiffPercent = 10000 - Math.max(1, Math.min(9999, fileSizeEquality))) / 10000L);
            }
        }
        if (this.config.isForceMirrorDetectionFileSizeCheck() || MirrorDetectionDecision.SAFE.equals((Object)mirrorDetectionDecision)) {
            return false;
        }
        return null;
    }

    private Boolean hasSameHash(DownloadLink linkCandidate, DownloadLink mirrorCandidate) {
        HashInfo hashInfoB;
        HashInfo hashInfoA = linkCandidate.getHashInfo();
        HashInfo hashInfo = hashInfoB = hashInfoA != null ? mirrorCandidate.getHashInfo() : null;
        if (hashInfoA != null && hashInfoB != null && hashInfoA.getType() == hashInfoB.getType()) {
            return hashInfoA.equals(hashInfoB);
        }
        return null;
    }

    private List<DownloadLink> findDownloadLinkMirrors(final DownloadLink link, final MirrorDetectionDecision mirrorDetectionDecision, final boolean includeDisabledLinks) {
        final ArrayList<DownloadLink> ret = new ArrayList<DownloadLink>();
        if (MirrorDetectionDecision.DISABLED.equals((Object)mirrorDetectionDecision)) {
            return ret;
        }
        final FilePackage fp = link.getFilePackage();
        final String name = link.getView().getDisplayName();
        fp.getModifyLock().runReadLock(new Runnable(){

            @Override
            public void run() {
                for (DownloadLink mirror : fp.getChildren()) {
                    if (mirror == link || !includeDisabledLinks && !mirror.isEnabled() || !DownloadWatchDog.this.isMirrorCandidate(link, name, mirror, mirrorDetectionDecision)) continue;
                    ret.add(mirror);
                }
            }
        });
        return ret;
    }

    private void printDownloadLinkCandidateHistory(DownloadLinkCandidate candidate) {
        try {
            List<DownloadLinkCandidateResult> results;
            DownloadSession currentSession;
            DownloadLinkCandidateHistory history;
            if (candidate != null && candidate.getLink() != null && candidate.getCachedAccount() != null && (history = (currentSession = this.getSession()).getHistory(candidate.getLink())) != null && (results = history.getResults(candidate)) != null) {
                block6: for (DownloadLinkCandidateResult result : results) {
                    switch (result.getResult()) {
                        case CONDITIONAL_SKIPPED: {
                            this.logger.info(candidate + "->" + (Object)((Object)result.getResult()) + "|" + result.getConditionalSkip());
                            continue block6;
                        }
                        case SKIPPED: {
                            this.logger.info(candidate + "->" + (Object)((Object)result.getResult()) + "|" + (Object)((Object)result.getSkipReason()));
                            continue block6;
                        }
                    }
                    this.logger.info(candidate + "->" + (Object)((Object)result.getResult()));
                }
            }
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
    }

    private void setFinalLinkStatus(DownloadLinkCandidate candidate, DownloadLinkCandidateResult value, SingleDownloadController singleDownloadController) {
        DownloadLink link = candidate.getLink();
        DownloadSession currentSession = this.getSession();
        boolean onDetach = singleDownloadController != null;
        HashResult hashResult = null;
        if (onDetach) {
            hashResult = singleDownloadController.getHashResult();
        }
        switch (value.getResult()) {
            case CONDITIONAL_SKIPPED: {
                this.logger.info(candidate + "->" + (Object)((Object)value.getResult()) + "|" + value.getConditionalSkip());
                break;
            }
            case SKIPPED: {
                this.logger.info(candidate + "->" + (Object)((Object)value.getResult()) + "|" + (Object)((Object)value.getSkipReason()));
                break;
            }
            default: {
                this.logger.info(candidate + "->" + (Object)((Object)value.getResult()));
            }
        }
        ProxyInfoHistory proxyHistory = currentSession.getProxyInfoHistory();
        switch (value.getResult()) {
            case PROXY_UNAVAILABLE: {
                if (onDetach) break;
                ConditionalSkipReason conditionalSkipReason = proxyHistory.getConditionalSkipReason(candidate);
                if (conditionalSkipReason != null) {
                    link.setConditionalSkipReason(conditionalSkipReason);
                }
                return;
            }
            case CONDITIONAL_SKIPPED: {
                ConditionalSkipReason conditionalSkipReason = value.getConditionalSkip();
                if (conditionalSkipReason != null) {
                    link.setConditionalSkipReason(conditionalSkipReason);
                }
                return;
            }
            case IP_BLOCKED: {
                if (!onDetach) break;
                long remainingTime = value.getRemainingTime();
                if (remainingTime > 0L) {
                    proxyHistory.putIntoHistory(candidate, new WaitingSkipReason(WaitingSkipReason.CAUSE.IP_BLOCKED, remainingTime, value.getMessage()));
                }
                return;
            }
            case HOSTER_UNAVAILABLE: {
                if (!onDetach) break;
                long remainingTime = value.getRemainingTime();
                if (remainingTime > 0L) {
                    proxyHistory.putIntoHistory(candidate, new WaitingSkipReason(WaitingSkipReason.CAUSE.HOST_TEMP_UNAVAILABLE, remainingTime, value.getMessage()));
                }
                return;
            }
            case FILE_UNAVAILABLE: {
                long remaining;
                if (!onDetach && (remaining = value.getRemainingTime()) > 0L) {
                    link.setConditionalSkipReason(new WaitingSkipReason(WaitingSkipReason.CAUSE.FILE_TEMP_UNAVAILABLE, remaining, value.getMessage()));
                }
                return;
            }
            case CONNECTION_ISSUES: {
                long remaining;
                if (!onDetach && (remaining = value.getRemainingTime()) > 0L) {
                    link.setConditionalSkipReason(new WaitingSkipReason(WaitingSkipReason.CAUSE.CONNECTION_TEMP_UNAVAILABLE, remaining, value.getMessage()));
                }
                return;
            }
            case SKIPPED: {
                if (SkipReason.NO_ACCOUNT.equals((Object)value.getSkipReason())) {
                    this.printDownloadLinkCandidateHistory(candidate);
                }
                currentSession.removeHistory(link);
                candidate.getLink().setSkipReason(value.getSkipReason());
                return;
            }
            case PLUGIN_DEFECT: {
                if (!onDetach) {
                    currentSession.removeHistory(link);
                    candidate.getLink().setFinalLinkState(FinalLinkState.PLUGIN_DEFECT);
                }
                return;
            }
            case OFFLINE_TRUSTED: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                candidate.getLink().setFinalLinkState(FinalLinkState.OFFLINE);
                return;
            }
            case FINISHED_EXISTS: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                candidate.getLink().setFinishedDate(value.getFinishTime());
                candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED_MIRROR);
                return;
            }
            case FINISHED: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                candidate.getLink().setFinishedDate(value.getFinishTime());
                if (hashResult != null && hashResult.match()) {
                    switch (hashResult.getHashInfo().getType()) {
                        case CRC32: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED_CRC32);
                            break;
                        }
                        case MD5: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED_MD5);
                            break;
                        }
                        case SHA1: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED_SHA1);
                            break;
                        }
                        case SHA256: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED_SHA256);
                            break;
                        }
                        default: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED);
                            break;
                        }
                    }
                } else {
                    candidate.getLink().setFinalLinkState(FinalLinkState.FINISHED);
                }
                return;
            }
            case FAILED_EXISTS: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_EXISTS);
                return;
            }
            case FAILED: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                if (hashResult != null && !hashResult.match()) {
                    switch (hashResult.getHashInfo().getType()) {
                        case CRC32: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_CRC32);
                            break;
                        }
                        case MD5: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_MD5);
                            break;
                        }
                        case SHA1: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_SHA1);
                            break;
                        }
                        case SHA256: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_SHA256);
                            break;
                        }
                        default: {
                            candidate.getLink().setFinalLinkState(FinalLinkState.FAILED);
                            break;
                        }
                    }
                } else {
                    candidate.getLink().setFinalLinkState(FinalLinkState.FAILED);
                }
                return;
            }
            case STOPPED: {
                if (!onDetach) break;
                currentSession.removeHistory(link);
                return;
            }
            case ACCOUNT_ERROR: 
            case ACCOUNT_INVALID: 
            case ACCOUNT_UNAVAILABLE: {
                if (!onDetach) break;
                Account account = candidate.getCachedAccount().getAccount();
                candidate.getCachedAccount().getPlugin().handleAccountException(account, null, value.getThrowable());
                return;
            }
            case ACCOUNT_REQUIRED: {
                if (!onDetach) {
                    this.printDownloadLinkCandidateHistory(candidate);
                    currentSession.removeHistory(link);
                    candidate.getLink().setSkipReason(SkipReason.NO_ACCOUNT);
                }
                return;
            }
            case CAPTCHA: {
                if (!onDetach) {
                    currentSession.removeHistory(link);
                    candidate.getLink().setSkipReason(SkipReason.CAPTCHA);
                }
                return;
            }
            case FATAL_ERROR: {
                if (!onDetach) {
                    currentSession.removeHistory(link);
                    candidate.getLink().setProperty("CUSTOM_MESSAGE", value.getMessage());
                    candidate.getLink().setFinalLinkState(FinalLinkState.FAILED_FATAL);
                }
                return;
            }
            default: {
                if (!onDetach) break;
                this.logger.info("TODO: " + (Object)((Object)value.getResult()));
                return;
            }
        }
        throw new WTFException("This should never happen!? " + (Object)((Object)value.getResult()));
    }

    protected DiskSpaceManager.DISKSPACERESERVATIONRESULT validateDiskFree(List<DownloadLinkCandidate> downloadLinkCandidates) {
        File partFile;
        DownloadLink downloadLink = null;
        for (DownloadLinkCandidate downloadLinkCandidate : downloadLinkCandidates) {
            if (downloadLinkCandidate.getLink().getVerifiedFileSize() < 0L) continue;
            downloadLink = downloadLinkCandidate.getLink();
            break;
        }
        if (downloadLink == null) {
            downloadLink = downloadLinkCandidates.get(0).getLink();
        }
        long doneSize = Math.max((partFile = new File(downloadLink.getFileOutput() + ".part")).exists() ? partFile.length() : 0L, downloadLink.getView().getBytesLoaded());
        final long remainingSize = downloadLink.getView().getBytesTotal() - Math.max(0L, doneSize);
        final DownloadLink finalDownloadLink = downloadLink;
        return this.getSession().getDiskSpaceManager().check(new DiskSpaceReservation(){

            @Override
            public File getDestination() {
                return partFile;
            }

            @Override
            public long getSize() {
                PluginForHost plugin = finalDownloadLink.getDefaultPlugin();
                if (plugin != null) {
                    return remainingSize + Math.max(0L, plugin.calculateAdditionalRequiredDiskSpace(finalDownloadLink));
                }
                return remainingSize;
            }

            @Override
            public Object getOwner() {
                return DownloadWatchDog.this;
            }

            @Override
            public LogInterface getLogger() {
                return DownloadWatchDog.this.logger;
            }
        });
    }

    protected DiskSpaceManager.DISKSPACERESERVATIONRESULT validateDiskFree(DiskSpaceReservation reservation) {
        return this.getSession().getDiskSpaceManager().check(reservation);
    }

    private List<DownloadLinkCandidate> nextDownloadLinkCandidates(DownloadLinkCandidateSelector selector) {
        DownloadLinkCandidate nextSelectedCandidate;
        DownloadSession currentSession = selector.getSession();
        boolean skipAllCaptchas = CaptchaSettings.MODE.SKIP_ALL.equals((Object)selector.getSession().getCaptchaMode());
        while (!selector.isStopMarkReached() && this.newDLStartAllowed(currentSession) && (nextSelectedCandidate = this.nextDownloadLinkCandidate(selector)) != null) {
            ArrayList<DownloadLinkCandidate> nextSelectedCandidates = new ArrayList<DownloadLinkCandidate>();
            nextSelectedCandidates.add(nextSelectedCandidate);
            if (!nextSelectedCandidate.isForced() && selector.isMirrorManagement()) {
                nextSelectedCandidates.addAll(this.findDownloadLinkCandidateMirrors(selector, nextSelectedCandidate));
            }
            ArrayList<DownloadLinkCandidate> checkNextCandidatesStage1 = new ArrayList<DownloadLinkCandidate>();
            for (DownloadLinkCandidate candidate : nextSelectedCandidates) {
                Iterator link = candidate.getLink();
                selector.addExcluded((DownloadLink)((Object)link));
                AccountCache accountCache = currentSession.getAccountCache((DownloadLink)((Object)link));
                int ok = 0;
                AccountCache.CachedAccount waitForAccount = null;
                ConditionalSkipReason conditionalSkipReason = null;
                for (AccountCache.CachedAccount cachedAccount : accountCache) {
                    DownloadLinkCandidateSelector.CachedAccountPermission permission = selector.getCachedAccountPermission(cachedAccount);
                    try {
                        if (DownloadLinkCandidateSelector.CachedAccountPermission.OK.equals((Object)permission)) {
                            if (!cachedAccount.canHandle((DownloadLink)((Object)link))) continue;
                            DownloadLinkCandidate checkNextCandidate = new DownloadLinkCandidate(candidate, cachedAccount, accountCache.isCustomizedCache());
                            ok = 1;
                            if (cachedAccount.hasCaptcha((DownloadLink)((Object)link)) && (skipAllCaptchas || CaptchaBlackList.getInstance().matches(new PrePluginCheckDummyChallenge((DownloadLink)((Object)link))) != null)) {
                                if (!selector.validateDownloadLinkCandidate(checkNextCandidate)) continue;
                                selector.addExcluded(candidate, new DownloadLinkCandidateResult(SkipReason.CAPTCHA, null, null));
                                continue;
                            }
                            checkNextCandidatesStage1.add(checkNextCandidate);
                            continue;
                        }
                        if (!DownloadLinkCandidateSelector.CachedAccountPermission.TEMP_DISABLED.equals((Object)permission) || !cachedAccount.canHandle((DownloadLink)((Object)link)) || waitForAccount != null && waitForAccount.getAccount().getTmpDisabledTimeout() <= cachedAccount.getAccount().getTmpDisabledTimeout()) continue;
                        waitForAccount = cachedAccount;
                    }
                    catch (ConditionalSkipReasonException e) {
                        ConditionalSkipReason skipReason = e.getConditionalSkipReason();
                        if (skipReason != null) {
                            if (conditionalSkipReason == null) {
                                conditionalSkipReason = skipReason;
                                continue;
                            }
                            if (!(skipReason instanceof TimeOutCondition) || !(conditionalSkipReason instanceof TimeOutCondition) || ((TimeOutCondition)((Object)conditionalSkipReason)).getTimeOutLeft() >= ((TimeOutCondition)((Object)skipReason)).getTimeOutLeft()) continue;
                            conditionalSkipReason = skipReason;
                            continue;
                        }
                        this.logger.log((Throwable)e);
                    }
                    catch (Exception e) {
                        this.logger.log((Throwable)e);
                    }
                }
                if (ok != 0) continue;
                if (conditionalSkipReason != null) {
                    selector.addExcluded(candidate, new DownloadLinkCandidateResult(conditionalSkipReason, null, null));
                    continue;
                }
                if (waitForAccount != null) {
                    selector.addExcluded(candidate, new DownloadLinkCandidateResult(new WaitForAccountSkipReason(waitForAccount.getAccount()), null, null));
                    continue;
                }
                selector.addExcluded(candidate, new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_REQUIRED, null, null));
            }
            if (checkNextCandidatesStage1.size() <= 0) continue;
            ArrayList<DownloadLinkCandidate> checkNextCandidatesStage2 = new ArrayList<DownloadLinkCandidate>();
            boolean[][] flags = new boolean[][]{{false, false}, {true, false}, {true, true}};
            for (Object flag : (Iterator)flags) {
                Iterator it = checkNextCandidatesStage1.iterator();
                while (it.hasNext()) {
                    DownloadLinkCandidate candidate = (DownloadLinkCandidate)it.next();
                    List<AbstractProxySelectorImpl> proxySelectors = selector.getProxies(candidate, (boolean)flag[0], (boolean)flag[1]);
                    if (proxySelectors.size() <= 0) continue;
                    it.remove();
                    for (AbstractProxySelectorImpl proxySelector : proxySelectors) {
                        checkNextCandidatesStage2.add(new DownloadLinkCandidate(candidate, proxySelector));
                    }
                }
                if (checkNextCandidatesStage2.size() > 0) break;
            }
            for (DownloadLinkCandidate notPossibleCandidate : checkNextCandidatesStage1) {
                try {
                    if (!selector.validateDownloadLinkCandidate(notPossibleCandidate)) continue;
                    selector.addExcluded(notPossibleCandidate, new DownloadLinkCandidateResult(SkipReason.CONNECTION_UNAVAILABLE, null, null));
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    selector.addExcluded(notPossibleCandidate, new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, null, null));
                }
            }
            ArrayList<DownloadLinkCandidate> nextCandidates = new ArrayList<DownloadLinkCandidate>();
            for (DownloadLinkCandidate candidate : checkNextCandidatesStage2) {
                try {
                    DownloadLinkCandidateSelector.DownloadLinkCandidatePermission permission = selector.getDownloadLinkCandidatePermission(candidate);
                    switch (permission) {
                        case OK: 
                        case OK_FORCED: 
                        case OK_SPEED_EXTENSION: {
                            if (!selector.validateDownloadLinkCandidate(candidate)) break;
                            nextCandidates.add(candidate);
                            break;
                        }
                        case CONCURRENCY_FORBIDDEN: 
                        case CONCURRENCY_LIMIT: {
                            if (!selector.validateDownloadLinkCandidate(candidate)) break;
                            selector.addExcluded(candidate, new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_TEMP_UNAVAILABLE, null, null));
                        }
                    }
                }
                catch (Throwable e) {
                    this.logger.log(e);
                    selector.addExcluded(candidate, new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, null, null));
                }
            }
            if (nextCandidates.size() <= 0) continue;
            return nextCandidates;
        }
        return null;
    }

    private List<DownloadLinkCandidate> findDownloadLinkCandidateMirrors(DownloadLinkCandidateSelector selector, DownloadLinkCandidate candidate) {
        ArrayList<DownloadLinkCandidate> ret = new ArrayList<DownloadLinkCandidate>();
        if (candidate.isForced()) {
            return ret;
        }
        DownloadLink link = candidate.getLink();
        FilePackage filePackage = link.getFilePackage();
        String name = link.getView().getDisplayName();
        ArrayList<DownloadLink> removeList = new ArrayList<DownloadLink>();
        MirrorDetectionDecision mirrorDetectionDecision = this.config.getMirrorDetectionDecision();
        for (DownloadLink next : this.getSession().getActivationRequests()) {
            if (next == link || next.getFilePackage() != filePackage || this.canIgnore(selector, next, false)) continue;
            if (this.canRemove(next, false)) {
                next.setConditionalSkipReason(null);
                removeList.add(next);
                continue;
            }
            if (!this.isMirrorCandidate(link, name, next, mirrorDetectionDecision)) continue;
            ret.add(new DownloadLinkCandidate(next, false));
        }
        this.getSession().removeActivationRequests(removeList);
        return ret;
    }

    private boolean canRemove(DownloadLink next, boolean isForced) {
        if (next.getDefaultPlugin() == null) {
            return true;
        }
        if (FilePackage.isDefaultFilePackage(next.getFilePackage())) {
            return true;
        }
        if (next.getAvailableStatus() == DownloadLink.AvailableStatus.FALSE) {
            return true;
        }
        if (next.getFinalLinkState() != null) {
            return true;
        }
        if (next.isSkipped()) {
            return true;
        }
        return !isForced && !next.isEnabled();
    }

    private boolean canIgnore(DownloadLinkCandidateSelector selector, DownloadLink next, boolean isForced) {
        if (next.getDownloadLinkController() != null) {
            return true;
        }
        ConditionalSkipReason conditionalSkipReason = next.getConditionalSkipReason();
        if (conditionalSkipReason != null) {
            if (conditionalSkipReason instanceof IgnorableConditionalSkipReason && ((IgnorableConditionalSkipReason)((Object)conditionalSkipReason)).canIgnore()) {
                return true;
            }
            if (!(conditionalSkipReason instanceof ValidatableConditionalSkipReason) || ((ValidatableConditionalSkipReason)((Object)conditionalSkipReason)).isValid()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private DownloadLinkCandidate nextDownloadLinkCandidate(DownloadLinkCandidateSelector selector) {
        ArrayList<DownloadLink> removeList = new ArrayList<DownloadLink>();
        try {
            DownloadSession currentSession = selector.getSession();
            HashSet<DownloadLink> avoidReHandle = new HashSet<DownloadLink>();
            ArrayList<List<DownloadLink>> activationRequests = new ArrayList<List<DownloadLink>>(2);
            if (currentSession.isForcedLinksWaiting()) {
                activationRequests.add(currentSession.getForcedLinks());
            }
            if (!selector.isForcedOnly() && !currentSession.isForcedOnlyModeEnabled()) {
                activationRequests.add(currentSession.getActivationRequests());
            }
            Iterator iterator = activationRequests.iterator();
            block5: while (iterator.hasNext()) {
                List list = (List)iterator.next();
                list.removeAll(removeList);
                boolean isForced = list == currentSession.getForcedLinks();
                try {
                    DownloadLink next;
                    Iterator it = list.iterator();
                    while (true) {
                        if (!it.hasNext()) continue block5;
                        next = (DownloadLink)it.next();
                        if (selector.isExcluded(next) || !avoidReHandle.add(next)) continue;
                        if (this.canIgnore(selector, next, isForced)) {
                            selector.addExcluded(next);
                            continue;
                        }
                        if (!this.canRemove(next, isForced)) break;
                        next.setConditionalSkipReason(null);
                        removeList.add(next);
                    }
                    DownloadLinkCandidate downloadLinkCandidate = new DownloadLinkCandidate(next, isForced);
                    return downloadLinkCandidate;
                }
                finally {
                    list.removeAll(removeList);
                }
            }
            return null;
        }
        catch (Throwable e) {
            this.logger.log(e);
        }
        return null;
    }

    public boolean isPaused() {
        return this.stateMachine.isState(new State[]{PAUSE_STATE});
    }

    private boolean isAutoReconnectEnabled() {
        return this.autoReconnectEnabled.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean newDLStartAllowed(DownloadSession session) {
        DownloadWatchDogJob job;
        if (ShutdownController.getInstance().isShutDownRequested()) {
            return false;
        }
        LinkedList<DownloadWatchDogJob> linkedList = this.watchDogJobs;
        synchronized (linkedList) {
            job = this.watchDogJobs.peek();
        }
        if (job != null && job.isHighPriority()) {
            return false;
        }
        DownloadSession.SessionState sessionState = session.getSessionState();
        if (sessionState == DownloadSession.SessionState.RECONNECT_RUNNING) {
            return false;
        }
        boolean isForcedLinksWaiting = session.isForcedLinksWaiting();
        if (!isForcedLinksWaiting) {
            if (!this.stateMachine.isState(new State[]{RUNNING_STATE})) {
                return false;
            }
            if (sessionState == DownloadSession.SessionState.RECONNECT_REQUESTED && this.isAutoReconnectEnabled() && CFG_RECONNECT.CFG.isDownloadControllerPrefersReconnectEnabled()) {
                return false;
            }
        }
        return true;
    }

    protected void setTempWatchDogJobThread(Thread thread) {
        this.tempWatchDogJobThread.set((Object)thread);
    }

    public void pauseDownloadWatchDog(final boolean value) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (value && !DownloadWatchDog.this.stateMachine.isState(new State[]{RUNNING_STATE})) {
                    return;
                }
                if (value) {
                    currentSession.setSpeedLimitBeforePause(DownloadWatchDog.this.config.getDownloadSpeedLimit());
                    currentSession.setSpeedWasLimitedBeforePauseEnabled(DownloadWatchDog.this.config.isDownloadSpeedLimitEnabled());
                    DownloadWatchDog.this.config.setDownloadSpeedLimit(DownloadWatchDog.this.config.getPauseSpeed());
                    DownloadWatchDog.this.config.setDownloadSpeedLimitEnabled(true);
                    DownloadWatchDog.this.logger.info("Pause enabled: Reducing downloadspeed to " + DownloadWatchDog.this.config.getPauseSpeed() + " KiB/s");
                    DownloadWatchDog.this.stateMachine.setStatus(PAUSE_STATE);
                } else {
                    Boolean beforeEnabled;
                    if (currentSession.getSpeedLimitBeforePause() > 0) {
                        DownloadWatchDog.this.logger.info("Pause disabled: Switch back to old downloadspeed");
                        DownloadWatchDog.this.config.setDownloadSpeedLimit(currentSession.getSpeedLimitBeforePause());
                    }
                    if ((beforeEnabled = currentSession.isSpeedWasLimitedBeforePauseEnabled()) != null) {
                        DownloadWatchDog.this.config.setDownloadSpeedLimitEnabled(beforeEnabled);
                    }
                    if (DownloadWatchDog.this.stateMachine.isState(new State[]{PAUSE_STATE})) {
                        DownloadWatchDog.this.stateMachine.setStatus(RUNNING_STATE);
                    }
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public void notifyCurrentState(final DownloadWatchdogListener listener) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.stateMachine.isState(new State[]{RUNNING_STATE})) {
                    listener.onDownloadWatchdogStateIsRunning();
                } else if (DownloadWatchDog.this.stateMachine.isState(new State[]{STOPPED_STATE})) {
                    listener.onDownloadWatchdogStateIsStopped();
                } else if (DownloadWatchDog.this.stateMachine.isState(new State[]{IDLE_STATE})) {
                    listener.onDownloadWatchdogStateIsIdle();
                } else if (DownloadWatchDog.this.stateMachine.isState(new State[]{PAUSE_STATE})) {
                    listener.onDownloadWatchdogStateIsPause();
                } else if (DownloadWatchDog.this.stateMachine.isState(new State[]{STOPPING_STATE})) {
                    listener.onDownloadWatchdogStateIsStopping();
                }
                listener.onDownloadWatchDogPropertyChange(new DownloadWatchDogProperty(DownloadWatchDogProperty.Property.STOPSIGN, currentSession.getStopMark()));
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public long getDownloadSpeedbyFilePackage(FilePackage pkg) {
        long speed = -1L;
        for (SingleDownloadController con : this.getSession().getControllers()) {
            DownloadInterface dli;
            if (con.getDownloadLink().getFilePackage() != pkg || (dli = con.getDownloadInstance()) == null) continue;
            speed += (long)dli.getManagedConnetionHandler().getSpeed();
        }
        return speed;
    }

    public int getDownloadsbyFilePackage(FilePackage pkg) {
        int ret = 0;
        for (SingleDownloadController con : this.getSession().getControllers()) {
            if (con.getDownloadLink().getFilePackage() != pkg) continue;
            ++ret;
        }
        return ret;
    }

    public Set<SingleDownloadController> getRunningDownloadLinks() {
        return this.getSession().getControllers();
    }

    public Set<FilePackage> getRunningFilePackages() {
        HashSet<FilePackage> ret = new HashSet<FilePackage>();
        for (SingleDownloadController con : this.getSession().getControllers()) {
            ret.add(con.getDownloadLink().getParentNode());
        }
        return ret;
    }

    public boolean hasRunningDownloads(FilePackage pkg) {
        for (SingleDownloadController con : this.getSession().getControllers()) {
            if (con.getDownloadLink().getFilePackage() != pkg) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortAllSingleDownloadControllers() {
        if (this.isWatchDogThread()) {
            throw new WTFException("it is not possible to use this method inside WatchDogThread!");
        }
        while (true) {
            for (SingleDownloadController con : this.getSession().getControllers()) {
                if (!con.isAlive() || con.isAborting()) continue;
                con.abort();
            }
            Object object = this.WATCHDOGLOCK;
            synchronized (object) {
                if (this.getSession().getControllers().size() == 0) {
                    return;
                }
                try {
                    this.WATCHDOGLOCK.wait(1000L);
                }
                catch (InterruptedException e) {
                    this.logger.log((Throwable)e);
                    return;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueJob(DownloadWatchDogJob job) {
        Object object = this.watchDogJobs;
        synchronized (object) {
            if (job.isHighPriority()) {
                DownloadWatchDogJob first = this.watchDogJobs.peekFirst();
                DownloadWatchDogJob last = this.watchDogJobs.peekLast();
                if (first == null || !first.isHighPriority()) {
                    this.watchDogJobs.offerFirst(job);
                } else if (last.isHighPriority()) {
                    this.watchDogJobs.offerLast(job);
                } else {
                    boolean jobOffered = false;
                    ListIterator<DownloadWatchDogJob> it = this.watchDogJobs.listIterator();
                    while (it.hasNext()) {
                        DownloadWatchDogJob next = (DownloadWatchDogJob)it.next();
                        if (next.isHighPriority()) continue;
                        it.previous();
                        it.add(job);
                        jobOffered = true;
                        break;
                    }
                    if (!jobOffered) {
                        this.watchDogJobs.offerLast(job);
                    }
                }
            } else {
                this.watchDogJobs.offerLast(job);
            }
        }
        if (!this.isWatchDogThread()) {
            object = this.WATCHDOGLOCK;
            synchronized (object) {
                this.WATCHDOGLOCK.notifyAll();
            }
        }
    }

    public void resume(final List<DownloadLink> resetLinks) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                for (DownloadLink link : resetLinks) {
                    if (link.getDownloadLinkController() != null || !FinalLinkState.CheckFailed(link.getFinalLinkState()) && !link.isSkipped()) continue;
                    DownloadWatchDog.this.resumeLink(link, currentSession);
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public void unSkip(final List<DownloadLink> resetLinks) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                for (DownloadLink link : resetLinks) {
                    if (link.getDownloadLinkController() != null || !link.isSkipped()) continue;
                    DownloadWatchDog.this.unSkipLink(link, currentSession);
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public void reset(final List<DownloadLink> resetLinks) {
        if (resetLinks == null || resetLinks.size() == 0) {
            return;
        }
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (currentSession != null) {
                    currentSession.getActivationRequests().removeAll(resetLinks);
                    currentSession.getForcedLinks().removeAll(resetLinks);
                }
                for (final DownloadLink link : resetLinks) {
                    SingleDownloadController con = link.getDownloadLinkController();
                    if (con == null) {
                        DownloadWatchDog.this.resetLink(link, currentSession);
                        continue;
                    }
                    con.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                        @Override
                        public void interrupt() {
                        }

                        @Override
                        public void execute(DownloadSession currentSession) {
                            DownloadWatchDog.this.resetLink(link, currentSession);
                        }

                        @Override
                        public boolean isHighPriority() {
                            return false;
                        }
                    });
                    con.abort();
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    private void resumeLink(DownloadLink link, DownloadSession session) {
        if (link.getDownloadLinkController() != null) {
            throw new IllegalStateException("Link is in progress! cannot resume!");
        }
        FinalLinkState finalLinkState = link.getFinalLinkState();
        if (!FinalLinkState.CheckFinished(finalLinkState)) {
            if (FinalLinkState.CheckFailed(finalLinkState)) {
                link.setFinalLinkState(null);
            }
            this.unSkipLink(link, session);
            if (!link.isEnabled()) {
                link.setEnabled(true);
            }
        }
        DownloadLinkCandidateHistory history = session.getHistory(link);
        List<PluginForHost> plugins = this.getPluginsFromHistory(link, history);
        link.resume(new ArrayList<PluginForHost>(plugins));
    }

    private void unSkipLink(DownloadLink link, DownloadSession session) {
        if (link.isSkipped()) {
            if (SkipReason.FFMPEG_MISSING.equals((Object)link.getSkipReason()) || SkipReason.UPDATE_RESTART_REQUIRED.equals((Object)link.getSkipReason())) {
                this.getSession().removeProperty("FFMPEG_INSTALL_CHECK");
            }
            link.setSkipReason(null);
        }
        CaptchaBlackList.getInstance().addWhitelist(link);
    }

    private List<PluginForHost> getPluginsFromHistory(DownloadLink link, DownloadLinkCandidateHistory history) {
        PluginForHost defaultPlugin;
        HashSet<PluginForHost> plugins = new HashSet<PluginForHost>();
        if (history != null) {
            for (DownloadLinkCandidate candidate : history.getHistory().keySet()) {
                plugins.add(candidate.getCachedAccount().getPlugin());
            }
        }
        if ((defaultPlugin = link.getDefaultPlugin()) != null) {
            plugins.add(defaultPlugin);
        }
        return new ArrayList<PluginForHost>(plugins);
    }

    private void resetLink(DownloadLink link, DownloadSession session) {
        if (link.getDownloadLinkController() != null) {
            throw new IllegalStateException("Link is in progress! cannot reset!");
        }
        DownloadLinkCandidateHistory history = session.removeHistory(link);
        List<ProxyInfoHistory.WaitingSkipReasonContainer> list = session.getProxyInfoHistory().list(link.getHost());
        if (list != null) {
            for (ProxyInfoHistory.WaitingSkipReasonContainer container : list) {
                container.invalidate();
            }
        }
        this.deleteFile(link, FileCreationManager.DeleteOption.NULL);
        this.unSkipLink(link, session);
        List<PluginForHost> plugins = this.getPluginsFromHistory(link, history);
        link.reset(plugins);
    }

    public void delete(List<DownloadLink> deleteFiles, FileCreationManager.DeleteOption deleteTo) {
        this.delete(deleteFiles, deleteTo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<DownloadLink, Map<File, Boolean>> delete(List<DownloadLink> deleteFiles, final FileCreationManager.DeleteOption deleteTo, boolean waitForDeletion) {
        if (deleteFiles == null || deleteFiles.size() == 0) {
            return null;
        }
        final HashSet<DownloadLink> todo = new HashSet<DownloadLink>(deleteFiles);
        final HashMap<DownloadLink, Map<File, Boolean>> ret = new HashMap<DownloadLink, Map<File, Boolean>>();
        this.enqueueJob(new DownloadWatchDogJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(DownloadSession currentSession) {
                if (currentSession != null) {
                    currentSession.getActivationRequests().removeAll(todo);
                    currentSession.getForcedLinks().removeAll(todo);
                }
                for (final DownloadLink link : todo) {
                    SingleDownloadController con = link.getDownloadLinkController();
                    if (con == null || !con.isAlive()) {
                        Map result = null;
                        try {
                            result = DownloadWatchDog.this.deleteFile(link, deleteTo);
                            continue;
                        }
                        finally {
                            Map map = ret;
                            synchronized (map) {
                                ret.put(link, result);
                                ret.notifyAll();
                                continue;
                            }
                        }
                    }
                    con.abort();
                    con.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void execute(DownloadSession currentSession) {
                            Object result = null;
                            try {
                                DownloadWatchDog.this.deleteFile(link, deleteTo);
                            }
                            finally {
                                Map map = ret;
                                synchronized (map) {
                                    ret.put(link, result);
                                    ret.notifyAll();
                                }
                            }
                        }

                        @Override
                        public void interrupt() {
                        }

                        @Override
                        public boolean isHighPriority() {
                            return false;
                        }
                    });
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
        if (waitForDeletion) {
            while (true) {
                HashMap<DownloadLink, Map<File, Boolean>> hashMap = ret;
                synchronized (hashMap) {
                    if (ret.size() != todo.size()) {
                        try {
                            ret.wait();
                        }
                        catch (InterruptedException e) {
                            this.logger.log((Throwable)e);
                            return new HashMap<DownloadLink, Map<File, Boolean>>(ret);
                        }
                    } else {
                        break;
                    }
                }
            }
            return ret;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<File, Boolean> deleteFile(DownloadLink link, FileCreationManager.DeleteOption deleteTo) {
        if (deleteTo == null) {
            deleteTo = FileCreationManager.DeleteOption.NULL;
        }
        if (FileCreationManager.DeleteOption.NO_DELETE == deleteTo) {
            return null;
        }
        HashMap<File, Boolean> deleteFiles = new HashMap<File, Boolean>();
        try {
            for (File deleteFile : link.getDefaultPlugin().listProcessFiles(link)) {
                if (!deleteFile.exists() || !deleteFile.isFile()) continue;
                try {
                    this.getSession().getFileAccessManager().lock(deleteFile, this);
                    deleteFiles.put(deleteFile, null);
                }
                catch (FileIsLockedException e) {
                    this.logger.log((Throwable)e);
                }
            }
            for (File deleteFile : new ArrayList(deleteFiles.keySet())) {
                switch (deleteTo) {
                    case NULL: {
                        if (!deleteFile.delete()) {
                            deleteFiles.put(deleteFile, Boolean.FALSE);
                            this.logger.info("Could not delete file: " + deleteFile + " for " + link + " exists: " + deleteFile.exists());
                            break;
                        }
                        deleteFiles.put(deleteFile, Boolean.TRUE);
                        this.logger.info("Deleted file: " + deleteFile + " for " + link);
                        break;
                    }
                    case RECYCLE: {
                        try {
                            JDFileUtils.moveToTrash(deleteFile);
                            deleteFiles.put(deleteFile, Boolean.TRUE);
                            this.logger.info("Recycled file: " + deleteFile + " for " + link);
                        }
                        catch (IOException e) {
                            deleteFiles.put(deleteFile, Boolean.FALSE);
                            this.logger.log((Throwable)e);
                            this.logger.info("Could not recycle file: " + deleteFile + " for " + link + " exists: " + deleteFile.exists());
                        }
                        break;
                    }
                    case NO_DELETE: {
                        Map<File, Boolean> e = null;
                        return e;
                    }
                }
            }
            File dlFolder = new File(link.getDownloadDirectory());
            File dfFolder = new File(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDefaultDownloadFolder());
            if (!dfFolder.equals(dlFolder) && dlFolder.isDirectory()) {
                File[] files = dlFolder.listFiles();
                if (files == null || files.length > 0) {
                    this.logger.info("Could not delete folder(not empty:" + (files != null ? Integer.valueOf(files.length) : "-1") + "): " + dlFolder + " for " + link);
                } else if (!dlFolder.delete()) {
                    this.logger.info("Could not delete folder: " + dlFolder + " for " + link);
                } else {
                    this.logger.info("Deleted folder: " + dlFolder + " for " + link);
                }
            }
            HashMap<File, Boolean> hashMap = deleteFiles;
            return hashMap;
        }
        finally {
            for (File deleteFile : deleteFiles.keySet()) {
                this.getSession().getFileAccessManager().unlock(deleteFile, this);
            }
        }
    }

    public void abort(final List<DownloadLink> abortLinks) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                for (DownloadLink link : abortLinks) {
                    SingleDownloadController con = link.getDownloadLinkController();
                    if (con == null) continue;
                    con.abort();
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SingleDownloadController> activateDownloads(List<DownloadLink> downloadLinksWithConditionalSkipReasons) throws Exception {
        ArrayList<SingleDownloadController> ret;
        block14: {
            ret = new ArrayList<SingleDownloadController>();
            DownloadSession session = this.getSession();
            DownloadLinkCandidateSelector selector = new DownloadLinkCandidateSelector(session);
            int maxConcurrentNormal = Math.max(1, this.config.getMaxSimultaneDownloads());
            maxConcurrentNormal = Math.max(maxConcurrentNormal, DomainRuleController.getInstance().getMaxSimultanDownloads());
            int maxConcurrentForced = maxConcurrentNormal + Math.max(0, this.config.getMaxForcedDownloads());
            int loopCounter = 0;
            boolean invalidate = session.setCandidatesRefreshRequired(false);
            try {
                boolean canExceed;
                if (invalidate && downloadLinksWithConditionalSkipReasons != null) {
                    for (DownloadLink downloadLink : downloadLinksWithConditionalSkipReasons) {
                        ConditionalSkipReason con = downloadLink.getConditionalSkipReason();
                        if (con == null || !(con instanceof ValidatableConditionalSkipReason)) continue;
                        ((ValidatableConditionalSkipReason)((Object)con)).invalidate();
                    }
                }
                if (session.isForcedLinksWaiting()) {
                    selector.setForcedOnly(true);
                    loopCounter = 0;
                    while (this.newDLStartAllowed(session) && session.isForcedLinksWaiting() && this.getActiveDownloads() < maxConcurrentForced && loopCounter < maxConcurrentForced) {
                        try {
                            DownloadLinkCandidate candidate = this.next(selector);
                            if (candidate == null) break;
                            ret.add(this.attach(candidate));
                        }
                        finally {
                            ++loopCounter;
                        }
                    }
                }
                if (session.isStopMarkReached()) break block14;
                selector.setForcedOnly(false);
                boolean bl = canExceed = DomainRuleController.getInstance().getMaxSimultanDownloads() > 0;
                while (this.newDLStartAllowed(session)) {
                    if (!canExceed && this.getActiveDownloads() >= maxConcurrentNormal && !this.checkForAdditionalDownloadSlots(session)) {
                    } else {
                        DownloadLinkCandidate downloadLinkCandidate = this.next(selector);
                        if (downloadLinkCandidate != null) {
                            ret.add(this.attach(downloadLinkCandidate));
                            continue;
                        }
                    }
                    break;
                }
            }
            finally {
                this.finalize(selector, downloadLinksWithConditionalSkipReasons);
            }
        }
        return ret;
    }

    public boolean checkForAdditionalDownloadSlots(DownloadSession session) {
        long autoMaxDownloadSpeedLimit = this.config.getAutoMaxDownloadsSpeedLimit();
        int autoMaxDownloadsMaxDownloads = this.config.getAutoMaxDownloadsSpeedLimitMaxDownloads();
        int autoMaxDownloadsMinDelay = this.config.getAutoMaxDownloadsSpeedLimitMinDelay();
        Set<SingleDownloadController> controllers = session.getControllers();
        if (autoMaxDownloadSpeedLimit > 0L && (autoMaxDownloadsMaxDownloads == 0 || controllers.size() < autoMaxDownloadsMaxDownloads)) {
            try {
                long currentDownloadSpeed = this.getDownloadSpeedManager().getSpeedMeter().getValue(SpeedMeterInterface.Resolution.SECONDS);
                if (currentDownloadSpeed < autoMaxDownloadSpeedLimit) {
                    int speedlimit;
                    int n = speedlimit = this.config.isDownloadSpeedLimitEnabled() ? this.config.getDownloadSpeedLimit() : 0;
                    if (speedlimit > 0 && (double)currentDownloadSpeed > (double)speedlimit * 0.8) {
                        return false;
                    }
                    long latestStart = 0L;
                    for (SingleDownloadController s : controllers) {
                        latestStart = Math.max(latestStart, s.getStartTimestamp());
                        long left = s.getDownloadLink().getView().getBytesTotal() - s.getDownloadLink().getView().getBytesLoaded();
                        if (left <= 0L || s.getDownloadLink().getView().getSpeedBps() > 0L) continue;
                        return false;
                    }
                    return System.currentTimeMillis() - latestStart >= (long)autoMaxDownloadsMinDelay;
                }
            }
            catch (Throwable e) {
                this.logger.log(e);
            }
        }
        return false;
    }

    private void finalize(DownloadLinkCandidateSelector selector, List<DownloadLink> downloadLinksWithConditionalSkipReasons) {
        if (downloadLinksWithConditionalSkipReasons != null) {
            for (DownloadLink link : downloadLinksWithConditionalSkipReasons) {
                ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
                if (conditionalSkipReason == null) continue;
                if (conditionalSkipReason instanceof ValidatableConditionalSkipReason && !((ValidatableConditionalSkipReason)((Object)conditionalSkipReason)).isValid()) {
                    link.setConditionalSkipReason(null);
                }
                if (!conditionalSkipReason.isConditionReached()) continue;
                link.setConditionalSkipReason(null);
                conditionalSkipReason.finalize(link);
            }
        }
        LinkedHashMap<DownloadLinkCandidate, DownloadLinkCandidateResult> results = selector.finalizeDownloadLinkCandidatesResults();
        for (Map.Entry<DownloadLinkCandidate, DownloadLinkCandidateResult> next : results.entrySet()) {
            DownloadLinkCandidate candidate = next.getKey();
            DownloadLinkCandidateResult result = next.getValue();
            this.setFinalLinkStatus(candidate, result, null);
        }
    }

    public void startDownloads() {
        this.startDownloads(null);
    }

    public void startDownloads(final Runnable runBeforeStartingDownloadWatchDog) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.stateMachine.reset(false);
                }
                if (!DownloadWatchDog.this.stateMachine.isStartState()) {
                    return;
                }
                DownloadWatchDog.this.session.set((Object)new DownloadSession(currentSession));
                if (runBeforeStartingDownloadWatchDog != null) {
                    try {
                        runBeforeStartingDownloadWatchDog.run();
                    }
                    catch (Throwable e) {
                        DownloadWatchDog.this.logger.log(e);
                    }
                }
                DownloadWatchDog.this.startDownloadWatchDog();
                DownloadWatchDog.this.logger.info("DownloadWatchDog: start");
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public DownloadSession getSession() {
        return (DownloadSession)this.session.get();
    }

    private SingleDownloadController attach(final DownloadLinkCandidate candidate) {
        this.logger.info("Start new Download: Use Premium: " + this.getSession().isUseAccountsEnabled() + " Host:" + candidate);
        DownloadLinkCandidateHistory history = this.getSession().buildHistory(candidate.getLink());
        if (history == null || !history.attach(candidate)) {
            this.logger.severe("Could not attach to History: " + candidate);
        }
        final SingleDownloadController con = new SingleDownloadController(candidate, this);
        DownloadController.getInstance().getQueue().addWait(new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                boolean ignoreUnsafe = true;
                String downloadTo = candidate.getLink().getFileOutput(ignoreUnsafe, false);
                if (StringUtils.isEmpty((String)downloadTo)) {
                    ignoreUnsafe = false;
                    downloadTo = candidate.getLink().getFileOutput(ignoreUnsafe, false);
                }
                String customDownloadTo = candidate.getLink().getFileOutput(ignoreUnsafe, true);
                if (ignoreUnsafe) {
                    DownloadWatchDog.this.logger.info("Download To: " + downloadTo);
                } else {
                    DownloadWatchDog.this.logger.info("Download To(Unsafe): " + downloadTo);
                }
                if (!StringUtils.equalsIgnoreCase((String)downloadTo, (String)customDownloadTo)) {
                    DownloadWatchDog.this.logger.info("Download To(custom): " + customDownloadTo);
                }
                con.setSessionDownloadDirectory(candidate.getLink().getParentNode().getDownloadDirectory());
                return null;
            }
        });
        con.setSessionDownloadFilename(candidate.getLink().getForcedFileName());
        if (candidate.getProxySelector() != null) {
            candidate.getProxySelector().add(con);
        }
        candidate.getLink().setEnabled(true);
        this.getSession().getControllers().add(con);
        con.start();
        return con;
    }

    protected void detach(final SingleDownloadController singleDownloadController, final SingleDownloadReturnState returnState) {
        this.enqueueJob(new DownloadWatchDogJob(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(DownloadSession currentSession) {
                LogSource logger = null;
                try {
                    if (singleDownloadController.getLogger() instanceof LogSource) {
                        logger = (LogSource)singleDownloadController.getLogger();
                    }
                    if (logger == null) {
                        logger = new LogSource("Dummy"){

                            public synchronized void clear() {
                            }

                            public synchronized void log(LogRecord record) {
                                DownloadWatchDog.this.logger.log(record);
                            }
                        };
                    }
                    DownloadLinkCandidate candidate = singleDownloadController.getDownloadLinkCandidate();
                    DownloadLink link = candidate.getLink();
                    if (candidate.getProxySelector() != null) {
                        candidate.getProxySelector().remove(singleDownloadController);
                    }
                    DownloadLinkCandidateResult result = null;
                    try {
                        Set finalizedLinks;
                        try {
                            result = DownloadWatchDog.this.handleReturnState(logger, singleDownloadController, returnState);
                            result.setStartTime(singleDownloadController.getStartTimestamp());
                            result.setFinishTime(returnState.getTimeStamp());
                            DownloadLinkCandidateHistory existingHistory = currentSession.getHistory(link);
                            DownloadWatchDog.this.setFinalLinkStatus(candidate, result, singleDownloadController);
                            if (existingHistory != null && !existingHistory.dettach(candidate, result)) {
                                DownloadWatchDog.this.logger.severe("Could not detach from History: " + candidate);
                            }
                        }
                        catch (Throwable e) {
                            DownloadWatchDog.this.logger.log(e);
                        }
                        currentSession.getControllers().remove(singleDownloadController);
                        for (DownloadWatchDogJob job : singleDownloadController.getJobsAfterDetach()) {
                            try {
                                job.execute(currentSession);
                            }
                            catch (Throwable e) {
                                DownloadWatchDog.this.logger.log(e);
                            }
                        }
                        try {
                            logger.info("Rename after Download?");
                            File desiredPath = new File(link.getFileOutput(false, false));
                            logger.info("Desired Path: " + desiredPath);
                            File usedPath = singleDownloadController.getFileOutput(false, false);
                            logger.info("Actually Used path: " + usedPath);
                            if (!desiredPath.equals(usedPath)) {
                                logger.info("Move");
                                DownloadWatchDog.this.move(link, usedPath.getParent(), usedPath.getName(), desiredPath.getParent(), desiredPath.getName());
                            }
                        }
                        catch (Throwable e) {
                            DownloadWatchDog.this.logger.log(e);
                        }
                        currentSession.refreshCandidates();
                        FilePackage fp = link.getLastValidFilePackage();
                        try {
                            fp.getView().requestUpdate();
                        }
                        catch (Throwable usedPath) {
                            // empty catch block
                        }
                        if (fp != null && !FilePackage.isDefaultFilePackage(fp)) {
                            boolean readL = fp.getModifyLock().readLock();
                            try {
                                finalizedLinks = DownloadWatchDog.this.finalizeConditionalSkipReasons(fp.getChildren(), (List<DownloadLink>)null);
                            }
                            finally {
                                fp.getModifyLock().readUnlock(readL);
                            }
                        } else {
                            finalizedLinks = null;
                        }
                        try {
                            DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.LINK_STOPPED, singleDownloadController, candidate, result));
                        }
                        catch (Throwable e) {
                            DownloadWatchDog.this.logger.log(e);
                        }
                        DownloadWatchDog.this.handleFinalLinkStates(finalizedLinks, currentSession, DownloadWatchDog.this.logger, singleDownloadController);
                    }
                    finally {
                        if (result != null) {
                            // empty if block
                        }
                    }
                }
                catch (Throwable e) {
                    DownloadWatchDog.this.logger.log(e);
                    if (logger != null) {
                        logger.log(e);
                    }
                }
                finally {
                    if (logger != null) {
                        logger.close();
                    }
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
    }

    private void handleFinalLinkStates(Set<DownloadLink> links, DownloadSession session, final LogSource logger, final SingleDownloadController singleDownloadController) {
        DownloadLink singleDownloadControllerLink;
        if ((links == null || links.size() == 0) && singleDownloadController == null) {
            return;
        }
        if (links == null) {
            links = new HashSet<DownloadLink>();
        }
        if (singleDownloadController != null) {
            singleDownloadControllerLink = singleDownloadController.getDownloadLinkCandidate().getLink();
            links.add(singleDownloadControllerLink);
        } else {
            singleDownloadControllerLink = null;
        }
        Iterator<DownloadLink> it = links.iterator();
        final CleanAfterDownloadAction cleanupAction = CFG_GENERAL.CFG.getCleanupAfterDownloadAction();
        boolean cleanupFileExists = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getCleanupFileExists();
        final ArrayList<DownloadLink> cleanupLinks = new ArrayList<DownloadLink>();
        final HashSet<FilePackage> cleanupPackages = new HashSet<FilePackage>();
        while (it.hasNext()) {
            final DownloadLink next = it.next();
            FinalLinkState state = next.getFinalLinkState();
            if (FinalLinkState.FAILED_EXISTS.equals((Object)state)) {
                session.removeActivationRequest(next);
                session.removeHistory(next);
                it.remove();
                if (!cleanupFileExists) continue;
                switch (cleanupAction) {
                    case CLEANUP_IMMEDIATELY: {
                        cleanupLinks.add(next);
                        break;
                    }
                    case CLEANUP_AFTER_PACKAGE_HAS_FINISHED: {
                        cleanupPackages.add(next.getFilePackage());
                    }
                }
                continue;
            }
            if (!FinalLinkState.CheckFinished(state)) continue;
            session.removeActivationRequest(next);
            session.removeHistory(next);
            it.remove();
            switch (cleanupAction) {
                case CLEANUP_IMMEDIATELY: {
                    cleanupLinks.add(next);
                    break;
                }
                case CLEANUP_AFTER_PACKAGE_HAS_FINISHED: {
                    cleanupPackages.add(next.getFilePackage());
                }
            }
            if (next != singleDownloadControllerLink) continue;
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    FileCreationManager.getInstance().getEventSender().fireEvent((DefaultEvent)new FileCreationEvent(singleDownloadController, FileCreationEvent.Type.NEW_FILES, new File(next.getFileOutput())));
                    return null;
                }
            });
        }
        if (cleanupLinks.size() > 0 || cleanupPackages.size() > 0) {
            TaskQueue.getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                protected Void run() throws RuntimeException {
                    switch (cleanupAction) {
                        case CLEANUP_IMMEDIATELY: {
                            if (cleanupLinks.size() <= 0) break;
                            DownloadController.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                                protected Void run() throws RuntimeException {
                                    for (DownloadLink cleanupLink : cleanupLinks) {
                                        if (DownloadController.getInstance() != cleanupLink.getFilePackage().getControlledBy()) continue;
                                        String name = cleanupLink.getView().getDisplayName();
                                        logger.info("Remove Link " + name + " because " + (Object)((Object)cleanupLink.getFinalLinkState()) + " and CleanupImmediately!");
                                        List<DownloadLink> remove = new ArrayList<DownloadLink>();
                                        remove.add(cleanupLink);
                                        remove = DownloadController.getInstance().askForRemoveVetos((Object)singleDownloadController, remove);
                                        if (remove.size() > 0) {
                                            DownloadController.getInstance().removeChildren(remove);
                                            continue;
                                        }
                                        logger.info("Remove Link " + name + " failed because of removeVetos!");
                                    }
                                    return null;
                                }
                            });
                            break;
                        }
                        case CLEANUP_AFTER_PACKAGE_HAS_FINISHED: {
                            if (cleanupPackages.size() <= 0) break;
                            for (FilePackage filePackage : cleanupPackages) {
                                DownloadController.removePackageIfFinished(singleDownloadController, logger, filePackage);
                            }
                            break;
                        }
                    }
                    return null;
                }
            });
        }
    }

    private DownloadLinkCandidateResult handleReturnState(LogSource logger, SingleDownloadController singleDownloadController, SingleDownloadReturnState result) {
        AccountInfo ai;
        Throwable throwable = result.getCaughtThrowable();
        DownloadLinkCandidate candidate = singleDownloadController.getDownloadLinkCandidate();
        DownloadLink link = candidate.getLink();
        long sizeChange = Math.max(0L, link.getView().getBytesLoaded() - singleDownloadController.getSizeBefore());
        Account account = singleDownloadController.getAccount();
        if (account != null && sizeChange > 0L && (ai = account.getAccountInfo()) != null && !ai.isUnlimitedTraffic()) {
            long left = Math.max(0L, ai.getTrafficLeft() - sizeChange);
            ai.setTrafficLeft(left);
            if (left == 0L) {
                if (ai.isSpecialTraffic()) {
                    logger.severe("Account: " + account.getUser() + ": Traffic Limit could be reached, but SpecialTraffic might be available!");
                } else {
                    logger.severe("Account: " + account.getUser() + ": Traffic Limit reached");
                    account.setTempDisabled(true);
                }
            }
        }
        Enum skipReason = null;
        PluginException pluginException = null;
        ConditionalSkipReason conditionalSkipReason = null;
        PluginForHost latestPlugin = null;
        latestPlugin = result.getLatestPlugin();
        String pluginHost = latestPlugin != null ? latestPlugin.getLazyP().getHost() : candidate.getCachedAccount().getPlugin().getLazyP().getHost();
        if (throwable != null) {
            if (throwable instanceof PluginException) {
                pluginException = (PluginException)throwable;
            } else if (throwable instanceof SkipReasonException) {
                skipReason = ((SkipReasonException)throwable).getSkipReason();
            } else if (throwable instanceof ConditionalSkipReasonException) {
                conditionalSkipReason = ((ConditionalSkipReasonException)throwable).getConditionalSkipReason();
            } else {
                if (throwable instanceof NoInternetConnection) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getNetworkIssuesTimeout());
                    ret.setMessage(_JDT.T.plugins_errors_nointernetconn());
                    return ret;
                }
                if (throwable instanceof UnknownHostException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getNetworkIssuesTimeout());
                    ret.setMessage(_JDT.T.plugins_errors_nointernetconn());
                    return ret;
                }
                if (throwable instanceof SocketTimeoutException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getNetworkIssuesTimeout());
                    ret.setMessage(_JDT.T.plugins_errors_hosteroffline());
                    return ret;
                }
                if (throwable instanceof SocketException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getNetworkIssuesTimeout());
                    ret.setMessage(_JDT.T.plugins_errors_disconnect());
                    return ret;
                }
                if (throwable instanceof NoGateWayException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(10000L);
                    ret.setMessage(_JDT.T.plugins_errors_proxy_connection());
                    return ret;
                }
                if (throwable instanceof ProxyConnectException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(10000L);
                    ret.setMessage(_JDT.T.plugins_errors_proxy_connection());
                    return ret;
                }
                if (throwable instanceof ProxyAuthException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(30000L);
                    ret.setMessage(_JDT.T.plugins_errors_proxy_auth());
                    return ret;
                }
                if (throwable instanceof Browser.BlockedByException) {
                    Browser.BlockedByException bbe = (Browser.BlockedByException)throwable;
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDownloadUnknownIOExceptionWaittime());
                    ret.setMessage(_JDT.T.downloadlink_status_error_blocked_by(bbe.getBlockedBy().getLabel()));
                    return ret;
                }
                if (throwable instanceof IOException) {
                    DownloadLinkCandidateResult ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                    ret.setWaitTime(((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDownloadUnknownIOExceptionWaittime());
                    ret.setMessage(_JDT.T.plugins_errors_hosterproblem());
                    return ret;
                }
                if (throwable instanceof InterruptedException) {
                    if (result.getController().isAborting()) {
                        return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.STOPPED, throwable, pluginHost);
                    }
                    pluginException = new PluginException(0x400000, _JDT.T.plugins_errors_error() + "Interrupted");
                } else {
                    pluginException = new PluginException(0x400000, _JDT.T.plugins_errors_error() + "Throwable");
                }
            }
        }
        if (skipReason != null) {
            switch (45.$SwitchMap$org$jdownloader$plugins$SkipReason[skipReason.ordinal()]) {
                case 1: {
                    return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_REQUIRED, throwable, pluginHost);
                }
            }
            return new DownloadLinkCandidateResult((SkipReason)skipReason, throwable, pluginHost);
        }
        if (conditionalSkipReason != null) {
            return new DownloadLinkCandidateResult(conditionalSkipReason, throwable, pluginHost);
        }
        if (pluginException instanceof CandidateResultProvider) {
            DownloadLinkCandidateResult ret = ((CandidateResultProvider)((Object)pluginException)).createCandidateResult(candidate, pluginHost);
            if (ret != null) {
                return ret;
            }
        } else if (pluginException != null) {
            DownloadLinkCandidateResult ret = null;
            String message = null;
            long waitTime = -1L;
            switch (pluginException.getLinkStatus()) {
                case 4: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.RETRY, throwable, pluginHost);
                    message = pluginException.getLocalizedMessage();
                    break;
                }
                case 8: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CAPTCHA, throwable, pluginHost);
                    break;
                }
                case 2: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FINISHED_EXISTS, throwable, pluginHost);
                    break;
                }
                case 32: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.OFFLINE_TRUSTED, throwable, pluginHost);
                    break;
                }
                case 0x400000: {
                    if (latestPlugin != null) {
                        latestPlugin.errLog(throwable, null, link);
                    }
                    logger.info("Plugin Defect.1");
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, throwable, pluginHost);
                    break;
                }
                case 131072: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FATAL_ERROR, throwable, pluginHost);
                    message = pluginException.getLocalizedMessage();
                    break;
                }
                case 16: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.IP_BLOCKED, throwable, pluginHost);
                    message = pluginException.getLocalizedMessage();
                    waitTime = 3600000L;
                    if (pluginException.getValue() <= 0L) break;
                    waitTime = pluginException.getValue();
                    break;
                }
                case 2048: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FILE_UNAVAILABLE, throwable, pluginHost);
                    message = pluginException.getLocalizedMessage();
                    if (pluginException.getValue() > 0L) {
                        waitTime = pluginException.getValue();
                        break;
                    }
                    if (pluginException.getValue() > 0L) break;
                    waitTime = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDownloadTempUnavailableRetryWaittime();
                    break;
                }
                case 4096: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.HOSTER_UNAVAILABLE, throwable, pluginHost);
                    message = pluginException.getLocalizedMessage();
                    if (pluginException.getValue() > 0L) {
                        waitTime = pluginException.getValue();
                        break;
                    }
                    if (pluginException.getValue() > 0L) break;
                    waitTime = ((GeneralSettings)JsonConfig.create(GeneralSettings.class)).getDownloadHostUnavailableRetryWaittime();
                    break;
                }
                case 256: {
                    if (pluginException.getValue() == (long)PluginException.VALUE_ID_PREMIUM_ONLY) {
                        ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_REQUIRED, throwable, pluginHost);
                        break;
                    }
                    if (pluginException.getValue() == (long)PluginException.VALUE_ID_PREMIUM_DISABLE) {
                        ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_INVALID, throwable, pluginHost);
                        break;
                    }
                    if (pluginException.getValue() == (long)PluginException.VALUE_ID_PREMIUM_TEMP_DISABLE) {
                        ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_UNAVAILABLE, throwable, pluginHost);
                        break;
                    }
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.ACCOUNT_ERROR, throwable, pluginHost);
                    break;
                }
                case 16384: {
                    if (pluginException.getValue() == 2L) {
                        ret = new DownloadLinkCandidateResult(SkipReason.INVALID_DESTINATION, throwable, pluginHost);
                        break;
                    }
                    if (pluginException.getValue() == 1L) {
                        ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                        break;
                    }
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FAILED, throwable, pluginHost);
                    break;
                }
                case 512: {
                    if (pluginException.getValue() == 1L) {
                        ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.CONNECTION_ISSUES, throwable, pluginHost);
                        break;
                    }
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FAILED_INCOMPLETE, throwable, pluginHost);
                    break;
                }
                case 8192: {
                    ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FAILED_EXISTS, throwable, pluginHost);
                }
            }
            if (ret == null) {
                logger.info("Plugin Defect.2");
                ret = new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, throwable, pluginHost);
            }
            ret.setWaitTime(waitTime);
            ret.setMessage(message);
            return ret;
        }
        if (result.getController().isAborting()) {
            if (result.getController().getLinkStatus().getStatus() == 2) {
                return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FINISHED, throwable, pluginHost);
            }
            return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.STOPPED, throwable, pluginHost);
        }
        if (result.getController().getLinkStatus().getStatus() == 2) {
            return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.FINISHED, throwable, pluginHost);
        }
        logger.info("Plugin Defect.3");
        return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PLUGIN_DEFECT, throwable, pluginHost);
    }

    private Set<DownloadLink> finalizeConditionalSkipReasons(DownloadSession currentSession, List<DownloadLink> downloadLinksWithConditionalSkipReasons) {
        return this.finalizeConditionalSkipReasons((Iterable<DownloadLink>)new ConcatIterator(new Iterator[]{currentSession.getForcedLinks().iterator(), currentSession.getActivationRequests().iterator()}), downloadLinksWithConditionalSkipReasons);
    }

    private Set<DownloadLink> finalizeConditionalSkipReasons(Iterable<DownloadLink> links, List<DownloadLink> downloadLinksWithConditionalSkipReasons) {
        HashSet<DownloadLink> ret = new HashSet<DownloadLink>();
        ArrayList<DownloadLink> again = new ArrayList<DownloadLink>();
        for (DownloadLink link : links) {
            ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
            if (conditionalSkipReason == null) continue;
            if (conditionalSkipReason.isConditionReached()) {
                link.setConditionalSkipReason(null);
                conditionalSkipReason.finalize(link);
                if (link.getFinalLinkState() == null) continue;
                ret.add(link);
                continue;
            }
            again.add(link);
        }
        int size = again.size();
        while (size > 0) {
            int finalized = 0;
            for (int index = 0; index < size; ++index) {
                DownloadLink link = (DownloadLink)again.get(index);
                ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
                if (conditionalSkipReason == null || !conditionalSkipReason.isConditionReached()) continue;
                link.setConditionalSkipReason(null);
                conditionalSkipReason.finalize(link);
                ++finalized;
                if (link.getFinalLinkState() == null) continue;
                ret.add(link);
            }
            if (finalized != 0) continue;
            break;
        }
        if (downloadLinksWithConditionalSkipReasons != null) {
            for (int index = 0; index < size; ++index) {
                DownloadLink link = (DownloadLink)again.get(index);
                ConditionalSkipReason conditionalSkipReason = link.getConditionalSkipReason();
                if (conditionalSkipReason == null) continue;
                downloadLinksWithConditionalSkipReasons.add(link);
            }
        }
        return ret;
    }

    private synchronized void startDownloadJobExecuter() {
        Thread thread = new Thread(){

            @Override
            public void interrupt() {
                DownloadWatchDog.this.logger.log((Throwable)new RuntimeException("WatchDog(" + this.getName() + ") interrupted!"));
                super.interrupt();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                this.setName("WatchDog: jobExecuter");
                while (true) {
                    block19: {
                        block18: {
                            Object object = DownloadWatchDog.this.WATCHDOGLOCK;
                            // MONITORENTER : object
                            if (DownloadWatchDog.this.isWatchDogThread()) break block18;
                            // MONITOREXIT : object
                            DownloadWatchDog.this.currentWatchDogThread.compareAndSet((Object)Thread.currentThread(), null);
                            return;
                        }
                        30.interrupted();
                        if (!DownloadWatchDog.this.hasWaitingJobs()) {
                            DownloadWatchDog.this.WATCHDOGLOCK.wait();
                        }
                        if (DownloadWatchDog.this.isWatchDogThread()) break block19;
                        // MONITOREXIT : object
                        {
                            catch (Throwable e) {
                                DownloadWatchDog.this.logger.log(e);
                                DownloadWatchDog.this.currentWatchDogThread.compareAndSet((Object)Thread.currentThread(), null);
                                return;
                            }
                        }
                        DownloadWatchDog.this.currentWatchDogThread.compareAndSet((Object)Thread.currentThread(), null);
                        return;
                    }
                    try {
                        // MONITOREXIT : object
                        LinkedList linkedList = DownloadWatchDog.this.watchDogJobs;
                        // MONITORENTER : linkedList
                        DownloadWatchDogJob job = (DownloadWatchDogJob)DownloadWatchDog.this.watchDogJobs.poll();
                        // MONITOREXIT : linkedList
                        if (job == null) continue;
                        try {
                            DownloadWatchDog.this.currentWatchDogJob.set((Object)job);
                            job.execute(DownloadWatchDog.this.getSession());
                            continue;
                        }
                        catch (Throwable e) {
                            DownloadWatchDog.this.logger.log(e);
                            continue;
                        }
                        finally {
                            DownloadWatchDog.this.currentWatchDogJob.set(null);
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        DownloadWatchDog.this.currentWatchDogThread.compareAndSet((Object)Thread.currentThread(), null);
                        throw throwable;
                    }
                    break;
                }
            }
        };
        thread.setDaemon(true);
        this.currentWatchDogThread.set((Object)thread);
        thread.start();
    }

    private boolean isReconnectPossible(List<ProxyInfoHistory.WaitingSkipReasonContainer> reconnectRequests) {
        if (CFG_RECONNECT.CFG.isReconnectAllowedToInterruptResumableDownloads()) {
            for (SingleDownloadController con : this.getSession().getControllers()) {
                if (!con.getDownloadLink().isResumeable()) {
                    return false;
                }
                for (ProxyInfoHistory.WaitingSkipReasonContainer reconnectRequest : reconnectRequests) {
                    if (!StringUtils.equals((String)reconnectRequest.getDlHost(), (String)con.getDownloadLink().getHost())) continue;
                    return false;
                }
            }
            return true;
        }
        return this.getSession().getControllers().size() == 0;
    }

    private boolean isReconnectRequired(DownloadSession currentSession, ProxyInfoHistory.WaitingSkipReasonContainer reconnectRequest) {
        ConditionalSkipReason conditionalSkipReason;
        if (!reconnectRequest.getProxySelector().isReconnectSupported()) {
            return false;
        }
        HashSet<DownloadLink> alreadyChecked = new HashSet<DownloadLink>();
        for (DownloadLink link : currentSession.getForcedLinks()) {
            if (!alreadyChecked.add(link) || this.canRemove(link, true) || (conditionalSkipReason = link.getConditionalSkipReason()) == null) continue;
            if (conditionalSkipReason instanceof WaitWhileWaitingSkipReasonIsSet) {
                conditionalSkipReason = ((WaitWhileWaitingSkipReasonIsSet)conditionalSkipReason).getConditionalSkipReason();
            }
            if (!(conditionalSkipReason instanceof WaitingSkipReason) || !StringUtils.equals((String)reconnectRequest.getDlHost(), (String)link.getHost())) continue;
            return true;
        }
        if (!currentSession.isForcedOnlyModeEnabled()) {
            for (DownloadLink link : currentSession.getActivationRequests()) {
                if (!alreadyChecked.add(link) || this.canRemove(link, false) || (conditionalSkipReason = link.getConditionalSkipReason()) == null) continue;
                if (conditionalSkipReason instanceof WaitWhileWaitingSkipReasonIsSet) {
                    conditionalSkipReason = ((WaitWhileWaitingSkipReasonIsSet)conditionalSkipReason).getConditionalSkipReason();
                }
                if (!(conditionalSkipReason instanceof WaitingSkipReason) || !StringUtils.equals((String)reconnectRequest.getDlHost(), (String)link.getHost())) continue;
                return true;
            }
        }
        return false;
    }

    private void validateProxyInfoHistory() {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.isAutoReconnectEnabled()) {
                    ProxyInfoHistory proxyInfoHistory = currentSession.getProxyInfoHistory();
                    proxyInfoHistory.validate();
                    List<ProxyInfoHistory.WaitingSkipReasonContainer> reconnectRequests = proxyInfoHistory.list(WaitingSkipReason.CAUSE.IP_BLOCKED, null);
                    if (reconnectRequests != null) {
                        for (ProxyInfoHistory.WaitingSkipReasonContainer reconnectRequest : reconnectRequests) {
                            if (!DownloadWatchDog.this.isReconnectRequired(currentSession, reconnectRequest)) continue;
                            currentSession.compareAndSetSessionState(DownloadSession.SessionState.NORMAL, DownloadSession.SessionState.RECONNECT_REQUESTED);
                            if (currentSession.getSessionState() == DownloadSession.SessionState.RECONNECT_REQUESTED && DownloadWatchDog.this.isReconnectPossible(reconnectRequests)) {
                                DownloadWatchDog.this.invokeReconnect(currentSession);
                            }
                            return;
                        }
                    }
                }
                currentSession.compareAndSetSessionState(DownloadSession.SessionState.RECONNECT_REQUESTED, DownloadSession.SessionState.NORMAL);
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
    }

    private ReconnectThread invokeReconnect(DownloadSession currentSession) {
        Thread ret;
        while ((ret = (Thread)this.reconnectThread.get()) == null) {
            ret = new ReconnectThread();
            if (!this.reconnectThread.compareAndSet(null, (Object)ret)) continue;
            if (this.isWatchDogThread() && currentSession != null) {
                currentSession.setSessionState(DownloadSession.SessionState.RECONNECT_RUNNING);
            }
            DownloadWatchDogJob job = new DownloadWatchDogJob(){

                @Override
                public void execute(DownloadSession currentSession) {
                    currentSession.setSessionState(DownloadSession.SessionState.RECONNECT_RUNNING);
                    if (currentSession.getControllers().size() > 0) {
                        for (SingleDownloadController con : DownloadWatchDog.this.getSession().getControllers()) {
                            if (!con.isAlive() || con.isAborting()) continue;
                            con.abort();
                        }
                        DownloadWatchDog.this.enqueueJob(this);
                    } else {
                        ((Thread)DownloadWatchDog.this.reconnectThread.get()).start();
                    }
                }

                @Override
                public void interrupt() {
                }

                @Override
                public boolean isHighPriority() {
                    return false;
                }
            };
            this.enqueueJob(job);
        }
        return (ReconnectThread)ret;
    }

    public Reconnecter.ReconnectResult requestReconnect(boolean waitForResult) throws InterruptedException {
        ReconnectThread thread = this.invokeReconnect(null);
        if (waitForResult) {
            return thread.waitForResult();
        }
        return null;
    }

    protected DownloadWatchDogJob getCurrentDownloadWatchDogJob() {
        return (DownloadWatchDogJob)this.currentWatchDogJob.get();
    }

    public void unSkipAllSkipped() {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void interrupt() {
            }

            @Override
            public void execute(DownloadSession currentSession) {
                List<DownloadLink> unSkip = DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

                    @Override
                    public int returnMaxResults() {
                        return 0;
                    }

                    @Override
                    public boolean acceptNode(DownloadLink node) {
                        return node.isSkipped();
                    }
                });
                DownloadWatchDog.this.unSkip(unSkip);
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasWaitingJobs() {
        LinkedList<DownloadWatchDogJob> linkedList = this.watchDogJobs;
        synchronized (linkedList) {
            return this.watchDogJobs.peek() != null;
        }
    }

    private synchronized void startDownloadWatchDog() {
        this.stateMachine.setStatus(RUNNING_STATE);
        Thread thread = new Thread(){
            protected final int maxWaitTimeout = 5000;

            @Override
            public void interrupt() {
                DownloadWatchDog.this.logger.log((Throwable)new RuntimeException("WatchDog(" + this.getName() + ") interrupted!"));
                super.interrupt();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            protected final void processJobs() {
                try {
                    DownloadWatchDogJob job;
                    DownloadWatchDog.this.setTempWatchDogJobThread(Thread.currentThread());
                    DownloadWatchDogJob peekLast = null;
                    do {
                        LinkedList linkedList = DownloadWatchDog.this.watchDogJobs;
                        synchronized (linkedList) {
                            if (peekLast == null) {
                                peekLast = (DownloadWatchDogJob)DownloadWatchDog.this.watchDogJobs.peekLast();
                            }
                            job = (DownloadWatchDogJob)DownloadWatchDog.this.watchDogJobs.poll();
                        }
                        if (job == null) return;
                        try {
                            DownloadWatchDog.this.currentWatchDogJob.set((Object)job);
                            job.execute(DownloadWatchDog.this.getSession());
                        }
                        catch (Throwable e) {
                            DownloadWatchDog.this.logger.log(e);
                        }
                        finally {
                            DownloadWatchDog.this.currentWatchDogJob.set(null);
                        }
                    } while (job != peekLast);
                    return;
                }
                finally {
                    DownloadWatchDog.this.setTempWatchDogJobThread(null);
                }
            }

            private void removeLink(final DownloadLink link, DownloadSession session) {
                session.removeActivationRequest(link);
                SingleDownloadController con = link.getDownloadLinkController();
                if (con != null) {
                    con.getJobsAfterDetach().add(new DownloadWatchDogJob(){

                        @Override
                        public void execute(DownloadSession currentSession) {
                            link.setConditionalSkipReason(null);
                            currentSession.removeHistory(link);
                        }

                        @Override
                        public void interrupt() {
                        }

                        @Override
                        public boolean isHighPriority() {
                            return false;
                        }
                    });
                    con.abort();
                } else {
                    link.setConditionalSkipReason(null);
                    session.removeHistory(link);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block35: {
                    Object finalLinkStateLinks;
                    this.setName("WatchDog: downloadWatchDog");
                    boolean jobExecuterStarted = false;
                    DownloadControllerListener listener = null;
                    AccountControllerListener accListener = null;
                    HosterRuleControllerListener hrcListener = null;
                    DefaultEventListener<ProxyEvent<AbstractProxySelectorImpl>> proxyListener = null;
                    final AtomicLong lastStructureChange = new AtomicLong(-1L);
                    AtomicLong lastActivatorRequestRebuild = new AtomicLong(-1L);
                    long waitedForNewActivationRequests = 0L;
                    FileBytesCache hardReferenceFileBytesCache = DownloadSession.getDownloadWriteCache();
                    try {
                        DownloadWatchDog.this.unSkipAllSkipped();
                        proxyListener = new DefaultEventListener<ProxyEvent<AbstractProxySelectorImpl>>(){
                            final DelayedRunnable delayer = new DelayedRunnable(1000L, 5000L){

                                public void delayedrun() {
                                    DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                        @Override
                                        public void interrupt() {
                                        }

                                        @Override
                                        public void execute(DownloadSession currentSession) {
                                            List<DownloadLink> unSkip = DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

                                                @Override
                                                public int returnMaxResults() {
                                                    return 0;
                                                }

                                                @Override
                                                public boolean acceptNode(DownloadLink node) {
                                                    return SkipReason.CONNECTION_UNAVAILABLE.equals((Object)node.getSkipReason());
                                                }
                                            });
                                            DownloadWatchDog.this.unSkip(unSkip);
                                        }

                                        @Override
                                        public boolean isHighPriority() {
                                            return false;
                                        }
                                    });
                                }
                            };

                            public void onEvent(ProxyEvent<AbstractProxySelectorImpl> event) {
                                this.delayer.delayedrun();
                            }
                        };
                        ProxyController.getInstance().getEventSender().addListener((EventListener)proxyListener, true);
                        hrcListener = new HosterRuleControllerListener(){

                            private void removeAccountCache(final String host) {
                                if (host != null) {
                                    DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                        @Override
                                        public void execute(DownloadSession currentSession) {
                                            currentSession.removeAccountCache(host);
                                        }

                                        @Override
                                        public void interrupt() {
                                        }

                                        @Override
                                        public boolean isHighPriority() {
                                            return false;
                                        }
                                    });
                                }
                            }

                            @Override
                            public void onRuleAdded(AccountUsageRule parameter) {
                                if (parameter != null) {
                                    this.removeAccountCache(parameter.getHoster());
                                }
                            }

                            @Override
                            public void onRuleDataUpdate(AccountUsageRule parameter) {
                                if (parameter != null) {
                                    this.removeAccountCache(parameter.getHoster());
                                }
                            }

                            @Override
                            public void onRuleRemoved(AccountUsageRule parameter) {
                                if (parameter != null) {
                                    this.removeAccountCache(parameter.getHoster());
                                }
                            }

                            @Override
                            public void onRuleStructureUpdate() {
                            }
                        };
                        HosterRuleController.getInstance().getEventSender().addListener(hrcListener, true);
                        accListener = new AccountControllerListener(){

                            @Override
                            public void onAccountControllerEvent(final AccountControllerEvent event) {
                                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        List<String> multiHostList;
                                        currentSession.removeAccountCache(event.getAccount().getHoster());
                                        AccountInfo ai = event.getAccount().getAccountInfo();
                                        if (ai != null && (multiHostList = ai.getMultiHostSupport()) != null) {
                                            for (String multiHost : multiHostList) {
                                                currentSession.removeAccountCache(multiHost);
                                            }
                                        }
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }
                                });
                            }
                        };
                        AccountController.getInstance().getEventSender().addListener((EventListener)accListener, true);
                        listener = new DownloadControllerListener(){

                            @Override
                            public void onDownloadControllerAddedPackage(FilePackage pkg) {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerStructureRefresh(FilePackage pkg) {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerStructureRefresh() {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerRemovedPackage(final FilePackage fp) {
                                lastStructureChange.set(-1L);
                                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        currentSession.setOnFileExistsAction(fp, null);
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }
                                });
                            }

                            @Override
                            public void onDownloadControllerRemovedLinklist(final List<DownloadLink> list) {
                                lastStructureChange.set(-1L);
                                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        for (DownloadLink item : list) {
                                            this.removeLink(item, currentSession);
                                        }
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }
                                });
                            }

                            @Override
                            public void onDownloadControllerUpdatedData(DownloadLink dl, DownloadLinkProperty dlProperty) {
                                lastStructureChange.set(-1L);
                                if (dl != null) {
                                    final DownloadLink link = dlProperty.getDownloadLink();
                                    switch (dlProperty.getProperty()) {
                                        case PRIORITY: {
                                            DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                                @Override
                                                public void execute(DownloadSession currentSession) {
                                                    if (link.isEnabled()) {
                                                        currentSession.incrementActivatorRebuildRequest();
                                                    }
                                                }

                                                @Override
                                                public void interrupt() {
                                                }

                                                @Override
                                                public boolean isHighPriority() {
                                                    return false;
                                                }
                                            });
                                            break;
                                        }
                                        case ENABLED: {
                                            DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                                @Override
                                                public void execute(DownloadSession currentSession) {
                                                    if (!link.isEnabled()) {
                                                        this.removeLink(link, currentSession);
                                                    } else {
                                                        currentSession.incrementActivatorRebuildRequest();
                                                    }
                                                }

                                                @Override
                                                public void interrupt() {
                                                }

                                                @Override
                                                public boolean isHighPriority() {
                                                    return false;
                                                }
                                            });
                                            break;
                                        }
                                        case SKIPPED: {
                                            DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                                @Override
                                                public void execute(DownloadSession currentSession) {
                                                    if (link.getSkipReason() != null) {
                                                        this.removeLink(link, currentSession);
                                                    } else {
                                                        currentSession.incrementActivatorRebuildRequest();
                                                    }
                                                }

                                                @Override
                                                public void interrupt() {
                                                }

                                                @Override
                                                public boolean isHighPriority() {
                                                    return false;
                                                }
                                            });
                                            break;
                                        }
                                        case FINAL_STATE: {
                                            DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                                @Override
                                                public void execute(DownloadSession currentSession) {
                                                    if (link.getFinalLinkState() != null) {
                                                        this.removeLink(link, currentSession);
                                                    } else {
                                                        currentSession.incrementActivatorRebuildRequest();
                                                    }
                                                }

                                                @Override
                                                public void interrupt() {
                                                }

                                                @Override
                                                public boolean isHighPriority() {
                                                    return false;
                                                }
                                            });
                                        }
                                    }
                                }
                            }

                            @Override
                            public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
                                lastStructureChange.set(-1L);
                            }

                            @Override
                            public void onDownloadControllerUpdatedData(FilePackage pkg) {
                                lastStructureChange.set(-1L);
                            }
                        };
                        DownloadController.getInstance().addListener(listener, true);
                        while (DownloadWatchDog.this.stateMachine.isState(new State[]{RUNNING_STATE, PAUSE_STATE})) {
                            long currentStructure = DownloadController.getInstance().getPackageControllerChanges();
                            long currentActivatorRequestRebuild = DownloadWatchDog.this.getSession().getActivatorRebuildRequest();
                            if (lastStructureChange.getAndSet(currentStructure) != currentStructure || lastActivatorRequestRebuild.getAndSet(currentActivatorRequestRebuild) != currentActivatorRequestRebuild) {
                                final AtomicInteger skippedLinksCounterTmp = new AtomicInteger(0);
                                List<DownloadLink> links = DownloadController.getInstance().getChildrenByFilter(new AbstractPackageChildrenNodeFilter<DownloadLink>(){

                                    @Override
                                    public int returnMaxResults() {
                                        return 0;
                                    }

                                    @Override
                                    public boolean acceptNode(DownloadLink node) {
                                        if (node.isSkipped()) {
                                            skippedLinksCounterTmp.incrementAndGet();
                                            return false;
                                        }
                                        if (DownloadWatchDog.this.canRemove(node, false)) {
                                            node.setConditionalSkipReason(null);
                                            return false;
                                        }
                                        return true;
                                    }
                                });
                                DownloadWatchDog.this.getSession().setSkipCounter(skippedLinksCounterTmp.get());
                                DownloadWatchDog.this.getSession().setActivationRequests(new CopyOnWriteArrayList<DownloadLink>(DownloadWatchDog.this.sortActivationRequests(links)));
                                DownloadWatchDog.this.eventSender.fireEvent((DefaultEvent)new DownloadWatchdogEvent(this, DownloadWatchdogEvent.Type.DATA_UPDATE, new Object[0]));
                            }
                            try {
                                int before;
                                ArrayList downloadLinksWithConditionalSkipReasons = new ArrayList();
                                do {
                                    before = DownloadWatchDog.this.getSession().getControllers().size();
                                    DownloadWatchDog.this.validateProxyInfoHistory();
                                    this.processJobs();
                                    Set finalLinkStateLinks2 = DownloadWatchDog.this.finalizeConditionalSkipReasons(DownloadWatchDog.this.getSession(), (List<DownloadLink>)downloadLinksWithConditionalSkipReasons);
                                    DownloadWatchDog.this.handleFinalLinkStates(finalLinkStateLinks2, DownloadWatchDog.this.getSession(), DownloadWatchDog.this.logger, null);
                                } while (before != DownloadWatchDog.this.getSession().getControllers().size());
                                if (DownloadWatchDog.this.newDLStartAllowed(DownloadWatchDog.this.getSession())) {
                                    DownloadWatchDog.this.activateDownloads(downloadLinksWithConditionalSkipReasons);
                                }
                                if (DownloadWatchDog.this.getSession().getControllers().size() == 0 && DownloadWatchDog.this.getSession().isStopMarkReached()) {
                                    DownloadWatchDog.this.logger.info("Wait at least " + Math.max(0L, 5000L - waitedForNewActivationRequests) + " for new change in StopMark(reached)");
                                } else if (DownloadWatchDog.this.getSession().getControllers().size() > 0 || lastActivatorRequestRebuild.get() != DownloadWatchDog.this.getSession().getActivatorRebuildRequest() || lastStructureChange.get() != DownloadController.getInstance().getPackageControllerChanges() || DownloadWatchDog.this.getSession().isActivationRequestsWaiting()) {
                                    waitedForNewActivationRequests = 0L;
                                } else {
                                    DownloadWatchDog.this.logger.info("Wait at least " + Math.max(0L, 5000L - waitedForNewActivationRequests) + " for new ActivationRequests");
                                }
                                if (waitedForNewActivationRequests > 5000L) {
                                    DownloadWatchDog.this.logger.info("Waited " + waitedForNewActivationRequests + " but no new ActivationRequests are available->Stop DownloadWatchDog");
                                    break;
                                }
                            }
                            catch (Exception e) {
                                DownloadWatchDog.this.logger.log((Throwable)e);
                            }
                            try {
                                int round = 0;
                                Object object = DownloadWatchDog.this.WATCHDOGLOCK;
                                synchronized (object) {
                                    while (!DownloadWatchDog.this.hasWaitingJobs() && ++round < 4 && DownloadWatchDog.this.stateMachine.isState(new State[]{RUNNING_STATE, PAUSE_STATE})) {
                                        long currentTimeStamp = System.currentTimeMillis();
                                        DownloadWatchDog.this.WATCHDOGLOCK.wait(1250L);
                                        waitedForNewActivationRequests += System.currentTimeMillis() - currentTimeStamp;
                                        if (DownloadWatchDog.this.getSession().isActivationRequestsWaiting() || DownloadWatchDog.this.getActiveDownloads() != 0) continue;
                                        break;
                                    }
                                }
                            }
                            catch (InterruptedException e) {
                                DownloadWatchDog.this.logger.log((Throwable)e);
                            }
                        }
                        DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                            @Override
                            public void execute(DownloadSession currentSession) {
                                DownloadWatchDog.this.stateMachine.setStatus(STOPPING_STATE);
                            }

                            @Override
                            public void interrupt() {
                            }

                            @Override
                            public boolean isHighPriority() {
                                return true;
                            }
                        });
                        DownloadController.getInstance().removeListener(listener);
                        AccountController.getInstance().getEventSender().removeListener((EventListener)accListener);
                        HosterRuleController.getInstance().getEventSender().removeListener(hrcListener);
                        ProxyController.getInstance().getEventSender().removeListener((EventListener)proxyListener);
                        DownloadWatchDog.this.logger.info("DownloadWatchDog: stopping");
                        DownloadWatchDog currentStructure = DownloadWatchDog.this;
                        synchronized (currentStructure) {
                            DownloadWatchDog.this.startDownloadJobExecuter();
                            jobExecuterStarted = !DownloadWatchDog.this.isWatchDogThread();
                        }
                        DownloadWatchDog.this.abortAllSingleDownloadControllers();
                        finalLinkStateLinks = DownloadWatchDog.this.finalizeConditionalSkipReasons(DownloadWatchDog.this.getSession(), (List<DownloadLink>)null);
                        DownloadWatchDog.this.handleFinalLinkStates((Set)finalLinkStateLinks, DownloadWatchDog.this.getSession(), DownloadWatchDog.this.logger, null);
                        DownloadWatchDog.this.clearDownloadListStatus();
                        DownloadWatchDog.this.pauseDownloadWatchDog(false);
                        if (DownloadWatchDog.this.getSession().isStopMarkReached()) {
                            DownloadWatchDog.this.getSession().setStopMark((Object)DownloadSession.STOPMARK.NONE);
                        }
                        if (jobExecuterStarted) break block35;
                        finalLinkStateLinks = DownloadWatchDog.this;
                    }
                    catch (Throwable e2) {
                        block36: {
                            DownloadWatchDog e2;
                            try {
                                DownloadWatchDog.this.logger.log(e2);
                                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(){

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        DownloadWatchDog.this.stateMachine.setStatus(STOPPING_STATE);
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return true;
                                    }
                                });
                                if (jobExecuterStarted) break block36;
                                e2 = DownloadWatchDog.this;
                            }
                            catch (Throwable throwable) {
                                if (!jobExecuterStarted) {
                                    DownloadWatchDog downloadWatchDog = DownloadWatchDog.this;
                                    synchronized (downloadWatchDog) {
                                        DownloadWatchDog.this.startDownloadJobExecuter();
                                    }
                                }
                                DownloadWatchDog.this.logger.info("DownloadWatchDog: stopped");
                                DownloadSession latestSession = DownloadWatchDog.this.getSession();
                                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(latestSession){
                                    final /* synthetic */ DownloadSession val$latestSession;
                                    {
                                        this.val$latestSession = downloadSession;
                                    }

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        try {
                                            this.val$latestSession.removeHistory(null);
                                            this.val$latestSession.removeAccountCache(null);
                                            this.val$latestSession.clearPluginCache();
                                            this.val$latestSession.getActivationRequests().clear();
                                            this.val$latestSession.getForcedLinks().clear();
                                            this.val$latestSession.setOnFileExistsAction(null, null);
                                        }
                                        finally {
                                            DownloadWatchDog.this.stateMachine.setStatus(STOPPED_STATE);
                                        }
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return true;
                                    }
                                });
                                throw throwable;
                            }
                            synchronized (e2) {
                                DownloadWatchDog.this.startDownloadJobExecuter();
                            }
                        }
                        DownloadWatchDog.this.logger.info("DownloadWatchDog: stopped");
                        DownloadSession latestSession = DownloadWatchDog.this.getSession();
                        DownloadWatchDog.this.enqueueJob(new /* invalid duplicate definition of identical inner class */);
                    }
                    synchronized (finalLinkStateLinks) {
                        DownloadWatchDog.this.startDownloadJobExecuter();
                    }
                }
                DownloadWatchDog.this.logger.info("DownloadWatchDog: stopped");
                DownloadSession latestSession = DownloadWatchDog.this.getSession();
                DownloadWatchDog.this.enqueueJob(new /* invalid duplicate definition of identical inner class */);
            }
        };
        thread.setDaemon(true);
        this.currentWatchDogThread.set((Object)thread);
        thread.start();
    }

    public void stopDownloads() {
        DownloadWatchDogJob job = this.getCurrentDownloadWatchDogJob();
        if (job != null) {
            job.interrupt();
        }
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.stateMachine.isFinal() || DownloadWatchDog.this.stateMachine.isStartState()) {
                    return;
                }
                if (DownloadWatchDog.this.stateMachine.isState(new State[]{STOPPING_STATE})) {
                    return;
                }
                DownloadWatchDog.this.stateMachine.setStatus(STOPPING_STATE);
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public void toggleStartStop() {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                if (DownloadWatchDog.this.stateMachine.isStartState() || DownloadWatchDog.this.stateMachine.isFinal()) {
                    DownloadWatchDog.this.startDownloads();
                } else {
                    DownloadWatchDog.this.stopDownloads();
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    @Deprecated
    public StateMachine getStateMachine() {
        return this.stateMachine;
    }

    @Override
    public void onNewFile(Object obj, File[] list) {
        if (((GeneralSettings)JsonConfig.create(GeneralSettings.class)).isAutoOpenContainerAfterDownload() && list != null && list.length > 0) {
            String source;
            final ArrayList<String> files = new ArrayList<String>();
            for (File file : list) {
                files.add(file.toURI().toString());
            }
            if (obj instanceof SingleDownloadController) {
                String url = ((SingleDownloadController)obj).getDownloadLink().getContentUrl();
                if (url == null) {
                    url = ((SingleDownloadController)obj).getDownloadLink().getContentUrl();
                }
                source = url;
            } else {
                source = null;
            }
            HashSet<String> handled = new HashSet<String>();
            for (PluginsC pCon : ContainerPluginController.getInstance().list()) {
                for (String file : files) {
                    if (!pCon.canHandle(file) || !handled.add(file)) continue;
                    TaskQueue.getQueue().addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

                        protected Void run() throws RuntimeException {
                            StringBuilder sb = new StringBuilder();
                            for (String file : files) {
                                if (sb.length() > 0) {
                                    sb.append("\r\n");
                                }
                                sb.append(file);
                            }
                            LinkCollector.getInstance().addCrawlerJob(new LinkCollectingJob(LinkOriginDetails.getInstance(LinkOrigin.DOWNLOADED_CONTAINER, source), sb.toString()));
                            return null;
                        }

                        protected boolean allowAsync() {
                            return true;
                        }
                    });
                }
            }
        }
    }

    public static boolean looksLikeTooLongWindowsPathOrFilename(File file) throws IOException {
        String[] folders;
        for (String folder : folders = CrossSystem.getPathComponents((File)file)) {
            if (!DownloadWatchDog.looksLikeTooLongWindowsPathSegment(folder)) continue;
            return true;
        }
        return false;
    }

    public static boolean looksLikeTooLongWindowsPathSegment(String str) throws IOException {
        return str.length() > 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void localFileCheck(final SingleDownloadController controller, final ExceptionRunnable runOkay, final ExceptionRunnable runFailed) throws Exception {
        final NullsafeAtomicReference asyncResult = new NullsafeAtomicReference(null);
        this.enqueueJob(new DownloadWatchDogJob(){

            private void check(DownloadSession session, final SingleDownloadController controller2) throws Exception {
                boolean fileExists;
                File fileOutput;
                MirrorDetectionDecision mirrorDetectionDecision;
                DownloadLink downloadLink;
                block49: {
                    if (controller2.isAborting()) {
                        throw new InterruptedException("Controller is aborted");
                    }
                    downloadLink = controller2.getDownloadLink();
                    mirrorDetectionDecision = DownloadWatchDog.this.config.getMirrorDetectionDecision();
                    fileOutput = controller2.getFileOutput(false, true);
                    if (fileOutput.isDirectory()) {
                        controller2.getLogger().severe("fileOutput is a directory " + fileOutput);
                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                    }
                    fileExists = fileOutput.exists();
                    if (!fileExists) {
                        try {
                            DownloadWatchDog.this.validateDestination(fileOutput);
                        }
                        catch (PathTooLongException e) {
                            controller2.getLogger().severe("not allowed to create path " + e.getFile());
                            throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                        }
                        catch (BadDestinationException e) {
                            controller2.getLogger().severe("not allowed to create path " + e.getFile());
                            throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                        }
                        if (fileOutput.getParentFile() == null) {
                            controller2.getLogger().severe("has no parentFile?! " + fileOutput);
                            throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                        }
                        if (!fileOutput.getParentFile().exists() && !fileOutput.getParentFile().mkdirs()) {
                            controller2.getLogger().severe("could not mkdirs parentFile: " + fileOutput.getParent());
                            if (CrossSystem.isWindows() && DownloadWatchDog.looksLikeTooLongWindowsPathOrFilename(fileOutput)) {
                                controller2.getLogger().severe("Looks like too long downloadpath for Windows: " + fileOutput.getParent());
                            }
                            throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                        }
                        if (!accessChecks.contains(fileOutput.getParentFile().getAbsolutePath())) {
                            File writeTest = new File(fileOutput.getParentFile(), "jd_accessCheck_" + new UniqueAlltimeID().getID());
                            try {
                                if (!writeTest.exists()) {
                                    try {
                                        RandomAccessFile raf = IO.open((File)writeTest, (String)"rw");
                                        raf.close();
                                    }
                                    catch (IOException e) {
                                        throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
                                    }
                                } else if (!writeTest.canWrite()) {
                                    throw new SkipReasonException(SkipReason.INVALID_DESTINATION);
                                }
                                accessChecks.add(fileOutput.getParentFile().getAbsolutePath());
                                if (writeTest.delete()) break block49;
                                controller2.getJobsAfterDetach().add(new DownloadWatchDogJob(writeTest){
                                    final /* synthetic */ File val$writeTest;
                                    {
                                        this.val$writeTest = file;
                                    }

                                    @Override
                                    public void interrupt() {
                                    }

                                    @Override
                                    public void execute(DownloadSession currentSession) {
                                        this.val$writeTest.delete();
                                    }

                                    @Override
                                    public boolean isHighPriority() {
                                        return false;
                                    }
                                });
                            }
                            catch (Exception e) {
                                try {
                                    LogSource.exception((LogInterface)controller2.getLogger(), (Throwable)e);
                                    if (e instanceof SkipReasonException) {
                                        throw (SkipReasonException)e;
                                    }
                                    throw new SkipReasonException(SkipReason.INVALID_DESTINATION, e);
                                }
                                catch (Throwable throwable) {
                                    if (!writeTest.delete()) {
                                        controller2.getJobsAfterDetach().add(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    throw throwable;
                                }
                            }
                        }
                    }
                }
                if (!DownloadWatchDog.this.config.isAllowUnsafeFileNameForFileExistsCheck() && controller2.getDownloadInstance() == null && controller2.getFileOutput(true, true) == null) {
                    return;
                }
                DownloadLink fileInProgress = null;
                if (!fileExists) {
                    Object checkFile;
                    String fileName = MirrorDetectionDecision.SAFE.equals((Object)mirrorDetectionDecision) ? ((checkFile = controller2.getFileOutput(true, true)) != null ? ((File)checkFile).getName() : downloadLink.getName(true, false)) : fileOutput.getName();
                    for (SingleDownloadController downloadController : session.getControllers()) {
                        DownloadLink block;
                        if (downloadController == controller2 || (block = downloadController.getDownloadLink()) == downloadLink || !session.getFileAccessManager().isLockedBy(fileOutput, downloadController)) continue;
                        if (block.getFilePackage() == downloadLink.getFilePackage() && DownloadWatchDog.this.isMirrorCandidate(downloadLink, fileName, block, mirrorDetectionDecision)) {
                            throw new ConditionalSkipReasonException(new MirrorLoading(block));
                        }
                        fileInProgress = block;
                        break;
                    }
                }
                if (fileExists || fileInProgress != null) {
                    DownloadSession currentSession;
                    IfFileExistsAction doAction = DownloadWatchDog.this.config.getIfFileExistsAction();
                    if (!(doAction != null && IfFileExistsAction.ASK_FOR_EACH_FILE != doAction || (doAction = (currentSession = DownloadWatchDog.this.getSession()).getOnFileExistsAction(downloadLink.getFilePackage())) != null && doAction != IfFileExistsAction.ASK_FOR_EACH_FILE)) {
                        IfFileExistsDialogInterface io = new IfFileExistsDialog(downloadLink, fileInProgress).show();
                        if (io.getCloseReason() == CloseReason.TIMEOUT) {
                            throw new SkipReasonException(SkipReason.FILE_EXISTS);
                        }
                        if (io.getCloseReason() == CloseReason.INTERRUPT) {
                            throw new InterruptedException("IFFileExistsDialog Interrupted");
                        }
                        doAction = io.getCloseReason() != CloseReason.OK ? IfFileExistsAction.SKIP_FILE : io.getAction();
                        if (doAction == null) {
                            doAction = IfFileExistsAction.SKIP_FILE;
                        }
                        if (io.isDontShowAgainSelected() && io.getCloseReason() == CloseReason.OK) {
                            currentSession.setOnFileExistsAction(downloadLink.getFilePackage(), doAction);
                        } else {
                            currentSession.setOnFileExistsAction(downloadLink.getFilePackage(), null);
                        }
                    }
                    switch (doAction) {
                        case SKIP_FILE: {
                            switch (CFG_GENERAL.CFG.getOnSkipDueToAlreadyExistsAction()) {
                                case SET_FILE_TO_SUCCESSFUL_MIRROR: {
                                    if (fileInProgress == null) {
                                        throw new DeferredRunnableException(new ExceptionRunnable(){

                                            @Override
                                            public void run() throws Exception {
                                                Downloadable downloadable;
                                                PluginForHost plugin = controller2.getProcessingPlugin();
                                                if (plugin != null && (downloadable = plugin.newDownloadable(downloadLink, null)) != null) {
                                                    switch (mirrorDetectionDecision) {
                                                        case AUTO: {
                                                            HashResult hashResult;
                                                            HashInfo hashInfo = downloadable.getHashInfo();
                                                            if (hashInfo != null && (hashResult = downloadable.getHashResult(hashInfo, fileOutput)) != null && hashResult.match()) {
                                                                downloadable.setHashResult(hashResult);
                                                                downloadLink.setDownloadCurrent(fileOutput.length());
                                                                throw new PluginException(2);
                                                            }
                                                        }
                                                        case FILENAME_FILESIZE: {
                                                            long fileSize = downloadable.getVerifiedFileSize();
                                                            if (fileSize < 0L || fileSize != fileOutput.length()) break;
                                                            downloadLink.setDownloadCurrent(fileOutput.length());
                                                            throw new PluginException(2);
                                                        }
                                                    }
                                                }
                                                throw new PluginException(8192);
                                            }
                                        });
                                    }
                                    throw new PluginException(8192);
                                }
                                case SET_FILE_TO_SUCCESSFUL: {
                                    throw new PluginException(2);
                                }
                            }
                            throw new PluginException(8192);
                        }
                        case OVERWRITE_FILE: {
                            if (fileInProgress != null) {
                                controller2.getLogger().severe("Cannot not overwrite file:" + fileOutput + "|Blocked by:" + fileInProgress);
                                throw new PluginException(8192);
                            }
                            if (fileOutput.delete()) break;
                            controller2.getLogger().severe("Could not overwrite file:" + fileOutput);
                            throw new PluginException(8192);
                        }
                        case AUTO_RENAME: {
                            String[] splitName = CrossSystem.splitFileName((String)fileOutput.getName());
                            String downloadPath = fileOutput.getParent();
                            String extension = splitName[1];
                            extension = extension == null ? "" : "." + extension;
                            String name = splitName[0];
                            long duplicateFilenameCounter = 2L;
                            String alreadyDuplicated = new Regex(name, ".*_(\\d+)$").getMatch(0);
                            if (alreadyDuplicated != null) {
                                duplicateFilenameCounter = Long.parseLong(alreadyDuplicated) + 1L;
                                name = new Regex(name, "(.*)_\\d+$").getMatch(0);
                            }
                            try {
                                File check = null;
                                String newName = null;
                                block21: do {
                                    if ((check = new File(downloadPath, newName = name + "_" + duplicateFilenameCounter++ + extension)).exists()) {
                                        check = null;
                                        continue;
                                    }
                                    for (SingleDownloadController downloadController : session.getControllers()) {
                                        if (downloadController == controller2 || !session.getFileAccessManager().isLockedBy(check, downloadController)) continue;
                                        check = null;
                                        continue block21;
                                    }
                                } while (check == null);
                                controller2.setSessionDownloadFilename(newName);
                                downloadLink.setForcedFileName(newName);
                                downloadLink.setChunksProgress(null);
                                break;
                            }
                            catch (Throwable e) {
                                LogSource.exception((LogInterface)controller2.getLogger(), (Throwable)e);
                                downloadLink.setForcedFileName(null);
                                throw new PluginException(8192);
                            }
                        }
                        default: {
                            throw new PluginException(8192);
                        }
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(DownloadSession currentSession) {
                try {
                    this.check(currentSession, controller);
                    if (runOkay != null) {
                        runOkay.run();
                    }
                    NullsafeAtomicReference nullsafeAtomicReference = asyncResult;
                    synchronized (nullsafeAtomicReference) {
                        asyncResult.set((Object)asyncResult);
                        asyncResult.notifyAll();
                    }
                }
                catch (Exception e) {
                    try {
                        if (runFailed != null) {
                            runFailed.run();
                        }
                    }
                    catch (Throwable e2) {
                        DownloadWatchDog.this.logger.log(e2);
                    }
                    finally {
                        NullsafeAtomicReference nullsafeAtomicReference = asyncResult;
                        synchronized (nullsafeAtomicReference) {
                            asyncResult.set((Object)e);
                            asyncResult.notifyAll();
                        }
                    }
                }
            }

            @Override
            public void interrupt() {
                Thread watchDogThread = DownloadWatchDog.this.getWatchDogThread();
                if (DownloadWatchDog.this.getCurrentDownloadWatchDogJob() == this && watchDogThread != null) {
                    watchDogThread.interrupt();
                }
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
        Object ret = null;
        while (true) {
            NullsafeAtomicReference nullsafeAtomicReference = asyncResult;
            synchronized (nullsafeAtomicReference) {
                ret = asyncResult.get();
                if (ret != null) {
                    break;
                }
                asyncResult.wait();
            }
        }
        if (asyncResult == ret) {
            return;
        }
        if (ret instanceof PluginException) {
            throw (PluginException)ret;
        }
        if (ret instanceof Exception) {
            throw (Exception)ret;
        }
        throw new WTFException("WTF? Result: " + ret);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onShutdownVetoRequest(ShutdownRequest request) throws ShutdownVetoException {
        if (request.getVetos().size() > 0) {
            return;
        }
        String dialogTitle = null;
        Object object = this.shutdownLock;
        synchronized (object) {
            if (this.stateMachine.isState(new State[]{RUNNING_STATE, PAUSE_STATE})) {
                for (SingleDownloadController con : this.getSession().getControllers()) {
                    if (!con.isAlive()) continue;
                    dialogTitle = _JDT.T.DownloadWatchDog_onShutdownRequest_();
                    DownloadInterface dl = con.getDownloadInstance();
                    if (dl == null || con.getDownloadLink().isResumeable()) continue;
                    dialogTitle = _JDT.T.DownloadWatchDog_onShutdownRequest_nonresumable();
                    break;
                }
            }
            if (dialogTitle != null) {
                if (!request.isSilent()) {
                    if (JDGui.bugme((WarnLevel)WarnLevel.NORMAL)) {
                        if (UIOManager.I().showConfirmDialog(544, dialogTitle, _JDT.T.DownloadWatchDog_onShutdownRequest_msg(), (Icon)new AbstractIcon("download", 32), _JDT.T.literally_yes(), null)) {
                            return;
                        }
                    } else {
                        return;
                    }
                    throw new ShutdownVetoException(dialogTitle, (ShutdownVetoListener)this);
                }
                throw new ShutdownVetoException(dialogTitle, (ShutdownVetoListener)this);
            }
        }
    }

    public long getShutdownVetoPriority() {
        return 0L;
    }

    public boolean isLinkForced(DownloadLink dlLink) {
        List<DownloadLink> links = this.getSession().getForcedLinks();
        return links.size() > 0 && links.contains(dlLink);
    }

    public boolean isRunning() {
        return this.stateMachine.isState(new State[]{RUNNING_STATE, PAUSE_STATE});
    }

    public boolean isIdle() {
        return this.stateMachine.isState(new State[]{IDLE_STATE, STOPPED_STATE});
    }

    public boolean isStopping() {
        return this.stateMachine.isState(new State[]{STOPPING_STATE});
    }

    public void onShutdown(ShutdownRequest request) {
        this.config.setClosedWithRunningDownloads(this.isRunning());
    }

    public void onShutdownVeto(ShutdownRequest request) {
    }

    @Override
    public void onDownloadControllerAddedPackage(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh(FilePackage pkg) {
    }

    @Override
    public void onDownloadControllerStructureRefresh() {
    }

    @Override
    public void onDownloadControllerStructureRefresh(AbstractNode node, Object param) {
    }

    @Override
    public void onDownloadControllerRemovedPackage(final FilePackage pkg) {
        DownloadSession session = this.getSession();
        if (!session.isStopMarkSet() || session.getStopMark() == DownloadSession.STOPMARK.HIDDEN) {
            return;
        }
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                Object stopMark = currentSession.getStopMark();
                if (!currentSession.isStopMarkSet() || stopMark == DownloadSession.STOPMARK.HIDDEN) {
                    return;
                }
                if (stopMark == pkg) {
                    currentSession.setStopMark((Object)DownloadSession.STOPMARK.HIDDEN);
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
    }

    @Override
    public void onDownloadControllerRemovedLinklist(final List<DownloadLink> list) {
        DownloadSession session = this.getSession();
        if (!session.isStopMarkSet() || session.getStopMark() == DownloadSession.STOPMARK.HIDDEN) {
            return;
        }
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void execute(DownloadSession currentSession) {
                Object stopMark = currentSession.getStopMark();
                if (!currentSession.isStopMarkSet() || stopMark == DownloadSession.STOPMARK.HIDDEN) {
                    return;
                }
                for (DownloadLink l : list) {
                    if (stopMark != l) continue;
                    currentSession.setStopMark((Object)DownloadSession.STOPMARK.HIDDEN);
                    return;
                }
            }

            @Override
            public void interrupt() {
            }

            @Override
            public boolean isHighPriority() {
                return false;
            }
        });
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink, DownloadLinkProperty property) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg, FilePackageProperty property) {
    }

    @Override
    public void onDownloadControllerUpdatedData(DownloadLink downloadlink) {
    }

    @Override
    public void onDownloadControllerUpdatedData(FilePackage pkg) {
    }

    public void renameLink(final DownloadLink downloadLink, final String value) {
        if (!StringUtils.equals((String)downloadLink.getForcedFileName(), (String)value)) {
            this.logger.info("Requested Rename of " + downloadLink + " to " + value);
            this.enqueueJob(new DownloadWatchDogJob(){

                @Override
                public void execute(DownloadSession currentSession) {
                    if (!StringUtils.equals((String)downloadLink.getForcedFileName(), (String)value)) {
                        if (downloadLink.getDownloadLinkController() != null) {
                            DownloadWatchDog.this.logger.info("Requested Rename of " + downloadLink + " to " + value + " DELAYED");
                            downloadLink.setForcedFileName(value);
                        } else if (downloadLink.getDefaultPlugin() != null) {
                            DownloadWatchDog.this.logger.info("Requested Rename of " + downloadLink + " to " + value + " NOW");
                            DownloadWatchDog.this.move(downloadLink, downloadLink.getParentNode().getDownloadDirectory(), downloadLink.getName(), downloadLink.getParentNode().getDownloadDirectory(), value);
                            downloadLink.setForcedFileName(value);
                        }
                    }
                }

                @Override
                public void interrupt() {
                }

                @Override
                public boolean isHighPriority() {
                    return false;
                }
            });
        }
    }

    public void setStopMark(final Object stopEntry) {
        this.enqueueJob(new DownloadWatchDogJob(){

            @Override
            public void interrupt() {
            }

            @Override
            public void execute(DownloadSession currentSession) {
                currentSession.setStopMark(stopEntry);
            }

            @Override
            public boolean isHighPriority() {
                return true;
            }
        });
    }

    public void handleMovedDownloadLinks(final FilePackage dest, final FilePackage source, final List<DownloadLink> links) {
        if (source != dest) {
            this.enqueueJob(new DownloadWatchDogJob(){

                @Override
                public void execute(DownloadSession currentSession) {
                    for (DownloadLink downloadLink : links) {
                        if (downloadLink.getDownloadLinkController() != null || downloadLink.getDefaultPlugin() == null) continue;
                        DownloadWatchDog.this.move(downloadLink, source.getDownloadDirectory(), downloadLink.getName(), dest.getDownloadDirectory(), null);
                    }
                }

                @Override
                public void interrupt() {
                }

                @Override
                public boolean isHighPriority() {
                    return false;
                }
            });
        }
    }

    public void setDownloadDirectory(final FilePackage pkg, final String path) {
        if (!new File(pkg.getDownloadDirectory()).equals(new File(path))) {
            this.enqueueJob(new DownloadWatchDogJob(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(DownloadSession currentSession) {
                    String old = pkg.getDownloadDirectory();
                    if (!new File(pkg.getDownloadDirectory()).equals(new File(path))) {
                        pkg.setDownloadDirectory(path);
                        boolean readL = pkg.getModifyLock().readLock();
                        try {
                            for (DownloadLink downloadLink : pkg.getChildren()) {
                                if (downloadLink.getDownloadLinkController() != null || downloadLink.getDefaultPlugin() == null) continue;
                                DownloadWatchDog.this.move(downloadLink, old, downloadLink.getName(), path, null);
                            }
                        }
                        finally {
                            pkg.getModifyLock().readUnlock(readL);
                        }
                    }
                }

                @Override
                public void interrupt() {
                }

                @Override
                public boolean isHighPriority() {
                    return false;
                }
            });
        }
    }

    protected void move(DownloadLink downloadLink, String oldDir, String oldName, String newDir, String newName) {
        try {
            ArrayList<DownloadLinkCandidate> lst = new ArrayList<DownloadLinkCandidate>();
            lst.add(new DownloadLinkCandidate(downloadLink, true));
            if (DiskSpaceManager.DISKSPACERESERVATIONRESULT.FAILED.equals((Object)this.validateDiskFree(lst))) {
                throw new IOException(_GUI.T.DownloadWatchDog_move_exception_disk_full(downloadLink.getFileOutput()));
            }
            this.logger.info("Move " + downloadLink);
            this.logger.info("From " + oldDir + "/" + oldName + " to " + newDir + "/" + newName);
            if (!new File(oldDir).equals(new File(newDir)) && !CFG_GENERAL.CFG.isMoveFilesIfDownloadDestinationChangesEnabled()) {
                this.logger.info("Cancel isMoveFilesIfDownloadDestinationChanges is false");
                return;
            }
            if (new File(oldDir).equals(new File(newDir)) && !oldName.equals(newName) && !CFG_GENERAL.CFG.isRenameFilesIfDownloadLinkNameChangesEnabled()) {
                this.logger.info("Cancel isRenameFilesIfDownloadLinkNameChangesEnabled is false");
            }
            downloadLink.getDefaultPlugin().move(downloadLink, oldDir, oldName, newDir, newName);
            return;
        }
        catch (Throwable e) {
            this.logger.log(e);
            UIOManager.I().show(ExceptionDialogInterface.class, (UserIODefinition)new ExceptionDialog(16, _GUI.T.lit_error_occured(), e.getMessage(), e, _GUI.T.lit_close(), null));
            return;
        }
    }

    @Override
    public void onNewFolder(Object caller, File folder) {
    }

    static {
        IDLE_STATE.addChildren(new State[]{RUNNING_STATE});
        RUNNING_STATE.addChildren(new State[]{STOPPING_STATE, PAUSE_STATE});
        PAUSE_STATE.addChildren(new State[]{RUNNING_STATE, STOPPING_STATE});
        STOPPING_STATE.addChildren(new State[]{STOPPED_STATE});
        INSTANCE = new DownloadWatchDog();
        accessChecks = new HashSet();
    }

    private class ReconnectThread
    extends Thread {
        private AtomicBoolean finished = new AtomicBoolean(false);
        private volatile Reconnecter.ReconnectResult result = null;

        private ReconnectThread() {
        }

        public Reconnecter.ReconnectResult waitForResult() throws InterruptedException {
            return this.waitForResult(-1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Reconnecter.ReconnectResult waitForResult(long timeout) throws InterruptedException {
            AtomicBoolean atomicBoolean = this.finished;
            synchronized (atomicBoolean) {
                if (!this.finished.get()) {
                    if (timeout > 0L) {
                        this.finished.wait(timeout);
                    } else {
                        this.finished.wait();
                    }
                    if (!this.finished.get()) {
                        return Reconnecter.ReconnectResult.RUNNING;
                    }
                }
            }
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                IPController.getInstance().invalidate();
                this.result = Reconnecter.getInstance().doReconnect();
            }
            catch (Throwable throwable) {
                Thread thread = Thread.currentThread();
                DownloadWatchDog.this.enqueueJob(new DownloadWatchDogJob(thread){
                    final /* synthetic */ Thread val$thread;
                    {
                        this.val$thread = thread;
                    }

                    @Override
                    public boolean isHighPriority() {
                        return true;
                    }

                    @Override
                    public void interrupt() {
                    }

                    @Override
                    public void execute(DownloadSession currentSession) {
                        if (DownloadWatchDog.this.reconnectThread.compareAndSet((Object)this.val$thread, null)) {
                            currentSession.compareAndSetSessionState(DownloadSession.SessionState.RECONNECT_RUNNING, DownloadSession.SessionState.NORMAL);
                        }
                    }
                });
                AtomicBoolean atomicBoolean = this.finished;
                synchronized (atomicBoolean) {
                    this.finished.set(true);
                    this.finished.notifyAll();
                }
                throw throwable;
            }
            Thread thread = Thread.currentThread();
            DownloadWatchDog.this.enqueueJob(new /* invalid duplicate definition of identical inner class */);
            AtomicBoolean atomicBoolean = this.finished;
            synchronized (atomicBoolean) {
                this.finished.set(true);
                this.finished.notifyAll();
            }
        }
    }
}

