/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.PackageControllerComparator;
import jd.plugins.DownloadLink;
import jd.plugins.DownloadLinkStorable;
import jd.plugins.FilePackage;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.storage.Storable;
import org.appwork.storage.StorableAllowPrivateAccessModifier;
import org.appwork.utils.logging2.extmanager.LoggerFactory;

public class FilePackageStorable
implements Storable {
    private FilePackage filePackage;
    private List<DownloadLinkStorable> links;

    @StorableAllowPrivateAccessModifier
    private FilePackageStorable() {
        this.filePackage = FilePackage.getInstance();
        this.links = new ArrayList<DownloadLinkStorable>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FilePackageStorable(FilePackage filePackage, boolean includeChildren) {
        this.filePackage = filePackage;
        if (!includeChildren) {
            this.links = new ArrayList<DownloadLinkStorable>();
        } else {
            this.links = new ArrayList<DownloadLinkStorable>(filePackage.size());
            boolean readL = filePackage.getModifyLock().readLock();
            try {
                for (DownloadLink link : filePackage.getChildren()) {
                    this.links.add(new DownloadLinkStorable(link));
                }
            }
            finally {
                filePackage.getModifyLock().readUnlock(readL);
            }
        }
    }

    public FilePackageStorable(FilePackage filePackage) {
        this(filePackage, false);
    }

    public long getUID() {
        return this.filePackage.getUniqueID().getID();
    }

    public void setUID(long id) {
        this.filePackage.getUniqueID().setID(id);
    }

    public String getName() {
        return this.filePackage.getName();
    }

    public String getSorterId() {
        PackageControllerComparator<AbstractNode> lSorter = this.filePackage.getCurrentSorter();
        if (lSorter == null) {
            return null;
        }
        boolean asc = lSorter.isAsc();
        return (asc ? "ASC" : "DESC") + "." + lSorter.getID();
    }

    public void setSorterId(String id) {
        try {
            if (id == null) {
                this.filePackage.setCurrentSorter(null);
            } else {
                this.filePackage.setCurrentSorter(PackageControllerComparator.getComparator(id));
            }
        }
        catch (Throwable t) {
            LoggerFactory.getDefaultLogger().log(t);
        }
    }

    public void setName(String name) {
        this.filePackage.setName(name);
    }

    public Map<String, Object> getProperties() {
        return this.filePackage.getProperties();
    }

    @AllowNonStorableObjects(value={Object.class})
    public void setProperties(Map<String, Object> props) {
        this.filePackage.setProperties(props);
    }

    public long getCreated() {
        return this.filePackage.getCreated();
    }

    public void setModified(long modified) {
        this.filePackage.setModified(modified);
    }

    public long getModified() {
        return this.filePackage.getModified();
    }

    public void setCreated(long time) {
        this.filePackage.setCreated(time);
    }

    public String getDownloadFolder() {
        return this.filePackage.getDownloadDirectory();
    }

    public void setDownloadFolder(String dest) {
        this.filePackage.setDownloadDirectory(dest);
    }

    public List<DownloadLinkStorable> getLinks() {
        return this.links;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLinks(List<DownloadLinkStorable> links) {
        if (links != null) {
            this.links = links;
            this.filePackage.getModifyLock().writeLock();
            try {
                for (DownloadLinkStorable link : links) {
                    this.filePackage.add(link._getDownloadLink());
                }
            }
            finally {
                this.filePackage.getModifyLock().writeUnlock();
            }
        }
    }

    public FilePackage _getFilePackage() {
        return this.filePackage;
    }
}

