/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.lang.ref.WeakReference;
import javax.swing.Icon;
import jd.controlling.downloadcontroller.AccountCache;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.downloadcontroller.DownloadSession;
import jd.controlling.downloadcontroller.DownloadWatchDog;
import jd.controlling.downloadcontroller.SingleDownloadController;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.proxy.SingleDirectGatewaySelector;
import jd.plugins.Account;
import jd.plugins.AccountInfo;
import jd.plugins.DownloadLink;
import org.appwork.swing.components.ExtMergedIcon;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.FinalLinkState;
import org.jdownloader.plugins.SkipReason;
import org.jdownloader.plugins.WaitingSkipReason;

public class HistoryEntry {
    private AccountCache.ACCOUNTTYPE accountType;
    private String resultIconKey;
    private String resultStatus;
    private WeakReference<DownloadLinkCandidate> candidate;
    private String accountIconKey;
    private String accountStatus;
    private String gatewayStatus;
    private String gatewayIconKey;
    private long createTime;
    private SkipReason resultSkipReason;
    private ConditionalSkipReason resultConditionalSkipReason;
    private FinalLinkState resultFinalStatus;
    private DownloadLink link;
    private WeakReference<DownloadSession> session;
    private Account account;
    private String customMessage = null;

    public String getResultStatus() {
        String ret = this.resultStatus;
        if (StringUtils.isNotEmpty((String)ret)) {
            return ret;
        }
        ret = this.resultSkipReason != null ? this.resultSkipReason.getExplanation(this, this.link) : (this.resultFinalStatus != null ? this.resultFinalStatus.getExplanation(this, this.link) : (this.resultConditionalSkipReason != null ? this.resultConditionalSkipReason.getMessage(this, this.link) : null));
        return ret;
    }

    private String getAccountIconKey() {
        return this.accountIconKey;
    }

    public String getAccountStatus() {
        return this.accountStatus;
    }

    public String getGatewayStatus() {
        return this.gatewayStatus;
    }

    private String getGatewayIconKey() {
        return this.gatewayIconKey;
    }

    public DownloadLinkCandidate getCandidate() {
        return (DownloadLinkCandidate)this.candidate.get();
    }

    public String getCustomMessage(SkipReason skipReason) {
        if (skipReason != null && this.resultSkipReason == skipReason) {
            return this.customMessage;
        }
        return null;
    }

    public String getCustomMessage(FinalLinkState finalLinkState) {
        if (finalLinkState != null && this.resultFinalStatus == finalLinkState) {
            return this.customMessage;
        }
        return null;
    }

    public Icon getResultIcon(int size) {
        if (this.resultSkipReason != null) {
            return this.resultSkipReason.getIcon(this, size);
        }
        String key = this.resultIconKey;
        if (key != null) {
            return new AbstractIcon(key, size);
        }
        if (this.resultSkipReason != null) {
            return this.resultSkipReason.getIcon(this, size);
        }
        if (this.resultFinalStatus != null) {
            return this.resultFinalStatus.getIcon(size);
        }
        if (this.resultConditionalSkipReason != null) {
            return this.resultConditionalSkipReason.getIcon(this, this.link);
        }
        return null;
    }

    public Icon getAccountIcon(int size) {
        String key = this.getAccountIconKey();
        if (key == null) {
            return null;
        }
        return new AbstractIcon(key, size);
    }

    public Icon getGatewayIcon(int size) {
        String key = this.getGatewayIconKey();
        if (key == null) {
            return null;
        }
        if ("expired".equals(key)) {
            return new ExtMergedIcon((Icon)new AbstractIcon("error", size)).add((Icon)new AbstractIcon("wait", (int)((double)size * 0.7)), (int)((double)size * 0.2), (int)((double)size * 0.3));
        }
        return new AbstractIcon(key, size);
    }

    public DownloadSession getSession() {
        return (DownloadSession)this.session.get();
    }

    public HistoryEntry(DownloadLinkCandidate candidate) {
        this.candidate = new WeakReference<DownloadLinkCandidate>(candidate);
        this.session = new WeakReference<DownloadSession>(DownloadWatchDog.getInstance().getSession());
        this.link = candidate.getLink();
        this.createTime = System.currentTimeMillis();
        this.resultStatus = _GUI.T.CandidateTooltipTableModel_initColumns_running_();
        this.resultIconKey = "play";
    }

    public static HistoryEntry create(DownloadLinkCandidate candidate) {
        HTTPProxy proxy;
        HistoryEntry ret = new HistoryEntry(candidate);
        AccountCache.CachedAccount cachedAccount = candidate.getCachedAccount();
        HistoryEntry.collectInfo(cachedAccount != null ? cachedAccount.getAccount() : null, ret);
        ret.accountType = cachedAccount != null ? cachedAccount.getType() : AccountCache.ACCOUNTTYPE.NONE;
        AbstractProxySelectorImpl proxySel = candidate.getProxySelector();
        SingleDownloadController controller = candidate.getLink().getDownloadLinkController();
        if (controller != null && (proxy = controller.getUsedProxy()) != null) {
            ret.gatewayStatus = proxy._toString();
            switch (proxy.getType()) {
                case HTTP: 
                case HTTPS: 
                case SOCKS4: 
                case SOCKS4A: 
                case SOCKS5: {
                    ret.gatewayIconKey = "proxy";
                    break;
                }
            }
        }
        if (StringUtils.isEmpty((String)ret.gatewayStatus)) {
            if (proxySel instanceof NoProxySelector) {
                ret.gatewayStatus = HTTPProxy.NONE._toString();
            } else if (proxySel instanceof SingleDirectGatewaySelector) {
                ret.gatewayStatus = ((SingleDirectGatewaySelector)proxySel).getProxy()._toString();
            } else if (proxySel != null) {
                ret.gatewayIconKey = "proxy";
                ret.gatewayStatus = proxySel.toDetailsString();
            }
        }
        return ret;
    }

    public AccountCache.ACCOUNTTYPE getAccountType() {
        return this.accountType;
    }

    private static void collectInfo(Account account, HistoryEntry history) {
        history.account = account;
        if (account == null) {
            history.accountIconKey = "download";
            history.accountStatus = _GUI.T.CandidateAccountColumn_getStringValue_free_();
        } else if (account.isChecking()) {
            history.accountIconKey = "refresh";
        } else if (account.getError() == null) {
            String ret;
            history.accountIconKey = "ok";
            AccountInfo ai = account.getAccountInfo();
            String string = ret = ai == null ? null : ai.getStatus();
            if (StringUtils.isEmpty((String)ret)) {
                if (account.isTempDisabled()) {
                    if (StringUtils.isNotEmpty((String)account.getErrorString())) {
                        history.accountStatus = account.getErrorString();
                        return;
                    }
                    ret = _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled();
                } else {
                    ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_();
                }
            } else if (account.isTempDisabled()) {
                if (StringUtils.isNotEmpty((String)account.getErrorString())) {
                    history.accountIconKey = "wait";
                    history.accountStatus = account.getErrorString();
                    return;
                }
                ret = _GUI.T.PremiumAccountTableModel_getStringValue_temp_disabled2(ret);
            } else {
                ret = _GUI.T.PremiumAccountTableModel_getStringValue_account_ok_2(ret);
            }
            history.accountStatus = ret;
        } else if (StringUtils.isNotEmpty((String)account.getErrorString())) {
            history.accountStatus = account.getErrorString();
        } else {
            switch (account.getError()) {
                case EXPIRED: {
                    history.accountIconKey = "expired";
                    history.accountStatus = _GUI.T.PremiumAccountTableModel_getStringValue_status_expired();
                    break;
                }
                case INVALID: {
                    history.accountIconKey = "error";
                    history.accountStatus = _GUI.T.PremiumAccountTableModel_getStringValue_status_invalid();
                    break;
                }
                case PLUGIN_ERROR: {
                    history.accountIconKey = "error";
                    history.accountStatus = _GUI.T.PremiumAccountTableModel_getStringValue_status_plugin_error();
                    break;
                }
                case TEMP_DISABLED: {
                    history.accountIconKey = "wait";
                    history.accountStatus = _GUI.T.PremiumAccountTableModel_getStringValue_status_unknown_error();
                    break;
                }
                default: {
                    history.accountIconKey = "error";
                    history.accountStatus = _GUI.T.PremiumAccountTableModel_getStringValue_status_unknown_error();
                }
            }
        }
    }

    public Account getAccount() {
        return this.account;
    }

    public static void updateResult(HistoryEntry history, DownloadLinkCandidate candidate, DownloadLinkCandidateResult result) {
        history.resultStatus = null;
        history.customMessage = null;
        history.resultIconKey = null;
        history.resultConditionalSkipReason = null;
        history.resultFinalStatus = null;
        history.resultSkipReason = null;
        if (result == null || result.getResult() == null) {
            history.resultIconKey = "play";
            history.resultStatus = _GUI.T.CandidateTooltipTableModel_initColumns_running_();
        } else {
            switch (result.getResult()) {
                case PROXY_UNAVAILABLE: {
                    break;
                }
                case CONDITIONAL_SKIPPED: {
                    history.resultConditionalSkipReason = result.getConditionalSkip();
                    break;
                }
                case IP_BLOCKED: {
                    history.resultConditionalSkipReason = new WaitingSkipReason(WaitingSkipReason.CAUSE.IP_BLOCKED, result.getWaitTime(), result.getMessage());
                    break;
                }
                case HOSTER_UNAVAILABLE: {
                    history.resultConditionalSkipReason = new WaitingSkipReason(WaitingSkipReason.CAUSE.HOST_TEMP_UNAVAILABLE, result.getWaitTime(), result.getMessage());
                    break;
                }
                case FILE_UNAVAILABLE: {
                    history.resultConditionalSkipReason = new WaitingSkipReason(WaitingSkipReason.CAUSE.FILE_TEMP_UNAVAILABLE, result.getWaitTime(), result.getMessage());
                    break;
                }
                case CONNECTION_ISSUES: {
                    history.resultConditionalSkipReason = new WaitingSkipReason(WaitingSkipReason.CAUSE.CONNECTION_TEMP_UNAVAILABLE, result.getWaitTime(), result.getMessage());
                    break;
                }
                case SKIPPED: {
                    history.resultSkipReason = result.getSkipReason();
                    break;
                }
                case PLUGIN_DEFECT: {
                    history.resultFinalStatus = FinalLinkState.PLUGIN_DEFECT;
                    break;
                }
                case OFFLINE_TRUSTED: {
                    history.resultFinalStatus = FinalLinkState.OFFLINE;
                    break;
                }
                case FINISHED_EXISTS: {
                    history.resultFinalStatus = FinalLinkState.FINISHED_MIRROR;
                    break;
                }
                case FINISHED: {
                    history.resultFinalStatus = FinalLinkState.FINISHED;
                    break;
                }
                case FAILED_EXISTS: {
                    history.resultFinalStatus = FinalLinkState.FAILED_EXISTS;
                    break;
                }
                case FAILED: {
                    history.resultFinalStatus = FinalLinkState.FAILED;
                    break;
                }
                case STOPPED: {
                    history.resultStatus = _GUI.T.CandidateTooltipTableModel_configureRendererComponent_stopped_();
                    history.resultIconKey = "cancel";
                    break;
                }
                case ACCOUNT_ERROR: {
                    history.resultStatus = result.getThrowable() != null ? result.getThrowable().getMessage() : null;
                    history.resultIconKey = "false";
                    break;
                }
                case ACCOUNT_INVALID: {
                    history.resultStatus = result.getThrowable() != null ? result.getThrowable().getMessage() : null;
                    history.resultIconKey = "false";
                    break;
                }
                case ACCOUNT_UNAVAILABLE: {
                    history.resultStatus = _GUI.T.CandidateTooltipTableModel_configureRendererComponent_account_unavailable();
                    history.resultIconKey = "false";
                    break;
                }
                case ACCOUNT_REQUIRED: {
                    history.resultStatus = _GUI.T.CandidateTooltipTableModel_configureRendererComponent_account_required();
                    history.resultIconKey = "false";
                    history.resultSkipReason = SkipReason.NO_ACCOUNT;
                    history.customMessage = result.getMessage();
                    break;
                }
                case CAPTCHA: {
                    history.resultSkipReason = SkipReason.CAPTCHA;
                    break;
                }
                case FATAL_ERROR: {
                    history.resultFinalStatus = FinalLinkState.FAILED_FATAL;
                    history.resultStatus = result.getMessage();
                    history.resultIconKey = "false";
                    history.customMessage = result.getMessage();
                    break;
                }
                default: {
                    history.resultStatus = (Object)((Object)result.getResult()) + "";
                    if (!StringUtils.isNotEmpty((String)result.getMessage())) break;
                    history.resultStatus = result.getMessage();
                }
            }
            if (StringUtils.isEmpty((String)history.resultStatus)) {
                history.resultStatus = result.getMessage();
            }
        }
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public DownloadLink getLink() {
        return this.link;
    }
}

