/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import jd.controlling.downloadcontroller.IfFileExistsDialogInterface;
import jd.plugins.DownloadLink;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.formatter.SizeFormatter;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.gui.views.downloads.table.DownloadsTableModel;
import org.jdownloader.settings.IfFileExistsAction;
import org.jdownloader.settings.staticreferences.CFG_GUI;
import org.jdownloader.translate._JDT;

public class IfFileExistsDialog
extends AbstractDialog<IfFileExistsAction>
implements IfFileExistsDialogInterface,
FocusListener {
    private final String path;
    private IfFileExistsAction result;
    private final String packagename;
    private JRadioButton skip;
    private JRadioButton overwrite;
    private JRadioButton rename;
    private final String packageID;
    private final DownloadLink downloadLink;
    private final DownloadLink downloadLinkInProgress;

    public boolean isRemoteAPIEnabled() {
        return true;
    }

    @Override
    public String getPackagename() {
        return this.packagename;
    }

    @Override
    public String getPackageID() {
        return this.packageID;
    }

    public IfFileExistsDialog(DownloadLink downloadLink, DownloadLink downloadLinkInProgress) {
        super(36, _JDT.T.jd_controlling_SingleDownloadController_askexists_title(), null, null, null);
        this.packagename = downloadLink.getFilePackage().getName();
        this.packageID = downloadLink.getFilePackage().getName() + "_" + downloadLink.getFilePackage().getCreated();
        this.path = downloadLink.getFileOutput();
        this.downloadLink = downloadLink;
        this.downloadLinkInProgress = downloadLinkInProgress;
        this.setTimeout(60000);
    }

    public Dialog.ModalityType getModalityType() {
        return Dialog.ModalityType.MODELESS;
    }

    public String getDontShowAgainKey() {
        return null;
    }

    protected IfFileExistsAction createReturnValue() {
        if (this.okButton != null) {
            this.okButton.removeFocusListener(this);
        }
        if (this.result != null) {
            CFG_GUI.CFG.setLastIfFileExists(this.result);
        }
        return this.result;
    }

    protected String getDontShowAgainLabelText() {
        return _GUI.T.IfFileExistsDialog_getDontShowAgainLabelText_();
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 1", "", "");
        ExtTextArea txt = new ExtTextArea();
        txt.setLabelMode(true);
        txt.setToolTipText(this.path);
        txt.setText(_JDT.T.jd_controlling_SingleDownloadController_askexists3());
        p.add((Component)txt);
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filename())), (Object)"split 2,sg 1");
        p.add((Component)new JLabel(new File(this.path).getName()));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filesize2())), (Object)"split 2,sg 1");
        p.add((Component)new JLabel(SizeFormatter.formatBytes((long)this.downloadLink.getView().getBytesTotalEstimated())));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_filesize_existing())), (Object)"split 2,sg 1");
        String fileOutput = this.downloadLink.getFileOutput();
        File localFile = new File(fileOutput);
        if (!localFile.exists()) {
            localFile = new File(fileOutput + ".part");
        }
        long existingSize = this.downloadLinkInProgress != null ? Math.max(this.downloadLinkInProgress.getKnownDownloadSize(), localFile.length()) : localFile.length();
        p.add((Component)new JLabel(SizeFormatter.formatBytes((long)existingSize)));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_package())), (Object)"split 2,sg 1");
        p.add((Component)new JLabel(this.packagename));
        p.add((Component)SwingUtils.toBold((JLabel)new JLabel(_GUI.T.IfFileExistsDialog_layoutDialogContent_hoster())), (Object)"split 2,sg 1");
        p.add((Component)new JLabel(this.downloadLink.getDomainInfo().getTld()));
        this.skip = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_skip_());
        this.skip.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.SKIP_FILE;
            }
        });
        this.overwrite = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_overwrite_());
        this.overwrite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.OVERWRITE_FILE;
            }
        });
        this.rename = new JRadioButton(_GUI.T.IfFileExistsDialog_layoutDialogContent_rename_());
        this.rename.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                IfFileExistsDialog.this.result = IfFileExistsAction.AUTO_RENAME;
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.skip);
        group.add(this.overwrite);
        group.add(this.rename);
        p.add((Component)new JSeparator(), (Object)"pushx,growx");
        p.add((Component)this.skip, (Object)"gapleft 10");
        p.add((Component)this.overwrite, (Object)"gapleft 10");
        p.add((Component)this.rename, (Object)"gapleft 10");
        IfFileExistsAction def = CFG_GUI.CFG.getLastIfFileExists();
        if (def == null) {
            def = IfFileExistsAction.SKIP_FILE;
        }
        switch (def) {
            case AUTO_RENAME: {
                this.rename.setSelected(true);
                break;
            }
            case OVERWRITE_FILE: {
                this.overwrite.setSelected(true);
                break;
            }
            default: {
                this.skip.setSelected(true);
            }
        }
        this.result = def;
        if (this.okButton != null) {
            this.okButton.addFocusListener(this);
        }
        return p;
    }

    @Override
    public IfFileExistsAction getAction() {
        return this.result;
    }

    @Override
    public String getFilePath() {
        return this.path;
    }

    public IfFileExistsDialogInterface show() {
        return (IfFileExistsDialogInterface)UIOManager.I().show(IfFileExistsDialogInterface.class, (UserIODefinition)this);
    }

    @Override
    public void focusGained(FocusEvent e) {
        DownloadsTableModel.getInstance().setSelectedObject(this.downloadLink);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public String getHost() {
        return this.downloadLink.getHost();
    }
}

