/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.downloadcontroller.DownloadSpeedManager;
import jd.plugins.DownloadLink;
import org.appwork.utils.net.throttledconnection.ThrottledConnection;
import org.appwork.utils.net.throttledconnection.ThrottledConnectionHandler;
import org.appwork.utils.speedmeter.SpeedMeterInterface;

public class ManagedThrottledConnectionHandler
implements ThrottledConnectionHandler {
    protected CopyOnWriteArrayList<ThrottledConnection> connections = new CopyOnWriteArrayList();
    protected AtomicInteger limit = new AtomicInteger(0);
    protected AtomicLong traffic = new AtomicLong(0L);
    protected DownloadSpeedManager managedBy = null;

    public ManagedThrottledConnectionHandler() {
    }

    @Deprecated
    public ManagedThrottledConnectionHandler(DownloadLink link) {
    }

    public void addThrottledConnection(ThrottledConnection con) {
        if (this.connections.addIfAbsent(con)) {
            DownloadSpeedManager lmanagedBy = this.managedBy;
            if (lmanagedBy != null && lmanagedBy.getLimit() > 0 || this.getLimit() > 0) {
                con.setLimit(10);
            }
            con.setHandler((ThrottledConnectionHandler)this);
        }
    }

    public List<ThrottledConnection> getConnections() {
        return this.connections;
    }

    public int getLimit() {
        return this.limit.get();
    }

    public int getSpeed() {
        int ret = 0;
        for (ThrottledConnection con : this.connections) {
            ret = (int)((long)ret + ((SpeedMeterInterface)con).getValue(SpeedMeterInterface.Resolution.SECONDS));
        }
        return ret;
    }

    public long getTraffic() {
        long ret = this.traffic.get();
        for (ThrottledConnection con : this.connections) {
            ret += con.transfered();
        }
        return ret;
    }

    public void removeThrottledConnection(ThrottledConnection con) {
        if (this.connections.remove(con)) {
            this.traffic.addAndGet(con.transfered());
            con.setHandler(null);
        }
    }

    public void setLimit(int newLimit) {
        this.limit.set(Math.max(0, newLimit));
    }

    public int size() {
        return this.connections.size();
    }

    protected void setManagedBy(DownloadSpeedManager downloadSpeedManager) {
        this.managedBy = downloadSpeedManager;
    }
}

