/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.downloadcontroller;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import jd.controlling.downloadcontroller.DownloadLinkCandidate;
import jd.controlling.downloadcontroller.DownloadLinkCandidateResult;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.plugins.Account;
import org.appwork.utils.StringUtils;
import org.jdownloader.plugins.ConditionalSkipReason;
import org.jdownloader.plugins.WaitWhileWaitingSkipReasonIsSet;
import org.jdownloader.plugins.WaitingSkipReason;

public class ProxyInfoHistory {
    private final Map<WaitingSkipReason.CAUSE, Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>>> causeMapping = new LinkedHashMap<WaitingSkipReason.CAUSE, Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>>>();
    private final Map<AbstractProxySelectorImpl, Map<String, Map<Account, List<WaitingSkipReasonContainer>>>> history = new LinkedHashMap<AbstractProxySelectorImpl, Map<String, Map<Account, List<WaitingSkipReasonContainer>>>>();

    private List<WaitingSkipReasonContainer> getInteralWaitingSkipReasonList(DownloadLinkCandidate candidate) {
        Account acc;
        List<WaitingSkipReasonContainer> ret;
        String host;
        Map<Account, List<WaitingSkipReasonContainer>> map2;
        AbstractProxySelectorImpl proxy = candidate.getProxySelector();
        Map<String, Map<Account, List<WaitingSkipReasonContainer>>> map1 = this.history.get(proxy);
        if (map1 == null) {
            map1 = new HashMap<String, Map<Account, List<WaitingSkipReasonContainer>>>();
            this.history.put(proxy, map1);
        }
        if ((map2 = map1.get(host = candidate.getCachedAccount().getPlugin().getHost())) == null) {
            map2 = new WeakHashMap<Account, List<WaitingSkipReasonContainer>>();
            map1.put(host, map2);
        }
        if ((ret = map2.get(acc = candidate.getCachedAccount().getAccount())) == null) {
            ret = new ArrayList<WaitingSkipReasonContainer>();
            map2.put(acc, ret);
        }
        return ret;
    }

    private void add(WaitingSkipReasonContainer waitingSkipReason, AbstractProxySelectorImpl proxyInfo) {
        List<WaitingSkipReasonContainer> list;
        WaitingSkipReason.CAUSE cause = waitingSkipReason.getWaitingSkipReason().getCause();
        Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>> map = this.causeMapping.get((Object)cause);
        if (map == null) {
            map = new HashMap<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>>();
            this.causeMapping.put(cause, map);
        }
        if ((list = map.get(proxyInfo)) == null) {
            list = new ArrayList<WaitingSkipReasonContainer>();
            map.put(proxyInfo, list);
        }
        list.add(waitingSkipReason);
    }

    private void remove(WaitingSkipReasonContainer waitingSkipReason, AbstractProxySelectorImpl proxyInfo) {
        waitingSkipReason.invalidate();
        WaitingSkipReason.CAUSE cause = waitingSkipReason.getWaitingSkipReason().getCause();
        Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>> map = this.causeMapping.get((Object)cause);
        if (map == null) {
            return;
        }
        List<WaitingSkipReasonContainer> list = map.get(proxyInfo);
        if (list == null) {
            return;
        }
        list.remove(waitingSkipReason);
        if (list.size() == 0) {
            map.remove(proxyInfo);
            if (map.size() == 0) {
                this.causeMapping.remove((Object)cause);
            }
        }
    }

    public Set<AbstractProxySelectorImpl> list(WaitingSkipReason.CAUSE cause) {
        Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>> map = this.causeMapping.get((Object)cause);
        if (map != null) {
            return map.keySet();
        }
        return null;
    }

    public List<WaitingSkipReasonContainer> list(WaitingSkipReason.CAUSE cause, AbstractProxySelectorImpl proxyInfo) {
        Map<AbstractProxySelectorImpl, List<WaitingSkipReasonContainer>> map = this.causeMapping.get((Object)cause);
        if (map != null) {
            if (proxyInfo == null) {
                ArrayList<WaitingSkipReasonContainer> ret = new ArrayList<WaitingSkipReasonContainer>();
                for (List<WaitingSkipReasonContainer> list : map.values()) {
                    ret.addAll(list);
                }
                return ret;
            }
            return map.get(proxyInfo);
        }
        return null;
    }

    public List<WaitingSkipReasonContainer> list(String host) {
        if (StringUtils.isEmpty((String)host)) {
            return null;
        }
        ArrayList<WaitingSkipReasonContainer> ret = new ArrayList<WaitingSkipReasonContainer>();
        for (Map.Entry<AbstractProxySelectorImpl, Map<String, Map<Account, List<WaitingSkipReasonContainer>>>> next : this.history.entrySet()) {
            Map<String, Map<Account, List<WaitingSkipReasonContainer>>> map = next.getValue();
            Map<Account, List<WaitingSkipReasonContainer>> map2 = map.get(host);
            if (map2 == null) continue;
            for (List<WaitingSkipReasonContainer> list : map2.values()) {
                ret.addAll(list);
            }
        }
        return ret;
    }

    public DownloadLinkCandidateResult getBlockingHistory(DownloadLinkCandidate candidate) {
        if (candidate.getProxySelector() == null) {
            return null;
        }
        List<WaitingSkipReasonContainer> list = this.cleanup(this.getInteralWaitingSkipReasonList(candidate), candidate.getProxySelector());
        if (list != null && list.size() > 0) {
            final WaitingSkipReason waitingSkipReason = list.get(0).getWaitingSkipReason();
            return new DownloadLinkCandidateResult(DownloadLinkCandidateResult.RESULT.PROXY_UNAVAILABLE, null, null){

                @Override
                public long getRemainingTime() {
                    return waitingSkipReason.getTimeOutLeft();
                }
            };
        }
        return null;
    }

    private List<WaitingSkipReasonContainer> cleanup(List<WaitingSkipReasonContainer> list, AbstractProxySelectorImpl proxyInfo) {
        if (list == null || proxyInfo == null) {
            return list;
        }
        Iterator<WaitingSkipReasonContainer> it = list.iterator();
        while (it.hasNext()) {
            WaitingSkipReasonContainer next = it.next();
            if (next.skipReason.isValid() && !next.skipReason.isConditionReached()) continue;
            this.remove(next, proxyInfo);
            it.remove();
        }
        return list;
    }

    public void validate() {
        Iterator<Map.Entry<AbstractProxySelectorImpl, Map<String, Map<Account, List<WaitingSkipReasonContainer>>>>> it1 = this.history.entrySet().iterator();
        while (it1.hasNext()) {
            Map.Entry<AbstractProxySelectorImpl, Map<String, Map<Account, List<WaitingSkipReasonContainer>>>> next1 = it1.next();
            Iterator<Map.Entry<String, Map<Account, List<WaitingSkipReasonContainer>>>> it2 = next1.getValue().entrySet().iterator();
            while (it2.hasNext()) {
                Map.Entry<String, Map<Account, List<WaitingSkipReasonContainer>>> next2 = it2.next();
                Iterator<Map.Entry<Account, List<WaitingSkipReasonContainer>>> it3 = next2.getValue().entrySet().iterator();
                while (it3.hasNext()) {
                    Map.Entry<Account, List<WaitingSkipReasonContainer>> next3 = it3.next();
                    Iterator<WaitingSkipReasonContainer> it4 = next3.getValue().iterator();
                    while (it4.hasNext()) {
                        WaitingSkipReasonContainer next4 = it4.next();
                        WaitingSkipReason skipReason = next4.skipReason;
                        if (!skipReason.isConditionReached() && skipReason.isValid()) continue;
                        this.remove(next4, next1.getKey());
                        it4.remove();
                    }
                    if (next3.getValue().size() != 0) continue;
                    it3.remove();
                }
                if (next2.getValue().size() != 0) continue;
                it2.remove();
            }
            if (next1.getValue().size() != 0) continue;
            it1.remove();
        }
    }

    public ConditionalSkipReason getConditionalSkipReason(DownloadLinkCandidate candidate) {
        if (candidate.getProxySelector() == null) {
            return null;
        }
        List<WaitingSkipReasonContainer> list = this.cleanup(this.getInteralWaitingSkipReasonList(candidate), candidate.getProxySelector());
        if (list.size() > 0) {
            WaitingSkipReasonContainer first = list.get(0);
            WaitWhileWaitingSkipReasonIsSet ret = first.waitWhile;
            if (ret == null || !ret.isValid() || ret.isConditionReached()) {
                ret = new WaitWhileWaitingSkipReasonIsSet(first.skipReason, candidate.getLink());
                first.waitWhile = ret;
            }
            return ret;
        }
        return null;
    }

    public boolean putIntoHistory(DownloadLinkCandidate candidate, WaitingSkipReason waitingSkipReason) {
        if (candidate.getProxySelector() == null) {
            throw new IllegalArgumentException("candidate.getProxy() == null");
        }
        if (waitingSkipReason.getCause() != WaitingSkipReason.CAUSE.HOST_TEMP_UNAVAILABLE && waitingSkipReason.getCause() != WaitingSkipReason.CAUSE.IP_BLOCKED) {
            throw new IllegalArgumentException("putIntoHistory cannot be used with " + (Object)((Object)waitingSkipReason.getCause()));
        }
        AbstractProxySelectorImpl proxyInfo = candidate.getProxySelector();
        List<WaitingSkipReasonContainer> list = this.cleanup(this.getInteralWaitingSkipReasonList(candidate), proxyInfo);
        Iterator<WaitingSkipReasonContainer> it = list.iterator();
        boolean add = true;
        while (it.hasNext()) {
            WaitingSkipReasonContainer next = it.next();
            if (next.skipReason.getCause() != waitingSkipReason.getCause()) continue;
            if (next.skipReason.getTimeOutTimeStamp() < waitingSkipReason.getTimeOutTimeStamp()) {
                add = false;
                continue;
            }
            this.remove(next, proxyInfo);
            it.remove();
        }
        if (add) {
            WaitingSkipReasonContainer container = new WaitingSkipReasonContainer(waitingSkipReason, candidate);
            list.add(container);
            this.add(container, proxyInfo);
            Collections.sort(list, new Comparator<WaitingSkipReasonContainer>(){

                @Override
                public int compare(WaitingSkipReasonContainer o1, WaitingSkipReasonContainer o2) {
                    long y;
                    long x = o1.skipReason.getTimeOutTimeStamp();
                    return x < (y = o2.skipReason.getTimeOutTimeStamp()) ? -1 : (x == y ? 0 : 1);
                }
            });
            return true;
        }
        return false;
    }

    public static final class WaitingSkipReasonContainer {
        private final WaitingSkipReason skipReason;
        private WaitWhileWaitingSkipReasonIsSet waitWhile = null;
        private final String acchost;
        private final String dlHost;
        private final AbstractProxySelectorImpl proxySelector;
        private final Account account;

        private WaitingSkipReasonContainer(WaitingSkipReason skipReason, DownloadLinkCandidate candidate) {
            this.skipReason = skipReason;
            this.acchost = candidate.getCachedAccount().getPlugin().getHost();
            this.dlHost = candidate.getLink().getHost();
            this.proxySelector = candidate.getProxySelector();
            this.account = candidate.getCachedAccount().getAccount();
        }

        public final void invalidate() {
            this.skipReason.invalidate();
        }

        public final String getAccHost() {
            return this.acchost;
        }

        public final String getDlHost() {
            return this.dlHost;
        }

        public final WaitingSkipReason getWaitingSkipReason() {
            return this.skipReason;
        }

        public final AbstractProxySelectorImpl getProxySelector() {
            return this.proxySelector;
        }

        public Account getAccount() {
            return this.account;
        }
    }
}

