/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkchecker;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jd.controlling.linkchecker.LinkChecker;
import jd.controlling.linkcrawler.CheckableLink;
import jd.http.BrowserSettingsThread;
import jd.plugins.DownloadLink;
import jd.plugins.LinkStatus;
import jd.plugins.PluginForHost;
import jd.plugins.UseSetLinkStatusThread;

public class LinkCheckerThread
extends BrowserSettingsThread
implements UseSetLinkStatusThread {
    protected List<LinkChecker.InternCheckableLink> checkableLinks;
    private Map<DownloadLink, LinkStatus> linkStatusMap = new HashMap<DownloadLink, LinkStatus>();
    protected PluginForHost plugin;

    public LinkChecker<?> getLinkCheckerByLink(CheckableLink link) {
        List<LinkChecker.InternCheckableLink> lcheckableLinks = this.checkableLinks;
        if (lcheckableLinks != null) {
            for (LinkChecker.InternCheckableLink l : lcheckableLinks) {
                if (!this.match(l.getCheckableLink(), link)) continue;
                return l.getLinkChecker();
            }
        }
        return null;
    }

    private boolean match(CheckableLink a, CheckableLink b) {
        if (a == null || b == null) {
            return false;
        }
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            return a.getDownloadLink() == b.getDownloadLink();
        }
        return false;
    }

    public PluginForHost getPlugin() {
        return this.plugin;
    }

    @Override
    public LinkStatus getLinkStatus(DownloadLink downloadLink) {
        LinkStatus ret = this.linkStatusMap.get(downloadLink);
        if (ret == null) {
            ret = new LinkStatus(downloadLink);
            this.linkStatusMap.put(downloadLink, ret);
        }
        return ret;
    }

    @Override
    public void resetLinkStatus() {
        this.linkStatusMap = new HashMap<DownloadLink, LinkStatus>();
    }
}

