/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcollector.event.LinkCollectorCrawlerEvent;
import jd.controlling.linkcollector.event.LinkCollectorCrawlerEventSender;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.LinkCrawler;
import jd.plugins.PluginsC;
import org.appwork.utils.event.DefaultEvent;
import org.jdownloader.plugins.controller.crawler.LazyCrawlerPlugin;
import org.jdownloader.plugins.controller.host.LazyHostPlugin;
import org.jdownloader.settings.staticreferences.CFG_GENERAL;

public class LinkCollectorCrawler
extends LinkCrawler
implements LinkCollectorListener {
    private final LinkCollectorCrawlerEventSender eventSender;

    protected LinkCollectorCrawler() {
        super(true, true);
        this.setDirectHTTPPermission(LinkCrawler.getConfig().getDirectHTTPPermission());
        this.setHostPluginBlacklist(CFG_GENERAL.CFG.getCrawlerHostPluginBlacklist());
        this.setCrawlerPluginBlacklist(CFG_GENERAL.CFG.getCrawlerCrawlerPluginBlacklist());
        this.eventSender = new LinkCollectorCrawlerEventSender();
    }

    public LinkCollectorCrawlerEventSender getEventSender() {
        return this.eventSender;
    }

    @Override
    protected void crawl(LinkCrawler.LinkCrawlerGeneration generation, LazyCrawlerPlugin lazyC, CrawledLink cryptedLink) {
        if (this.eventSender.hasListener()) {
            this.eventSender.fireEvent((DefaultEvent)new LinkCollectorCrawlerEvent(this, LinkCollectorCrawlerEvent.Type.CRAWLER_PLUGIN, cryptedLink));
        }
        super.crawl(generation, lazyC, cryptedLink);
    }

    @Override
    protected boolean distributeFinalCrawledLink(LinkCrawler.LinkCrawlerGeneration generation, CrawledLink crawledLink) {
        boolean ret = super.distributeFinalCrawledLink(generation, crawledLink);
        if (ret && this.eventSender.hasListener()) {
            this.eventSender.fireEvent((DefaultEvent)new LinkCollectorCrawlerEvent(this, LinkCollectorCrawlerEvent.Type.HOST_PLUGIN, crawledLink));
        }
        return ret;
    }

    @Override
    protected void processHostPlugin(LinkCrawler.LinkCrawlerGeneration generation, LazyHostPlugin pHost, CrawledLink possibleCryptedLink) {
        if (this.eventSender.hasListener()) {
            this.eventSender.fireEvent((DefaultEvent)new LinkCollectorCrawlerEvent(this, LinkCollectorCrawlerEvent.Type.HOST_PLUGIN, possibleCryptedLink));
        }
        super.processHostPlugin(generation, pHost, possibleCryptedLink);
    }

    @Override
    protected void container(LinkCrawler.LinkCrawlerGeneration generation, PluginsC oplg, CrawledLink cryptedLink) {
        if (this.eventSender.hasListener()) {
            this.eventSender.fireEvent((DefaultEvent)new LinkCollectorCrawlerEvent(this, LinkCollectorCrawlerEvent.Type.CONTAINER_PLUGIN, cryptedLink));
        }
        super.container(generation, oplg, cryptedLink);
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
        this.stopCrawling();
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCrawlerAdded(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStarted(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerStopped(LinkCollectorCrawler parameter) {
    }

    @Override
    public void onLinkCrawlerNewJob(LinkCollectingJob job) {
    }

    @Override
    public void onLinkCrawlerFinished() {
    }
}

