/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import jd.controlling.linkcollector.LinkCollectingInformation;
import jd.controlling.linkcollector.LinkCollectingJob;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorEvent;
import jd.controlling.linkcollector.LinkCollectorListener;
import jd.controlling.linkcrawler.CrawledLink;
import org.appwork.scheduler.DelayedRunnable;

public abstract class LinkCollectorHighlightListener
implements LinkCollectorListener {
    private final long cleanupTIMEOUT = 30000L;
    private WeakHashMap<LinkCollectingJob, Long> newJobMap = new WeakHashMap();
    private DelayedRunnable delayedCleanup;

    public LinkCollectorHighlightListener() {
        this.delayedCleanup = new DelayedRunnable(LinkCollector.getInstance().TIMINGQUEUE, 5000L, 60000L){

            public String getID() {
                return "LinkCollectorHighlightListener";
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void delayedrun() {
                boolean restartCleanup = false;
                WeakHashMap weakHashMap = LinkCollectorHighlightListener.this.newJobMap;
                synchronized (weakHashMap) {
                    Iterator it = LinkCollectorHighlightListener.this.newJobMap.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        if (System.currentTimeMillis() - (Long)next.getValue() <= 30000L) continue;
                        it.remove();
                    }
                    restartCleanup = LinkCollectorHighlightListener.this.newJobMap.size() > 0;
                }
                if (restartCleanup) {
                    LinkCollectorHighlightListener.this.delayedCleanup.resetAndStart();
                }
            }
        };
    }

    @Override
    public void onLinkCollectorAbort(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentAdded(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksAvailable(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorFilteredLinksEmpty(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorDataRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorStructureRefresh(LinkCollectorEvent event) {
    }

    @Override
    public void onLinkCollectorContentRemoved(LinkCollectorEvent event) {
        if (LinkCollector.getInstance().getPackages().size() == 0) {
            this.delayedCleanup.resetAndStart();
        }
    }

    @Override
    public void onLinkCollectorLinkAdded(LinkCollectorEvent event, CrawledLink parameter) {
        this.doHightLight(parameter);
    }

    @Override
    public void onLinkCollectorDupeAdded(LinkCollectorEvent event, CrawledLink parameter) {
        this.doHightLight(parameter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doHightLight(CrawledLink parameter) {
        if (this.isThisListenerEnabled()) {
            LinkCollectingInformation sourceJob = parameter.getCollectingInfo();
            if (sourceJob == null || sourceJob.getLinkCrawler().isCollecting()) {
                return;
            }
            if (LinkCollector.getInstance().getDefaultLinkChecker().isRunning()) {
                return;
            }
            boolean doHighlight = false;
            WeakHashMap<LinkCollectingJob, Long> weakHashMap = this.newJobMap;
            synchronized (weakHashMap) {
                if (this.newJobMap.put(parameter.getSourceJob(), System.currentTimeMillis()) == null) {
                    this.delayedCleanup.resetAndStart();
                    doHighlight = true;
                } else {
                    doHighlight = false;
                }
            }
            if (doHighlight) {
                this.onHighLight(parameter);
            }
        }
    }

    public abstract void onHighLight(CrawledLink var1);

    public abstract boolean isThisListenerEnabled();
}

