/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcollector.autostart;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.WeakHashMap;
import jd.controlling.linkcollector.LinkCollectingInformation;
import jd.controlling.linkcollector.LinkCollector;
import jd.controlling.linkcollector.LinkCollectorCrawler;
import jd.controlling.linkcollector.autostart.AutoStartManagerEvent;
import jd.controlling.linkcollector.autostart.AutoStartManagerEventSender;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledPackage;
import org.appwork.scheduler.DelayedRunnable;
import org.appwork.storage.config.ValidationException;
import org.appwork.storage.config.events.GenericConfigEventListener;
import org.appwork.storage.config.handler.KeyHandler;
import org.appwork.utils.Application;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.swing.EDTHelper;
import org.jdownloader.gui.views.SelectionInfo;
import org.jdownloader.gui.views.linkgrabber.LinkGrabberTable;
import org.jdownloader.gui.views.linkgrabber.contextmenu.ConfirmLinksContextAction;
import org.jdownloader.myjdownloader.client.json.AvailableLinkState;
import org.jdownloader.settings.staticreferences.CFG_LINKGRABBER;

public class AutoStartManager
implements GenericConfigEventListener<Boolean> {
    private final DelayedRunnable delayer;
    private volatile boolean globalAutoStart;
    private volatile boolean globalAutoConfirm;
    private final AutoStartManagerEventSender eventSender;
    private final WeakHashMap<LinkCollectorCrawler, Boolean> resetMap = new WeakHashMap();

    public AutoStartManagerEventSender getEventSender() {
        return this.eventSender;
    }

    public AutoStartManager() {
        this.eventSender = new AutoStartManagerEventSender();
        CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.getEventSender().addListener((EventListener)((Object)this), true);
        CFG_LINKGRABBER.LINKGRABBER_AUTO_CONFIRM_ENABLED.getEventSender().addListener((EventListener)((Object)this), true);
        this.globalAutoStart = CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.isEnabled();
        this.globalAutoConfirm = CFG_LINKGRABBER.LINKGRABBER_AUTO_CONFIRM_ENABLED.isEnabled();
        int minDelay = Math.max(1, CFG_LINKGRABBER.CFG.getAutoConfirmDelay());
        int maxDelay = CFG_LINKGRABBER.CFG.getAutoConfirmMaxDelay();
        if (maxDelay <= 0) {
            maxDelay = -1;
        } else if (maxDelay < minDelay) {
            maxDelay = minDelay;
        }
        this.delayer = new DelayedRunnable(minDelay, maxDelay){

            public String getID() {
                return "AutoConfirmButton";
            }

            public void delayedrun() {
                final SelectionInfo selectionInfo = !Application.isHeadless() && CFG_LINKGRABBER.CFG.isAutoStartConfirmSidebarFilterEnabled() ? (SelectionInfo)new EDTHelper<SelectionInfo<CrawledPackage, CrawledLink>>(){

                    public SelectionInfo<CrawledPackage, CrawledLink> edtRun() {
                        LinkGrabberTable.getInstance().getModel().fireStructureChange(true);
                        return LinkGrabberTable.getInstance().getSelectionInfo(false, true);
                    }
                }.getReturnValue() : LinkCollector.getInstance().getSelectionInfo();
                LinkCollector.getInstance().getQueue().add((QueueAction)new QueueAction<Void, RuntimeException>(){

                    protected Void run() throws RuntimeException {
                        if (AutoStartManager.this.eventSender.hasListener()) {
                            AutoStartManager.this.eventSender.fireEvent((DefaultEvent)new AutoStartManagerEvent((Object)this, AutoStartManagerEvent.Type.RUN, new Object[0]));
                        }
                        boolean autoConfirm = AutoStartManager.this.globalAutoConfirm;
                        ArrayList<CrawledLink> list = new ArrayList<CrawledLink>(selectionInfo.getChildren().size());
                        boolean createNewSelection = false;
                        for (CrawledLink child : selectionInfo.getChildren()) {
                            if (child.getLinkState() == AvailableLinkState.OFFLINE) {
                                createNewSelection = true;
                                continue;
                            }
                            if (autoConfirm || child.isAutoConfirmEnabled()) {
                                list.add(child);
                                continue;
                            }
                            createNewSelection = true;
                        }
                        if (list.size() > 0) {
                            SelectionInfo<CrawledPackage, CrawledLink> si = createNewSelection ? new SelectionInfo<CrawledPackage, CrawledLink>(null, list) : selectionInfo;
                            LinkCollector.ConfirmLinksSettings cls = new LinkCollector.ConfirmLinksSettings(LinkCollector.MoveLinksMode.AUTO);
                            ConfirmLinksContextAction.confirmSelection(si, cls);
                        }
                        if (!AutoStartManager.this.delayer.isDelayerActive() && AutoStartManager.this.eventSender.hasListener()) {
                            AutoStartManager.this.eventSender.fireEvent((DefaultEvent)new AutoStartManagerEvent((Object)this, AutoStartManagerEvent.Type.DONE, new Object[0]));
                        }
                        return null;
                    }
                });
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onCrawlerFinished(LinkCollectorCrawler linkCrawler) {
        Boolean resetFlag;
        WeakHashMap<LinkCollectorCrawler, Boolean> weakHashMap = this.resetMap;
        synchronized (weakHashMap) {
            resetFlag = this.resetMap.get(linkCrawler);
        }
        if (Boolean.TRUE.equals(resetFlag)) {
            this.resetAndStart(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLinkAdded(CrawledLink link) {
        if (this.globalAutoStart || this.globalAutoConfirm || link.isAutoConfirmEnabled() || link.isAutoStartEnabled() || link.isForcedAutoStartEnabled()) {
            LinkCollectingInformation collectingInfo = link.getCollectingInfo();
            if (collectingInfo != null) {
                LinkCollector.JobLinkCrawler linkCrawler = collectingInfo.getLinkCrawler();
                WeakHashMap<LinkCollectorCrawler, Boolean> weakHashMap = this.resetMap;
                synchronized (weakHashMap) {
                    this.resetMap.put(linkCrawler, Boolean.TRUE);
                    if (this.delayer.getMaximumDelay() == -1L && linkCrawler.isCollecting()) {
                        this.resetAndStart(true);
                        return;
                    }
                    this.resetMap.remove(linkCrawler);
                }
            }
            this.resetAndStart(false);
        }
    }

    protected void resetAndStart(boolean onlyWhenActive) {
        if (!onlyWhenActive || this.delayer.isDelayerActive()) {
            this.delayer.resetAndStart();
            if (this.eventSender.hasListener()) {
                this.eventSender.fireEvent((DefaultEvent)new AutoStartManagerEvent(this, AutoStartManagerEvent.Type.RESET, new Object[0]));
            }
        }
    }

    public void onConfigValidatorError(KeyHandler<Boolean> keyHandler, Boolean invalidValue, ValidationException validateException) {
    }

    public void onConfigValueModified(KeyHandler<Boolean> keyHandler, Boolean newValue) {
        this.globalAutoStart = CFG_LINKGRABBER.LINKGRABBER_AUTO_START_ENABLED.isEnabled();
        this.globalAutoConfirm = CFG_LINKGRABBER.LINKGRABBER_AUTO_CONFIRM_ENABLED.isEnabled();
    }

    public int getMaximum() {
        return (int)this.delayer.getMinimumDelay();
    }

    public int getValue() {
        return (int)this.delayer.getEstimatedNextRun();
    }

    public boolean isRunning() {
        return this.delayer != null && this.delayer.isDelayerActive();
    }

    public void interrupt() {
        if (this.delayer.stop() && this.eventSender.hasListener()) {
            this.eventSender.fireEvent((DefaultEvent)new AutoStartManagerEvent(this, AutoStartManagerEvent.Type.DONE, new Object[0]));
        }
    }
}

