/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jd.config.Property;
import jd.controlling.linkcollector.LinknameCleaner;
import jd.controlling.linkcrawler.CrawledLink;
import jd.controlling.linkcrawler.CrawledLinkProperty;
import jd.controlling.linkcrawler.CrawledPackageProperty;
import jd.controlling.linkcrawler.CrawledPackageView;
import jd.controlling.packagecontroller.AbstractNode;
import jd.controlling.packagecontroller.AbstractNodeNotifier;
import jd.controlling.packagecontroller.AbstractPackageChildrenNode;
import jd.controlling.packagecontroller.AbstractPackageNode;
import jd.controlling.packagecontroller.PackageController;
import jd.controlling.packagecontroller.PackageControllerComparator;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.ModifyLock;
import org.appwork.utils.StringUtils;
import org.jdownloader.controlling.Priority;
import org.jdownloader.controlling.UniqueAlltimeID;
import org.jdownloader.controlling.packagizer.PackagizerController;
import org.jdownloader.controlling.packagizer.SubFolderByPackageRule;
import org.jdownloader.gui.views.linkgrabber.addlinksdialog.LinkgrabberSettings;
import org.jdownloader.settings.GeneralSettings;
import org.jdownloader.settings.staticreferences.CFG_LINKCOLLECTOR;

public class CrawledPackage
implements AbstractPackageNode<CrawledLink, CrawledPackage> {
    private TYPE type = TYPE.NORMAL;
    private static final int SUBFOLDER_THRESHOLD = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).getSubfolderThreshold();
    private static final SubFolderByPackageRule.COUNT SUBFOLDER_COUNT = ((LinkgrabberSettings)JsonConfig.create(LinkgrabberSettings.class)).getSubfolderCount();
    private static final GeneralSettings GENERALSETTINGS = (GeneralSettings)JsonConfig.create(GeneralSettings.class);
    private List<CrawledLink> children;
    private String comment = null;
    private PackageController<CrawledPackage, CrawledLink> controller = null;
    private long created;
    private long modified = this.created = System.currentTimeMillis();
    private String name = null;
    private String downloadFolder = null;
    private boolean downloadFolderContainsTags = false;
    private boolean expanded = CFG_LINKCOLLECTOR.CFG.isPackageAutoExpanded();
    private UniqueAlltimeID uniqueID = null;
    protected CrawledPackageView view;
    private String compiledDownloadFolder = null;
    private ModifyLock lock = null;
    private PackageControllerComparator<AbstractNode> sorter;
    private Priority priority = Priority.DEFAULT;

    public void setType(TYPE type) {
        this.type = type;
    }

    public TYPE getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UniqueAlltimeID getUniqueID() {
        if (this.uniqueID == null) {
            CrawledPackage crawledPackage = this;
            synchronized (crawledPackage) {
                if (this.uniqueID == null) {
                    this.uniqueID = new UniqueAlltimeID();
                }
            }
        }
        return this.uniqueID;
    }

    public CrawledPackage() {
        this.children = new ArrayList<CrawledLink>();
        if (GENERALSETTINGS.isAutoSortChildrenEnabled()) {
            this.sorter = PackageControllerComparator.SORTER_ASC;
        }
        this.setDownloadFolder(null);
    }

    @Override
    public void copyPropertiesTo(CrawledPackage dest) {
        if (dest == null || dest == this) {
            return;
        }
        dest.name = this.name;
        dest.comment = this.comment;
        dest.setDownloadFolder(this.getRawDownloadFolder());
    }

    @Override
    public List<CrawledLink> getChildren() {
        return this.children;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public PackageController<CrawledPackage, CrawledLink> getControlledBy() {
        return this.controller;
    }

    @Override
    public long getCreated() {
        return this.created;
    }

    public void setModified(long modified) {
        this.modified = modified;
    }

    @Override
    public long getModified() {
        return this.modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDownloadFolder() {
        String ret = this.compiledDownloadFolder;
        if (ret == null) {
            ret = this.getRawDownloadFolder();
            if (ret != null && this.downloadFolderContainsTags) {
                if (SUBFOLDER_THRESHOLD == 0) {
                    ret = PackagizerController.replaceDynamicTags(ret, this.getName(), this);
                } else if (this.getChildren().size() <= SUBFOLDER_THRESHOLD) {
                    ret = PackagizerController.replaceDynamicTags(ret, null, this);
                } else {
                    switch (SUBFOLDER_COUNT) {
                        case ITEMS: {
                            ret = PackagizerController.replaceDynamicTags(ret, this.getName(), this);
                            break;
                        }
                        case NAMES: {
                            boolean readL = this.getModifyLock().readLock();
                            try {
                                HashSet<String> names = new HashSet<String>();
                                for (CrawledLink link : this.getChildren()) {
                                    names.add(link.getName());
                                    if (names.size() <= SUBFOLDER_THRESHOLD) continue;
                                    break;
                                }
                                if (names.size() > SUBFOLDER_THRESHOLD) {
                                    ret = PackagizerController.replaceDynamicTags(ret, this.getName(), this);
                                    break;
                                }
                                ret = PackagizerController.replaceDynamicTags(ret, null, this);
                                break;
                            }
                            finally {
                                this.getModifyLock().readUnlock(readL);
                            }
                        }
                    }
                }
            }
            this.compiledDownloadFolder = ret;
        }
        return ret;
    }

    @Override
    public long getFinishedDate() {
        return 0L;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getRawDownloadFolder() {
        return this.downloadFolder;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    public void notifyStructureChanges() {
    }

    @Override
    public void setComment(String comment) {
        if (!StringUtils.equals((String)comment, (String)this.comment)) {
            this.comment = comment;
            this.setType(TYPE.NORMAL);
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledPackageProperty(this, CrawledPackageProperty.Property.COMMENT, this.getComment()));
            }
        }
    }

    @Override
    public void setControlledBy(PackageController<CrawledPackage, CrawledLink> controller) {
        this.controller = controller;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    @Override
    public void setName(String name) {
        if (!StringUtils.equals((String)name, (String)this.name)) {
            if (name != null && StringUtils.equals((String)(name = LinknameCleaner.cleanPackagename(name, true)), (String)this.name)) {
                return;
            }
            this.setType(TYPE.NORMAL);
            this.name = name;
            this.compiledDownloadFolder = null;
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledPackageProperty(this, CrawledPackageProperty.Property.NAME, this.getName()));
            }
        }
    }

    @Override
    public void setDownloadFolder(String downloadFolder) {
        if (!StringUtils.equals((String)downloadFolder, (String)this.getDownloadFolder())) {
            if (!StringUtils.isEmpty((String)downloadFolder)) {
                this.downloadFolderContainsTags = downloadFolder.contains("<jd:");
                this.downloadFolder = Property.dedupeString(downloadFolder.trim());
            } else {
                this.downloadFolderContainsTags = false;
                this.downloadFolder = null;
            }
            this.compiledDownloadFolder = null;
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledPackageProperty(this, CrawledPackageProperty.Property.FOLDER, this.getDownloadFolder()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean b) {
        ArrayList<CrawledLink> links;
        boolean readL = this.getModifyLock().readLock();
        try {
            links = new ArrayList<CrawledLink>(this.getChildren());
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
        for (CrawledLink link : links) {
            link.setEnabled(b);
        }
    }

    @Override
    public void setExpanded(boolean b) {
        this.expanded = b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CrawledPackageView getView() {
        if (this.view == null) {
            CrawledPackage crawledPackage = this;
            synchronized (crawledPackage) {
                if (this.view == null) {
                    CrawledPackageView lfpInfo;
                    this.view = lfpInfo = new CrawledPackageView(this);
                }
            }
        }
        return this.view;
    }

    @Override
    public boolean isEnabled() {
        return this.getView().isEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int indexOf(CrawledLink child) {
        boolean readL = this.getModifyLock().readLock();
        try {
            int n = this.children.indexOf(child);
            return n;
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
    }

    public void setPriorityEnum(Priority priority) {
        if (priority == null) {
            priority = Priority.DEFAULT;
        }
        if (this.getPriorityEnum() != priority) {
            this.priority = priority;
            if (this.hasNotificationListener()) {
                this.nodeUpdated(this, AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE, new CrawledPackageProperty(this, CrawledPackageProperty.Property.PRIORITY, (Object)priority));
            }
        }
    }

    public Priority getPriorityEnum() {
        return this.priority;
    }

    @Override
    public PackageControllerComparator<AbstractNode> getCurrentSorter() {
        return this.sorter;
    }

    @Override
    public void setCurrentSorter(PackageControllerComparator<AbstractNode> comparator) {
        this.sorter = comparator;
    }

    @Override
    public void nodeUpdated(AbstractNode source, AbstractNodeNotifier.NOTIFY notify, Object param) {
        if (source == this && AbstractNodeNotifier.NOTIFY.STRUCTURE_CHANGE.equals((Object)notify)) {
            this.setModified(System.currentTimeMillis());
            this.compiledDownloadFolder = null;
        } else {
            CrawledPackageView lView;
            PackageController<CrawledPackage, CrawledLink> n;
            if (source instanceof AbstractPackageChildrenNode && AbstractNodeNotifier.NOTIFY.PROPERTY_CHANGE.equals((Object)notify) && param instanceof CrawledLinkProperty && CrawledLinkProperty.Property.NAME.equals((Object)((CrawledLinkProperty)param).getProperty())) {
                this.compiledDownloadFolder = null;
            }
            if ((n = this.getControlledBy()) == null) {
                return;
            }
            AbstractNode lsource = source == null ? this : source;
            if (lsource instanceof AbstractPackageChildrenNode && (lView = this.view) != null) {
                lView.requestUpdate();
            }
            n.nodeUpdated(lsource, notify, param);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ModifyLock getModifyLock() {
        if (this.lock == null) {
            CrawledPackage crawledPackage = this;
            synchronized (crawledPackage) {
                if (this.lock == null) {
                    this.lock = new ModifyLock();
                }
            }
        }
        return this.lock;
    }

    @Override
    public boolean hasNotificationListener() {
        PackageController<CrawledPackage, CrawledLink> n = this.getControlledBy();
        return n != null && n.hasNotificationListener();
    }

    @Override
    public int size() {
        boolean readL = this.getModifyLock().readLock();
        try {
            int n = this.children.size();
            return n;
        }
        finally {
            if (readL) {
                this.getModifyLock().readUnlock(readL);
            }
        }
    }

    @Override
    public String getDownloadDirectory() {
        return this.getDownloadFolder();
    }

    public static enum TYPE {
        NORMAL,
        OFFLINE,
        POFFLINE,
        VARIOUS;

    }
}

