/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.util.List;
import jd.controlling.linkcrawler.LinkCrawlerRuleStorable;
import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultEnumValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultJsonObject;
import org.appwork.storage.config.annotations.DefaultStringArrayValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.RequiresRestart;
import org.appwork.storage.config.annotations.SpinnerValidator;

public interface LinkCrawlerConfig
extends ConfigInterface {
    @DefaultIntValue(value=12)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="max. number of linkcrawler threads")
    @SpinnerValidator(min=1L, max=128L)
    public int getMaxThreads();

    public void setMaxThreads(int var1);

    @DefaultIntValue(value=20000)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="max. time in ms before killing an idle linkcrawler thread")
    public int getThreadKeepAlive();

    public void setThreadKeepAlive(int var1);

    @DefaultIntValue(value=0xA00000)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="max. bytes for page request during deep decrypt")
    @SpinnerValidator(min=0x100000L, max=0x6400000L)
    public int getDeepDecryptLoadLimit();

    public void setDeepDecryptLoadLimit(int var1);

    @DefaultIntValue(value=0x200000)
    @AboutConfig
    @RequiresRestart(value="A JDownloader Restart is Required")
    @DescriptionForConfigEntry(value="max. file size in bytes during deep decrypt")
    @SpinnerValidator(min=-1L, max=0x6400000L)
    public int getDeepDecryptFileSizeLimit();

    public void setDeepDecryptFileSizeLimit(int var1);

    @DefaultStringArrayValue(value={"CAPTCHA", "EMPTY_FOLDER", "EMPTY_PROFILE", "FILE_NOT_FOUND", "HOST", "NO_ACCOUNT", "PLUGIN_DEFECT", "PLUGIN_SETTINGS", "PASSWORD", "GEO", "IP", "HOST_RATE_LIMIT", "UNSUPPORTED_LIVESTREAM", "BLOCKED_BY"})
    @AboutConfig
    @DescriptionForConfigEntry(value="Add a retry task for following crawling errors")
    public String[] getAddRetryCrawlerTasks3();

    public void setAddRetryCrawlerTasks3(String[] var1);

    @DefaultBooleanValue(value=true)
    @AboutConfig
    public boolean isLinkCrawlerRulesEnabled();

    @DefaultStringArrayValue(value={"ADD_LINKS_DIALOG", "PASTE_LINKS_ACTION", "MYJD"})
    @AboutConfig
    public String[] getAutoLearnExtensionOrigins();

    public void setAutoLearnExtensionOrigins(String[] var1);

    public void setLinkCrawlerRulesEnabled(boolean var1);

    @DefaultJsonObject(value="[]")
    @AboutConfig
    public List<LinkCrawlerRuleStorable> getLinkCrawlerRules();

    public void setLinkCrawlerRules(List<LinkCrawlerRuleStorable> var1);

    @AboutConfig
    @DefaultEnumValue(value="ALWAYS")
    @DescriptionForConfigEntry(value="When to accept direct downloadable URLs? ALWAYS = Accept all, no matter how they were added RULES_ONLY = Only accept direct URLs added via LinkCrawler DIRECTHTTP rule, FORBIDDEN = Never accept direct URLs")
    public DirectHTTPPermission getDirectHTTPPermission();

    public void setDirectHTTPPermission(DirectHTTPPermission var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    public boolean isAutoImportContainer();

    public void setAutoImportContainer(boolean var1);

    public static enum DirectHTTPPermission {
        ALWAYS,
        RULES_ONLY,
        FORBIDDEN;

    }
}

