/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.linkcrawler;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import jd.http.Browser;
import jd.http.Cookie;
import jd.http.Cookies;
import org.appwork.remoteapi.annotations.AllowNonStorableObjects;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.URLHelper;
import org.jdownloader.controlling.UniqueAlltimeID;

public class LinkCrawlerRule {
    protected boolean enabled = true;
    protected List<String[]> cookies = null;
    protected List<String[]> headers = null;
    protected Map<String, List<Pattern>> propertyPatterns = null;
    protected boolean updateCookies = false;
    protected boolean logging = false;
    protected int maxDecryptDepth = 0;
    protected final UniqueAlltimeID id;
    protected String name = null;
    protected Pattern pattern = null;
    protected RULE rule = null;
    protected Pattern packageNamePattern = null;
    protected Pattern passwordPattern = null;
    protected Pattern formPattern = null;
    protected Pattern deepPattern = null;
    protected String rewriteReplaceWith = null;

    public boolean isLogging() {
        return this.logging;
    }

    public void setLogging(boolean logging) {
        this.logging = logging;
    }

    public boolean isUpdateCookies() {
        return this.updateCookies;
    }

    public void setUpdateCookies(boolean updateCookies) {
        this.updateCookies = updateCookies;
    }

    public Object getCookies() {
        return this._getCookies();
    }

    @AllowNonStorableObjects
    public void setCookies(Object obj) {
        Cookies cookies = Cookies.parseCookiesFromObject((Object)obj, null);
        if (cookies == null) {
            this._setCookies(null);
            return;
        }
        ArrayList<String[]> cookielist = new ArrayList<String[]>();
        for (Cookie cookie : cookies.getCookies()) {
            String[] cookiearray;
            if (cookie.getHost() != null) {
                cookiearray = new String[]{cookie.getKey(), cookie.getValue(), cookie.getHost()};
                cookielist.add(cookiearray);
                continue;
            }
            cookiearray = new String[]{cookie.getKey(), cookie.getValue()};
            cookielist.add(cookiearray);
        }
        this._setCookies(cookielist);
    }

    public List<String[]> getHeaders() {
        return this.headers;
    }

    public void setHeaders(List<String[]> headers) {
        this.headers = headers == null || headers.size() == 0 ? null : new ArrayList<String[]>(headers);
    }

    @AllowNonStorableObjects
    public Map<String, Object> getPropertyPatterns() {
        if (this.propertyPatterns == null) {
            return null;
        }
        HashMap<String, Object> propertyPatternsO = new HashMap<String, Object>();
        for (Map.Entry<String, List<Pattern>> entry : this.propertyPatterns.entrySet()) {
            ArrayList<String> patternsStr = new ArrayList<String>();
            for (Pattern pattern : entry.getValue()) {
                patternsStr.add(pattern.pattern());
            }
            propertyPatternsO.put(entry.getKey(), patternsStr);
        }
        return propertyPatternsO;
    }

    public Map<String, List<Pattern>> _getPropertyPatterns() {
        return this.propertyPatterns;
    }

    public void setPropertyPatterns(Map<String, Object> propertyPatterns) {
        if (propertyPatterns == null) {
            this.propertyPatterns = null;
            return;
        }
        HashMap<String, List<Pattern>> compiledPropertiesPatternMap = new HashMap<String, List<Pattern>>();
        for (Map.Entry<String, Object> entry : propertyPatterns.entrySet()) {
            String key = entry.getKey();
            if (StringUtils.isEmpty((String)key)) continue;
            Object value = entry.getValue();
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            if (value instanceof String) {
                patterns.add(Pattern.compile(value.toString()));
            } else {
                if (!(value instanceof List)) continue;
                for (String regexStr : (List)value) {
                    patterns.add(Pattern.compile(regexStr));
                }
            }
            compiledPropertiesPatternMap.put(key, patterns);
        }
        this.propertyPatterns = compiledPropertiesPatternMap;
    }

    public int getMaxDecryptDepth() {
        return this.maxDecryptDepth;
    }

    public void setMaxDecryptDepth(int maxDecryptDepth) {
        this.maxDecryptDepth = maxDecryptDepth < 0 ? -1 : maxDecryptDepth;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public UniqueAlltimeID _getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id.setID(id);
    }

    public long getId() {
        return this.id.getID();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPattern() {
        Pattern lPattern = this._getPattern();
        if (lPattern != null) {
            return lPattern.pattern();
        }
        return null;
    }

    public boolean updateCookies(Browser br, String url, boolean forceUpdate, boolean onlyOnPatternMatch) {
        if ((!onlyOnPatternMatch || this.matches(url)) && (forceUpdate || this.isUpdateCookies())) {
            Cookies cookies = br.getCookies(url);
            ArrayList<String[]> updateCookies = new ArrayList<String[]>();
            for (Cookie cookie : cookies.getCookies()) {
                if (cookie.isExpired()) continue;
                updateCookies.add(new String[]{cookie.getKey(), cookie.getValue()});
            }
            this._setCookies(updateCookies);
            return true;
        }
        return false;
    }

    protected void _setCookies(List<String[]> cookies) {
        this.cookies = cookies == null || cookies.size() == 0 ? null : new ArrayList<String[]>(cookies);
    }

    protected List<String[]> _getCookies() {
        return this.cookies;
    }

    public void applyCookiesAndHeaders(Browser br, String url, boolean onlyOnPatternMatch) {
        this.applyCookies(br, url, onlyOnPatternMatch);
        this.applyHeaders(br);
    }

    public boolean applyCookies(Browser br, String url, boolean onlyOnPatternMatch) {
        if (onlyOnPatternMatch && !this.matches(url)) {
            return false;
        }
        List<String[]> cookies = this._getCookies();
        if (cookies == null || cookies.size() == 0) {
            return false;
        }
        int cookiesSet = 0;
        String host = Browser.getHost((String)url);
        for (String[] cookie : cookies) {
            if (cookie == null) continue;
            switch (cookie.length) {
                case 1: {
                    br.setCookie(url, cookie[0], null);
                    ++cookiesSet;
                    break;
                }
                case 2: {
                    br.setCookie(url, cookie[0], cookie[1]);
                    ++cookiesSet;
                    break;
                }
                case 3: {
                    if (cookie[2] != null && !StringUtils.equalsIgnoreCase((String)host, (String)cookie[2])) break;
                    br.setCookie(url, cookie[0], cookie[1]);
                    ++cookiesSet;
                    break;
                }
            }
        }
        return cookiesSet > 0;
    }

    public boolean applyHeaders(Browser br) {
        List<String[]> headers = this.getHeaders();
        if (headers == null || headers.size() == 0) {
            return false;
        }
        int headersSet = 0;
        for (String[] header : headers) {
            if (header == null || header.length != 2 || header[0] == null) continue;
            br.getHeaders().put(header[0], header[1]);
            ++headersSet;
        }
        return headersSet > 0;
    }

    public boolean matches(String input) {
        Pattern lPattern = this._getPattern();
        if (lPattern == null || input == null) {
            return false;
        }
        if (lPattern.matcher(input).matches()) {
            return true;
        }
        try {
            URL url = new URL(input);
            if (url.getUserInfo() != null) {
                return lPattern.matcher(URLHelper.getURL((URL)url, (boolean)true, (boolean)false, (boolean)true).toString()).matches();
            }
            return false;
        }
        catch (Throwable ignore) {
            return false;
        }
    }

    public Pattern _getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public RULE getRule() {
        return this.rule;
    }

    public void setRule(RULE rule) {
        this.rule = rule;
    }

    public LinkCrawlerRule() {
        this.id = new UniqueAlltimeID();
    }

    protected LinkCrawlerRule(long ID2) {
        this.id = new UniqueAlltimeID(ID2);
    }

    public Pattern _getPasswordPattern() {
        return this.passwordPattern;
    }

    public String getPasswordPattern() {
        Pattern lPattern = this._getPasswordPattern();
        if (lPattern != null) {
            return lPattern.pattern();
        }
        return null;
    }

    public void setPasswordPattern(String pattern) {
        this.passwordPattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public String getRewriteReplaceWith() {
        return this.rewriteReplaceWith;
    }

    public void setRewriteReplaceWith(String rewriteReplaceWith) {
        this.rewriteReplaceWith = rewriteReplaceWith;
    }

    public Pattern _getDeepPattern() {
        return this.deepPattern;
    }

    public String getDeepPattern() {
        Pattern lPattern = this._getDeepPattern();
        if (lPattern != null) {
            return lPattern.pattern();
        }
        return null;
    }

    public void setDeepPattern(String pattern) {
        this.deepPattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public Pattern _getPackageNamePattern() {
        return this.packageNamePattern;
    }

    public Pattern _getFormPattern() {
        return this.formPattern;
    }

    public String getFormPattern() {
        Pattern lPattern = this._getFormPattern();
        if (lPattern != null) {
            return lPattern.pattern();
        }
        return null;
    }

    public void setFormPattern(String pattern) {
        this.formPattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public String getPackageNamePattern() {
        Pattern lPattern = this._getPackageNamePattern();
        if (lPattern != null) {
            return lPattern.pattern();
        }
        return null;
    }

    public void setPackageNamePattern(String pattern) {
        this.packageNamePattern = pattern == null ? null : Pattern.compile(pattern);
    }

    public static enum RULE {
        REWRITE,
        SUBMITFORM,
        DIRECTHTTP,
        DEEPDECRYPT,
        FOLLOWREDIRECT;

    }
}

