/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.lang.ref.WeakReference;
import java.net.URL;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ConnectionBan;
import org.appwork.utils.Hash;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;

public abstract class AbstractBan
implements ConnectionBan {
    protected final AbstractProxySelectorImpl selector;
    protected final WeakReference<HTTPProxy> proxy;
    protected final String auth;

    public AbstractBan(HTTPProxy proxy, AbstractProxySelectorImpl proxySelector) {
        this.selector = proxySelector;
        this.proxy = new WeakReference<HTTPProxy>(proxy);
        this.auth = this.getAuth(proxy);
    }

    public AbstractProxySelectorImpl getSelector() {
        return this.selector;
    }

    protected HTTPProxy getProxy() {
        return (HTTPProxy)this.proxy.get();
    }

    protected String getAuth() {
        return this.auth;
    }

    @Override
    public boolean isExpired() {
        HTTPProxy proxy = this.getProxy();
        return proxy == null || !StringUtils.equals((String)this.getAuth(), (String)this.getAuth(proxy));
    }

    protected int getPort(URL uri) {
        int ret = uri.getPort();
        if (ret == -1) {
            String scheme = uri.getProtocol();
            if (StringUtils.equalsIgnoreCase((String)scheme, (String)"http")) {
                return 80;
            }
            if (StringUtils.equalsIgnoreCase((String)scheme, (String)"https")) {
                return 443;
            }
            if (StringUtils.equalsIgnoreCase((String)scheme, (String)"ftp")) {
                return 21;
            }
            return uri.getDefaultPort();
        }
        return ret;
    }

    protected String getAuth(HTTPProxy proxy) {
        if (proxy != null) {
            return Hash.getSHA256((String)(proxy.getUser() + ":" + proxy.getPass()));
        }
        return null;
    }

    public boolean stringEquals(String a, String b) {
        return StringUtils.equals((String)a, (String)b);
    }

    public boolean proxyEquals(HTTPProxy a, HTTPProxy b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            return a.getType() == b.getType() && this.stringEquals(a.getHost(), b.getHost()) && a.getPort() == b.getPort();
        }
        return false;
    }
}

