/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.proxy;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jd.controlling.proxy.AbstractProxySelectorImpl;
import jd.controlling.proxy.ProxyController;
import jd.controlling.proxy.SelectProxyByURLHook;
import jd.controlling.proxy.SelectedProxy;
import jd.http.Request;
import jd.plugins.Plugin;
import org.appwork.utils.StringUtils;
import org.appwork.utils.net.httpconnection.HTTPProxy;
import org.appwork.utils.net.httpconnection.HTTPProxyStorable;
import org.jdownloader.updatev2.ProxyData;

public class SingleBasicProxySelectorImpl
extends AbstractProxySelectorImpl {
    private final SelectedProxy proxy;
    private final List<HTTPProxy> list;
    private String username;
    private String password;
    private String tempUser;
    private String tempPass;

    @Override
    public ProxyData toProxyData() {
        HTTPProxyStorable storable = HTTPProxy.getStorable((HTTPProxy)this.getProxy());
        storable.setUsername(this.username);
        storable.setPassword(this.password);
        storable.setPreferNativeImplementation(this.isPreferNativeImplementation());
        ProxyData ret = super.toProxyData(storable);
        ret.setProxy(storable);
        ret.setReconnectSupported(this.isReconnectSupported());
        return ret;
    }

    @Override
    public String toDetailsString() {
        String ret = this.proxy.toString();
        if (StringUtils.isNotEmpty((String)this.getUser())) {
            return this.getUser() + "@" + ret;
        }
        return ret;
    }

    public boolean updateProxy(Request request, int retryCounter) {
        return ProxyController.getInstance().updateProxy(this, request, retryCounter);
    }

    public SingleBasicProxySelectorImpl(ProxyData proxyData) {
        this.proxy = new SelectedProxy(this, HTTPProxy.getHTTPProxy((HTTPProxyStorable)proxyData.getProxy()));
        this.setFilter(proxyData.getFilter());
        this.proxy.setConnectMethodPrefered(proxyData.getProxy().isConnectMethodPrefered());
        this.setResumeAllowed(proxyData.isRangeRequestsSupported());
        this.setEnabled(proxyData.isEnabled());
        this.username = this.proxy.getUser();
        this.password = this.proxy.getPass();
        ArrayList<SelectedProxy> list = new ArrayList<SelectedProxy>();
        list.add(this.proxy);
        this.list = Collections.unmodifiableList(list);
        this.setReconnectSupported(proxyData.isReconnectSupported());
    }

    public SingleBasicProxySelectorImpl(HTTPProxy rawProxy) {
        this.proxy = new SelectedProxy(this, rawProxy);
        this.username = this.proxy.getUser();
        this.password = this.proxy.getPass();
        ArrayList<SelectedProxy> list = new ArrayList<SelectedProxy>();
        list.add(this.proxy);
        this.list = Collections.unmodifiableList(list);
    }

    public List<HTTPProxy> getProxiesByURL(URL url) {
        for (SelectProxyByURLHook hook : this.selectProxyByURLHooks) {
            hook.onProxyChoosen(url, this.list);
        }
        return this.list;
    }

    public SelectedProxy getProxy() {
        return this.proxy;
    }

    @Override
    public AbstractProxySelectorImpl.Type getType() {
        HTTPProxy.TYPE type = this.getProxy().getType();
        switch (type) {
            case HTTP: {
                return AbstractProxySelectorImpl.Type.HTTP;
            }
            case HTTPS: {
                return AbstractProxySelectorImpl.Type.HTTPS;
            }
            case SOCKS4: {
                return AbstractProxySelectorImpl.Type.SOCKS4;
            }
            case SOCKS4A: {
                return AbstractProxySelectorImpl.Type.SOCKS4A;
            }
            case SOCKS5: {
                return AbstractProxySelectorImpl.Type.SOCKS5;
            }
        }
        throw new IllegalStateException(type.name());
    }

    @Override
    public void setType(AbstractProxySelectorImpl.Type value) {
        switch (value) {
            case HTTP: {
                this.proxy.setType(HTTPProxy.TYPE.HTTP);
                break;
            }
            case HTTPS: {
                this.proxy.setType(HTTPProxy.TYPE.HTTPS);
                break;
            }
            case SOCKS4: {
                this.proxy.setType(HTTPProxy.TYPE.SOCKS4);
                break;
            }
            case SOCKS4A: {
                this.proxy.setType(HTTPProxy.TYPE.SOCKS4A);
                break;
            }
            case SOCKS5: {
                this.proxy.setType(HTTPProxy.TYPE.SOCKS5);
                break;
            }
            default: {
                throw new IllegalStateException(value.name());
            }
        }
    }

    public void setUser(String user) {
        SelectedProxy proxy = this.getProxy();
        if (!StringUtils.equals((String)user, (String)proxy.getUser())) {
            proxy.setUser(user);
            this.username = user;
            this.tempUser = null;
            this.tempPass = null;
            this.clearBanList();
        }
    }

    public void setPassword(String pass) {
        SelectedProxy proxy = this.getProxy();
        if (!StringUtils.equals((String)pass, (String)proxy.getPass())) {
            proxy.setPass(pass);
            this.password = pass;
            this.tempUser = null;
            this.tempPass = null;
            this.clearBanList();
        }
    }

    public String getPassword() {
        String ret = this.tempPass;
        if (ret != null) {
            return "(Temp)" + ret;
        }
        return this.password;
    }

    public String _getPassword() {
        String ret = this.tempPass;
        if (ret != null) {
            return ret;
        }
        return this.password;
    }

    public String _getUsername() {
        String ret = this.tempUser;
        if (ret != null) {
            return ret;
        }
        return this.username;
    }

    public String getUser() {
        String ret = this.tempUser;
        if (ret != null) {
            return "(Temp)" + ret;
        }
        return this.username;
    }

    @Override
    public boolean isPreferNativeImplementation() {
        return this.getProxy().isPreferNativeImplementation();
    }

    @Override
    public void setPreferNativeImplementation(boolean preferNativeImplementation) {
        if (this.isPreferNativeImplementation() != preferNativeImplementation) {
            this.getProxy().setPreferNativeImplementation(preferNativeImplementation);
            this.clearBanList();
        }
    }

    public int getPort() {
        return this.getProxy().getPort();
    }

    public void setPort(int port) {
        SelectedProxy proxy = this.getProxy();
        if (proxy.getPort() != port) {
            proxy.setPort(port);
            this.clearBanList();
        }
    }

    public void setHost(String value) {
        SelectedProxy proxy = this.getProxy();
        if (!StringUtils.equals((String)value, (String)proxy.getHost())) {
            proxy.setHost(value);
            this.clearBanList();
        }
    }

    public String getHost() {
        return this.getProxy().getHost();
    }

    @Override
    public String toExportString() {
        String password;
        StringBuilder sb = new StringBuilder();
        boolean hasUSerInfo = false;
        SelectedProxy proxy = this.getProxy();
        switch (proxy.getType()) {
            case HTTP: {
                sb.append("http://");
                break;
            }
            case HTTPS: {
                sb.append("https://");
                break;
            }
            case SOCKS4: {
                sb.append("socks4://");
                break;
            }
            case SOCKS4A: {
                sb.append("socks4a://");
                break;
            }
            case SOCKS5: {
                sb.append("socks5://");
                break;
            }
            case DIRECT: {
                if (proxy.getLocal() != null) {
                    sb.append("direct://");
                    sb.append(proxy.getLocal());
                    return sb.toString();
                }
                return null;
            }
            default: {
                return null;
            }
        }
        String username = this._getUsername();
        if (!StringUtils.isEmpty((String)username)) {
            sb.append(username);
            hasUSerInfo = true;
        }
        if (!StringUtils.isEmpty((String)(password = this._getPassword()))) {
            if (hasUSerInfo) {
                sb.append(":");
            }
            hasUSerInfo = true;
            sb.append(password);
        }
        if (hasUSerInfo) {
            sb.append("@");
        }
        sb.append(this.getHost());
        if (this.getPort() > 0) {
            sb.append(":");
            sb.append(this.getPort());
        }
        return sb.toString();
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(SingleBasicProxySelectorImpl.class) && this.getProxy().equals((Object)((SingleBasicProxySelectorImpl)obj).getProxy());
    }

    public int hashCode() {
        return SingleBasicProxySelectorImpl.class.hashCode();
    }

    @Override
    protected boolean isLocal() {
        return false;
    }

    @Override
    public boolean isProxyBannedFor(HTTPProxy orgReference, URL url, Plugin pluginFromThread, boolean ignoreConnectBans) {
        if (!this.getProxy().equals(orgReference)) {
            return false;
        }
        return super.isProxyBannedFor(orgReference, url, pluginFromThread, ignoreConnectBans);
    }

    public void setTempAuth(String user, String pass) {
        SelectedProxy proxy = this.getProxy();
        proxy.setUser(user == null ? this.username : user);
        proxy.setPass(pass == null ? this.password : pass);
        this.tempUser = user;
        this.tempPass = pass;
        if (user != null || pass != null) {
            this.clearBanList();
        }
    }
}

