/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import org.appwork.storage.config.ConfigInterface;
import org.appwork.storage.config.annotations.AboutConfig;
import org.appwork.storage.config.annotations.DefaultBooleanValue;
import org.appwork.storage.config.annotations.DefaultIntValue;
import org.appwork.storage.config.annotations.DefaultStringValue;
import org.appwork.storage.config.annotations.DescriptionForConfigEntry;
import org.appwork.storage.config.annotations.PlainStorage;
import org.appwork.storage.config.annotations.SpinnerValidator;

@PlainStorage
public interface ReconnectConfig
extends ConfigInterface {
    @AboutConfig
    public String getActivePluginID();

    public void setActivePluginID(String var1);

    @DefaultIntValue(value=0)
    public void setGlobalFailedCounter(int var1);

    public int getGlobalFailedCounter();

    @DefaultIntValue(value=0)
    public void setFailedCounter(int var1);

    public int getFailedCounter();

    @DefaultIntValue(value=0)
    public void setGlobalSuccessCounter(int var1);

    public int getGlobalSuccessCounter();

    @DefaultIntValue(value=0)
    public void setSuccessCounter(int var1);

    public int getSuccessCounter();

    @AboutConfig
    @DefaultIntValue(value=300)
    public int getSecondsToWaitForIPChange();

    public void setSecondsToWaitForIPChange(int var1);

    @AboutConfig
    @DefaultIntValue(value=60)
    public int getSecondsToWaitForOffline();

    public void setSecondsToWaitForOffline(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isIPCheckGloballyDisabled();

    public void setIPCheckGloballyDisabled(boolean var1);

    @DefaultIntValue(value=5)
    @AboutConfig
    public int getSecondsBeforeFirstIPCheck();

    public void setSecondsBeforeFirstIPCheck(int var1);

    @DescriptionForConfigEntry(value="Please enter Website for IPCheck here")
    @AboutConfig
    public String getGlobalIPCheckUrl();

    public void setGlobalIPCheckUrl(String var1);

    @DescriptionForConfigEntry(value="Please enter Regex for IPCheck here")
    @AboutConfig
    @DefaultStringValue(value="\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b")
    public String getGlobalIPCheckPattern();

    public void setGlobalIPCheckPattern(String var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    public boolean isCustomIPCheckEnabled();

    public void setCustomIPCheckEnabled(boolean var1);

    @DefaultIntValue(value=5)
    @AboutConfig
    public int getMaxReconnectRetryNum();

    public void setMaxReconnectRetryNum(int var1);

    @AboutConfig
    @DefaultIntValue(value=2000)
    public int getIPCheckConnectTimeout();

    public void setIPCheckConnectTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=10000)
    public int getIPCheckReadTimeout();

    public void setIPCheckReadTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=30000)
    public int getReconnectBrowserReadTimeout();

    public void setReconnectBrowserReadTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=30000)
    public int getReconnectBrowserConnectTimeout();

    public void setReconnectBrowserConnectTimeout(int var1);

    @AboutConfig
    @DefaultIntValue(value=5)
    @DescriptionForConfigEntry(value="Auto Reconnect Wizard performs a few reconnects for each successful script to find the fastest one. The more rounds we use, the better the result will be, but the longer it will take.")
    @SpinnerValidator(min=1L, max=20L)
    public int getOptimizationRounds();

    public void setOptimizationRounds(int var1);

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="AutoReconnect enabled?")
    public boolean isAutoReconnectEnabled();

    @AboutConfig
    @DescriptionForConfigEntry(value="Do not start further downloads if others are waiting for a reconnect/new ip")
    @DefaultBooleanValue(value=true)
    public boolean isDownloadControllerPrefersReconnectEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=true)
    @DescriptionForConfigEntry(value="If disabled, No Reconnects will be done while Resumable Downloads (Premium Downloads) are running")
    public boolean isReconnectAllowedToInterruptResumableDownloads();

    public void setAutoReconnectEnabled(boolean var1);

    @AboutConfig
    @DefaultIntValue(value=10)
    @DescriptionForConfigEntry(value="Disable auto reconnect if reconnect method has failed x times in a row (-1 = never disable auto reconnect)")
    @SpinnerValidator(min=-1L, max=100L)
    public int getDisableAutoReconnectFails();

    public void setDisableAutoReconnectFails(int var1);

    public void setReconnectAllowedToInterruptResumableDownloads(boolean var1);

    public void setDownloadControllerPrefersReconnectEnabled(boolean var1);

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="Usually, the IP Check has to use the direct connection. However, in some rare situations, it is important to use a proxy to do the ipcheck. Only change this if you are 100% sure.")
    public void setIPCheckUsesProxyEnabled(boolean var1);

    public boolean isIPCheckUsesProxyEnabled();

    @AboutConfig
    @DefaultBooleanValue(value=false)
    @DescriptionForConfigEntry(value="If your router supports UPNP, it might be possible to get your external IP by asking the router instead of doing a query to ipcheck*.jdownloader.org. This information might be incorrect. If the reconnect does not work after choosing this option, disable it.")
    public boolean isIPCheckAllowLocalUpnpIpCheckEnabled();

    public void setIPCheckAllowLocalUpnpIpCheckEnabled(boolean var1);
}

