/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.util.ArrayList;
import jd.controlling.reconnect.ProcessCallBackAdapter;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IPController;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.logging.LogController;

public abstract class ReconnectInvoker {
    private static final long OFFLINE_TIMEOUT = 30000L;
    private RouterPlugin routerPlugin;
    protected LogSource logger = LogController.TRASH;
    private String statusString;

    public LogSource getLogger() {
        return this.logger;
    }

    public void setLogger(LogSource logger) {
        if (logger == null) {
            logger = LogController.TRASH;
        }
        this.logger = logger;
    }

    public ReconnectInvoker(RouterPlugin routerPlugin) {
        this.routerPlugin = routerPlugin;
    }

    public abstract void run() throws ReconnectException, InterruptedException;

    public ReconnectResult validate() throws InterruptedException, ReconnectException {
        return this.validate(this.createReconnectResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReconnectResult validate(ReconnectResult ret) throws InterruptedException, ReconnectException {
        ret.setInvoker(this);
        if (IPController.getInstance().getIpState().isOffline()) {
            IPController.getInstance().invalidate();
            Thread.sleep(1000L);
            IPController.getInstance().validate();
            if (IPController.getInstance().getIpState().isOffline()) {
                throw new ReconnectException(_GUI.T.ReconnectInvoker_validate_offline_());
            }
        }
        this.logger.info("IP BEFORE=" + IPController.getInstance().getIP());
        try {
            IPController.getInstance().invalidate();
            ret.setStartTime(System.currentTimeMillis());
            this.testRun();
            Thread.sleep(1000L);
            IPController ipc = IPController.getInstance();
            if (ipc.validate()) {
                this.logger.info("Successful: REconnect has been very fast!");
                ret.setSuccess(true);
                ret.setOfflineTime(System.currentTimeMillis());
                ret.setSuccessTime(System.currentTimeMillis());
                ReconnectResult reconnectResult = ret;
                return reconnectResult;
            }
            this.logger.info("Script done. Wait for offline");
            do {
                Thread.sleep(1000L);
                if (ipc.validate() || ipc.getIpState().isOffline() || System.currentTimeMillis() - ret.getStartTime() <= 30000L) continue;
                this.logger.info("Disconnect failed. Still online after 30000 ms");
                ReconnectResult reconnectResult = ret;
                return reconnectResult;
            } while (!ipc.getIpState().isOffline() && ipc.isInvalidated());
            ret.setOfflineTime(System.currentTimeMillis());
            this.logger.info("Offline after " + ret.getOfflineDuration() + " ms");
            if (ipc.isInvalidated()) {
                this.logger.info("Wait for online status");
                long endTime = System.currentTimeMillis() + 450000L;
                while (System.currentTimeMillis() < endTime) {
                    long s = System.currentTimeMillis();
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (ipc.validate()) {
                        ret.setSuccessTime(System.currentTimeMillis());
                        ret.setSuccess(true);
                        this.logger.info("Successful: REconnect after " + ret.getSuccessDuration() + " ms");
                        ReconnectResult reconnectResult = ret;
                        return reconnectResult;
                    }
                    if (!ipc.getIpState().isOffline()) {
                        this.logger.info("Failed. returned from offline. But no new ip");
                        ReconnectResult reconnectResult = ret;
                        return reconnectResult;
                    }
                    Thread.sleep(Math.max(0L, 1000L - (System.currentTimeMillis() - s)));
                }
                this.logger.info("Connect failed! Maybe router restart is required. This should NEVER happen!");
                ReconnectResult reconnectResult = ret;
                return reconnectResult;
            }
            ret.setSuccessTime(System.currentTimeMillis());
            ret.setSuccess(true);
            this.logger.info("Successful: REconnect after " + ret.getSuccessDuration() + " ms");
            ReconnectResult reconnectResult = ret;
            return reconnectResult;
        }
        finally {
            this.logger.info("IP AFTER=" + IPController.getInstance().getIP());
        }
    }

    public RouterPlugin getPlugin() {
        return this.routerPlugin;
    }

    protected ReconnectResult createReconnectResult() {
        return new ReconnectResult();
    }

    protected abstract void testRun() throws ReconnectException, InterruptedException;

    public void doOptimization(ReconnectResult res, ProcessCallBackAdapter processCallBackAdapter) throws InterruptedException {
        ArrayList<ReconnectResult> list = new ArrayList<ReconnectResult>();
        list.add(res);
        int success = 1;
        long duration = res.getSuccessDuration();
        long offlineDuration = res.getOfflineDuration();
        long maxOfflineDuration = res.getOfflineDuration();
        long maxSuccessDuration = res.getSuccessDuration();
        long startTime = res.getStartTime();
        for (int i = 1; i < ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds(); ++i) {
            ReconnectResult r;
            processCallBackAdapter.setProgress(this, i * 100 / ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds());
            try {
                r = this.validate();
            }
            catch (ReconnectException e) {
                e.printStackTrace();
                r = this.createReconnectResult();
            }
            list.add(r);
            if (!r.isSuccess()) continue;
            ++success;
            duration += r.getSuccessDuration();
            startTime = r.getStartTime();
            offlineDuration = Math.min(offlineDuration, r.getOfflineDuration());
            maxOfflineDuration = Math.max(maxOfflineDuration, r.getOfflineDuration());
            maxSuccessDuration = Math.max(maxSuccessDuration, r.getSuccessDuration());
        }
        double successRate = (double)success / (double)((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds();
        res.setAverageSuccessDuration((long)((double)(duration /= (long)success) / successRate));
        res.setMaxOfflineDuration(maxOfflineDuration * 2L);
        res.setMaxSuccessDuration(maxSuccessDuration * 4L);
        res.setOfflineTime(offlineDuration);
        res.setStartTime(startTime);
    }

    public String getName() {
        return "Reconnect";
    }

    public String getStatusString() {
        return this.statusString;
    }

    public void setStatusString(String statusString) {
        this.statusString = statusString;
    }
}

