/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipInputStream;
import javax.swing.Icon;
import jd.controlling.reconnect.DummyRouterPlugin;
import jd.controlling.reconnect.ProcessCallBack;
import jd.controlling.reconnect.ProcessCallBackAdapter;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectPluginInfo;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.controlling.reconnect.pluginsinc.batch.ExternBatchReconnectPlugin;
import jd.controlling.reconnect.pluginsinc.easybox804.EasyBox804;
import jd.controlling.reconnect.pluginsinc.extern.ExternReconnectPlugin;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnect;
import jd.controlling.reconnect.pluginsinc.speedporthybrid.SpeedPortHybrid;
import jd.controlling.reconnect.pluginsinc.upnp.UPNPRouterPlugin;
import jd.nutils.io.JDFileFilter;
import jd.utils.JDUtilities;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Application;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.IO;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.logging2.LogSource;
import org.appwork.utils.logging2.extmanager.LoggerFactory;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.appwork.utils.swing.dialog.DialogNoAnswerException;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;

public class ReconnectPluginController {
    private static final String JD_CONTROLLING_RECONNECT_PLUGINS = "jd/controlling/reconnect/plugins/";
    private static final ReconnectPluginController INSTANCE = new ReconnectPluginController();
    private List<RouterPlugin> plugins;
    private final ReconnectConfig storage = (ReconnectConfig)JsonConfig.create(ReconnectConfig.class);

    public static ReconnectPluginController getInstance() {
        return INSTANCE;
    }

    private ReconnectPluginController() {
        this.scan();
    }

    public static void main(String[] args) {
        try {
            Dialog.getInstance().showConfirmDialog(0, _GUI.T.AutoDetectAction_actionPerformed_dooptimization_title(), _GUI.T.AutoDetectAction_actionPerformed_dooptimization_msg(1, "ff", "ggf"), (Icon)new AbstractIcon("ok", 32), _GUI.T.AutoDetectAction_run_optimization(), _GUI.T.AutoDetectAction_skip_optimization());
        }
        catch (DialogClosedException e) {
            e.printStackTrace();
        }
        catch (DialogCanceledException e) {
            e.printStackTrace();
        }
    }

    public List<ReconnectResult> autoFind(final ProcessCallBack feedback) throws InterruptedException {
        final ArrayList<ReconnectResult> scripts = new ArrayList<ReconnectResult>();
        for (RouterPlugin plg : this.plugins) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (!(plg instanceof UPNPRouterPlugin) && !(plg instanceof LiveHeaderReconnect)) continue;
            try {
                feedback.setStatus(plg, null);
                List<ReconnectResult> founds = plg.runDetectionWizard(feedback);
                if (founds != null) {
                    scripts.addAll(founds);
                }
                if (scripts.size() <= 0) continue;
                break;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Exception exception) {
            }
        }
        if (((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds() > 1 && scripts.size() > 0) {
            boolean i = true;
            long bestTime = Long.MAX_VALUE;
            long optiduration = 0L;
            for (ReconnectResult found : scripts) {
                bestTime = Math.min(bestTime, found.getSuccessDuration());
                optiduration = (long)((double)optiduration + (double)(found.getSuccessDuration() * (long)(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getOptimizationRounds() - 1)) * 1.5);
            }
            try {
                Dialog.getInstance().showConfirmDialog(0, _GUI.T.AutoDetectAction_actionPerformed_dooptimization_title(), _GUI.T.AutoDetectAction_actionPerformed_dooptimization_msg(scripts.size(), TimeFormatter.formatMilliSeconds((long)optiduration, (int)0), TimeFormatter.formatMilliSeconds((long)bestTime, (int)0)), (Icon)new AbstractIcon("ok", 32), _GUI.T.AutoDetectAction_run_optimization(), _GUI.T.AutoDetectAction_skip_optimization());
                feedback.setProgress(this, 0);
                int ii = 0;
                while (ii < scripts.size()) {
                    ReconnectResult found;
                    found = (ReconnectResult)scripts.get(ii);
                    feedback.setStatusString(this, _GUI.T.AutoDetectAction_run_optimize(found.getInvoker().getName()));
                    final int step = ii++;
                    found.optimize(new ProcessCallBackAdapter(){

                        @Override
                        public void setProgress(Object caller, int percent) {
                            feedback.setProgress(caller, step * (100 / scripts.size()) + percent / scripts.size());
                        }

                        @Override
                        public void setStatusString(Object caller, String string) {
                            feedback.setStatusString(caller, _GUI.T.AutoDetectAction_run_optimize(string));
                        }
                    });
                }
            }
            catch (DialogNoAnswerException dialogNoAnswerException) {
                // empty catch block
            }
        }
        try {
            Collections.sort(scripts, new Comparator<ReconnectResult>(){

                @Override
                public int compare(ReconnectResult o1, ReconnectResult o2) {
                    return CompareUtils.compareLong((long)o1.getAverageSuccessDuration(), (long)o2.getAverageSuccessDuration());
                }
            });
        }
        catch (Throwable e) {
            LoggerFactory.getDefaultLogger().log(e);
        }
        return scripts;
    }

    protected final boolean doReconnect(RouterPlugin plg, LogSource logger) throws InterruptedException, ReconnectException {
        IP beforeIP = IPController.getInstance().getIP();
        logger.info("IP Before=" + beforeIP);
        try {
            IP latestIP;
            int waitBeforeFirstIPCheck;
            ReconnectInvoker invoker = plg.getReconnectInvoker();
            if (invoker == null) {
                throw new ReconnectException("Reconnect Plugin  \"" + plg.getName() + "\" is not set up correctly. Invoker==null");
            }
            invoker.setLogger(logger);
            invoker.run();
            logger.finer("Initial Waittime: " + waitBeforeFirstIPCheck + " seconds");
            for (waitBeforeFirstIPCheck = Math.max(this.getWaittimeBeforeFirstIPCheck(), 0); waitBeforeFirstIPCheck > 0 && ((latestIP = IPController.getInstance().getLatestIP()) == null || latestIP.equals(beforeIP)); waitBeforeFirstIPCheck -= 1000) {
                Thread.sleep(1000L);
            }
            boolean bl = IPController.getInstance().validateAndWait(this.getWaitForIPTime(), Math.max(0, this.storage.getSecondsToWaitForOffline()), this.getIpCheckInterval());
            return bl;
        }
        catch (InterruptedException e) {
            logger.log((Throwable)e);
            throw e;
        }
        catch (RuntimeException e) {
            logger.log((Throwable)e);
            throw new ReconnectException(e);
        }
        finally {
            logger.info("IP AFTER=" + IPController.getInstance().getIP());
        }
    }

    public RouterPlugin getActivePlugin() {
        String id = this.storage.getActivePluginID();
        RouterPlugin active = ReconnectPluginController.getInstance().getPluginByID(id);
        if (active == null) {
            active = DummyRouterPlugin.getInstance();
            this.storage.setActivePluginID(active.getID());
        }
        return active;
    }

    private int getIpCheckInterval() {
        int ret = 0;
        if (!this.storage.isIPCheckGloballyDisabled()) {
            ret = this.getActivePlugin().getIPCheckProvider() != null ? this.getActivePlugin().getIPCheckProvider().getIpCheckInterval() : 5;
        }
        return Math.max(ret, 0);
    }

    public RouterPlugin getPluginByID(String activeID) {
        for (RouterPlugin plg : this.plugins) {
            if (!plg.getID().equals(activeID)) continue;
            return plg;
        }
        return null;
    }

    public List<RouterPlugin> getPlugins() {
        return this.plugins;
    }

    private int getWaitForIPTime() {
        return Math.max(this.storage.getSecondsToWaitForIPChange(), 0);
    }

    private int getWaittimeBeforeFirstIPCheck() {
        int ret = 0;
        if (!this.storage.isIPCheckGloballyDisabled()) {
            ret = this.getActivePlugin().getIPCheckProvider() != null ? this.getActivePlugin().getWaittimeBeforeFirstIPCheck() : this.storage.getSecondsBeforeFirstIPCheck();
        }
        return Math.max(ret, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scan() {
        try {
            File[] files = JDUtilities.getResourceFile("reconnect").listFiles((FileFilter)new JDFileFilter(null, ".reconnect", false));
            this.plugins = new ArrayList<RouterPlugin>();
            this.plugins.add(DummyRouterPlugin.getInstance());
            this.plugins.add(new ExternBatchReconnectPlugin());
            this.plugins.add(new ExternReconnectPlugin());
            this.plugins.add(new UPNPRouterPlugin());
            this.plugins.add(new LiveHeaderReconnect());
            this.plugins.add(new SpeedPortHybrid());
            this.plugins.add(new EasyBox804());
            ArrayList<URL> urls = new ArrayList<URL>();
            if (files != null) {
                int length = files.length;
                for (int i = 0; i < length; ++i) {
                    try {
                        urls.add(files[i].toURI().toURL());
                        Application.addUrlToClassPath((URL)files[i].toURI().toURL(), (ClassLoader)this.getClass().getClassLoader());
                        continue;
                    }
                    catch (Throwable e) {
                        LogController.CL().log(e);
                    }
                }
            }
            Enumeration<URL> found = this.getClass().getClassLoader().getResources(JD_CONTROLLING_RECONNECT_PLUGINS);
            Pattern pattern = Pattern.compile(Pattern.quote(JD_CONTROLLING_RECONNECT_PLUGINS) + "(\\w+)/");
            while (found.hasMoreElements()) {
                URL url = found.nextElement();
                if (url.getProtocol().equalsIgnoreCase("jar")) {
                    String path = url.getPath();
                    File jarFile = new File(new URL(path.substring(0, path.lastIndexOf(33))).toURI());
                    ZipInputStream jis = null;
                    try {
                        JarEntry e;
                        jis = new JarInputStream(new FileInputStream(jarFile));
                        while ((e = ((JarInputStream)jis).getNextJarEntry()) != null) {
                            Matcher matcher = pattern.matcher(e.getName());
                            while (matcher.find()) {
                                try {
                                    String pkg = matcher.group(1);
                                    this.load(pkg);
                                    System.out.println(pkg);
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        continue;
                    }
                    finally {
                        try {
                            jis.close();
                        }
                        catch (Throwable e) {}
                        continue;
                    }
                }
                for (File dir : new File(url.toURI()).listFiles(new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return pathname.isDirectory();
                    }
                })) {
                    File file = new File(dir, "info.json");
                    if (!file.exists()) continue;
                    this.load(dir.getName());
                }
            }
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
    }

    private void load(String pkg) {
        try {
            URL infourl = Application.getRessourceURL((String)(JD_CONTROLLING_RECONNECT_PLUGINS + pkg + "/info.json"));
            if (infourl == null) {
                LogController.CL().finer("Could not load Reconnect Plugin " + pkg);
                return;
            }
            ReconnectPluginInfo plgInfo = (ReconnectPluginInfo)JSonStorage.restoreFromString((String)IO.readURLToString((URL)infourl), (TypeRef)new TypeRef<ReconnectPluginInfo>(){}, null);
            if (plgInfo == null) {
                LogController.CL().finer("Could not load Reconnect Plugin (no info.json)" + pkg);
                return;
            }
            Class<?> clazz = this.getClass().getClassLoader().loadClass(JD_CONTROLLING_RECONNECT_PLUGINS.replace("/", ".") + pkg + "." + plgInfo.getClassName());
            for (RouterPlugin plg : this.plugins) {
                if (plg.getClass() != clazz) continue;
                LogController.CL().finer("Dupe found: " + pkg);
                return;
            }
            this.plugins.add((RouterPlugin)clazz.newInstance());
        }
        catch (Throwable e) {
            LogController.CL().log(e);
        }
    }

    public void setActivePlugin(RouterPlugin selectedItem) {
        this.storage.setActivePluginID(selectedItem.getID());
    }

    public void setActivePlugin(String id) {
        this.setActivePlugin(this.getPluginByID(id));
    }
}

