/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import jd.controlling.reconnect.ProcessCallBackAdapter;
import jd.controlling.reconnect.ReconnectInvoker;

public class ReconnectResult {
    private boolean success;
    private long startTime;
    private long offlineTime;
    private long successTime;
    private long averageSuccessDuration = -1L;
    private ReconnectInvoker invoker;
    private long maxSuccessDuration = -1L;
    private long maxOfflineDuration = -1L;

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public long getOfflineTime() {
        return this.offlineTime;
    }

    public void setOfflineTime(long offlineTime) {
        this.offlineTime = offlineTime;
    }

    public long getSuccessTime() {
        return this.successTime;
    }

    public void setSuccessTime(long successTime) {
        this.successTime = successTime;
    }

    public long getMaxSuccessDuration() {
        if (this.maxSuccessDuration < 0L) {
            return this.getSuccessDuration() * 10L;
        }
        return this.maxSuccessDuration;
    }

    public void setMaxSuccessDuration(long maxSuccessDuration) {
        this.maxSuccessDuration = maxSuccessDuration;
    }

    public long getOfflineDuration() {
        return Math.max(200L, this.offlineTime - this.startTime);
    }

    public long getSuccessDuration() {
        return Math.max(0L, this.successTime - this.startTime);
    }

    public long getAverageSuccessDuration() {
        if (this.averageSuccessDuration < 0L) {
            return this.getSuccessDuration();
        }
        return this.averageSuccessDuration;
    }

    public void setAverageSuccessDuration(long averageSuccessDuration) {
        this.averageSuccessDuration = averageSuccessDuration;
    }

    public void setInvoker(ReconnectInvoker reconnectInvoker) {
        this.invoker = reconnectInvoker;
    }

    public ReconnectInvoker getInvoker() {
        return this.invoker;
    }

    public void optimize(ProcessCallBackAdapter processCallBackAdapter) throws InterruptedException {
        this.getInvoker().doOptimization(this, processCallBackAdapter);
    }

    public void setMaxOfflineDuration(long maxOfflineDuration) {
        this.maxOfflineDuration = maxOfflineDuration;
    }

    public long getMaxOfflineDuration() {
        if (this.maxOfflineDuration < 0L) {
            return this.getOfflineDuration() * 10L;
        }
        return this.maxOfflineDuration;
    }
}

