/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import jd.controlling.reconnect.DummyRouterPlugin;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectEventSender;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.ReconnecterEvent;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.ipcheck.IPController;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;

public final class Reconnecter {
    private static final Reconnecter INSTANCE = new Reconnecter();
    private static final AtomicLong lastReconnect = new AtomicLong(0L);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final boolean debugNoRealReconnect = false;
    private final ReconnectEventSender eventSender = new ReconnectEventSender();
    private final ReconnectConfig storage = (ReconnectConfig)JsonConfig.create(ReconnectConfig.class);

    public static long getLastReconnect() {
        return lastReconnect.get();
    }

    public static Reconnecter getInstance() {
        return INSTANCE;
    }

    private Reconnecter() {
    }

    public static int getFailedCounter() {
        int failedCounter = Reconnecter.getInstance().storage.getFailedCounter();
        int failedLimit = Reconnecter.getInstance().storage.getDisableAutoReconnectFails();
        if (failedLimit == -1) {
            return 0;
        }
        if (failedCounter > failedLimit) {
            return 1000;
        }
        return 0;
    }

    public ReconnectResult doReconnect() {
        return this.doReconnect(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ReconnectResult doReconnect(boolean forceReconnect) {
        if (!forceReconnect && !IPController.getInstance().isInvalidated()) {
            return ReconnectResult.VALIDIP;
        }
        if (!this.running.compareAndSet(false, true)) {
            return ReconnectResult.RUNNING;
        }
        ReconnectResult result = null;
        try {
            LogSource logger = LogController.CL(false);
            RouterPlugin plugin = null;
            long startTime = System.currentTimeMillis();
            try {
                logger.setAllowTimeoutFlush(false);
                logger.info("Perform reconnect");
                plugin = ReconnectPluginController.getInstance().getActivePlugin();
                if (plugin == DummyRouterPlugin.getInstance()) {
                    throw new ReconnectException("Invalid Plugin");
                }
                this.eventSender.fireEvent((DefaultEvent)new ReconnecterEvent(ReconnecterEvent.Type.BEFORE, plugin));
                logger.info("Try to reconnect: " + plugin);
                int maxretries = this.storage.getMaxReconnectRetryNum();
                if (maxretries < 0) {
                    maxretries = Integer.MAX_VALUE;
                } else if (maxretries == 0) {
                    maxretries = 1;
                }
                for (int retry = 0; retry < maxretries; ++retry) {
                    logger.info("Starting \"" + plugin + "\" #" + (retry + 1) + "/" + maxretries);
                    if (!ReconnectPluginController.getInstance().doReconnect(plugin, logger)) continue;
                    result = ReconnectResult.SUCCESSFUL;
                    break;
                }
                if (result == null) {
                    result = ReconnectResult.FAILED;
                }
            }
            catch (Throwable e) {
                try {
                    logger.log(e);
                    return result;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (result == null) {
                        result = ReconnectResult.FAILED;
                    }
                    switch (result) {
                        case SUCCESSFUL: {
                            logger.clear();
                            logger.info("Reconnect successful: " + plugin);
                            lastReconnect.set(System.currentTimeMillis());
                            this.counterSuccess(1);
                            this.counterGlobalSuccess(1);
                            this.storage.setFailedCounter(0);
                            break;
                        }
                        case FAILED: {
                            this.counterFailed(1);
                            this.counterGlobalFailed(1);
                            this.storage.setSuccessCounter(0);
                            break;
                        }
                    }
                    try {
                        Thread.sleep(Math.max(10L, 1000L - (System.currentTimeMillis() - startTime)));
                    }
                    catch (InterruptedException e2) {
                        e2.printStackTrace();
                    }
                    logger.info("Reconnect: " + result.name() + " with " + plugin);
                    this.eventSender.fireEvent((DefaultEvent)new ReconnecterEvent(ReconnecterEvent.Type.AFTER, plugin, result));
                }
            }
            switch (result) {
                case SUCCESSFUL: {
                    logger.clear();
                    logger.info("Reconnect successful: " + plugin);
                    lastReconnect.set(System.currentTimeMillis());
                    this.counterSuccess(1);
                    this.counterGlobalSuccess(1);
                    this.storage.setFailedCounter(0);
                    break;
                }
                case FAILED: {
                    this.counterFailed(1);
                    this.counterGlobalFailed(1);
                    this.storage.setSuccessCounter(0);
                    break;
                }
            }
            try {
                Thread.sleep(Math.max(10L, 1000L - (System.currentTimeMillis() - startTime)));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            logger.info("Reconnect: " + result.name() + " with " + plugin);
            this.eventSender.fireEvent((DefaultEvent)new ReconnecterEvent(ReconnecterEvent.Type.AFTER, plugin, result));
            return result;
        }
        finally {
            this.running.set(false);
        }
    }

    private void counterGlobalSuccess(int i) {
        this.storage.setGlobalSuccessCounter(this.storage.getGlobalSuccessCounter() + i);
    }

    private void counterSuccess(int i) {
        this.storage.setSuccessCounter(this.storage.getSuccessCounter() + i);
    }

    private void counterGlobalFailed(int i) {
        this.storage.setGlobalFailedCounter(this.storage.getGlobalFailedCounter() + i);
    }

    private void counterFailed(int i) {
        this.storage.setFailedCounter(this.storage.getFailedCounter() + i);
    }

    public ReconnectEventSender getEventSender() {
        return this.eventSender;
    }

    public static enum ReconnectResult {
        VALIDIP,
        FAILED,
        SUCCESSFUL,
        RUNNING;

    }
}

