/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.regex.Pattern;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.RouterUtils;
import jd.controlling.reconnect.ipcheck.ForbiddenIPException;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.InvalidIPException;
import jd.controlling.reconnect.ipcheck.InvalidIPRangeException;
import jd.controlling.reconnect.ipcheck.OfflineException;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.StringUtils;
import org.jdownloader.logging.LogController;

public class IP {
    public static final String IP_PATTERN = "\\b(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\b";
    protected final String ip;

    public static IP getInstance(String ip) throws IPCheckException {
        String[] parts;
        if (ip.matches("^\\d+\\.\\d+\\.\\d+\\.\\d+$") && (parts = ip.split("\\.")).length == 4) {
            if (IP.isLocalIP(ip)) {
                throw new InvalidIPRangeException(ip);
            }
            int n1 = Integer.parseInt(parts[0]);
            int n2 = Integer.parseInt(parts[1]);
            int n3 = Integer.parseInt(parts[2]);
            int n4 = Integer.parseInt(parts[3]);
            if (n1 == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
                throw new OfflineException(ip);
            }
            if (n1 >= 0 && n1 <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255) {
                if (!IP.validateIP(ip)) {
                    throw new ForbiddenIPException(ip);
                }
                return new IP(ip);
            }
            throw new InvalidIPException(ip);
        }
        throw new InvalidIPException(ip);
    }

    private static boolean validateIP(String ip) {
        try {
            return ip != null && Pattern.compile(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getGlobalIPCheckPattern()).matcher(ip.trim()).matches();
        }
        catch (Exception e) {
            LogController.CL().severe("Could not validate IP!");
            LogController.CL().log((Throwable)e);
            return true;
        }
    }

    private IP(String ip) {
        this.ip = ip;
    }

    public String getIP() {
        return this.ip;
    }

    public boolean equals(Object c) {
        if (c == null) {
            return false;
        }
        if (c == this) {
            return true;
        }
        if (c != null && c instanceof IP) {
            IP ip = (IP)c;
            return StringUtils.equals((String)this.getIP(), (String)ip.getIP());
        }
        return false;
    }

    public int hashCode() {
        if (this.ip == null) {
            return super.hashCode();
        }
        return this.ip.hashCode();
    }

    public String toString() {
        return this.ip != null ? this.ip : "unknown";
    }

    public static boolean isValidRouterIP(String gatewayIP) {
        if (StringUtils.isEmpty((String)gatewayIP)) {
            return false;
        }
        String[] whiteListArray = ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getHostWhiteList();
        if (whiteListArray != null && Arrays.asList(whiteListArray).contains(gatewayIP)) {
            return RouterUtils.checkPort(gatewayIP);
        }
        try {
            return IP.resolveSiteLocalAddress(gatewayIP) != null && RouterUtils.checkPort(gatewayIP);
        }
        catch (UnknownHostException e) {
            LogController.CL().log((Throwable)e);
            return false;
        }
    }

    public static boolean isLocalIP(String ip) {
        try {
            InetAddress ret = IP.resolveSiteLocalAddress(ip);
            return ip != null && ip.equals(ret.getHostAddress());
        }
        catch (UnknownHostException e) {
            return false;
        }
    }

    public static InetAddress resolveSiteLocalAddress(String ip) throws UnknownHostException {
        if (!StringUtils.isEmpty((String)ip)) {
            InetAddress[] inetAddresses;
            for (InetAddress inetAddress : inetAddresses = RouterUtils.resolveHostnames(ip)) {
                if (!inetAddress.isSiteLocalAddress()) continue;
                return inetAddress;
            }
        }
        throw new UnknownHostException("no siteLocalAddress:" + ip);
    }
}

