/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.ipcheck;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.ipcheck.BalancedWebIPCheck;
import jd.controlling.reconnect.ipcheck.CustomWebIpCheck;
import jd.controlling.reconnect.ipcheck.ForbiddenIPException;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.ipcheck.IPCheckException;
import jd.controlling.reconnect.ipcheck.IPCheckProvider;
import jd.controlling.reconnect.ipcheck.IPConnectionState;
import jd.controlling.reconnect.ipcheck.InvalidProviderException;
import jd.controlling.reconnect.ipcheck.event.IPControllEvent;
import jd.controlling.reconnect.ipcheck.event.IPControllEventSender;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.event.DefaultEvent;
import org.appwork.utils.logging2.extmanager.Log;
import org.jdownloader.logging.LogController;

public class IPController
extends ArrayList<IPConnectionState> {
    private static final long serialVersionUID = -6856149094542337379L;
    private static final IPController INSTANCE = new IPController();
    private final AtomicBoolean invalidFlag = new AtomicBoolean(false);
    private volatile IPConnectionState latestConnectionState;
    private volatile IPConnectionState invalidState = null;
    private final Object LOCK = new Object();
    private final List<IPCheckProvider> badProviders = new ArrayList<IPCheckProvider>();
    private final IPControllEventSender eventSender = new IPControllEventSender();
    private long latestValidateTime;

    public static IPController getInstance() {
        return INSTANCE;
    }

    public IPControllEventSender getEventSender() {
        return this.eventSender;
    }

    private IPController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(IPConnectionState state) {
        if (state == null) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            IPConnectionState entry;
            if (this.size() > 0 && (entry = (IPConnectionState)this.get(this.size() - 1)).equalsLog(state)) {
                return false;
            }
            IPConnectionState oldState = this.latestConnectionState;
            this.latestConnectionState = state;
            this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.STATECHANGED, oldState, state));
            return super.add(state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean changedIP() {
        if (this.invalidState == null) {
            return false;
        }
        if (this.size() == 0) {
            return false;
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.fetchIP();
            IPConnectionState current = this.latestConnectionState;
            if (current.isOffline()) {
                return false;
            }
            for (int index = this.size() - 1; index >= 0; --index) {
                if (this.get(index) == this.invalidState) {
                    if (!this.invalidState.equalsLog(current)) {
                        this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.IP_CHANGED, this.invalidState, current));
                        return true;
                    }
                    return false;
                }
                if (!((IPConnectionState)this.get(index)).isOnline() || ((IPConnectionState)this.get(index)).equalsLog(current)) continue;
                this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.IP_CHANGED, this.invalidState, current));
                return true;
            }
        }
        return false;
    }

    protected IP fetchIP() {
        IPConnectionState newIP = null;
        while (true) {
            IPCheckProvider icp = null;
            try {
                icp = this.getIPCheckProvider();
                newIP = new IPConnectionState(icp.getExternalIP());
                System.out.println("IP: " + newIP.getExternalIp());
            }
            catch (InvalidProviderException e) {
                Log.log((Throwable)e);
                if (icp == null) continue;
                this.badProviders.add(icp);
                continue;
            }
            catch (IPCheckException e) {
                newIP = new IPConnectionState(e);
            }
            break;
        }
        IPConnectionState old = this.latestConnectionState;
        if (this.add(newIP)) {
            if (this.latestConnectionState.isOffline()) {
                this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.OFFLINE, new IPConnectionState[0]));
            }
            if ((old == null || old.isOffline()) && !newIP.isOffline()) {
                this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.ONLINE, newIP));
            }
        }
        return this.latestConnectionState.getExternalIp();
    }

    public synchronized IPConnectionState getIpState() {
        if (this.latestConnectionState == null) {
            this.fetchIP();
        }
        return this.latestConnectionState;
    }

    public synchronized IP getLatestIP() {
        if (this.latestConnectionState == null) {
            return null;
        }
        return this.latestConnectionState.getExternalIp();
    }

    public IP getIP() {
        return this.getIpState().getExternalIp();
    }

    private IPCheckProvider getIPCheckProvider() {
        IPCheckProvider p = ReconnectPluginController.getInstance().getActivePlugin().getIPCheckProvider();
        Log.info((String)("IP Check provider from Plugin: " + p));
        if (p == null || this.badProviders.contains(p)) {
            Log.info((String)(p + " is bad"));
            if (!((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).isCustomIPCheckEnabled()) {
                Log.info((String)"Use WebIP Check");
                return new BalancedWebIPCheck();
            }
            Log.info((String)"Use Custom");
            return CustomWebIpCheck.getInstance();
        }
        return p;
    }

    public void invalidate() {
        this.setInvalidated(true);
    }

    public boolean isInvalidated() {
        return this.invalidFlag.get();
    }

    public boolean validate() {
        if (!this.invalidFlag.get()) {
            return true;
        }
        this.latestValidateTime = System.currentTimeMillis();
        if (((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).isIPCheckGloballyDisabled()) {
            this.setInvalidated(false);
            return true;
        }
        if (this.changedIP()) {
            this.setInvalidated(false);
            return true;
        }
        this.setInvalidated(true);
        return false;
    }

    private boolean setInvalidated(boolean invalidated) {
        if (this.invalidFlag.getAndSet(invalidated) != invalidated) {
            if (invalidated) {
                this.invalidState = this.getIpState();
                this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.INVALIDATED, this.invalidState));
            } else {
                this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.VALIDATED, this.invalidState, this.getIpState()));
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean validateAndWait(int waitForIPTime, int waitForOfflineTime, int ipCheckInterval) throws InterruptedException {
        if (!this.invalidFlag.get()) {
            return true;
        }
        if (((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).isIPCheckGloballyDisabled()) {
            Thread.sleep(waitForIPTime);
            this.setInvalidated(false);
            return true;
        }
        endTime = System.currentTimeMillis() + (long)(waitForIPTime * 1000);
        endOfflineTime = System.currentTimeMillis() + (long)(waitForOfflineTime * 1000);
        hasBeenOffline = false;
        logger = LogController.CL(false);
        try {
            while (true) {
                this.validate();
                if (!this.isInvalidated()) {
                    var10_9 = true;
                    return var10_9;
                }
                if (this.latestConnectionState.isOffline()) {
                    hasBeenOffline = true;
                }
                if (this.latestConnectionState.getCause() == null) ** GOTO lbl-1000
                try {
                    throw this.latestConnectionState.getCause();
                }
                catch (ForbiddenIPException e) {
                    this.eventSender.fireEvent((DefaultEvent)new IPControllEvent(IPControllEvent.Type.FORBIDDEN_IP, new IPConnectionState[]{this.getIpState()}));
                    this.setInvalidated(true);
                    var11_11 = false;
                    logger.close();
                    return var11_11;
                }
                catch (Throwable var10_8) {
                    if (!hasBeenOffline && System.currentTimeMillis() >= endOfflineTime) {
                        logger.info("Not offline after " + waitForOfflineTime + " seconds");
                        break;
                    }
                    if (System.currentTimeMillis() >= endTime) {
                        logger.info("Not reconnected after " + waitForIPTime + " seconds");
                        break;
                    }
                    Thread.sleep(Math.max(250, ipCheckInterval * 1000));
                    continue;
                }
                break;
            }
        }
        finally {
            logger.close();
        }
        return this.isInvalidated() == false;
    }

    public void waitUntilWeAreOnline(long interval) throws InterruptedException {
        while (IPController.getInstance().getIpState().isOffline()) {
            IPController.getInstance().invalidate();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            Thread.sleep(interval);
            while (System.currentTimeMillis() - this.latestValidateTime < interval) {
                Thread.sleep(500L);
                if (IPController.getInstance().getIpState().isOffline()) continue;
                return;
            }
            IPController.getInstance().validate();
        }
    }

    public void waitUntilWeAreOnline() throws InterruptedException {
        this.waitUntilWeAreOnline(1000L);
    }

    public void forceFetchIP() {
        this.fetchIP();
    }
}

