/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.extern;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.RouterPlugin;
import jd.controlling.reconnect.pluginsinc.extern.translate.T;
import jd.gui.swing.components.ComboBrowseFile;
import jd.utils.JDUtilities;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.Storage;
import org.appwork.utils.Application;
import org.appwork.utils.Regex;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.TextComponentChangeListener;
import org.jdownloader.controlling.FileCreationManager;
import org.jdownloader.images.AbstractIcon;

public class ExternReconnectPlugin
extends RouterPlugin
implements ActionListener {
    private static final String COMMAND = "COMMAND";
    private static final String DUMMY_BATCH_ENABLED = "DUMMY_BATCH_ENABLED";
    private static final String WAIT_FOR_RETURN_SECONDS = "WAIT_FOR_RETURN_SECONDS";
    private static final String PARAMETER = "PARAMETER";
    public static final String ID = "ExternReconnect";
    private JTextPane txtParameter;
    private JCheckBox chbDummyBatch;
    private ComboBrowseFile browse;
    private Icon icon = new AbstractIcon("console", 16);
    private ReconnectInvoker invoker = new ReconnectInvoker(this){

        @Override
        protected void testRun() throws ReconnectException, InterruptedException {
            this.run();
        }

        private File getDummyBat() {
            int number = 0;
            while (true) {
                if (number == 100) {
                    this.logger.severe("Cannot create dummy Bat file, please delete all recon_*.bat files in tmp folder!");
                    return null;
                }
                File tmp = Application.getTempResource((String)("recon_" + number + ".bat"));
                if (tmp.exists()) {
                    if (FileCreationManager.getInstance().delete(tmp, null)) {
                        return tmp;
                    }
                } else {
                    return tmp;
                }
                tmp.deleteOnExit();
                ++number;
            }
        }

        @Override
        public void run() throws ReconnectException {
            int waitForReturn = ExternReconnectPlugin.this.getWaitForReturn();
            String command = ExternReconnectPlugin.this.getCommand();
            if (command.length() == 0) {
                throw new ReconnectException("Command Invalid: " + command);
            }
            File f = new File(command);
            if (!f.exists()) {
                throw new ReconnectException("Command does not exist: " + f.getAbsolutePath());
            }
            String t = f.getAbsolutePath();
            String executeIn = t.substring(0, t.indexOf(f.getName()) - 1).trim();
            if (CrossSystem.isWindows() && ExternReconnectPlugin.this.isDummyBatchEnabled()) {
                File bat = this.getDummyBat();
                if (bat == null) {
                    throw new ReconnectException("Could not create Dummy Batch");
                }
                BufferedWriter output = null;
                try {
                    output = new BufferedWriter(new FileWriter(bat));
                    if (executeIn.contains(" ")) {
                        output.write("cd \"" + executeIn + "\"\r\n");
                    } else {
                        output.write("cd " + executeIn + "\r\n");
                    }
                    String parameter = ExternReconnectPlugin.this.getParameterString();
                    String[] params = Regex.getLines((String)parameter);
                    StringBuilder sb = new StringBuilder(" ");
                    for (String param : params) {
                        sb.append(param);
                        sb.append(" ");
                    }
                    if (executeIn.contains(" ")) {
                        output.write("\"" + command + "\"" + sb.toString() + " >nul 2>nul");
                    } else {
                        output.write(command + " " + sb.toString() + ">nul 2>nul");
                    }
                    output.close();
                }
                catch (Exception e) {
                    this.logger.log((Throwable)e);
                    throw new ReconnectException(e);
                }
                finally {
                    try {
                        output.close();
                    }
                    catch (Throwable throwable) {}
                }
                this.logger.finer("Execute Returns: " + JDUtilities.runCommand(bat.toString(), new String[0], executeIn, waitForReturn));
            } else {
                String parameter = ExternReconnectPlugin.this.getParameterString();
                this.logger.finer("Execute Returns: " + JDUtilities.runCommand(command, Regex.getLines((String)parameter), executeIn, waitForReturn));
            }
        }
    };

    @Override
    public Icon getIcon16() {
        return this.icon;
    }

    private Storage getStorage() {
        return JSonStorage.getPlainStorage((String)this.getID());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.browse) {
            this.setCommand(this.browse.getText());
        } else {
            this.setDummyBatchEnabled(this.chbDummyBatch.isSelected());
        }
    }

    private String getCommand() {
        return (String)this.getStorage().get(COMMAND, (Object)"");
    }

    @Override
    public JComponent getGUI() {
        JPanel p = new JPanel((LayoutManager)new MigLayout("ins 0,wrap 2", "[][grow,fill]", "[][][grow,fill][]"));
        p.setOpaque(false);
        this.browse = new ComboBrowseFile(this.getID());
        this.browse.setEditable(true);
        this.browse.setFileSelectionMode(0);
        this.browse.setDialogType(Integer.valueOf(0));
        this.txtParameter = new JTextPane();
        this.chbDummyBatch = new JCheckBox();
        p.add((Component)new JLabel(T.T.interaction_externreconnect_command()), "sg left");
        p.add((Component)this.browse);
        this.browse.addActionListener((ActionListener)this);
        p.add((Component)new JLabel(T.T.interaction_externreconnect_parameter()), "newline,spanx,sg left");
        p.add((Component)new JScrollPane(this.txtParameter), "spanx,newline,pushx,growx");
        if (CrossSystem.isWindows()) {
            p.add((Component)new JLabel(T.T.interaction_externreconnect_dummybat()), "newline,sg left");
            p.add(this.chbDummyBatch);
        }
        this.chbDummyBatch.addActionListener(this);
        new TextComponentChangeListener(this.txtParameter){

            protected void onChanged(DocumentEvent e) {
                ExternReconnectPlugin.this.setParameter(ExternReconnectPlugin.this.txtParameter.getText());
            }
        };
        this.updateGUI();
        return p;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return T.T.jd_controlling_reconnect_plugins_extern_ExternReconnectPlugin_getName();
    }

    private String getParameterString() {
        return (String)this.getStorage().get(PARAMETER, (Object)"");
    }

    private int getWaitForReturn() {
        return (Integer)this.getStorage().get(WAIT_FOR_RETURN_SECONDS, (Object)0);
    }

    private boolean isDummyBatchEnabled() {
        return (Boolean)this.getStorage().get(DUMMY_BATCH_ENABLED, (Object)true);
    }

    private void setCommand(String text) {
        this.getStorage().put(COMMAND, text);
        this.updateGUI();
    }

    private void setDummyBatchEnabled(boolean selected) {
        this.getStorage().put(DUMMY_BATCH_ENABLED, Boolean.valueOf(selected));
        this.updateGUI();
    }

    private void setParameter(String text) {
        this.getStorage().put(PARAMETER, text);
        this.updateGUI();
    }

    private void updateGUI() {
        new EDTRunner(){

            protected void runInEDT() {
                try {
                    ExternReconnectPlugin.this.browse.setText(ExternReconnectPlugin.this.getCommand());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    ExternReconnectPlugin.this.txtParameter.setText(ExternReconnectPlugin.this.getParameterString());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                try {
                    ExternReconnectPlugin.this.chbDummyBatch.setSelected(ExternReconnectPlugin.this.isDummyBatchEnabled());
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        };
    }

    @Override
    public ReconnectInvoker getReconnectInvoker() {
        return this.invoker;
    }
}

