/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.gui.swing.Factory;
import jd.nutils.encoding.Encoding;
import net.miginfocom.swing.MigLayout;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.images.AbstractIcon;

public class ImportRouterDialog
extends AbstractDialog<Integer> {
    private static final long serialVersionUID = 2043825047691368115L;
    private final List<String[]> scripts;
    private JList list;

    public ImportRouterDialog(List<String[]> scripts) {
        super(4, T.T.gui_config_liveheader_dialog_importrouter(), (Icon)new AbstractIcon("search", 32), null, null);
        this.scripts = scripts;
        Collections.sort(this.scripts, new Comparator<String[]>(){

            @Override
            public int compare(String[] a, String[] b) {
                return (a[0] + " " + a[1]).compareToIgnoreCase(b[0] + " " + b[1]);
            }
        });
    }

    protected Integer createReturnValue() {
        return this.getReturnmask();
    }

    public String[] getResult() {
        String selected = this.list.getSelectedValue().toString();
        int id = Integer.parseInt(selected.split("\\.")[0]);
        return this.scripts.get(id);
    }

    public JComponent layoutDialogContent() {
        HashMap<String, Boolean> ch = new HashMap<String, Boolean>();
        for (int i = this.scripts.size() - 1; i >= 0; --i) {
            if (ch.containsKey(this.scripts.get(i)[0] + this.scripts.get(i)[1] + this.scripts.get(i)[2])) {
                this.scripts.remove(i);
                continue;
            }
            ch.put(this.scripts.get(i)[0] + this.scripts.get(i)[1] + this.scripts.get(i)[2], true);
        }
        final String[] d = new String[this.scripts.size()];
        for (int i = 0; i < d.length; ++i) {
            d[i] = i + ". " + Encoding.htmlDecode((String)(this.scripts.get(i)[0] + " : " + this.scripts.get(i)[1]));
        }
        JPanel panel = new JPanel((LayoutManager)new MigLayout("ins 10,wrap 3", "[grow 30,fill]5[grow 0,fill]10[grow,fill,300!]", "[fill]5[]5[fill,grow]"));
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        final String text = T.T.gui_config_reconnect_selectrouter();
        final JTextField searchField = new JTextField();
        this.list = new JList(defaultListModel);
        searchField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.refreshList();
            }

            private void refreshList() {
                String search = searchField.getText().toLowerCase();
                String[] hits = search.split(" ");
                defaultListModel.removeAllElements();
                for (int i = 0; i < d.length; ++i) {
                    for (int j = 0; j < hits.length && d[i].toLowerCase().contains(hits[j]); ++j) {
                        if (j != hits.length - 1) continue;
                        defaultListModel.addElement(d[i]);
                    }
                }
                ImportRouterDialog.this.list.setModel(defaultListModel);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.refreshList();
            }
        });
        searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (searchField.getText().equals(text)) {
                    searchField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (searchField.getText().equals("")) {
                    searchField.setText(text);
                    for (String element : d) {
                        defaultListModel.addElement(element);
                    }
                }
            }
        });
        final JTextArea preview = new JTextArea();
        preview.setFocusable(true);
        JButton reset = Factory.createButton(null, (Icon)new AbstractIcon("undo", 16), (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchField.setForeground(Color.lightGray);
                searchField.setText(text);
                preview.setText("");
                for (String element : d) {
                    defaultListModel.addElement(element);
                }
            }
        });
        reset.setBorder(null);
        searchField.setText(text);
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                String selected = (String)ImportRouterDialog.this.list.getSelectedValue();
                if (selected != null) {
                    int id = Integer.parseInt(selected.split("\\.")[0]);
                    String[] data = (String[])ImportRouterDialog.this.scripts.get(id);
                    preview.setText(data[2]);
                }
            }
        });
        JLabel example = new JLabel(T.T.gui_config_reconnect_selectrouter_example());
        for (String element : d) {
            defaultListModel.addElement(element);
        }
        panel.add(searchField);
        panel.add(reset);
        panel.add((Component)new JScrollPane(preview), "spany");
        panel.add((Component)example, "spanx 2");
        panel.add((Component)new JScrollPane(this.list), "spanx 2");
        return panel;
    }

    protected void packed() {
        this.setMinimumSize(new Dimension(700, 500));
    }
}

