/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jd.controlling.proxy.NoProxySelector;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectException;
import jd.controlling.reconnect.ReconnectInvoker;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.RouterUtils;
import jd.controlling.reconnect.ipcheck.IP;
import jd.controlling.reconnect.pluginsinc.liveheader.LHProcessFeedback;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnect;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectResult;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.ReconnectFailedException;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.RecollController;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.http.Browser;
import jd.http.Cookies;
import jd.http.ProxySelectorInterface;
import jd.http.Request;
import jd.http.RequestHeader;
import jd.http.requests.GetRequest;
import jd.http.requests.PostRequest;
import jd.http.requests.PutRequest;
import jd.nutils.Formatter;
import jd.nutils.JDHash;
import jd.nutils.encoding.Encoding;
import jd.utils.JDUtilities;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Hash;
import org.appwork.utils.Regex;
import org.appwork.utils.StringUtils;
import org.appwork.utils.encoding.Base64;
import org.appwork.utils.formatter.HexFormatter;
import org.appwork.utils.logging2.LogInterface;
import org.appwork.utils.net.httpconnection.HTTPConnectionUtils;
import org.appwork.utils.parser.UrlQuery;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LiveHeaderInvoker
extends ReconnectInvoker {
    private String script;
    private final String user;
    private final String pass;
    private final String router;
    private LHProcessFeedback feedback = null;
    private final String orgScript;
    private final String name;
    private Map<String, String> internalVariables = null;
    private Map<String, String> parsedVariables = null;
    private Set<String> verifiedIPs;
    private RouterData routerData;

    public String getScript() {
        return this.orgScript;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public String getRouter() {
        return this.router;
    }

    @Override
    public ReconnectResult validate(ReconnectResult r) throws InterruptedException, ReconnectException {
        try {
            Object rd;
            r = super.validate(r);
            if (r instanceof LiveHeaderReconnectResult && (rd = ((LiveHeaderReconnectResult)r).getRouterData()) != null && ((RouterData)rd).getScriptID() != null) {
                if (r.isSuccess()) {
                    RecollController.getInstance().trackWorking(((RouterData)rd).getScriptID(), r.getSuccessDuration(), r.getOfflineDuration());
                } else {
                    RecollController.getInstance().trackNotWorking(((RouterData)rd).getScriptID());
                }
            }
            rd = r;
            return rd;
        }
        catch (ReconnectException e) {
            RouterData rd = ((LiveHeaderReconnectResult)r).getRouterData();
            if (rd != null && rd.getScriptID() != null) {
                RecollController.getInstance().trackNotWorking(rd.getScriptID());
            }
            throw e;
        }
    }

    public LHProcessFeedback getFeedback() {
        return this.feedback;
    }

    public void setFeedback(LHProcessFeedback feedback) {
        this.feedback = feedback;
    }

    @Override
    protected ReconnectResult createReconnectResult() {
        return new LiveHeaderReconnectResult(this.routerData);
    }

    @Override
    public String getName() {
        return T.T.LiveHeaderInvoker_getName_(this.name);
    }

    public LiveHeaderInvoker(LiveHeaderReconnect liveHeaderReconnect, String script, String user, String pass, String ip, String name) {
        super(liveHeaderReconnect);
        this.orgScript = script;
        this.name = name;
        this.script = LiveHeaderInvoker.prepareScript(script);
        this.user = user;
        this.pass = pass;
        this.router = ip != null ? ip.trim() : ip;
    }

    private final String getRouterIP() {
        return this.getInternalValue("ip");
    }

    private boolean isAttributeSet(NamedNodeMap attributes, String key) {
        Node node = attributes.getNamedItem(key);
        return node != null && (StringUtils.equalsIgnoreCase((String)node.getNodeValue(), (String)"true") || StringUtils.equalsIgnoreCase((String)node.getTextContent(), (String)"true"));
    }

    @Override
    public void run() throws ReconnectException, InterruptedException {
        InetAddress ip;
        if (this.script == null || this.script.length() == 0) {
            throw new ReconnectException("No LiveHeader Script found");
        }
        String router = this.getRouter();
        if (!IP.isValidRouterIP(router)) {
            throw new ReconnectException("Invalid Router IP:\"" + router + "\"");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("user", this.user);
        map.put("pass", this.pass);
        map.put("username", this.user);
        map.put("password", this.pass);
        map.put("basicauth", Encoding.Base64Encode((String)(this.user + ":" + this.pass)));
        map.put("auth", Encoding.Base64Encode((String)(this.user + ":" + this.pass)));
        try {
            ip = IP.resolveSiteLocalAddress(router);
            map.put("ip", ip.getHostAddress());
            map.put("routerip", ip.getHostAddress());
        }
        catch (UnknownHostException e) {
            throw new ReconnectException(e);
        }
        map.put("host", router);
        this.internalVariables = Collections.unmodifiableMap(map);
        this.logger.info("Internal Variables: " + this.internalVariables);
        this.parsedVariables = new HashMap<String, String>();
        this.verifiedIPs = new HashSet<String>();
        Browser br = new Browser();
        if (ip instanceof Inet4Address) {
            br.setIPVersion(HTTPConnectionUtils.IPVERSION.IPV4_IPV6);
        }
        br.setDebug(true);
        br.setVerbose(true);
        br.setCookiesExclusive(true);
        br.setReadTimeout(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getReconnectBrowserReadTimeout());
        br.setConnectTimeout(((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).getReconnectBrowserConnectTimeout());
        br.setProxySelector((ProxySelectorInterface)new NoProxySelector());
        br.setLogger((LogInterface)this.logger);
        br.setAllowedResponseCodes(new int[]{401});
        try {
            Document xmlScript = JDUtilities.parseXmlString(this.script);
            if (xmlScript == null) {
                this.logger.severe("Error while parsing the xml string: " + this.script);
                throw new ReconnectException("Error while parsing the xml string");
            }
            Node root = xmlScript.getChildNodes().item(0);
            if (root == null || !root.getNodeName().equalsIgnoreCase("HSRC")) {
                this.logger.severe("Root Node must be [[[HSRC]]]*[/HSRC]");
                throw new ReconnectException("Error while parsing the xml string. Root Node must be [[[HSRC]]]*[/HSRC]");
            }
            NodeList steps = root.getChildNodes();
            for (int step = 0; step < steps.getLength(); ++step) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                Node current = steps.item(step);
                if (current.getNodeType() == 3) continue;
                if (!current.getNodeName().equalsIgnoreCase("STEP")) {
                    this.logger.severe("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
                    throw new ReconnectException("Root Node should only contain [[[STEP]]]*[[[/STEP]]] ChildTag: " + current.getNodeName());
                }
                NodeList toDos = current.getChildNodes();
                int toDosLength = toDos.getLength();
                for (int toDoStep = 0; toDoStep < toDosLength; ++toDoStep) {
                    NamedNodeMap attributes;
                    Node toDo = toDos.item(toDoStep);
                    if (Thread.currentThread().isInterrupted()) {
                        throw new InterruptedException();
                    }
                    if (this.feedback != null) {
                        this.feedback.onNewStep(toDo.getNodeName(), toDo);
                    }
                    if (toDo.getNodeName().equalsIgnoreCase("DEFINE")) {
                        attributes = toDo.getAttributes();
                        for (int attribute = 0; attribute < attributes.getLength(); ++attribute) {
                            String key = attributes.item(attribute).getNodeName();
                            String value = attributes.item(attribute).getNodeValue();
                            String[] tmp = value.split("\\%\\%\\%(.*?)\\%\\%\\%", -1);
                            String[] params = new Regex(value, "%%%(.*?)%%%").getColumn(0);
                            if (params.length > 0) {
                                StringBuilder newValue = new StringBuilder(tmp[0]);
                                int tmpLength = tmp.length;
                                for (int i = 1; i <= tmpLength; ++i) {
                                    if (i > params.length) continue;
                                    this.logger.finer("Replace variable: *********(" + params[i - 1] + ")");
                                    newValue.append(this.getModifiedVariable(params[i - 1], null));
                                    if (i >= tmpLength) continue;
                                    newValue.append(tmp[i]);
                                }
                                value = newValue.toString();
                            }
                            this.putVariable(key, value);
                        }
                        if (this.feedback != null) {
                            this.feedback.onVariablesUpdated(this.internalVariables);
                        }
                    }
                    if (toDo.getNodeName().equalsIgnoreCase("PARSE")) {
                        String[] parseLines;
                        this.logger.info("Parse response: \r\n" + br.getRequest());
                        for (String parseLine : parseLines = LiveHeaderInvoker.splitLines(toDo.getChildNodes().item(0).getNodeValue().trim())) {
                            String varname = new Regex(parseLine, "(.*?):").getMatch(0);
                            String pattern = new Regex(parseLine, ".*?:(.+)").getMatch(0);
                            if (varname == null || pattern == null) continue;
                            varname = varname.trim();
                            String found = br.getRegex(pattern = pattern.trim()).getMatch(0);
                            if (found != null) {
                                found = found.trim();
                                this.logger.finer("Parse: Varname=" + varname + " Pattern=" + pattern + "->" + found);
                                this.putVariable(varname, found);
                                if (this.feedback == null) continue;
                                this.feedback.onVariablesUpdated(this.internalVariables);
                                continue;
                            }
                            found = new Regex(br.getRequest().getHttpConnection() + "", pattern).getMatch(0);
                            if (found != null) {
                                found = found.trim();
                                this.logger.finer("Parse: Varname=" + varname + " Pattern=" + pattern + "->" + found);
                                this.putVariable(varname, found);
                                if (this.feedback == null) continue;
                                this.feedback.onVariablesUpdated(this.internalVariables);
                                continue;
                            }
                            this.logger.finer("Parse: Varname=" + varname + " Pattern=" + pattern + "->NOT FOUND!");
                            if (this.feedback == null) continue;
                            this.feedback.onVariableParserFailed(pattern, br.getRequest());
                        }
                    }
                    if (toDo.getNodeName().equalsIgnoreCase("REQUEST")) {
                        if (toDo.getChildNodes().getLength() != 1) {
                            this.logger.severe("A REQUEST Tag is not allowed to have childTags.");
                            throw new ReconnectException("A REQUEST Tag is not allowed to have childTags.");
                        }
                        attributes = toDo.getAttributes();
                        Browser retbr = null;
                        try {
                            retbr = this.doRequest(toDo.getChildNodes().item(0).getNodeValue().trim(), br, this.isAttributeSet(attributes, "https"), this.isAttributeSet(attributes, "raw"), this.isAttributeSet(attributes, "postraw"));
                        }
                        catch (ReconnectException e) {
                            this.logger.log((Throwable)e);
                            throw e;
                        }
                        catch (Exception e) {
                            this.logger.log((Throwable)e);
                            retbr = null;
                        }
                        Thread.sleep(350L);
                        if (retbr == null || !retbr.getHttpConnection().isOK()) {
                            this.logger.severe("Request error!");
                            if (this.feedback != null && retbr != null) {
                                this.feedback.onRequesterror(retbr.getRequest());
                            }
                        } else {
                            if (retbr.getHttpConnection().getResponseCode() == 401) {
                                if (retbr.getHttpConnection().getRequestProperty("Authorization") != null) {
                                    if (this.feedback != null) {
                                        this.feedback.onRequesterror(retbr.getRequest());
                                    }
                                } else if (this.feedback != null) {
                                    this.feedback.onRequestOK(retbr.getRequest());
                                }
                            } else if (this.feedback != null) {
                                this.feedback.onRequestOK(retbr.getRequest());
                            }
                            br = retbr;
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"RESPONSE")) {
                        this.logger.finer("get Response");
                        if (toDo.getChildNodes().getLength() != 1) {
                            this.logger.severe("A RESPONSE Tag is not allowed to have childTags.");
                            throw new ReconnectException("A RESPONSE Tag is not allowed to have childTags.");
                        }
                        attributes = toDo.getAttributes();
                        if (attributes.getNamedItem("keys") == null) {
                            this.logger.severe("A RESPONSE Node needs a Keys Attribute: " + toDo);
                            throw new ReconnectException("A RESPONSE Node needs a Keys Attribute: " + toDo);
                        }
                        String[] keys = attributes.getNamedItem("keys").getNodeValue().split("\\;");
                        this.parseVariables(this.feedback, toDo.getChildNodes().item(0).getNodeValue().trim(), keys, br);
                    }
                    if (StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"WAIT")) {
                        attributes = toDo.getAttributes();
                        Node item = attributes.getNamedItem("seconds");
                        if (item == null) {
                            this.logger.severe("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                            throw new ReconnectException("A Wait Step needs a Waittimeattribute: e.g.: <WAIT seconds=\"15\"/>");
                        }
                        int seconds = Formatter.filterInt((String)item.getNodeValue());
                        if (seconds > 0) {
                            this.logger.finer("Wait " + seconds + " seconds");
                            Thread.sleep(seconds * 1000);
                        }
                    }
                    if (!StringUtils.equalsIgnoreCase((String)toDo.getNodeName(), (String)"TIMEOUT")) continue;
                    attributes = toDo.getAttributes();
                    Node item = attributes.getNamedItem("seconds");
                    if (item == null) {
                        this.logger.severe("A valid timeout must be set: e.g.: <TIMEOUT seconds=\"15\"/>");
                        throw new ReconnectException("A valid timeout must be set: e.g.: <TIMEOUT seconds=\"15\"/>");
                    }
                    int seconds = Formatter.filterInt((String)item.getNodeValue());
                    if (seconds <= 0 || br == null) continue;
                    this.logger.finer("Timeout set to " + seconds + " seconds");
                    br.setReadTimeout(seconds * 1000);
                    br.setConnectTimeout(seconds * 1000);
                }
            }
        }
        catch (InterruptedException e) {
            throw e;
        }
        catch (ReconnectException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            throw new ReconnectException(e);
        }
    }

    public static String prepareScript(String script) {
        if (script != null) {
            script = script.replaceAll("\\[\\[\\[", "<");
            script = script.replaceAll("\\]\\]\\]", ">");
            script = script.replaceAll("<REQUEST(.*?)>", "<REQUEST$1><![CDATA[");
            script = script.replaceAll("</REQUEST>", "]]></REQUEST>");
            script = script.replaceAll("<RESPONSE(.*?)>", "<RESPONSE$1><![CDATA[");
            script = script.replaceAll("</RESPONSE.*>", "]]></RESPONSE>");
        }
        return script;
    }

    private String getInternalValue(String key) {
        return this.internalVariables != null && key != null ? this.internalVariables.get(key.toLowerCase(Locale.ENGLISH)) : null;
    }

    private String getModifiedVariable(String key, Browser br) throws ReconnectException {
        if (StringUtils.equalsIgnoreCase((String)"timestamp", (String)key)) {
            return Long.toString(System.currentTimeMillis());
        }
        if (StringUtils.equalsIgnoreCase((String)"HuaweiHG255s", (String)key)) {
            if (br == null) {
                throw new ReconnectException("HuaweiHG255s not possible yet! No Browser available!");
            }
            String csrf_param = br.getRegex("\"csrf_param\"\\s*content\\s*=\\s*\"(.*?)\"").getMatch(0);
            String csrf_token = br.getRegex("\"csrf_token\"\\s*content\\s*=\\s*\"(.*?)\"").getMatch(0);
            if (csrf_param == null) {
                throw new ReconnectException("csrf_param not found!");
            }
            if (csrf_token == null) {
                throw new ReconnectException("csrf_token not found!");
            }
            return Hash.getSHA256((String)(this.getInternalValue("username") + Base64.encode((String)Hash.getSHA256((String)this.getInternalValue("password"))) + csrf_param + csrf_token));
        }
        if (StringUtils.containsIgnoreCase((String)key, (String)"random:")) {
            try {
                String[] params = new Regex(key, "random\\:(\\d+):(.+)").getRow(0);
                String possiblechars = params[1];
                StringBuilder sb = new StringBuilder();
                for (int i = 0; i < Integer.parseInt(params[0]); ++i) {
                    sb.append(possiblechars.charAt((int)(Math.random() * (double)possiblechars.length())));
                }
                return sb.toString();
            }
            catch (Exception e) {
                throw new ReconnectException(e);
            }
        }
        int index = key.indexOf(":::");
        String value = null;
        if (index == -1) {
            value = this.getVariable(key);
            return value == null ? "" : value;
        }
        String keyValue = key.substring(key.lastIndexOf(":::") + 3);
        value = this.getVariable(keyValue);
        if (value == null) {
            return "";
        }
        while ((index = key.indexOf(":::")) >= 0) {
            if (value == null) {
                this.logger.info("Modified Variable broken: " + key);
                return "";
            }
            String method = key.substring(0, index);
            key = key.substring(index + 3);
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLENCODE")) {
                value = Encoding.urlEncode((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"URLDECODE")) {
                value = Encoding.htmlDecode((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8DECODE")) {
                value = Encoding.UTF8Decode((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"UTF8ENCODE")) {
                value = Encoding.UTF8Encode((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"MD5")) {
                value = JDHash.getMD5((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"SHA256")) {
                value = Hash.getSHA256((String)value);
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64_SHA256")) {
                value = Encoding.Base64Encode((String)Hash.getSHA256((String)value));
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)method, (String)"BASE64")) {
                value = Encoding.Base64Encode((String)value);
                continue;
            }
            this.logger.info("Unknown/Unsupported method:" + method);
        }
        return value;
    }

    private static String[] splitLines(String source) {
        return source.split("\r\n|\r|\n");
    }

    private void showParsedVariables() {
        this.logger.finer("Parsed Variables: " + this.parsedVariables);
    }

    private Browser doRequest(String request, Browser br, boolean ishttps, boolean isRawHeader, boolean isRawPost) throws ReconnectException {
        try {
            String[] requestLines;
            StringBuilder postContent = new StringBuilder();
            HashMap<String, String> requestProperties = new HashMap<String, String>();
            if (isRawHeader) {
                br.setHeaders(new RequestHeader());
            }
            String[] tmp = request.split("\\%\\%\\%(.*?)\\%\\%\\%");
            String[] params = new Regex(request, "%%%(.*?)%%%").getColumn(0);
            if (params.length > 0) {
                String modifiedVariable;
                String key;
                int i;
                int tmpLength;
                StringBuilder req;
                if (request.startsWith(params[0])) {
                    req = new StringBuilder();
                    this.showParsedVariables();
                    tmpLength = tmp.length;
                    for (i = 0; i <= tmpLength; ++i) {
                        key = params[i - 1];
                        modifiedVariable = this.getModifiedVariable(key, br);
                        this.logger.finer("Replace variable: " + modifiedVariable + "(" + key + ")");
                        req.append(modifiedVariable);
                        if (i >= tmpLength) continue;
                        req.append(tmp[i]);
                    }
                } else {
                    req = new StringBuilder(tmp[0]);
                    this.showParsedVariables();
                    tmpLength = tmp.length;
                    for (i = 1; i <= tmpLength; ++i) {
                        if (i > params.length) continue;
                        key = params[i - 1];
                        modifiedVariable = this.getModifiedVariable(key, br);
                        this.logger.finer("Replace variable: " + modifiedVariable + "(" + key + ")");
                        req.append(modifiedVariable);
                        if (i >= tmpLength) continue;
                        req.append(tmp[i]);
                    }
                }
                request = req.toString();
            }
            if ((requestLines = LiveHeaderInvoker.splitLines(request)).length == 0) {
                throw new ReconnectException("Parse Fehler:" + request);
            }
            tmp = requestLines[0].split(" ");
            if (tmp.length < 2) {
                throw new ReconnectException("Konnte Requesttyp nicht finden: " + requestLines[0]);
            }
            String requestType = tmp[0];
            String path = tmp[1];
            boolean headersEnd = false;
            String host = null;
            int requestLinesLength = requestLines.length;
            for (int li = 1; li < requestLinesLength; ++li) {
                if (headersEnd) {
                    if (isRawPost) {
                        postContent.append(requestLines[li].trim());
                        continue;
                    }
                    postContent.append(requestLines[li]);
                    postContent.append('\r');
                    postContent.append('\n');
                    continue;
                }
                if (requestLines[li].trim().length() == 0) {
                    headersEnd = true;
                    continue;
                }
                String[] p = requestLines[li].split("\\:");
                if (p.length < 2) {
                    this.logger.warning("Syntax Fehler in: " + requestLines[li] + "\r\n Vermute Post Parameter");
                    headersEnd = true;
                    --li;
                    continue;
                }
                requestProperties.put(p[0].trim(), requestLines[li].substring(p[0].length() + 1).trim());
                if (!p[0].trim().equalsIgnoreCase("HOST")) continue;
                host = requestLines[li].substring(p[0].length() + 1).trim();
            }
            if (host == null) {
                throw new ReconnectException("Host not available: " + request);
            }
            GetRequest browserRequest = null;
            try {
                String protocoll;
                this.verifyHost(host);
                String string = protocoll = ishttps ? "https://" : "http://";
                if (StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
                    this.logger.finer("Convert AUTH->GET");
                }
                String requestURL = protocoll + host + path;
                if (StringUtils.equalsIgnoreCase((String)requestType, (String)"GET") || StringUtils.equalsIgnoreCase((String)requestType, (String)"AUTH")) {
                    browserRequest = br.createGetRequest(requestURL);
                } else if (StringUtils.equalsIgnoreCase((String)requestType, (String)"POST") || StringUtils.equalsIgnoreCase((String)requestType, (String)"PUT")) {
                    Object post;
                    if (isRawPost) {
                        post = HexFormatter.hexToByteArray((String)postContent.toString());
                        if (br.probeJSonContent(post)) {
                            browserRequest = br.createJSonPostRequest(requestURL, new String((byte[])post, "UTF-8"));
                        } else {
                            browserRequest = br.createPostRequest(requestURL, new ArrayList(), null);
                            ((PostRequest)browserRequest).setPostBytes(post);
                        }
                    } else {
                        post = postContent.toString().trim();
                        if (br.probeJSonContent((String)post)) {
                            browserRequest = br.createJSonPostRequest(requestURL, (String)post);
                        } else {
                            browserRequest = br.createPostRequest(requestURL, new UrlQuery(), null);
                            ((PostRequest)browserRequest).setPostDataString((String)post);
                        }
                    }
                    if (StringUtils.equalsIgnoreCase((String)requestType, (String)"PUT")) {
                        browserRequest = new PutRequest((Request)browserRequest);
                    }
                } else {
                    throw new ReconnectException("Unknown/Unsupported requestType: " + requestType);
                }
                if (requestProperties != null) {
                    HashSet<String> blackList = new HashSet<String>(Arrays.asList("content-length", "host", "accept-encoding"));
                    for (Map.Entry requestProperty : requestProperties.entrySet()) {
                        String key = (String)requestProperty.getKey();
                        String value = (String)requestProperty.getValue();
                        if (StringUtils.equalsIgnoreCase((String)key, (String)"content-type")) {
                            if (!(browserRequest instanceof PostRequest)) continue;
                            PostRequest postRequest = (PostRequest)browserRequest;
                            this.logger.info("Set-ContentType:oldValue=" + postRequest.getContentType() + "|newValue=" + value);
                            postRequest.setContentType(value);
                            continue;
                        }
                        if (StringUtils.equalsIgnoreCase((String)key, (String)"cookie")) {
                            Cookies cookies = Cookies.parseCookies((String)value, null, null);
                            this.logger.info("Set-Cookies:" + cookies);
                            browserRequest.getCookies().add(cookies);
                            continue;
                        }
                        if (key != null && !blackList.contains(key.toLowerCase(Locale.ENGLISH))) {
                            if (browserRequest.getHeaders().contains(key)) {
                                this.logger.info("Replace-Header:key=" + key + "|oldValue=" + browserRequest.getHeaders().getValue(key) + "|newValue=" + value);
                            } else {
                                this.logger.info("Set-Header:key=" + key + "|newValue=" + value);
                            }
                            browserRequest.getHeaders().put(key, value);
                            continue;
                        }
                        this.logger.info("Skip-Header:key=" + key + "|existingValue=" + browserRequest.getHeaders().getValue(key) + "|newValue=" + value);
                    }
                }
                br.getPage((Request)browserRequest);
                return br;
            }
            catch (IOException e) {
                if (this.feedback != null) {
                    this.feedback.onBasicRemoteAPIExceptionOccured(e, (Request)browserRequest);
                }
                throw e;
            }
        }
        catch (ReconnectFailedException e) {
            throw e;
        }
        catch (Exception e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    private void verifyHost(String verifyHost) throws ReconnectException {
        String verify = Browser.getHost((String)verifyHost, (boolean)false);
        if (this.verifiedIPs == null || !this.verifiedIPs.contains(verify)) {
            try {
                String[] whiteListArray = ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getHostWhiteList();
                List<String> whiteList = whiteListArray != null ? Arrays.asList(whiteListArray) : new ArrayList<String>(0);
                if (whiteList.contains(verify)) {
                    if (this.verifiedIPs != null) {
                        this.verifiedIPs.add(verify);
                    }
                    return;
                }
                String verifyIP = RouterUtils.resolveHostname(verify).getHostAddress();
                if (whiteList.contains(verifyIP)) {
                    if (this.verifiedIPs != null) {
                        this.verifiedIPs.add(verify);
                        this.verifiedIPs.add(verifyIP);
                    }
                    return;
                }
                if (!IP.isLocalIP(verifyIP)) {
                    throw new ReconnectException("Invalid Router Host:" + verify + "->" + verifyIP);
                }
                String routerIP = this.getRouterIP();
                if (!StringUtils.equals((String)routerIP, (String)verifyIP)) {
                    throw new ReconnectException("IP missmatch! (HOST)" + verifyIP + "!=" + routerIP + "(ROUTER)");
                }
                if (this.verifiedIPs != null) {
                    this.verifiedIPs.add(verify);
                }
            }
            catch (ReconnectException e) {
                throw e;
            }
            catch (Throwable e) {
                throw new ReconnectException("Invalid Router Host:" + verify, e);
            }
        }
    }

    private boolean putVariable(String key, String value) throws ReconnectFailedException {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                throw new ReconnectFailedException(T.T.failure_variable_overwrite_variable(lowerKey));
            }
            if (value == null) {
                this.logger.info("Remove Variable:" + lowerKey + "=" + this.parsedVariables.remove(lowerKey));
            } else {
                this.parsedVariables.put(lowerKey, value);
                this.logger.info("Set Variable:" + lowerKey + "->" + value);
            }
            return true;
        }
        return false;
    }

    private String getVariable(String key) throws ReconnectFailedException {
        if (key != null) {
            String lowerKey = key.toLowerCase(Locale.ENGLISH);
            if (this.internalVariables.containsKey(lowerKey)) {
                return this.internalVariables.get(lowerKey);
            }
            if (this.parsedVariables.containsKey(lowerKey)) {
                return this.parsedVariables.get(lowerKey);
            }
            this.logger.info("Variable not set:" + lowerKey);
        }
        return null;
    }

    private void parseVariables(LHProcessFeedback feedback, String patStr, String[] keys, Browser br) throws ReconnectFailedException {
        if (br != null && br.getRequest() != null && StringUtils.isNotEmpty((String)patStr)) {
            this.logger.info("Parse Variables:" + patStr);
            Pattern pattern = Pattern.compile(patStr, 34);
            Matcher matcher = pattern.matcher(br + "");
            this.logger.info("Matches: " + matcher.groupCount());
            if (matcher.find() && matcher.groupCount() > 0) {
                for (int i = 0; i < keys.length && i < matcher.groupCount(); ++i) {
                    this.putVariable(keys[i], matcher.group(i + 1));
                }
                if (feedback != null) {
                    feedback.onVariablesUpdated(this.parsedVariables);
                }
                return;
            }
            for (Map.Entry e : br.getRequest().getResponseHeaders().entrySet()) {
                for (String s : (List)e.getValue()) {
                    String txtx = (String)e.getKey() + ": " + s;
                    matcher = pattern.matcher(txtx);
                    this.logger.info("Matches: " + matcher.groupCount());
                    if (!matcher.find() || matcher.groupCount() <= 0) continue;
                    for (int i = 0; i < keys.length && i < matcher.groupCount(); ++i) {
                        this.putVariable(keys[i], matcher.group(i + 1));
                    }
                    if (feedback != null) {
                        feedback.onVariablesUpdated(this.parsedVariables);
                    }
                    return;
                }
            }
            this.logger.severe("Regular Expression without matches: " + patStr);
            if (feedback != null) {
                feedback.onVariableParserFailed(patStr, br.getRequest());
            }
        }
    }

    @Override
    protected void testRun() throws ReconnectException, InterruptedException {
        this.feedback = new LHProcessFeedback(){
            private int successRequests = 0;
            private int failedRequests = 0;

            @Override
            public void onBasicRemoteAPIExceptionOccured(IOException e, Request request) throws ReconnectFailedException {
                ++this.failedRequests;
                if (this.failedRequests > this.successRequests) {
                    throw new ReconnectFailedException(T.T.failure_variable_request_exception(e.getMessage(), request.getClass().getSimpleName(), request.getUrl()));
                }
            }

            @Override
            public void onVariablesUpdated(Map<String, String> variables) throws ReconnectFailedException {
            }

            @Override
            public void onVariableParserFailed(String pattern, Request request) throws ReconnectFailedException {
                throw new ReconnectFailedException(T.T.failure_variable_parser(pattern));
            }

            @Override
            public void onRequesterror(Request request) throws ReconnectFailedException {
                ++this.failedRequests;
                if (this.failedRequests > this.successRequests) {
                    throw new ReconnectFailedException(T.T.failure_variable_request(request.getClass().getSimpleName(), request.getUrl()));
                }
            }

            @Override
            public void onNewStep(String nodeName, Node toDo) throws ReconnectFailedException {
            }

            @Override
            public void onRequestOK(Request request) throws ReconnectFailedException {
                ++this.successRequests;
            }
        };
        try {
            this.run();
        }
        finally {
            this.feedback = null;
        }
    }

    public ReconnectResult validate(RouterData test) throws InterruptedException, ReconnectException {
        this.routerData = test;
        return this.validate();
    }

    public void setRouterData(RouterData rd) {
        this.routerData = rd;
    }
}

