/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import jd.controlling.reconnect.ReconnectResult;
import jd.controlling.reconnect.ipcheck.IPConnectionState;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.controlling.reconnect.ipcheck.event.IPControllListener;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtTextArea;
import org.appwork.swing.components.circlebar.CircledProgressBar;
import org.appwork.swing.components.circlebar.IconPainter;
import org.appwork.swing.components.circlebar.ImagePainter;
import org.appwork.utils.CompareUtils;
import org.appwork.utils.formatter.TimeFormatter;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.SwingUtils;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public abstract class ReconnectFindDialog
extends AbstractDialog<Object>
implements IPControllListener {
    private JProgressBar bar;
    private CircledProgressBar circle;
    private JLabel header;
    private JLabel state;
    private JLabel duration;
    private JLabel newIP;
    private Thread th;
    private Timer updateTimer;
    private long startTime;
    private List<? extends ReconnectResult> foundList;

    @Override
    public void onIPForbidden(IPConnectionState parameter) {
    }

    @Override
    public void onIPInvalidated(IPConnectionState parameter) {
    }

    @Override
    public void onIPChanged(IPConnectionState parameter, IPConnectionState parameter2) {
        this.setNewIP(parameter2.isOffline() ? "  -  " : parameter2.getExternalIp().toString());
    }

    @Override
    public void onIPOffline() {
        this.setSubStatusState(_GUI.T.ReconnectDialog_onIPOffline_(), new AbstractIcon("network-error", 16));
        this.setNewIP(_GUI.T.literally_offline());
    }

    @Override
    public void onIPValidated(IPConnectionState parameter, IPConnectionState parameter2) {
    }

    @Override
    public void onIPOnline(IPConnectionState parameter) {
        this.setSubStatusState(_GUI.T.ReconnectDialog_onIPOnline_(), new AbstractIcon("network-idle", 16));
    }

    @Override
    public void onIPStateChanged(IPConnectionState parameter, IPConnectionState parameter2) {
    }

    public ReconnectFindDialog() {
        super(256, _GUI.T.AutoDetectAction_actionPerformed_d_title(), null, _GUI.T.ReconnectFindDialog_ReconnectFindDialog_ok(), null);
    }

    protected Object createReturnValue() {
        return null;
    }

    public void setBarText(final String txt) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.bar.setString(txt);
            }
        };
    }

    public void setBarProgress(final int prog) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.bar.setValue(prog);
            }
        };
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 1", "[grow,fill]", "[]");
        ExtTextArea txt = new ExtTextArea();
        txt.setLabelMode(true);
        p.add((Component)txt);
        txt.setText(_GUI.T.AutoDetectAction_actionPerformed_d_msg());
        this.bar = new JProgressBar();
        this.bar.setStringPainted(true);
        this.bar.setMaximum(100);
        p.add((Component)this.bar);
        this.circle = new CircledProgressBar();
        this.circle.setValueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("reconnect", 26), 1.0f));
        ((ImagePainter)this.circle.getValueClipPainter()).setBackground(Color.WHITE);
        ((ImagePainter)this.circle.getValueClipPainter()).setForeground(Color.GREEN);
        this.circle.setNonvalueClipPainter((IconPainter)new ImagePainter((Icon)new AbstractIcon("reconnect", 26), 0.5f));
        ((ImagePainter)this.circle.getNonvalueClipPainter()).setBackground(Color.WHITE);
        ((ImagePainter)this.circle.getNonvalueClipPainter()).setForeground(Color.GREEN);
        MigPanel sp = new MigPanel("ins 0", "[fill][fill][grow,fill][fill][fill]", "[fill][grow,fill]");
        sp.add((Component)this.circle, (Object)"spany 2,gapright 10,height 42!,width 42!");
        this.header = new JLabel();
        sp.add((Component)this.header, (Object)"spanx 4,width 350:n:n");
        SwingUtils.toBold((JLabel)this.header);
        this.state = new JLabel();
        sp.add((Component)this.state, (Object)"spanx,alignx right");
        this.state.setHorizontalTextPosition(2);
        SwingUtils.toBold((JLabel)this.header);
        this.state.setHorizontalAlignment(4);
        this.circle.setIndeterminate(true);
        sp.add(this.label(_GUI.T.ReconnectDialog_layoutDialogContent_duration()));
        this.duration = new JLabel();
        sp.add((Component)this.duration);
        this.state.setHorizontalAlignment(4);
        sp.add((Component)new JLabel(new AbstractIcon("go-next", 18)));
        sp.add(this.label(_GUI.T.ReconnectDialog_layoutDialogContent_currentip()));
        this.newIP = new JLabel();
        sp.add((Component)this.newIP, (Object)"width 100!");
        this.newIP.setHorizontalAlignment(4);
        p.add((Component)sp);
        this.th = new Thread(this.getClass().getName()){
            {
                this.setDaemon(true);
            }

            @Override
            public void run() {
                try {
                    IPController.getInstance().invalidate();
                    IPController.getInstance().validate();
                    if (IPController.getInstance().getIpState().isOffline()) {
                        ReconnectFindDialog.this.setSubStatusState(_GUI.T.ReconnectDialog_onIPOffline_(), new AbstractIcon("network-error", 16));
                        ReconnectFindDialog.this.setNewIP(_GUI.T.literally_offline());
                    } else {
                        ReconnectFindDialog.this.setSubStatusState(_GUI.T.ReconnectDialog_onIPOnline_(), new AbstractIcon("network-idle", 16));
                        ReconnectFindDialog.this.setNewIP(IPController.getInstance().getIpState().getExternalIp().toString());
                    }
                    ReconnectFindDialog.this.run();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                finally {
                    ReconnectFindDialog.this.dispose();
                }
            }
        };
        this.startTime = System.currentTimeMillis();
        this.updateTimer = new Timer(1000, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReconnectFindDialog.this.duration.setText(TimeFormatter.formatMilliSeconds((long)(System.currentTimeMillis() - ReconnectFindDialog.this.startTime), (int)0));
            }
        });
        this.updateTimer.setRepeats(true);
        this.updateTimer.start();
        this.th.start();
        IPController.getInstance().getEventSender().addListener(this, true);
        return p;
    }

    protected void initFocus(JComponent focus) {
        super.initFocus((JComponent)this.cancelButton);
    }

    protected void packed() {
        super.packed();
        this.okButton.setEnabled(false);
        this.okButton.repaint();
        this.cancelButton.requestFocus();
        this.okButton.setToolTipText(_GUI.T.ReconnectFindDialog_packed_no_found_script_tooltip());
    }

    protected void setReturnmask(boolean b) {
        if (b) {
            Collections.sort(this.foundList, new Comparator<ReconnectResult>(){

                @Override
                public int compare(ReconnectResult o1, ReconnectResult o2) {
                    return CompareUtils.compareLong((long)o2.getAverageSuccessDuration(), (long)o1.getAverageSuccessDuration());
                }
            });
            this.foundList.get(0).getInvoker().getPlugin().setSetup(this.foundList.get(0));
        }
        super.setReturnmask(b);
    }

    public void setInterruptEnabled(List<? extends ReconnectResult> list) {
        this.foundList = list;
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.okButton.setEnabled(true);
                ReconnectFindDialog.this.okButton.setIcon(new AbstractIcon("ok", 18));
                ReconnectFindDialog.this.okButton.setToolTipText(_GUI.T.ReconnectFindDialog_packed_interrupt_tooltip());
            }
        };
    }

    public void dispose() {
        super.dispose();
        IPController.getInstance().getEventSender().removeListener(this);
        this.updateTimer.stop();
        this.th.interrupt();
    }

    public void setSubStatusState(final String txt, final Icon imageIcon) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.state.setText(txt);
                ReconnectFindDialog.this.state.setIcon(imageIcon);
            }
        };
    }

    public void setNewIP(final String txt) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.newIP.setText(txt);
            }
        };
    }

    public void setSubStatusHeader(final String txt) {
        new EDTRunner(){

            protected void runInEDT() {
                ReconnectFindDialog.this.header.setText(txt);
            }
        };
    }

    public abstract void run() throws InterruptedException;

    private Component label(String lbl) {
        JLabel ret = new JLabel(lbl);
        ret.setEnabled(false);
        return ret;
    }
}

