/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.UnknownHostException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderDetectionWizard;
import jd.controlling.reconnect.pluginsinc.liveheader.RouterDataResultTable;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.BadQueryException;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.RecollController;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.gui.swing.laf.LookAndFeelController;
import org.appwork.swing.MigPanel;
import org.appwork.swing.components.ExtButton;
import org.appwork.swing.components.ExtTextField;
import org.appwork.uio.UIOManager;
import org.appwork.uio.UserIODefinition;
import org.appwork.utils.Application;
import org.appwork.utils.StringUtils;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.ProgressDialog;
import org.jdownloader.actions.AppAction;
import org.jdownloader.gui.translate._GUI;
import org.jdownloader.images.AbstractIcon;

public class SearchScriptDialog
extends AbstractDialog<Object> {
    private ExtTextField routerName;
    private ExtTextField manufactor;
    private ExtTextField isp;
    private RouterData routerData;
    private ExtButton searchButton;
    private JSeparator seperator;
    private RouterDataResultTable table;
    private JScrollPane scrollPane;
    private JLabel status;
    protected RouterData selected;

    public SearchScriptDialog(RouterData rd) {
        super(0, T.T.SearchScriptDialog(), null, T.T.search(), null);
        this.routerData = rd;
    }

    protected Object createReturnValue() {
        return null;
    }

    protected int getPreferredHeight() {
        int pr = super.getPreferredHeight();
        if (pr > 0) {
            return Math.min(750, pr);
        }
        return Math.min(this.getRawPreferredSize().height + 20, 750);
    }

    private Component getLabel(String str) {
        JLabel ret = new JLabel(str);
        ret.setEnabled(false);
        return ret;
    }

    protected int getPreferredWidth() {
        int pr = super.getPreferredHeight();
        if (pr > 0) {
            return Math.min(1000, pr);
        }
        return 700;
    }

    public static void main(String[] args) throws UnknownHostException, InterruptedException {
        Application.setApplication((String)".jd_home");
        LookAndFeelController.getInstance().init();
        RouterData rd = new LiveHeaderDetectionWizard(){

            @Override
            protected void scanRemoteInfo() {
            }
        }.collectRouterDataInfo();
        rd.setIsp(RecollController.getInstance().getIsp());
        UIOManager.I().show(null, (UserIODefinition)new SearchScriptDialog(rd));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton && StringUtils.equals((String)T.T.search(), (String)this.okButton.getText())) {
            this.doSearch();
            return;
        }
        super.actionPerformed(e);
    }

    public void doSearch() {
        ProgressDialog.ProgressGetter pg = new ProgressDialog.ProgressGetter(){

            public void run() throws Exception {
                try {
                    List<RouterData> list = RecollController.getInstance().query(SearchScriptDialog.this.routerName.getText(), SearchScriptDialog.this.manufactor.getText(), SearchScriptDialog.this.isp.getText());
                    SearchScriptDialog.this.updateList(list);
                }
                catch (BadQueryException e) {
                    UIOManager.I().showErrorMessage(T.T.BadQueryException());
                }
                catch (Throwable e) {
                    UIOManager.I().showException(e.getMessage(), e);
                }
            }

            public String getString() {
                return null;
            }

            public int getProgress() {
                return -1;
            }

            public String getLabelString() {
                return null;
            }
        };
        ProgressDialog d = new ProgressDialog(pg, 8, T.T.searching(), _GUI.T.lit_please_wait(), (Icon)new AbstractIcon("wait", 32), null, null);
        UIOManager.I().show(null, (UserIODefinition)d);
    }

    protected void updateList(final List<RouterData> list) {
        new EDTRunner(){

            protected void runInEDT() {
                if (list == null || list.size() == 0) {
                    SearchScriptDialog.this.searchButton.setVisible(false);
                    SearchScriptDialog.this.scrollPane.setVisible(false);
                    SearchScriptDialog.this.seperator.setVisible(true);
                    SearchScriptDialog.this.status.setVisible(true);
                    SearchScriptDialog.this.status.setText(T.T.nothing_found());
                } else {
                    SearchScriptDialog.this.searchButton.setVisible(true);
                    SearchScriptDialog.this.scrollPane.setVisible(true);
                    SearchScriptDialog.this.seperator.setVisible(true);
                    SearchScriptDialog.this.status.setVisible(true);
                    SearchScriptDialog.this.status.setText(T.T.found(list.size()));
                    SearchScriptDialog.this.table.update(list);
                }
                SearchScriptDialog.this.pack();
            }
        };
    }

    public JComponent layoutDialogContent() {
        MigPanel p = new MigPanel("ins 0,wrap 2", "[align right][grow,fill]", "[]");
        p.add(this.getLabel(T.T.routername()));
        this.routerName = new ExtTextField();
        p.add((Component)this.routerName);
        p.add(this.getLabel(T.T.manufactor()));
        this.manufactor = new ExtTextField();
        p.add((Component)this.manufactor);
        p.add(this.getLabel(T.T.isp()));
        this.isp = new ExtTextField();
        p.add((Component)this.isp);
        this.routerName.setHelpText(T.T.routerName_help());
        this.manufactor.setHelpText(T.T.manufactor_help());
        this.isp.setHelpText(T.T.isp_help());
        if (this.routerData != null) {
            this.routerName.setText(this.routerData.getRouterName());
            this.manufactor.setText(this.routerData.getManufactor());
            this.isp.setText(this.routerData.getIsp() == null ? "" : this.routerData.getIsp().replaceAll("^\\w+\\d+ ", ""));
        }
        this.searchButton = new ExtButton((AbstractAction)((Object)new AppAction(){
            {
                this.setName(T.T.search());
            }

            public void actionPerformed(ActionEvent e) {
                SearchScriptDialog.this.doSearch();
            }
        }));
        p.add((Component)this.searchButton, (Object)"skip,alignx right,hidemode 3");
        this.seperator = new JSeparator(0);
        p.add((Component)this.seperator, (Object)"spanx,growx,pushx,hidemode 3");
        this.status = new JLabel();
        p.add((Component)this.status, (Object)"spanx,growx,pushx,hidemode 3");
        this.table = new RouterDataResultTable(){

            @Override
            protected void onSelectionChanged() {
                super.onSelectionChanged();
                List objects = this.getModel().getSelectedObjects();
                RouterData routerData = SearchScriptDialog.this.selected = objects == null || objects.size() == 0 ? null : (RouterData)objects.get(0);
                if (SearchScriptDialog.this.selected == null) {
                    SearchScriptDialog.this.okButton.setText(T.T.search());
                } else {
                    SearchScriptDialog.this.okButton.setText(T.T.use());
                }
            }
        };
        this.scrollPane = new JScrollPane((Component)((Object)this.table));
        p.add((Component)this.scrollPane, (Object)"spanx,growx,pushx,hidemode 3");
        this.searchButton.setVisible(false);
        this.seperator.setVisible(false);
        this.scrollPane.setVisible(false);
        this.status.setVisible(false);
        return p;
    }

    public RouterData getRouterData() {
        return this.selected;
    }
}

