/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.recoll;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.AddRouterResponse;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.BadQueryException;
import jd.controlling.reconnect.pluginsinc.liveheader.recoll.RetryIOException;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.http.Browser;
import jd.nutils.encoding.Encoding;
import org.appwork.storage.JSonStorage;
import org.appwork.storage.TypeRef;
import org.appwork.uio.UIOManager;
import org.appwork.utils.event.queue.Queue;
import org.appwork.utils.event.queue.QueueAction;
import org.appwork.utils.logging2.LogSource;
import org.jdownloader.logging.LogController;

public class RecollController {
    private static final RecollController INSTANCE = new RecollController();
    protected static String HTTP_BASE = "https://reconnect.jdownloader.org/";
    private LogSource logger = LogController.getInstance().getLogger(this.getClass().getName());
    private Queue queue = new Queue("RecollQueue"){};

    public static RecollController getInstance() {
        return INSTANCE;
    }

    private RecollController() {
    }

    protected <Typo> Typo call(String command, TypeRef<Typo> type, Object ... objects) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (objects != null) {
            for (int i = 0; i < objects.length; ++i) {
                sb.append(i == 0 ? "" : "&");
                sb.append(Encoding.urlEncode((String)JSonStorage.serializeToJson((Object)objects[i])));
            }
        }
        Browser br = new Browser();
        br.setAllowedResponseCodes(new int[]{200, 503, 500, 400});
        String ret = br.postPageRaw(HTTP_BASE + command, sb.toString());
        if (br.getRequest().getHttpConnection().getResponseCode() == 503) {
            throw new RetryIOException(ret);
        }
        if (br.getRequest().getHttpConnection().getResponseCode() == 400) {
            throw new BadQueryException(ret);
        }
        if (type == null) {
            return null;
        }
        return (Typo)JSonStorage.restoreFromString((String)ret, type);
    }

    public void trackWorking(final String scriptID, final long successDuration, final long offlineDuration) {
        this.queue.addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                try {
                    RecollController.this.call("setWorking", null, scriptID, successDuration, offlineDuration);
                }
                catch (Exception e) {
                    RecollController.this.logger.log((Throwable)e);
                }
                return null;
            }
        });
    }

    public void trackNotWorking(final String scriptID) {
        this.queue.addAsynch((QueueAction)new QueueAction<Void, RuntimeException>(){

            protected Void run() throws RuntimeException {
                try {
                    RecollController.this.call("setNotWorking", null, scriptID);
                }
                catch (Exception e) {
                    RecollController.this.logger.log((Throwable)e);
                }
                return null;
            }
        });
    }

    public boolean isAlive() {
        try {
            return (Boolean)this.call("isAlive", TypeRef.BOOLEAN, new Object[0]);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return false;
        }
    }

    public List<RouterData> findRouter(RouterData rd) throws InterruptedException {
        try {
            return this.call("findRouter", new TypeRef<ArrayList<RouterData>>(){}, rd);
        }
        catch (RetryIOException e) {
            Thread.sleep(2000L);
            return this.findRouter(rd);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    public String getManufactor(String mac) {
        try {
            return (String)this.call("getManufactor", TypeRef.STRING, mac);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    public AddRouterResponse addRouter(RouterData rd) {
        try {
            return this.call("addRouter", AddRouterResponse.TYPE_REF, rd);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    public String getIsp() {
        try {
            return (String)this.call("getIsp", TypeRef.STRING, new Object[0]);
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            return null;
        }
    }

    public List<RouterData> query(String name, String manufactor, String isp) throws InterruptedException, BadQueryException {
        try {
            return this.call("query", new TypeRef<ArrayList<RouterData>>(){}, name, manufactor, isp);
        }
        catch (RetryIOException e) {
            Thread.sleep(2000L);
            return this.query(name, manufactor, isp);
        }
        catch (BadQueryException e) {
            throw e;
        }
        catch (IOException e) {
            this.logger.log((Throwable)e);
            UIOManager.I().showErrorMessage(T.T.LiveHeaderDetectionWizard_runOnlineScan_notavailable_mm());
            return null;
        }
    }
}

