/*
 * Decompiled with CFR 0.152.
 */
package jd.controlling.reconnect.pluginsinc.liveheader.recorder;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import jd.config.SubConfiguration;
import jd.controlling.reconnect.ReconnectConfig;
import jd.controlling.reconnect.ReconnectPluginController;
import jd.controlling.reconnect.ipcheck.IPController;
import jd.controlling.reconnect.pluginsinc.liveheader.DataCompareDialog;
import jd.controlling.reconnect.pluginsinc.liveheader.LiveHeaderReconnectSettings;
import jd.controlling.reconnect.pluginsinc.liveheader.recorder.ReconnectRecorder;
import jd.controlling.reconnect.pluginsinc.liveheader.remotecall.RouterData;
import jd.controlling.reconnect.pluginsinc.liveheader.translate.T;
import jd.gui.UserIO;
import jd.nutils.JDFlags;
import net.miginfocom.swing.MigLayout;
import org.appwork.storage.config.JsonConfig;
import org.appwork.utils.Regex;
import org.appwork.utils.os.CrossSystem;
import org.appwork.utils.swing.EDTRunner;
import org.appwork.utils.swing.dialog.AbstractDialog;
import org.appwork.utils.swing.dialog.Dialog;
import org.appwork.utils.swing.dialog.DialogCanceledException;
import org.appwork.utils.swing.dialog.DialogClosedException;
import org.jdownloader.images.AbstractIcon;
import org.jdownloader.logging.LogController;

public class Gui
extends AbstractDialog<Object> {
    private static final long serialVersionUID = 1L;
    private JTextField routerip;
    private JCheckBox rawmode;
    public boolean saved = false;
    public String ip = null;
    public String methode = null;
    public String user = null;
    public String pass = null;
    private static long CHECK_INTERVAL = 5000L;
    private static long RECONNECT_DURATION = 0L;

    public Gui(String ip) {
        super(256, T.T.gui_config_jdrr_title(), null, T.T.gui_btn_start(), T.T.gui_btn_cancel());
        this.ip = ip;
    }

    protected void addButtons(JPanel buttonBar) {
        JButton help = new JButton(T.T.gui_btn_help());
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CrossSystem.openURL((String)"https://jdownloader.org/knowledge/wiki/reconnect/reconnect-recorder");
            }
        });
        buttonBar.add((Component)help, "tag help, sizegroup confirms");
    }

    protected Object createReturnValue() {
        return null;
    }

    public JComponent layoutDialogContent() {
        this.routerip = new JTextField(this.ip);
        this.rawmode = new JCheckBox(T.T.gui_config_jdrr_rawmode());
        this.rawmode.setSelected(false);
        this.rawmode.setHorizontalTextPosition(10);
        StringBuilder sb = new StringBuilder();
        sb.append("<html>");
        sb.append(T.T.jd_nrouter_recorder_Gui_info1());
        sb.append("<br>");
        sb.append(T.T.jd_nrouter_recorder_Gui_info2());
        sb.append("<br>");
        sb.append(T.T.jd_nrouter_recorder_Gui_info3());
        sb.append("</html>");
        JPanel panel = new JPanel((LayoutManager)new MigLayout("wrap 3, ins 5", "[][grow]10[]"));
        panel.add(new JLabel(T.T.gui_fengshuiconfig_routerip() + ":"));
        panel.add((Component)this.routerip, "growx");
        panel.add(this.rawmode);
        panel.add((Component)new JLabel(sb.toString()), "spanx,growx");
        return panel;
    }

    private void save() {
        UserIO userIO = UserIO.getInstance();
        String string = T.T.gui_config_jdrr_success();
        String string2 = T.T.gui_config_jdrr_savereconnect();
        UserIO.getInstance();
        int ret = userIO.requestConfirmDialog(0, string, string2, UserIO.getIcon((int)3), T.T.gui_btn_yes(), T.T.gui_btn_no());
        if (JDFlags.hasSomeFlags((int)ret, (int[])new int[]{2, 32})) {
            int ab;
            int aa;
            StringBuilder b = new StringBuilder();
            String br = System.getProperty("line.separator");
            for (String element : ReconnectRecorder.steps) {
                b.append(element).append(br);
            }
            this.methode = b.toString().trim();
            if (ReconnectRecorder.AUTH != null) {
                this.user = new Regex(ReconnectRecorder.AUTH, "(.+?):").getMatch(0);
                this.pass = new Regex(ReconnectRecorder.AUTH, ".+?:(.+)").getMatch(0);
                ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setUserName(this.user);
                ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setPassword(this.pass);
            }
            ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setRouterIP(this.routerip.getText().trim());
            if (this.methode != null && this.methode.equals(((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).getScript())) {
                ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setAlreadySendToCollectServer3(false);
            }
            ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setScript(this.methode);
            DataCompareDialog dcd = new DataCompareDialog(this.routerip.getText().trim(), null, null, null, null, null);
            RouterData rd = new RouterData();
            try {
                dcd.setNoLogins(true);
                Dialog.getInstance().showDialog((AbstractDialog)dcd);
                rd.setRouterName(rd.getRouterName());
                rd.setFirmware(rd.getFirmware());
                rd.setManufactor(rd.getManufactor());
            }
            catch (DialogClosedException e) {
                e.printStackTrace();
            }
            catch (DialogCanceledException e) {
                e.printStackTrace();
            }
            ((LiveHeaderReconnectSettings)JsonConfig.create(LiveHeaderReconnectSettings.class)).setRouterData(rd);
            ReconnectPluginController.getInstance().setActivePlugin("httpliveheader");
            if (RECONNECT_DURATION <= 2000L) {
                RECONNECT_DURATION = 2000L;
            }
            if ((aa = (int)(RECONNECT_DURATION / 1000L * 10L)) < 30) {
                aa = 30;
            }
            if ((ab = (int)(RECONNECT_DURATION / 1000L / 2L)) < 30) {
                ab = 5;
            }
            ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setSecondsToWaitForIPChange(aa);
            ((ReconnectConfig)JsonConfig.create(ReconnectConfig.class)).setSecondsBeforeFirstIPCheck(ab);
            this.saved = true;
            this.dispose();
        }
    }

    protected void setReturnmask(boolean b) {
        super.setReturnmask(b);
        if (b && !ReconnectRecorder.running && this.routerip.getText() != null && !this.routerip.getText().matches("\\s*")) {
            String host = this.routerip.getText().trim();
            boolean startwithhttps = false;
            if (host.contains("https")) {
                startwithhttps = true;
            }
            host = host.replaceAll("http://", "").replaceAll("https://", "");
            new Thread(((Object)((Object)this)).getClass().getName()){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    IPController.getInstance().invalidate();
                }
            }.start();
            ReconnectRecorder.startServer(host, this.rawmode.isSelected());
            if (startwithhttps) {
                CrossSystem.openURL((String)("http://localhost:" + (SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972) + 1)));
            } else {
                CrossSystem.openURL((String)("http://localhost:" + SubConfiguration.getConfig("ReconnectRecorder").getIntegerProperty("PARAM_PORT", 8972)));
            }
            try {
                Dialog.getInstance().showDialog((AbstractDialog)new JDRRInfoPopup());
            }
            catch (DialogClosedException e) {
                e.printStackTrace();
            }
            catch (DialogCanceledException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    public class JDRRInfoPopup
    extends AbstractDialog<Object> {
        private static final long serialVersionUID = 1L;
        private long reconnect_timer;
        private RRStatus statusicon;

        public JDRRInfoPopup() {
            super(264, T.T.gui_config_jdrr_status_title(), null, null, T.T.gui_btn_abort());
            this.reconnect_timer = 0L;
        }

        public void closePopup(final Boolean validate) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JDRRInfoPopup.this.cancelButton.setEnabled(false);
                    if (Boolean.TRUE.equals(validate)) {
                        if (JDRRInfoPopup.this.reconnect_timer == 0L) {
                            RECONNECT_DURATION = CHECK_INTERVAL;
                        } else {
                            RECONNECT_DURATION = System.currentTimeMillis() - JDRRInfoPopup.this.reconnect_timer;
                        }
                        LogController.CL().info("dauer: " + RECONNECT_DURATION);
                        JDRRInfoPopup.this.statusicon.setStatus(1);
                    } else {
                        JDRRInfoPopup.this.statusicon.setStatus(-1);
                    }
                    if (Boolean.TRUE.equals(validate)) {
                        Gui.this.save();
                    } else {
                        UserIO.getInstance().requestMessageDialog(T.T.gui_config_jdrr_reconnectfaild());
                    }
                    JDRRInfoPopup.this.dispose();
                }
            });
        }

        protected Object createReturnValue() {
            return null;
        }

        public JComponent layoutDialogContent() {
            this.statusicon = new RRStatus();
            return this.statusicon;
        }

        public void packed() {
            this.setMinimumSize(null);
            this.setResizable(false);
            this.setDefaultCloseOperation(0);
            this.startCheck();
        }

        protected void setReturnmask(boolean b) {
            ReconnectRecorder.stopServer();
            super.setReturnmask(b);
            if (!b) {
                this.closePopup(null);
            }
        }

        public void startCheck() {
            new Thread(){
                {
                    this.setDaemon(true);
                }

                @Override
                public void run() {
                    JDRRInfoPopup.this.statusicon.setStatus(0);
                    this.setName(T.T.gui_config_jdrr_popup_title());
                    JDRRInfoPopup.this.reconnect_timer = 0L;
                    try {
                        while (ReconnectRecorder.running) {
                            try {
                                Thread.sleep(CHECK_INTERVAL);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            if (!IPController.getInstance().validate() && JDRRInfoPopup.this.reconnect_timer == 0L) {
                                JDRRInfoPopup.this.reconnect_timer = System.currentTimeMillis();
                            }
                            if (!IPController.getInstance().validate()) continue;
                            JDRRInfoPopup.this.statusicon.setStatus(1);
                            if (ReconnectRecorder.running) {
                                JDRRInfoPopup.this.closePopup(true);
                            }
                            return;
                        }
                    }
                    finally {
                        ReconnectRecorder.stopServer();
                    }
                }
            }.start();
        }

        public class RRStatus
        extends JLabel {
            private static final long serialVersionUID = -3280613281656283625L;
            private final Icon imageProgress = new AbstractIcon("record", 32);
            private final Icon imageBad = new AbstractIcon("false", 32);
            private final Icon imageGood = new AbstractIcon("true", 32);
            private final String strProgress = T.T.jd_router_reconnectrecorder_Gui_icon_progress();
            private final String strBad = T.T.jd_router_reconnectrecorder_Gui_icon_bad();
            private final String strGood = T.T.jd_router_reconnectrecorder_Gui_icon_good();

            public RRStatus() {
                this.setStatus(0);
            }

            public void setStatus(final int state) {
                new EDTRunner(){

                    protected void runInEDT() {
                        if (state == 0) {
                            RRStatus.this.setIcon(RRStatus.this.imageProgress);
                            RRStatus.this.setText(RRStatus.this.strProgress);
                        } else if (state == 1) {
                            RRStatus.this.setIcon(RRStatus.this.imageGood);
                            RRStatus.this.setText(RRStatus.this.strGood);
                        } else {
                            RRStatus.this.setIcon(RRStatus.this.imageBad);
                            RRStatus.this.setText(RRStatus.this.strBad);
                        }
                    }
                };
            }
        }
    }
}

